//=======================================================================
// file.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef LIBPACO_FILE_H
#define LIBPACO_FILE_H

#include <string>

namespace Paco {

class File
{
	public:

	File(std::string const& __name, long __size, short __flags = 0)
	:
		mName(__name),
		mSize(__size),
		mFlags(__flags)
	{ }
	
	~File() { }

	// Codes used in the logs
	static int const SIZEOF_SYMLINK = -1;
	static int const SIZEOF_MISSING = -2;

	// Bits for mFlags
	static int const SHARED		= (1 << 0);
	static int const MISSING	= (1 << 1);

	// Accessors
	long size() const				{ return mSize; }
	long& size()					{ return mSize; }
	std::string const& name() const	{ return mName; }
	std::string& name()				{ return mName; }
	bool symlink() const			{ return mSize == SIZEOF_SYMLINK; }
	bool shared() const				{ return mFlags & SHARED; }
	bool missing() const			{ return mFlags & MISSING; }

	void shared(bool set)			{ setFlag(SHARED, set); }
	void missing(bool set)			{ setFlag(MISSING, set); }

	private:

	std::string mName;
	long mSize;
	short mFlags;

	// Prevent copies
	File(File const&);
	File& operator=(File const&);

	void setFlag(int flag, bool set)
	{
		if (set)
			mFlags |= flag;
		else
			mFlags &= ~flag;
	}

};	// class File

}	// namespace Paco


#endif  // LIBPACO_FILE_H
