#ifndef vtk_netcdf_mangle_h
#define vtk_netcdf_mangle_h

/*

This header file mangles all symbols exported from the netcdf library.
It is included in all files while building the netcdf library.  Due to
namespace pollution, no netcdf headers should be included in .h files in
VTK.

The following command was used to obtain the symbol list:

nm libvtkNetCDF.a |grep " [TRD] "

This is the way to recreate the whole list:

nm bin/libvtkNetCDF.so |grep " [TRD] " | awk '{ print "#define "$3" vtk_netcdf_"$3 }' | \
        grep -v vtk_netcdf__fini | grep -v vtk_netcdf__init | sort

Note that _fini and _init should be excluded because they are not functions
implemented by the library but are rather created by the linker and
used when the shared library is loaded/unloaded from an executable.

*/

#define NC_calcsize vtk_netcdf_NC_calcsize
#define NC_check_id vtk_netcdf_NC_check_id
#define NC_check_name vtk_netcdf_NC_check_name
#define NC_check_vlen vtk_netcdf_NC_check_vlen
#define NC_findattr vtk_netcdf_NC_findattr
#define NC_findvar vtk_netcdf_NC_findvar
#define NC_lookupvar vtk_netcdf_NC_lookupvar
#define NC_sync vtk_netcdf_NC_sync
#define NC_var_shape vtk_netcdf_NC_var_shape
#define _NC3__enddef vtk_netcdf__NC3__enddef
#define _NC3_abort vtk_netcdf__NC3_abort
#define _NC3_close vtk_netcdf__NC3_close
#define _NC3_create vtk_netcdf__NC3_create
#define _NC3_def_dim vtk_netcdf__NC3_def_dim
#define _NC3_def_var vtk_netcdf__NC3_def_var
#define _NC3_del_att vtk_netcdf__NC3_del_att
#define _NC3_dispatcher vtk_netcdf__NC3_dispatcher
#define _NC3_get_att vtk_netcdf__NC3_get_att
#define _NC3_get_vara vtk_netcdf__NC3_get_vara
#define _NC3_initialize vtk_netcdf__NC3_initialize
#define _NC3_inq vtk_netcdf__NC3_inq
#define _NC3_inq_att vtk_netcdf__NC3_inq_att
#define _NC3_inq_attid vtk_netcdf__NC3_inq_attid
#define _NC3_inq_attname vtk_netcdf__NC3_inq_attname
#define _NC3_inq_base_pe vtk_netcdf__NC3_inq_base_pe
#define _NC3_inq_dim vtk_netcdf__NC3_inq_dim
#define _NC3_inq_dimid vtk_netcdf__NC3_inq_dimid
#define _NC3_inq_format vtk_netcdf__NC3_inq_format
#define _NC3_inq_type vtk_netcdf__NC3_inq_type
#define _NC3_inq_unlimdim vtk_netcdf__NC3_inq_unlimdim
#define _NC3_inq_var vtk_netcdf__NC3_inq_var
#define _NC3_inq_varid vtk_netcdf__NC3_inq_varid
#define _NC3_new_nc vtk_netcdf__NC3_new_nc
#define _NC3_open vtk_netcdf__NC3_open
#define _NC3_put_att vtk_netcdf__NC3_put_att
#define _NC3_put_vara vtk_netcdf__NC3_put_vara
#define _NC3_redef vtk_netcdf__NC3_redef
#define _NC3_rename_att vtk_netcdf__NC3_rename_att
#define _NC3_rename_dim vtk_netcdf__NC3_rename_dim
#define _NC3_rename_var vtk_netcdf__NC3_rename_var
#define _NC3_set_base_pe vtk_netcdf__NC3_set_base_pe
#define _NC3_set_fill vtk_netcdf__NC3_set_fill
#define _NC3_sync vtk_netcdf__NC3_sync
#define _NCDEFAULT_get_varm vtk_netcdf__NCDEFAULT_get_varm
#define _NCDEFAULT_get_vars vtk_netcdf__NCDEFAULT_get_vars
#define _NCDEFAULT_put_varm vtk_netcdf__NCDEFAULT_put_varm
#define _NCDEFAULT_put_vars vtk_netcdf__NCDEFAULT_put_vars
#define _NC_atomictypelen vtk_netcdf__NC_atomictypelen
#define _NC_atomictypename vtk_netcdf__NC_atomictypename
#define _NC_create vtk_netcdf__NC_create
#define _NC_dispatch_overlay vtk_netcdf__NC_dispatch_overlay
#define _NC_get_dispatch_override vtk_netcdf__NC_get_dispatch_override
#define _NC_get_vara vtk_netcdf__NC_get_vara
#define _NC_initialize vtk_netcdf__NC_initialize
#define _NC_open vtk_netcdf__NC_open
#define _NC_set_dispatch_override vtk_netcdf__NC_set_dispatch_override
#define _NC_testurl vtk_netcdf__NC_testurl
#define _NC_urlmodel vtk_netcdf__NC_urlmodel
#define _add_to_NCList vtk_netcdf__add_to_NCList
#define _count_NCList vtk_netcdf__count_NCList
#define _del_from_NCList vtk_netcdf__del_from_NCList
#define _find_in_NCList vtk_netcdf__find_in_NCList
#define _free_NCList vtk_netcdf__free_NCList
#define _hash_fast vtk_netcdf__hash_fast
#define _nc_create_par vtk_netcdf__nc_create_par
#define _nc_create_par_fortran vtk_netcdf__nc_create_par_fortran
#define _nc_get_att_longlong vtk_netcdf__nc_get_att_longlong
#define _nc_get_att_string vtk_netcdf__nc_get_att_string
#define _nc_get_att_ubyte vtk_netcdf__nc_get_att_ubyte
#define _nc_get_att_uint vtk_netcdf__nc_get_att_uint
#define _nc_get_att_ulonglong vtk_netcdf__nc_get_att_ulonglong
#define _nc_get_att_ushort vtk_netcdf__nc_get_att_ushort
#define _nc_get_var vtk_netcdf__nc_get_var
#define _nc_get_var1_longlong vtk_netcdf__nc_get_var1_longlong
#define _nc_get_var1_ubyte vtk_netcdf__nc_get_var1_ubyte
#define _nc_get_var1_uint vtk_netcdf__nc_get_var1_uint
#define _nc_get_var1_ulonglong vtk_netcdf__nc_get_var1_ulonglong
#define _nc_get_var1_ushort vtk_netcdf__nc_get_var1_ushort
#define _nc_get_var_longlong vtk_netcdf__nc_get_var_longlong
#define _nc_get_var_ubyte vtk_netcdf__nc_get_var_ubyte
#define _nc_get_var_uint vtk_netcdf__nc_get_var_uint
#define _nc_get_var_ulonglong vtk_netcdf__nc_get_var_ulonglong
#define _nc_get_var_ushort vtk_netcdf__nc_get_var_ushort
#define _nc_get_vara_longlong vtk_netcdf__nc_get_vara_longlong
#define _nc_get_vara_ubyte vtk_netcdf__nc_get_vara_ubyte
#define _nc_get_vara_uint vtk_netcdf__nc_get_vara_uint
#define _nc_get_vara_ulonglong vtk_netcdf__nc_get_vara_ulonglong
#define _nc_get_vara_ushort vtk_netcdf__nc_get_vara_ushort
#define _nc_get_varm_longlong vtk_netcdf__nc_get_varm_longlong
#define _nc_get_varm_ubyte vtk_netcdf__nc_get_varm_ubyte
#define _nc_get_varm_uint vtk_netcdf__nc_get_varm_uint
#define _nc_get_varm_ulonglong vtk_netcdf__nc_get_varm_ulonglong
#define _nc_get_varm_ushort vtk_netcdf__nc_get_varm_ushort
#define _nc_get_vars_longlong vtk_netcdf__nc_get_vars_longlong
#define _nc_get_vars_ubyte vtk_netcdf__nc_get_vars_ubyte
#define _nc_get_vars_uint vtk_netcdf__nc_get_vars_uint
#define _nc_get_vars_ulonglong vtk_netcdf__nc_get_vars_ulonglong
#define _nc_get_vars_ushort vtk_netcdf__nc_get_vars_ushort
#define _nc_inq_path vtk_netcdf__nc_inq_path
#define _nc_open_par vtk_netcdf__nc_open_par
#define _nc_open_par_fortran vtk_netcdf__nc_open_par_fortran
#define _nc_put_att_longlong vtk_netcdf__nc_put_att_longlong
#define _nc_put_att_string vtk_netcdf__nc_put_att_string
#define _nc_put_att_ubyte vtk_netcdf__nc_put_att_ubyte
#define _nc_put_att_uint vtk_netcdf__nc_put_att_uint
#define _nc_put_att_ulonglong vtk_netcdf__nc_put_att_ulonglong
#define _nc_put_att_ushort vtk_netcdf__nc_put_att_ushort
#define _nc_put_var vtk_netcdf__nc_put_var
#define _nc_put_var1_longlong vtk_netcdf__nc_put_var1_longlong
#define _nc_put_var1_ubyte vtk_netcdf__nc_put_var1_ubyte
#define _nc_put_var1_uint vtk_netcdf__nc_put_var1_uint
#define _nc_put_var1_ulonglong vtk_netcdf__nc_put_var1_ulonglong
#define _nc_put_var1_ushort vtk_netcdf__nc_put_var1_ushort
#define _nc_put_var_longlong vtk_netcdf__nc_put_var_longlong
#define _nc_put_var_ubyte vtk_netcdf__nc_put_var_ubyte
#define _nc_put_var_uint vtk_netcdf__nc_put_var_uint
#define _nc_put_var_ulonglong vtk_netcdf__nc_put_var_ulonglong
#define _nc_put_var_ushort vtk_netcdf__nc_put_var_ushort
#define _nc_put_vara_longlong vtk_netcdf__nc_put_vara_longlong
#define _nc_put_vara_ubyte vtk_netcdf__nc_put_vara_ubyte
#define _nc_put_vara_uint vtk_netcdf__nc_put_vara_uint
#define _nc_put_vara_ulonglong vtk_netcdf__nc_put_vara_ulonglong
#define _nc_put_vara_ushort vtk_netcdf__nc_put_vara_ushort
#define _nc_put_varm_longlong vtk_netcdf__nc_put_varm_longlong
#define _nc_put_varm_ubyte vtk_netcdf__nc_put_varm_ubyte
#define _nc_put_varm_uint vtk_netcdf__nc_put_varm_uint
#define _nc_put_varm_ulonglong vtk_netcdf__nc_put_varm_ulonglong
#define _nc_put_varm_ushort vtk_netcdf__nc_put_varm_ushort
#define _nc_put_vars_longlong vtk_netcdf__nc_put_vars_longlong
#define _nc_put_vars_ubyte vtk_netcdf__nc_put_vars_ubyte
#define _nc_put_vars_uint vtk_netcdf__nc_put_vars_uint
#define _nc_put_vars_ulonglong vtk_netcdf__nc_put_vars_ulonglong
#define _nc_put_vars_ushort vtk_netcdf__nc_put_vars_ushort
#define _nc_urldecodeparams vtk_netcdf__nc_urldecodeparams
#define _nc_urlfree vtk_netcdf__nc_urlfree
#define _nc_urllookup vtk_netcdf__nc_urllookup
#define _nc_urllookupvalue vtk_netcdf__nc_urllookupvalue
#define _nc_urlparse vtk_netcdf__nc_urlparse
#define _nc_urlsetconstraints vtk_netcdf__nc_urlsetconstraints
#define _nc_urlsetprotocol vtk_netcdf__nc_urlsetprotocol
#define _nc_var_par_access vtk_netcdf__nc_var_par_access
#define _ncbytesappend vtk_netcdf__ncbytesappend
#define _ncbytesappendn vtk_netcdf__ncbytesappendn
#define _ncbytescat vtk_netcdf__ncbytescat
#define _ncbytesdup vtk_netcdf__ncbytesdup
#define _ncbytesextract vtk_netcdf__ncbytesextract
#define _ncbytesfill vtk_netcdf__ncbytesfill
#define _ncbytesfree vtk_netcdf__ncbytesfree
#define _ncbytesget vtk_netcdf__ncbytesget
#define _ncbytesnew vtk_netcdf__ncbytesnew
#define _ncbytesnull vtk_netcdf__ncbytesnull
#define _ncbytesprepend vtk_netcdf__ncbytesprepend
#define _ncbytesset vtk_netcdf__ncbytesset
#define _ncbytessetalloc vtk_netcdf__ncbytessetalloc
#define _ncbytessetcontents vtk_netcdf__ncbytessetcontents
#define _ncbytessetlength vtk_netcdf__ncbytessetlength
#define _nclistclone vtk_netcdf__nclistclone
#define _nclistcontains vtk_netcdf__nclistcontains
#define _nclistdup vtk_netcdf__nclistdup
#define _nclistfree vtk_netcdf__nclistfree
#define _nclistget vtk_netcdf__nclistget
#define _nclistinsert vtk_netcdf__nclistinsert
#define _nclistnew vtk_netcdf__nclistnew
#define _nclistnull vtk_netcdf__nclistnull
#define _nclistpop vtk_netcdf__nclistpop
#define _nclistpush vtk_netcdf__nclistpush
#define _nclistremove vtk_netcdf__nclistremove
#define _nclistset vtk_netcdf__nclistset
#define _nclistsetalloc vtk_netcdf__nclistsetalloc
#define _nclistsetlength vtk_netcdf__nclistsetlength
#define _nclisttop vtk_netcdf__nclisttop
#define _nclistunique vtk_netcdf__nclistunique
#define _ncx_get_double_longlong vtk_netcdf__ncx_get_double_longlong
#define _ncx_get_double_uint vtk_netcdf__ncx_get_double_uint
#define _ncx_get_double_ulonglong vtk_netcdf__ncx_get_double_ulonglong
#define _ncx_get_float_longlong vtk_netcdf__ncx_get_float_longlong
#define _ncx_get_float_uint vtk_netcdf__ncx_get_float_uint
#define _ncx_get_float_ulonglong vtk_netcdf__ncx_get_float_ulonglong
#define _ncx_get_int_longlong vtk_netcdf__ncx_get_int_longlong
#define _ncx_get_int_uint vtk_netcdf__ncx_get_int_uint
#define _ncx_get_int_ulonglong vtk_netcdf__ncx_get_int_ulonglong
#define _ncx_get_short_longlong vtk_netcdf__ncx_get_short_longlong
#define _ncx_get_short_uint vtk_netcdf__ncx_get_short_uint
#define _ncx_get_short_ulonglong vtk_netcdf__ncx_get_short_ulonglong
#define _ncx_getn_double_longlong vtk_netcdf__ncx_getn_double_longlong
#define _ncx_getn_double_uint vtk_netcdf__ncx_getn_double_uint
#define _ncx_getn_double_ulonglong vtk_netcdf__ncx_getn_double_ulonglong
#define _ncx_getn_float_longlong vtk_netcdf__ncx_getn_float_longlong
#define _ncx_getn_float_uint vtk_netcdf__ncx_getn_float_uint
#define _ncx_getn_float_ulonglong vtk_netcdf__ncx_getn_float_ulonglong
#define _ncx_getn_int_longlong vtk_netcdf__ncx_getn_int_longlong
#define _ncx_getn_int_uint vtk_netcdf__ncx_getn_int_uint
#define _ncx_getn_int_ulonglong vtk_netcdf__ncx_getn_int_ulonglong
#define _ncx_getn_schar_longlong vtk_netcdf__ncx_getn_schar_longlong
#define _ncx_getn_schar_uint vtk_netcdf__ncx_getn_schar_uint
#define _ncx_getn_schar_ulonglong vtk_netcdf__ncx_getn_schar_ulonglong
#define _ncx_getn_short_longlong vtk_netcdf__ncx_getn_short_longlong
#define _ncx_getn_short_uint vtk_netcdf__ncx_getn_short_uint
#define _ncx_getn_short_ulonglong vtk_netcdf__ncx_getn_short_ulonglong
#define _ncx_pad_getn_schar_longlong vtk_netcdf__ncx_pad_getn_schar_longlong
#define _ncx_pad_getn_schar_uint vtk_netcdf__ncx_pad_getn_schar_uint
#define _ncx_pad_getn_schar_ulonglong vtk_netcdf__ncx_pad_getn_schar_ulonglong
#define _ncx_pad_getn_short_longlong vtk_netcdf__ncx_pad_getn_short_longlong
#define _ncx_pad_getn_short_uint vtk_netcdf__ncx_pad_getn_short_uint
#define _ncx_pad_getn_short_ulonglong vtk_netcdf__ncx_pad_getn_short_ulonglong
#define _ncx_pad_putn_schar_longlong vtk_netcdf__ncx_pad_putn_schar_longlong
#define _ncx_pad_putn_schar_uint vtk_netcdf__ncx_pad_putn_schar_uint
#define _ncx_pad_putn_schar_ulonglong vtk_netcdf__ncx_pad_putn_schar_ulonglong
#define _ncx_pad_putn_short_longlong vtk_netcdf__ncx_pad_putn_short_longlong
#define _ncx_pad_putn_short_uint vtk_netcdf__ncx_pad_putn_short_uint
#define _ncx_pad_putn_short_ulonglong vtk_netcdf__ncx_pad_putn_short_ulonglong
#define _ncx_put_double_longlong vtk_netcdf__ncx_put_double_longlong
#define _ncx_put_double_uint vtk_netcdf__ncx_put_double_uint
#define _ncx_put_double_ulonglong vtk_netcdf__ncx_put_double_ulonglong
#define _ncx_put_float_longlong vtk_netcdf__ncx_put_float_longlong
#define _ncx_put_float_uint vtk_netcdf__ncx_put_float_uint
#define _ncx_put_float_ulonglong vtk_netcdf__ncx_put_float_ulonglong
#define _ncx_put_int_longlong vtk_netcdf__ncx_put_int_longlong
#define _ncx_put_int_uint vtk_netcdf__ncx_put_int_uint
#define _ncx_put_int_ulonglong vtk_netcdf__ncx_put_int_ulonglong
#define _ncx_put_short_longlong vtk_netcdf__ncx_put_short_longlong
#define _ncx_put_short_uint vtk_netcdf__ncx_put_short_uint
#define _ncx_put_short_ulonglong vtk_netcdf__ncx_put_short_ulonglong
#define _ncx_putn_double_longlong vtk_netcdf__ncx_putn_double_longlong
#define _ncx_putn_double_uint vtk_netcdf__ncx_putn_double_uint
#define _ncx_putn_double_ulonglong vtk_netcdf__ncx_putn_double_ulonglong
#define _ncx_putn_float_longlong vtk_netcdf__ncx_putn_float_longlong
#define _ncx_putn_float_uint vtk_netcdf__ncx_putn_float_uint
#define _ncx_putn_float_ulonglong vtk_netcdf__ncx_putn_float_ulonglong
#define _ncx_putn_int_longlong vtk_netcdf__ncx_putn_int_longlong
#define _ncx_putn_int_uint vtk_netcdf__ncx_putn_int_uint
#define _ncx_putn_int_ulonglong vtk_netcdf__ncx_putn_int_ulonglong
#define _ncx_putn_schar_longlong vtk_netcdf__ncx_putn_schar_longlong
#define _ncx_putn_schar_uint vtk_netcdf__ncx_putn_schar_uint
#define _ncx_putn_schar_ulonglong vtk_netcdf__ncx_putn_schar_ulonglong
#define _ncx_putn_short_longlong vtk_netcdf__ncx_putn_short_longlong
#define _ncx_putn_short_uint vtk_netcdf__ncx_putn_short_uint
#define _ncx_putn_short_ulonglong vtk_netcdf__ncx_putn_short_ulonglong
#define _utf8proc_NFC vtk_netcdf__utf8proc_NFC
#define _utf8proc_NFD vtk_netcdf__utf8proc_NFD
#define _utf8proc_NFKC vtk_netcdf__utf8proc_NFKC
#define _utf8proc_NFKD vtk_netcdf__utf8proc_NFKD
#define _utf8proc_check vtk_netcdf__utf8proc_check
#define _utf8proc_codepoint_valid vtk_netcdf__utf8proc_codepoint_valid
#define _utf8proc_decompose vtk_netcdf__utf8proc_decompose
#define _utf8proc_decompose_char vtk_netcdf__utf8proc_decompose_char
#define _utf8proc_encode_char vtk_netcdf__utf8proc_encode_char
#define _utf8proc_errmsg vtk_netcdf__utf8proc_errmsg
#define _utf8proc_get_property vtk_netcdf__utf8proc_get_property
#define _utf8proc_iterate vtk_netcdf__utf8proc_iterate
#define _utf8proc_map vtk_netcdf__utf8proc_map
#define _utf8proc_reencode vtk_netcdf__utf8proc_reencode
#define default_create_format vtk_netcdf_default_create_format
#define dup_NC_attrarrayV vtk_netcdf_dup_NC_attrarrayV
#define dup_NC_dimarrayV vtk_netcdf_dup_NC_dimarrayV
#define dup_NC_vararrayV vtk_netcdf_dup_NC_vararrayV
#define elem_NC_attrarray vtk_netcdf_elem_NC_attrarray
#define elem_NC_dimarray vtk_netcdf_elem_NC_dimarray
#define fill_NC_var vtk_netcdf_fill_NC_var
#define find_NC_Udim vtk_netcdf_find_NC_Udim
#define free_NC_attr vtk_netcdf_free_NC_attr
#define free_NC_attrarrayV vtk_netcdf_free_NC_attrarrayV
#define free_NC_attrarrayV0 vtk_netcdf_free_NC_attrarrayV0
#define free_NC_dim vtk_netcdf_free_NC_dim
#define free_NC_dimarrayV vtk_netcdf_free_NC_dimarrayV
#define free_NC_dimarrayV0 vtk_netcdf_free_NC_dimarrayV0
#define free_NC_string vtk_netcdf_free_NC_string
#define free_NC_var vtk_netcdf_free_NC_var
#define free_NC_vararrayV vtk_netcdf_free_NC_vararrayV
#define free_NC_vararrayV0 vtk_netcdf_free_NC_vararrayV0
#define nc__create vtk_netcdf_nc__create
#define nc__create_mp vtk_netcdf_nc__create_mp
#define nc__enddef vtk_netcdf_nc__enddef
#define nc__open vtk_netcdf_nc__open
#define nc__open_mp vtk_netcdf_nc__open_mp
#define nc_abort vtk_netcdf_nc_abort
#define nc_advise vtk_netcdf_nc_advise
#define nc_cktype vtk_netcdf_nc_cktype
#define nc_close vtk_netcdf_nc_close
#define nc_copy_att vtk_netcdf_nc_copy_att
#define nc_copy_var vtk_netcdf_nc_copy_var
#define nc_create vtk_netcdf_nc_create
#define nc_def_dim vtk_netcdf_nc_def_dim
#define nc_def_var vtk_netcdf_nc_def_var
#define nc_del_att vtk_netcdf_nc_del_att
#define nc_delete vtk_netcdf_nc_delete
#define nc_delete_mp vtk_netcdf_nc_delete_mp
#define nc_enddef vtk_netcdf_nc_enddef
#define nc_get_NC vtk_netcdf_nc_get_NC
#define nc_get_att vtk_netcdf_nc_get_att
#define nc_get_att_double vtk_netcdf_nc_get_att_double
#define nc_get_att_float vtk_netcdf_nc_get_att_float
#define nc_get_att_int vtk_netcdf_nc_get_att_int
#define nc_get_att_long vtk_netcdf_nc_get_att_long
#define nc_get_att_schar vtk_netcdf_nc_get_att_schar
#define nc_get_att_short vtk_netcdf_nc_get_att_short
#define nc_get_att_text vtk_netcdf_nc_get_att_text
#define nc_get_att_uchar vtk_netcdf_nc_get_att_uchar
#define nc_get_rec vtk_netcdf_nc_get_rec
#define nc_get_var1 vtk_netcdf_nc_get_var1
#define nc_get_var1_double vtk_netcdf_nc_get_var1_double
#define nc_get_var1_float vtk_netcdf_nc_get_var1_float
#define nc_get_var1_int vtk_netcdf_nc_get_var1_int
#define nc_get_var1_long vtk_netcdf_nc_get_var1_long
#define nc_get_var1_schar vtk_netcdf_nc_get_var1_schar
#define nc_get_var1_short vtk_netcdf_nc_get_var1_short
#define nc_get_var1_text vtk_netcdf_nc_get_var1_text
#define nc_get_var1_uchar vtk_netcdf_nc_get_var1_uchar
#define nc_get_var_double vtk_netcdf_nc_get_var_double
#define nc_get_var_float vtk_netcdf_nc_get_var_float
#define nc_get_var_int vtk_netcdf_nc_get_var_int
#define nc_get_var_long vtk_netcdf_nc_get_var_long
#define nc_get_var_schar vtk_netcdf_nc_get_var_schar
#define nc_get_var_short vtk_netcdf_nc_get_var_short
#define nc_get_var_text vtk_netcdf_nc_get_var_text
#define nc_get_var_uchar vtk_netcdf_nc_get_var_uchar
#define nc_get_vara vtk_netcdf_nc_get_vara
#define nc_get_vara_double vtk_netcdf_nc_get_vara_double
#define nc_get_vara_float vtk_netcdf_nc_get_vara_float
#define nc_get_vara_int vtk_netcdf_nc_get_vara_int
#define nc_get_vara_long vtk_netcdf_nc_get_vara_long
#define nc_get_vara_schar vtk_netcdf_nc_get_vara_schar
#define nc_get_vara_short vtk_netcdf_nc_get_vara_short
#define nc_get_vara_text vtk_netcdf_nc_get_vara_text
#define nc_get_vara_uchar vtk_netcdf_nc_get_vara_uchar
#define nc_get_varm vtk_netcdf_nc_get_varm
#define nc_get_varm_double vtk_netcdf_nc_get_varm_double
#define nc_get_varm_float vtk_netcdf_nc_get_varm_float
#define nc_get_varm_int vtk_netcdf_nc_get_varm_int
#define nc_get_varm_long vtk_netcdf_nc_get_varm_long
#define nc_get_varm_schar vtk_netcdf_nc_get_varm_schar
#define nc_get_varm_short vtk_netcdf_nc_get_varm_short
#define nc_get_varm_text vtk_netcdf_nc_get_varm_text
#define nc_get_varm_uchar vtk_netcdf_nc_get_varm_uchar
#define nc_get_vars vtk_netcdf_nc_get_vars
#define nc_get_vars_double vtk_netcdf_nc_get_vars_double
#define nc_get_vars_float vtk_netcdf_nc_get_vars_float
#define nc_get_vars_int vtk_netcdf_nc_get_vars_int
#define nc_get_vars_long vtk_netcdf_nc_get_vars_long
#define nc_get_vars_schar vtk_netcdf_nc_get_vars_schar
#define nc_get_vars_short vtk_netcdf_nc_get_vars_short
#define nc_get_vars_text vtk_netcdf_nc_get_vars_text
#define nc_get_vars_uchar vtk_netcdf_nc_get_vars_uchar
#define nc_inq vtk_netcdf_nc_inq
#define nc_inq_att vtk_netcdf_nc_inq_att
#define nc_inq_attid vtk_netcdf_nc_inq_attid
#define nc_inq_attlen vtk_netcdf_nc_inq_attlen
#define nc_inq_attname vtk_netcdf_nc_inq_attname
#define nc_inq_atttype vtk_netcdf_nc_inq_atttype
#define nc_inq_base_pe vtk_netcdf_nc_inq_base_pe
#define nc_inq_dim vtk_netcdf_nc_inq_dim
#define nc_inq_dimid vtk_netcdf_nc_inq_dimid
#define nc_inq_dimlen vtk_netcdf_nc_inq_dimlen
#define nc_inq_dimname vtk_netcdf_nc_inq_dimname
#define nc_inq_format vtk_netcdf_nc_inq_format
#define nc_inq_libvers vtk_netcdf_nc_inq_libvers
#define nc_inq_natts vtk_netcdf_nc_inq_natts
#define nc_inq_ndims vtk_netcdf_nc_inq_ndims
#define nc_inq_nvars vtk_netcdf_nc_inq_nvars
#define nc_inq_rec vtk_netcdf_nc_inq_rec
#define nc_inq_type vtk_netcdf_nc_inq_type
#define nc_inq_unlimdim vtk_netcdf_nc_inq_unlimdim
#define nc_inq_var vtk_netcdf_nc_inq_var
#define nc_inq_vardimid vtk_netcdf_nc_inq_vardimid
#define nc_inq_varid vtk_netcdf_nc_inq_varid
#define nc_inq_varname vtk_netcdf_nc_inq_varname
#define nc_inq_varnatts vtk_netcdf_nc_inq_varnatts
#define nc_inq_varndims vtk_netcdf_nc_inq_varndims
#define nc_inq_vartype vtk_netcdf_nc_inq_vartype
#define nc_open vtk_netcdf_nc_open
#define nc_put_att vtk_netcdf_nc_put_att
#define nc_put_att_double vtk_netcdf_nc_put_att_double
#define nc_put_att_float vtk_netcdf_nc_put_att_float
#define nc_put_att_int vtk_netcdf_nc_put_att_int
#define nc_put_att_long vtk_netcdf_nc_put_att_long
#define nc_put_att_schar vtk_netcdf_nc_put_att_schar
#define nc_put_att_short vtk_netcdf_nc_put_att_short
#define nc_put_att_text vtk_netcdf_nc_put_att_text
#define nc_put_att_uchar vtk_netcdf_nc_put_att_uchar
#define nc_put_rec vtk_netcdf_nc_put_rec
#define nc_put_var1 vtk_netcdf_nc_put_var1
#define nc_put_var1_double vtk_netcdf_nc_put_var1_double
#define nc_put_var1_float vtk_netcdf_nc_put_var1_float
#define nc_put_var1_int vtk_netcdf_nc_put_var1_int
#define nc_put_var1_long vtk_netcdf_nc_put_var1_long
#define nc_put_var1_schar vtk_netcdf_nc_put_var1_schar
#define nc_put_var1_short vtk_netcdf_nc_put_var1_short
#define nc_put_var1_text vtk_netcdf_nc_put_var1_text
#define nc_put_var1_uchar vtk_netcdf_nc_put_var1_uchar
#define nc_put_var_double vtk_netcdf_nc_put_var_double
#define nc_put_var_float vtk_netcdf_nc_put_var_float
#define nc_put_var_int vtk_netcdf_nc_put_var_int
#define nc_put_var_long vtk_netcdf_nc_put_var_long
#define nc_put_var_schar vtk_netcdf_nc_put_var_schar
#define nc_put_var_short vtk_netcdf_nc_put_var_short
#define nc_put_var_text vtk_netcdf_nc_put_var_text
#define nc_put_var_uchar vtk_netcdf_nc_put_var_uchar
#define nc_put_vara vtk_netcdf_nc_put_vara
#define nc_put_vara_double vtk_netcdf_nc_put_vara_double
#define nc_put_vara_float vtk_netcdf_nc_put_vara_float
#define nc_put_vara_int vtk_netcdf_nc_put_vara_int
#define nc_put_vara_long vtk_netcdf_nc_put_vara_long
#define nc_put_vara_schar vtk_netcdf_nc_put_vara_schar
#define nc_put_vara_short vtk_netcdf_nc_put_vara_short
#define nc_put_vara_text vtk_netcdf_nc_put_vara_text
#define nc_put_vara_uchar vtk_netcdf_nc_put_vara_uchar
#define nc_put_varm vtk_netcdf_nc_put_varm
#define nc_put_varm_double vtk_netcdf_nc_put_varm_double
#define nc_put_varm_float vtk_netcdf_nc_put_varm_float
#define nc_put_varm_int vtk_netcdf_nc_put_varm_int
#define nc_put_varm_long vtk_netcdf_nc_put_varm_long
#define nc_put_varm_schar vtk_netcdf_nc_put_varm_schar
#define nc_put_varm_short vtk_netcdf_nc_put_varm_short
#define nc_put_varm_text vtk_netcdf_nc_put_varm_text
#define nc_put_varm_uchar vtk_netcdf_nc_put_varm_uchar
#define nc_put_vars vtk_netcdf_nc_put_vars
#define nc_put_vars_double vtk_netcdf_nc_put_vars_double
#define nc_put_vars_float vtk_netcdf_nc_put_vars_float
#define nc_put_vars_int vtk_netcdf_nc_put_vars_int
#define nc_put_vars_long vtk_netcdf_nc_put_vars_long
#define nc_put_vars_schar vtk_netcdf_nc_put_vars_schar
#define nc_put_vars_short vtk_netcdf_nc_put_vars_short
#define nc_put_vars_text vtk_netcdf_nc_put_vars_text
#define nc_put_vars_uchar vtk_netcdf_nc_put_vars_uchar
#define nc_redef vtk_netcdf_nc_redef
#define nc_rename_att vtk_netcdf_nc_rename_att
#define nc_rename_dim vtk_netcdf_nc_rename_dim
#define nc_rename_var vtk_netcdf_nc_rename_var
#define nc_set_base_pe vtk_netcdf_nc_set_base_pe
#define nc_set_default_format vtk_netcdf_nc_set_default_format
#define nc_set_fill vtk_netcdf_nc_set_fill
#define nc_strerror vtk_netcdf_nc_strerror
#define nc_sync vtk_netcdf_nc_sync
#define ncabort vtk_netcdf_ncabort
#define ncattcopy vtk_netcdf_ncattcopy
#define ncattdel vtk_netcdf_ncattdel
#define ncattget vtk_netcdf_ncattget
#define ncattinq vtk_netcdf_ncattinq
#define ncattname vtk_netcdf_ncattname
#define ncattput vtk_netcdf_ncattput
#define ncattrename vtk_netcdf_ncattrename
#define ncclose vtk_netcdf_ncclose
#define nccreate vtk_netcdf_nccreate
#define ncdimdef vtk_netcdf_ncdimdef
#define ncdimid vtk_netcdf_ncdimid
#define ncdiminq vtk_netcdf_ncdiminq
#define ncdimrename vtk_netcdf_ncdimrename
#define ncendef vtk_netcdf_ncendef
#define ncerr vtk_netcdf_ncerr
#define ncinquire vtk_netcdf_ncinquire
#define ncio_close vtk_netcdf_ncio_close
#define ncio_create vtk_netcdf_ncio_create
#define ncio_filesize vtk_netcdf_ncio_filesize
#define ncio_open vtk_netcdf_ncio_open
#define ncio_pad_length vtk_netcdf_ncio_pad_length
#define ncopen vtk_netcdf_ncopen
#define ncopts vtk_netcdf_ncopts
#define ncrecget vtk_netcdf_ncrecget
#define ncrecinq vtk_netcdf_ncrecinq
#define ncrecput vtk_netcdf_ncrecput
#define ncredef vtk_netcdf_ncredef
#define ncsetfill vtk_netcdf_ncsetfill
#define ncsync vtk_netcdf_ncsync
#define nctypelen vtk_netcdf_nctypelen
#define ncvardef vtk_netcdf_ncvardef
#define ncvarget vtk_netcdf_ncvarget
#define ncvarget1 vtk_netcdf_ncvarget1
#define ncvargetg vtk_netcdf_ncvargetg
#define ncvargets vtk_netcdf_ncvargets
#define ncvarid vtk_netcdf_ncvarid
#define ncvarinq vtk_netcdf_ncvarinq
#define ncvarput vtk_netcdf_ncvarput
#define ncvarput1 vtk_netcdf_ncvarput1
#define ncvarputg vtk_netcdf_ncvarputg
#define ncvarputs vtk_netcdf_ncvarputs
#define ncvarrename vtk_netcdf_ncvarrename
#define ncx_get_double_double vtk_netcdf_ncx_get_double_double
#define ncx_get_double_float vtk_netcdf_ncx_get_double_float
#define ncx_get_double_int vtk_netcdf_ncx_get_double_int
#define ncx_get_double_long vtk_netcdf_ncx_get_double_long
#define ncx_get_double_schar vtk_netcdf_ncx_get_double_schar
#define ncx_get_double_short vtk_netcdf_ncx_get_double_short
#define ncx_get_double_uchar vtk_netcdf_ncx_get_double_uchar
#define ncx_get_float_double vtk_netcdf_ncx_get_float_double
#define ncx_get_float_float vtk_netcdf_ncx_get_float_float
#define ncx_get_float_int vtk_netcdf_ncx_get_float_int
#define ncx_get_float_long vtk_netcdf_ncx_get_float_long
#define ncx_get_float_schar vtk_netcdf_ncx_get_float_schar
#define ncx_get_float_short vtk_netcdf_ncx_get_float_short
#define ncx_get_float_uchar vtk_netcdf_ncx_get_float_uchar
#define ncx_get_int_double vtk_netcdf_ncx_get_int_double
#define ncx_get_int_float vtk_netcdf_ncx_get_int_float
#define ncx_get_int_int vtk_netcdf_ncx_get_int_int
#define ncx_get_int_long vtk_netcdf_ncx_get_int_long
#define ncx_get_int_schar vtk_netcdf_ncx_get_int_schar
#define ncx_get_int_short vtk_netcdf_ncx_get_int_short
#define ncx_get_int_uchar vtk_netcdf_ncx_get_int_uchar
#define ncx_get_off_t vtk_netcdf_ncx_get_off_t
#define ncx_get_short_double vtk_netcdf_ncx_get_short_double
#define ncx_get_short_float vtk_netcdf_ncx_get_short_float
#define ncx_get_short_int vtk_netcdf_ncx_get_short_int
#define ncx_get_short_long vtk_netcdf_ncx_get_short_long
#define ncx_get_short_schar vtk_netcdf_ncx_get_short_schar
#define ncx_get_short_short vtk_netcdf_ncx_get_short_short
#define ncx_get_short_uchar vtk_netcdf_ncx_get_short_uchar
#define ncx_get_size_t vtk_netcdf_ncx_get_size_t
#define ncx_getn_double_double vtk_netcdf_ncx_getn_double_double
#define ncx_getn_double_float vtk_netcdf_ncx_getn_double_float
#define ncx_getn_double_int vtk_netcdf_ncx_getn_double_int
#define ncx_getn_double_long vtk_netcdf_ncx_getn_double_long
#define ncx_getn_double_schar vtk_netcdf_ncx_getn_double_schar
#define ncx_getn_double_short vtk_netcdf_ncx_getn_double_short
#define ncx_getn_double_uchar vtk_netcdf_ncx_getn_double_uchar
#define ncx_getn_float_double vtk_netcdf_ncx_getn_float_double
#define ncx_getn_float_float vtk_netcdf_ncx_getn_float_float
#define ncx_getn_float_int vtk_netcdf_ncx_getn_float_int
#define ncx_getn_float_long vtk_netcdf_ncx_getn_float_long
#define ncx_getn_float_schar vtk_netcdf_ncx_getn_float_schar
#define ncx_getn_float_short vtk_netcdf_ncx_getn_float_short
#define ncx_getn_float_uchar vtk_netcdf_ncx_getn_float_uchar
#define ncx_getn_int_double vtk_netcdf_ncx_getn_int_double
#define ncx_getn_int_float vtk_netcdf_ncx_getn_int_float
#define ncx_getn_int_int vtk_netcdf_ncx_getn_int_int
#define ncx_getn_int_long vtk_netcdf_ncx_getn_int_long
#define ncx_getn_int_schar vtk_netcdf_ncx_getn_int_schar
#define ncx_getn_int_short vtk_netcdf_ncx_getn_int_short
#define ncx_getn_int_uchar vtk_netcdf_ncx_getn_int_uchar
#define ncx_getn_schar_double vtk_netcdf_ncx_getn_schar_double
#define ncx_getn_schar_float vtk_netcdf_ncx_getn_schar_float
#define ncx_getn_schar_int vtk_netcdf_ncx_getn_schar_int
#define ncx_getn_schar_long vtk_netcdf_ncx_getn_schar_long
#define ncx_getn_schar_schar vtk_netcdf_ncx_getn_schar_schar
#define ncx_getn_schar_short vtk_netcdf_ncx_getn_schar_short
#define ncx_getn_schar_uchar vtk_netcdf_ncx_getn_schar_uchar
#define ncx_getn_short_double vtk_netcdf_ncx_getn_short_double
#define ncx_getn_short_float vtk_netcdf_ncx_getn_short_float
#define ncx_getn_short_int vtk_netcdf_ncx_getn_short_int
#define ncx_getn_short_long vtk_netcdf_ncx_getn_short_long
#define ncx_getn_short_schar vtk_netcdf_ncx_getn_short_schar
#define ncx_getn_short_short vtk_netcdf_ncx_getn_short_short
#define ncx_getn_short_uchar vtk_netcdf_ncx_getn_short_uchar
#define ncx_getn_text vtk_netcdf_ncx_getn_text
#define ncx_getn_void vtk_netcdf_ncx_getn_void
#define ncx_howmany vtk_netcdf_ncx_howmany
#define ncx_len_NC vtk_netcdf_ncx_len_NC
#define ncx_pad_getn_schar_double vtk_netcdf_ncx_pad_getn_schar_double
#define ncx_pad_getn_schar_float vtk_netcdf_ncx_pad_getn_schar_float
#define ncx_pad_getn_schar_int vtk_netcdf_ncx_pad_getn_schar_int
#define ncx_pad_getn_schar_long vtk_netcdf_ncx_pad_getn_schar_long
#define ncx_pad_getn_schar_schar vtk_netcdf_ncx_pad_getn_schar_schar
#define ncx_pad_getn_schar_short vtk_netcdf_ncx_pad_getn_schar_short
#define ncx_pad_getn_schar_uchar vtk_netcdf_ncx_pad_getn_schar_uchar
#define ncx_pad_getn_short_double vtk_netcdf_ncx_pad_getn_short_double
#define ncx_pad_getn_short_float vtk_netcdf_ncx_pad_getn_short_float
#define ncx_pad_getn_short_int vtk_netcdf_ncx_pad_getn_short_int
#define ncx_pad_getn_short_long vtk_netcdf_ncx_pad_getn_short_long
#define ncx_pad_getn_short_schar vtk_netcdf_ncx_pad_getn_short_schar
#define ncx_pad_getn_short_short vtk_netcdf_ncx_pad_getn_short_short
#define ncx_pad_getn_short_uchar vtk_netcdf_ncx_pad_getn_short_uchar
#define ncx_pad_getn_text vtk_netcdf_ncx_pad_getn_text
#define ncx_pad_getn_void vtk_netcdf_ncx_pad_getn_void
#define ncx_pad_putn_schar_double vtk_netcdf_ncx_pad_putn_schar_double
#define ncx_pad_putn_schar_float vtk_netcdf_ncx_pad_putn_schar_float
#define ncx_pad_putn_schar_int vtk_netcdf_ncx_pad_putn_schar_int
#define ncx_pad_putn_schar_long vtk_netcdf_ncx_pad_putn_schar_long
#define ncx_pad_putn_schar_schar vtk_netcdf_ncx_pad_putn_schar_schar
#define ncx_pad_putn_schar_short vtk_netcdf_ncx_pad_putn_schar_short
#define ncx_pad_putn_schar_uchar vtk_netcdf_ncx_pad_putn_schar_uchar
#define ncx_pad_putn_short_double vtk_netcdf_ncx_pad_putn_short_double
#define ncx_pad_putn_short_float vtk_netcdf_ncx_pad_putn_short_float
#define ncx_pad_putn_short_int vtk_netcdf_ncx_pad_putn_short_int
#define ncx_pad_putn_short_long vtk_netcdf_ncx_pad_putn_short_long
#define ncx_pad_putn_short_schar vtk_netcdf_ncx_pad_putn_short_schar
#define ncx_pad_putn_short_short vtk_netcdf_ncx_pad_putn_short_short
#define ncx_pad_putn_short_uchar vtk_netcdf_ncx_pad_putn_short_uchar
#define ncx_pad_putn_text vtk_netcdf_ncx_pad_putn_text
#define ncx_pad_putn_void vtk_netcdf_ncx_pad_putn_void
#define ncx_put_NC vtk_netcdf_ncx_put_NC
#define ncx_put_double_double vtk_netcdf_ncx_put_double_double
#define ncx_put_double_float vtk_netcdf_ncx_put_double_float
#define ncx_put_double_int vtk_netcdf_ncx_put_double_int
#define ncx_put_double_long vtk_netcdf_ncx_put_double_long
#define ncx_put_double_schar vtk_netcdf_ncx_put_double_schar
#define ncx_put_double_short vtk_netcdf_ncx_put_double_short
#define ncx_put_double_uchar vtk_netcdf_ncx_put_double_uchar
#define ncx_put_float_double vtk_netcdf_ncx_put_float_double
#define ncx_put_float_float vtk_netcdf_ncx_put_float_float
#define ncx_put_float_int vtk_netcdf_ncx_put_float_int
#define ncx_put_float_long vtk_netcdf_ncx_put_float_long
#define ncx_put_float_schar vtk_netcdf_ncx_put_float_schar
#define ncx_put_float_short vtk_netcdf_ncx_put_float_short
#define ncx_put_float_uchar vtk_netcdf_ncx_put_float_uchar
#define ncx_put_int_double vtk_netcdf_ncx_put_int_double
#define ncx_put_int_float vtk_netcdf_ncx_put_int_float
#define ncx_put_int_int vtk_netcdf_ncx_put_int_int
#define ncx_put_int_long vtk_netcdf_ncx_put_int_long
#define ncx_put_int_schar vtk_netcdf_ncx_put_int_schar
#define ncx_put_int_short vtk_netcdf_ncx_put_int_short
#define ncx_put_int_uchar vtk_netcdf_ncx_put_int_uchar
#define ncx_put_off_t vtk_netcdf_ncx_put_off_t
#define ncx_put_short_double vtk_netcdf_ncx_put_short_double
#define ncx_put_short_float vtk_netcdf_ncx_put_short_float
#define ncx_put_short_int vtk_netcdf_ncx_put_short_int
#define ncx_put_short_long vtk_netcdf_ncx_put_short_long
#define ncx_put_short_schar vtk_netcdf_ncx_put_short_schar
#define ncx_put_short_short vtk_netcdf_ncx_put_short_short
#define ncx_put_short_uchar vtk_netcdf_ncx_put_short_uchar
#define ncx_put_size_t vtk_netcdf_ncx_put_size_t
#define ncx_putn_double_double vtk_netcdf_ncx_putn_double_double
#define ncx_putn_double_float vtk_netcdf_ncx_putn_double_float
#define ncx_putn_double_int vtk_netcdf_ncx_putn_double_int
#define ncx_putn_double_long vtk_netcdf_ncx_putn_double_long
#define ncx_putn_double_schar vtk_netcdf_ncx_putn_double_schar
#define ncx_putn_double_short vtk_netcdf_ncx_putn_double_short
#define ncx_putn_double_uchar vtk_netcdf_ncx_putn_double_uchar
#define ncx_putn_float_double vtk_netcdf_ncx_putn_float_double
#define ncx_putn_float_float vtk_netcdf_ncx_putn_float_float
#define ncx_putn_float_int vtk_netcdf_ncx_putn_float_int
#define ncx_putn_float_long vtk_netcdf_ncx_putn_float_long
#define ncx_putn_float_schar vtk_netcdf_ncx_putn_float_schar
#define ncx_putn_float_short vtk_netcdf_ncx_putn_float_short
#define ncx_putn_float_uchar vtk_netcdf_ncx_putn_float_uchar
#define ncx_putn_int_double vtk_netcdf_ncx_putn_int_double
#define ncx_putn_int_float vtk_netcdf_ncx_putn_int_float
#define ncx_putn_int_int vtk_netcdf_ncx_putn_int_int
#define ncx_putn_int_long vtk_netcdf_ncx_putn_int_long
#define ncx_putn_int_schar vtk_netcdf_ncx_putn_int_schar
#define ncx_putn_int_short vtk_netcdf_ncx_putn_int_short
#define ncx_putn_int_uchar vtk_netcdf_ncx_putn_int_uchar
#define ncx_putn_schar_double vtk_netcdf_ncx_putn_schar_double
#define ncx_putn_schar_float vtk_netcdf_ncx_putn_schar_float
#define ncx_putn_schar_int vtk_netcdf_ncx_putn_schar_int
#define ncx_putn_schar_long vtk_netcdf_ncx_putn_schar_long
#define ncx_putn_schar_schar vtk_netcdf_ncx_putn_schar_schar
#define ncx_putn_schar_short vtk_netcdf_ncx_putn_schar_short
#define ncx_putn_schar_uchar vtk_netcdf_ncx_putn_schar_uchar
#define ncx_putn_short_double vtk_netcdf_ncx_putn_short_double
#define ncx_putn_short_float vtk_netcdf_ncx_putn_short_float
#define ncx_putn_short_int vtk_netcdf_ncx_putn_short_int
#define ncx_putn_short_long vtk_netcdf_ncx_putn_short_long
#define ncx_putn_short_schar vtk_netcdf_ncx_putn_short_schar
#define ncx_putn_short_short vtk_netcdf_ncx_putn_short_short
#define ncx_putn_short_uchar vtk_netcdf_ncx_putn_short_uchar
#define ncx_putn_text vtk_netcdf_ncx_putn_text
#define ncx_putn_void vtk_netcdf_ncx_putn_void
#define ncx_szof vtk_netcdf_ncx_szof
#define new_NC_string vtk_netcdf_new_NC_string
#define new_x_NC_attr vtk_netcdf_new_x_NC_attr
#define new_x_NC_dim vtk_netcdf_new_x_NC_dim
#define new_x_NC_var vtk_netcdf_new_x_NC_var
#define nextUTF8 vtk_netcdf_nextUTF8
#define nulldup vtk_netcdf_nulldup
#define read_numrecs vtk_netcdf_read_numrecs
#define set_NC_string vtk_netcdf_set_NC_string
#define write_numrecs vtk_netcdf_write_numrecs

#include <vtknetcdf/ncconfig.h>

#endif /* vtk_netcdf_mangle_h */

