/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.parser;

import java.util.HashMap;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.sav.ContentHandler;
import org.web3d.vrml.sav.ErrorHandler;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.RouteHandler;
import org.web3d.vrml.sav.SAVNotSupportedException;
import org.web3d.vrml.sav.ScriptHandler;
import org.web3d.vrml.sav.VRMLReader;

public abstract class BaseReader
implements VRMLReader {
    protected static final String CONFORMANCE_PROP = "conformance";
    protected static final String WEAK_CONFORMANCE = "weak";
    protected static final String STRICT_CONFORMANCE = "strict";
    protected HashMap properties = new HashMap();
    protected ContentHandler contentHandler;
    protected RouteHandler routeHandler;
    protected ScriptHandler scriptHandler;
    protected ProtoHandler protoHandler;
    protected ErrorReporter errorReporter;
    protected ErrorHandler errorHandler;
    protected boolean ignoreHeader;

    protected BaseReader() {
        this.properties.put(CONFORMANCE_PROP, WEAK_CONFORMANCE);
        this.ignoreHeader = false;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public Object getProperty(String string) throws SAVNotSupportedException {
        if (!this.properties.containsKey(string)) {
            throw new SAVNotSupportedException("Unknown property: " + string);
        }
        return this.properties.get(string);
    }

    public void setProperty(String string, Object object) throws SAVNotSupportedException {
        if (!this.properties.containsKey(string)) {
            throw new SAVNotSupportedException("Unknown property: " + string);
        }
        if (object == null) {
            throw new SAVNotSupportedException("Null values not supported");
        }
        this.properties.put(string, object);
    }

    public void setHeaderIgnore(boolean bl) {
        this.ignoreHeader = bl;
    }

    public ErrorReporter getErrorHandler() {
        return this.errorReporter;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ScriptHandler getScriptHandler() {
        return this.scriptHandler;
    }

    public void setScriptHandler(ScriptHandler scriptHandler) {
        this.scriptHandler = scriptHandler;
    }

    public ProtoHandler getProtoHandler() {
        return this.protoHandler;
    }

    public void setProtoHandler(ProtoHandler protoHandler) {
        this.protoHandler = protoHandler;
    }

    public RouteHandler getRouteHandler() {
        return this.routeHandler;
    }

    public void setRouteHandler(RouteHandler routeHandler) {
        this.routeHandler = routeHandler;
    }
}

