/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <WindowAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: WindowAttributes::WindowAttributes
//
// Purpose: 
//   Init utility for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void WindowAttributes::Init()
{
    size[0] = 300;
    size[1] = 300;
    background[0] = 255;
    background[1] = 255;
    background[2] = 255;
    foreground[0] = 0;
    foreground[1] = 0;
    foreground[2] = 0;
    backgroundMode = 0;
    gradBG1[0] = 0;
    gradBG1[1] = 0;
    gradBG1[2] = 1;
    gradBG2[0] = 0;
    gradBG2[1] = 0;
    gradBG2[2] = 0;
    gradientBackgroundStyle = 0;
    imageRepeatX = 1;
    imageRepeatY = 1;

    WindowAttributes::SelectAll();
}

// ****************************************************************************
// Method: WindowAttributes::WindowAttributes
//
// Purpose: 
//   Copy utility for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void WindowAttributes::Copy(const WindowAttributes &obj)
{
    viewCurve = obj.viewCurve;
    view2D = obj.view2D;
    view3D = obj.view3D;
    viewAxisArray = obj.viewAxisArray;
    lights = obj.lights;
    renderAtts = obj.renderAtts;
    colorTables = obj.colorTables;
    size[0] = obj.size[0];
    size[1] = obj.size[1];

    background[0] = obj.background[0];
    background[1] = obj.background[1];
    background[2] = obj.background[2];

    foreground[0] = obj.foreground[0];
    foreground[1] = obj.foreground[1];
    foreground[2] = obj.foreground[2];

    backgroundMode = obj.backgroundMode;
    gradBG1[0] = obj.gradBG1[0];
    gradBG1[1] = obj.gradBG1[1];
    gradBG1[2] = obj.gradBG1[2];

    gradBG2[0] = obj.gradBG2[0];
    gradBG2[1] = obj.gradBG2[1];
    gradBG2[2] = obj.gradBG2[2];

    gradientBackgroundStyle = obj.gradientBackgroundStyle;
    backgroundImage = obj.backgroundImage;
    imageRepeatX = obj.imageRepeatX;
    imageRepeatY = obj.imageRepeatY;

    WindowAttributes::SelectAll();
}

// Type map format string
const char *WindowAttributes::TypeMapFormatString = WINDOWATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t WindowAttributes::TmfsStruct = {WINDOWATTRIBUTES_TMFS};


// ****************************************************************************
// Method: WindowAttributes::WindowAttributes
//
// Purpose: 
//   Default constructor for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

WindowAttributes::WindowAttributes() : 
    AttributeSubject(WindowAttributes::TypeMapFormatString)
{
    WindowAttributes::Init();
}

// ****************************************************************************
// Method: WindowAttributes::WindowAttributes
//
// Purpose: 
//   Constructor for the derived classes of WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

WindowAttributes::WindowAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    WindowAttributes::Init();
}

// ****************************************************************************
// Method: WindowAttributes::WindowAttributes
//
// Purpose: 
//   Copy constructor for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

WindowAttributes::WindowAttributes(const WindowAttributes &obj) : 
    AttributeSubject(WindowAttributes::TypeMapFormatString)
{
    WindowAttributes::Copy(obj);
}

// ****************************************************************************
// Method: WindowAttributes::WindowAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

WindowAttributes::WindowAttributes(const WindowAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    WindowAttributes::Copy(obj);
}

// ****************************************************************************
// Method: WindowAttributes::~WindowAttributes
//
// Purpose: 
//   Destructor for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

WindowAttributes::~WindowAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: WindowAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

WindowAttributes& 
WindowAttributes::operator = (const WindowAttributes &obj)
{
    if (this == &obj) return *this;

    WindowAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: WindowAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
WindowAttributes::operator == (const WindowAttributes &obj) const
{
    // Compare the size arrays.
    bool size_equal = true;
    for(int i = 0; i < 2 && size_equal; ++i)
        size_equal = (size[i] == obj.size[i]);

    // Compare the background arrays.
    bool background_equal = true;
    for(int i = 0; i < 3 && background_equal; ++i)
        background_equal = (background[i] == obj.background[i]);

    // Compare the foreground arrays.
    bool foreground_equal = true;
    for(int i = 0; i < 3 && foreground_equal; ++i)
        foreground_equal = (foreground[i] == obj.foreground[i]);

    // Compare the gradBG1 arrays.
    bool gradBG1_equal = true;
    for(int i = 0; i < 3 && gradBG1_equal; ++i)
        gradBG1_equal = (gradBG1[i] == obj.gradBG1[i]);

    // Compare the gradBG2 arrays.
    bool gradBG2_equal = true;
    for(int i = 0; i < 3 && gradBG2_equal; ++i)
        gradBG2_equal = (gradBG2[i] == obj.gradBG2[i]);

    // Create the return value
    return ((viewCurve == obj.viewCurve) &&
            (view2D == obj.view2D) &&
            (view3D == obj.view3D) &&
            (viewAxisArray == obj.viewAxisArray) &&
            (lights == obj.lights) &&
            (renderAtts == obj.renderAtts) &&
            (colorTables == obj.colorTables) &&
            size_equal &&
            background_equal &&
            foreground_equal &&
            (backgroundMode == obj.backgroundMode) &&
            gradBG1_equal &&
            gradBG2_equal &&
            (gradientBackgroundStyle == obj.gradientBackgroundStyle) &&
            (backgroundImage == obj.backgroundImage) &&
            (imageRepeatX == obj.imageRepeatX) &&
            (imageRepeatY == obj.imageRepeatY));
}

// ****************************************************************************
// Method: WindowAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
WindowAttributes::operator != (const WindowAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: WindowAttributes::TypeName
//
// Purpose: 
//   Type name method for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
WindowAttributes::TypeName() const
{
    return "WindowAttributes";
}

// ****************************************************************************
// Method: WindowAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
WindowAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const WindowAttributes *tmp = (const WindowAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: WindowAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
WindowAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new WindowAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: WindowAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the WindowAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
WindowAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new WindowAttributes(*this);
    else
        retval = new WindowAttributes;

    return retval;
}

// ****************************************************************************
// Method: WindowAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
WindowAttributes::SelectAll()
{
    Select(ID_viewCurve,               (void *)&viewCurve);
    Select(ID_view2D,                  (void *)&view2D);
    Select(ID_view3D,                  (void *)&view3D);
    Select(ID_viewAxisArray,           (void *)&viewAxisArray);
    Select(ID_lights,                  (void *)&lights);
    Select(ID_renderAtts,              (void *)&renderAtts);
    Select(ID_colorTables,             (void *)&colorTables);
    Select(ID_size,                    (void *)size, 2);
    Select(ID_background,              (void *)background, 3);
    Select(ID_foreground,              (void *)foreground, 3);
    Select(ID_backgroundMode,          (void *)&backgroundMode);
    Select(ID_gradBG1,                 (void *)gradBG1, 3);
    Select(ID_gradBG2,                 (void *)gradBG2, 3);
    Select(ID_gradientBackgroundStyle, (void *)&gradientBackgroundStyle);
    Select(ID_backgroundImage,         (void *)&backgroundImage);
    Select(ID_imageRepeatX,            (void *)&imageRepeatX);
    Select(ID_imageRepeatY,            (void *)&imageRepeatY);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: WindowAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
WindowAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    WindowAttributes defaultObject;
    bool addToParent = false;
    // Create a node for WindowAttributes.
    DataNode *node = new DataNode("WindowAttributes");

    if(completeSave || !FieldsEqual(ID_viewCurve, &defaultObject))
    {
        DataNode *viewCurveNode = new DataNode("viewCurve");
        if(viewCurve.CreateNode(viewCurveNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(viewCurveNode);
        }
        else
            delete viewCurveNode;
    }

    if(completeSave || !FieldsEqual(ID_view2D, &defaultObject))
    {
        DataNode *view2DNode = new DataNode("view2D");
        if(view2D.CreateNode(view2DNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(view2DNode);
        }
        else
            delete view2DNode;
    }

    if(completeSave || !FieldsEqual(ID_view3D, &defaultObject))
    {
        DataNode *view3DNode = new DataNode("view3D");
        if(view3D.CreateNode(view3DNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(view3DNode);
        }
        else
            delete view3DNode;
    }

    if(completeSave || !FieldsEqual(ID_viewAxisArray, &defaultObject))
    {
        DataNode *viewAxisArrayNode = new DataNode("viewAxisArray");
        if(viewAxisArray.CreateNode(viewAxisArrayNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(viewAxisArrayNode);
        }
        else
            delete viewAxisArrayNode;
    }

    if(completeSave || !FieldsEqual(ID_lights, &defaultObject))
    {
        DataNode *lightsNode = new DataNode("lights");
        if(lights.CreateNode(lightsNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(lightsNode);
        }
        else
            delete lightsNode;
    }

    if(completeSave || !FieldsEqual(ID_renderAtts, &defaultObject))
    {
        DataNode *renderAttsNode = new DataNode("renderAtts");
        if(renderAtts.CreateNode(renderAttsNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(renderAttsNode);
        }
        else
            delete renderAttsNode;
    }

    if(completeSave || !FieldsEqual(ID_colorTables, &defaultObject))
    {
        DataNode *colorTablesNode = new DataNode("colorTables");
        if(colorTables.CreateNode(colorTablesNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(colorTablesNode);
        }
        else
            delete colorTablesNode;
    }

    if(completeSave || !FieldsEqual(ID_size, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("size", size, 2));
    }

    if(completeSave || !FieldsEqual(ID_background, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("background", background, 3));
    }

    if(completeSave || !FieldsEqual(ID_foreground, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("foreground", foreground, 3));
    }

    if(completeSave || !FieldsEqual(ID_backgroundMode, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("backgroundMode", backgroundMode));
    }

    if(completeSave || !FieldsEqual(ID_gradBG1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("gradBG1", gradBG1, 3));
    }

    if(completeSave || !FieldsEqual(ID_gradBG2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("gradBG2", gradBG2, 3));
    }

    if(completeSave || !FieldsEqual(ID_gradientBackgroundStyle, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("gradientBackgroundStyle", gradientBackgroundStyle));
    }

    if(completeSave || !FieldsEqual(ID_backgroundImage, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("backgroundImage", backgroundImage));
    }

    if(completeSave || !FieldsEqual(ID_imageRepeatX, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("imageRepeatX", imageRepeatX));
    }

    if(completeSave || !FieldsEqual(ID_imageRepeatY, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("imageRepeatY", imageRepeatY));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: WindowAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
WindowAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("WindowAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("viewCurve")) != 0)
        viewCurve.SetFromNode(node);
    if((node = searchNode->GetNode("view2D")) != 0)
        view2D.SetFromNode(node);
    if((node = searchNode->GetNode("view3D")) != 0)
        view3D.SetFromNode(node);
    if((node = searchNode->GetNode("viewAxisArray")) != 0)
        viewAxisArray.SetFromNode(node);
    if((node = searchNode->GetNode("lights")) != 0)
        lights.SetFromNode(node);
    if((node = searchNode->GetNode("renderAtts")) != 0)
        renderAtts.SetFromNode(node);
    if((node = searchNode->GetNode("colorTables")) != 0)
        colorTables.SetFromNode(node);
    if((node = searchNode->GetNode("size")) != 0)
        SetSize(node->AsIntArray());
    if((node = searchNode->GetNode("background")) != 0)
        SetBackground(node->AsUnsignedCharArray());
    if((node = searchNode->GetNode("foreground")) != 0)
        SetForeground(node->AsUnsignedCharArray());
    if((node = searchNode->GetNode("backgroundMode")) != 0)
        SetBackgroundMode(node->AsInt());
    if((node = searchNode->GetNode("gradBG1")) != 0)
        SetGradBG1(node->AsDoubleArray());
    if((node = searchNode->GetNode("gradBG2")) != 0)
        SetGradBG2(node->AsDoubleArray());
    if((node = searchNode->GetNode("gradientBackgroundStyle")) != 0)
        SetGradientBackgroundStyle(node->AsInt());
    if((node = searchNode->GetNode("backgroundImage")) != 0)
        SetBackgroundImage(node->AsString());
    if((node = searchNode->GetNode("imageRepeatX")) != 0)
        SetImageRepeatX(node->AsInt());
    if((node = searchNode->GetNode("imageRepeatY")) != 0)
        SetImageRepeatY(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
WindowAttributes::SetViewCurve(const ViewCurveAttributes &viewCurve_)
{
    viewCurve = viewCurve_;
    Select(ID_viewCurve, (void *)&viewCurve);
}

void
WindowAttributes::SetView2D(const View2DAttributes &view2D_)
{
    view2D = view2D_;
    Select(ID_view2D, (void *)&view2D);
}

void
WindowAttributes::SetView3D(const View3DAttributes &view3D_)
{
    view3D = view3D_;
    Select(ID_view3D, (void *)&view3D);
}

void
WindowAttributes::SetViewAxisArray(const ViewAxisArrayAttributes &viewAxisArray_)
{
    viewAxisArray = viewAxisArray_;
    Select(ID_viewAxisArray, (void *)&viewAxisArray);
}

void
WindowAttributes::SetLights(const LightList &lights_)
{
    lights = lights_;
    Select(ID_lights, (void *)&lights);
}

void
WindowAttributes::SetRenderAtts(const RenderingAttributes &renderAtts_)
{
    renderAtts = renderAtts_;
    Select(ID_renderAtts, (void *)&renderAtts);
}

void
WindowAttributes::SetColorTables(const ColorTableAttributes &colorTables_)
{
    colorTables = colorTables_;
    Select(ID_colorTables, (void *)&colorTables);
}

void
WindowAttributes::SetSize(const int *size_)
{
    size[0] = size_[0];
    size[1] = size_[1];
    Select(ID_size, (void *)size, 2);
}

void
WindowAttributes::SetBackground(const unsigned char *background_)
{
    background[0] = background_[0];
    background[1] = background_[1];
    background[2] = background_[2];
    Select(ID_background, (void *)background, 3);
}

void
WindowAttributes::SetForeground(const unsigned char *foreground_)
{
    foreground[0] = foreground_[0];
    foreground[1] = foreground_[1];
    foreground[2] = foreground_[2];
    Select(ID_foreground, (void *)foreground, 3);
}

void
WindowAttributes::SetBackgroundMode(int backgroundMode_)
{
    backgroundMode = backgroundMode_;
    Select(ID_backgroundMode, (void *)&backgroundMode);
}

void
WindowAttributes::SetGradBG1(const double *gradBG1_)
{
    gradBG1[0] = gradBG1_[0];
    gradBG1[1] = gradBG1_[1];
    gradBG1[2] = gradBG1_[2];
    Select(ID_gradBG1, (void *)gradBG1, 3);
}

void
WindowAttributes::SetGradBG2(const double *gradBG2_)
{
    gradBG2[0] = gradBG2_[0];
    gradBG2[1] = gradBG2_[1];
    gradBG2[2] = gradBG2_[2];
    Select(ID_gradBG2, (void *)gradBG2, 3);
}

void
WindowAttributes::SetGradientBackgroundStyle(int gradientBackgroundStyle_)
{
    gradientBackgroundStyle = gradientBackgroundStyle_;
    Select(ID_gradientBackgroundStyle, (void *)&gradientBackgroundStyle);
}

void
WindowAttributes::SetBackgroundImage(const std::string &backgroundImage_)
{
    backgroundImage = backgroundImage_;
    Select(ID_backgroundImage, (void *)&backgroundImage);
}

void
WindowAttributes::SetImageRepeatX(int imageRepeatX_)
{
    imageRepeatX = imageRepeatX_;
    Select(ID_imageRepeatX, (void *)&imageRepeatX);
}

void
WindowAttributes::SetImageRepeatY(int imageRepeatY_)
{
    imageRepeatY = imageRepeatY_;
    Select(ID_imageRepeatY, (void *)&imageRepeatY);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const ViewCurveAttributes &
WindowAttributes::GetViewCurve() const
{
    return viewCurve;
}

ViewCurveAttributes &
WindowAttributes::GetViewCurve()
{
    return viewCurve;
}

const View2DAttributes &
WindowAttributes::GetView2D() const
{
    return view2D;
}

View2DAttributes &
WindowAttributes::GetView2D()
{
    return view2D;
}

const View3DAttributes &
WindowAttributes::GetView3D() const
{
    return view3D;
}

View3DAttributes &
WindowAttributes::GetView3D()
{
    return view3D;
}

const ViewAxisArrayAttributes &
WindowAttributes::GetViewAxisArray() const
{
    return viewAxisArray;
}

ViewAxisArrayAttributes &
WindowAttributes::GetViewAxisArray()
{
    return viewAxisArray;
}

const LightList &
WindowAttributes::GetLights() const
{
    return lights;
}

LightList &
WindowAttributes::GetLights()
{
    return lights;
}

const RenderingAttributes &
WindowAttributes::GetRenderAtts() const
{
    return renderAtts;
}

RenderingAttributes &
WindowAttributes::GetRenderAtts()
{
    return renderAtts;
}

const ColorTableAttributes &
WindowAttributes::GetColorTables() const
{
    return colorTables;
}

ColorTableAttributes &
WindowAttributes::GetColorTables()
{
    return colorTables;
}

const int *
WindowAttributes::GetSize() const
{
    return size;
}

int *
WindowAttributes::GetSize()
{
    return size;
}

const unsigned char *
WindowAttributes::GetBackground() const
{
    return background;
}

unsigned char *
WindowAttributes::GetBackground()
{
    return background;
}

const unsigned char *
WindowAttributes::GetForeground() const
{
    return foreground;
}

unsigned char *
WindowAttributes::GetForeground()
{
    return foreground;
}

int
WindowAttributes::GetBackgroundMode() const
{
    return backgroundMode;
}

const double *
WindowAttributes::GetGradBG1() const
{
    return gradBG1;
}

double *
WindowAttributes::GetGradBG1()
{
    return gradBG1;
}

const double *
WindowAttributes::GetGradBG2() const
{
    return gradBG2;
}

double *
WindowAttributes::GetGradBG2()
{
    return gradBG2;
}

int
WindowAttributes::GetGradientBackgroundStyle() const
{
    return gradientBackgroundStyle;
}

const std::string &
WindowAttributes::GetBackgroundImage() const
{
    return backgroundImage;
}

std::string &
WindowAttributes::GetBackgroundImage()
{
    return backgroundImage;
}

int
WindowAttributes::GetImageRepeatX() const
{
    return imageRepeatX;
}

int
WindowAttributes::GetImageRepeatY() const
{
    return imageRepeatY;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
WindowAttributes::SelectViewCurve()
{
    Select(ID_viewCurve, (void *)&viewCurve);
}

void
WindowAttributes::SelectView2D()
{
    Select(ID_view2D, (void *)&view2D);
}

void
WindowAttributes::SelectView3D()
{
    Select(ID_view3D, (void *)&view3D);
}

void
WindowAttributes::SelectViewAxisArray()
{
    Select(ID_viewAxisArray, (void *)&viewAxisArray);
}

void
WindowAttributes::SelectLights()
{
    Select(ID_lights, (void *)&lights);
}

void
WindowAttributes::SelectRenderAtts()
{
    Select(ID_renderAtts, (void *)&renderAtts);
}

void
WindowAttributes::SelectColorTables()
{
    Select(ID_colorTables, (void *)&colorTables);
}

void
WindowAttributes::SelectSize()
{
    Select(ID_size, (void *)size, 2);
}

void
WindowAttributes::SelectBackground()
{
    Select(ID_background, (void *)background, 3);
}

void
WindowAttributes::SelectForeground()
{
    Select(ID_foreground, (void *)foreground, 3);
}

void
WindowAttributes::SelectGradBG1()
{
    Select(ID_gradBG1, (void *)gradBG1, 3);
}

void
WindowAttributes::SelectGradBG2()
{
    Select(ID_gradBG2, (void *)gradBG2, 3);
}

void
WindowAttributes::SelectBackgroundImage()
{
    Select(ID_backgroundImage, (void *)&backgroundImage);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: WindowAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
WindowAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_viewCurve:               return "viewCurve";
    case ID_view2D:                  return "view2D";
    case ID_view3D:                  return "view3D";
    case ID_viewAxisArray:           return "viewAxisArray";
    case ID_lights:                  return "lights";
    case ID_renderAtts:              return "renderAtts";
    case ID_colorTables:             return "colorTables";
    case ID_size:                    return "size";
    case ID_background:              return "background";
    case ID_foreground:              return "foreground";
    case ID_backgroundMode:          return "backgroundMode";
    case ID_gradBG1:                 return "gradBG1";
    case ID_gradBG2:                 return "gradBG2";
    case ID_gradientBackgroundStyle: return "gradientBackgroundStyle";
    case ID_backgroundImage:         return "backgroundImage";
    case ID_imageRepeatX:            return "imageRepeatX";
    case ID_imageRepeatY:            return "imageRepeatY";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: WindowAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
WindowAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_viewCurve:               return FieldType_att;
    case ID_view2D:                  return FieldType_att;
    case ID_view3D:                  return FieldType_att;
    case ID_viewAxisArray:           return FieldType_att;
    case ID_lights:                  return FieldType_att;
    case ID_renderAtts:              return FieldType_att;
    case ID_colorTables:             return FieldType_att;
    case ID_size:                    return FieldType_intArray;
    case ID_background:              return FieldType_ucharArray;
    case ID_foreground:              return FieldType_ucharArray;
    case ID_backgroundMode:          return FieldType_int;
    case ID_gradBG1:                 return FieldType_doubleArray;
    case ID_gradBG2:                 return FieldType_doubleArray;
    case ID_gradientBackgroundStyle: return FieldType_int;
    case ID_backgroundImage:         return FieldType_string;
    case ID_imageRepeatX:            return FieldType_int;
    case ID_imageRepeatY:            return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: WindowAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
WindowAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_viewCurve:               return "att";
    case ID_view2D:                  return "att";
    case ID_view3D:                  return "att";
    case ID_viewAxisArray:           return "att";
    case ID_lights:                  return "att";
    case ID_renderAtts:              return "att";
    case ID_colorTables:             return "att";
    case ID_size:                    return "intArray";
    case ID_background:              return "ucharArray";
    case ID_foreground:              return "ucharArray";
    case ID_backgroundMode:          return "int";
    case ID_gradBG1:                 return "doubleArray";
    case ID_gradBG2:                 return "doubleArray";
    case ID_gradientBackgroundStyle: return "int";
    case ID_backgroundImage:         return "string";
    case ID_imageRepeatX:            return "int";
    case ID_imageRepeatY:            return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: WindowAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
WindowAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const WindowAttributes &obj = *((const WindowAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_viewCurve:
        {  // new scope
        retval = (viewCurve == obj.viewCurve);
        }
        break;
    case ID_view2D:
        {  // new scope
        retval = (view2D == obj.view2D);
        }
        break;
    case ID_view3D:
        {  // new scope
        retval = (view3D == obj.view3D);
        }
        break;
    case ID_viewAxisArray:
        {  // new scope
        retval = (viewAxisArray == obj.viewAxisArray);
        }
        break;
    case ID_lights:
        {  // new scope
        retval = (lights == obj.lights);
        }
        break;
    case ID_renderAtts:
        {  // new scope
        retval = (renderAtts == obj.renderAtts);
        }
        break;
    case ID_colorTables:
        {  // new scope
        retval = (colorTables == obj.colorTables);
        }
        break;
    case ID_size:
        {  // new scope
        // Compare the size arrays.
        bool size_equal = true;
        for(int i = 0; i < 2 && size_equal; ++i)
            size_equal = (size[i] == obj.size[i]);

        retval = size_equal;
        }
        break;
    case ID_background:
        {  // new scope
        // Compare the background arrays.
        bool background_equal = true;
        for(int i = 0; i < 3 && background_equal; ++i)
            background_equal = (background[i] == obj.background[i]);

        retval = background_equal;
        }
        break;
    case ID_foreground:
        {  // new scope
        // Compare the foreground arrays.
        bool foreground_equal = true;
        for(int i = 0; i < 3 && foreground_equal; ++i)
            foreground_equal = (foreground[i] == obj.foreground[i]);

        retval = foreground_equal;
        }
        break;
    case ID_backgroundMode:
        {  // new scope
        retval = (backgroundMode == obj.backgroundMode);
        }
        break;
    case ID_gradBG1:
        {  // new scope
        // Compare the gradBG1 arrays.
        bool gradBG1_equal = true;
        for(int i = 0; i < 3 && gradBG1_equal; ++i)
            gradBG1_equal = (gradBG1[i] == obj.gradBG1[i]);

        retval = gradBG1_equal;
        }
        break;
    case ID_gradBG2:
        {  // new scope
        // Compare the gradBG2 arrays.
        bool gradBG2_equal = true;
        for(int i = 0; i < 3 && gradBG2_equal; ++i)
            gradBG2_equal = (gradBG2[i] == obj.gradBG2[i]);

        retval = gradBG2_equal;
        }
        break;
    case ID_gradientBackgroundStyle:
        {  // new scope
        retval = (gradientBackgroundStyle == obj.gradientBackgroundStyle);
        }
        break;
    case ID_backgroundImage:
        {  // new scope
        retval = (backgroundImage == obj.backgroundImage);
        }
        break;
    case ID_imageRepeatX:
        {  // new scope
        retval = (imageRepeatX == obj.imageRepeatX);
        }
        break;
    case ID_imageRepeatY:
        {  // new scope
        retval = (imageRepeatY == obj.imageRepeatY);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

