/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "ClipCases.h"

// Programmer: Jeremy Meredith
// Date      : August 11, 2003
//
// Modifications:
//    Jeremy Meredith, Mon Sep 15 17:30:21 PDT 2003
//    Added ability for Centroid-Points to have an associated color.
//    Fixed two inconsistent cases.

// This file is meant to be read and created by a program other than a
// compiler.  If you must modify it by hand, at least be nice to the 
// parser and don't add anything else to this file or rearrange it.

int numClipCasesHex = 256;

int numClipShapesHex[256] = {
  1,  10,  10,  3,  10,  18,  3,  15, // cases 0 - 7
  10,  3,  18,  15,  3,  15,  15,  2, // cases 8 - 15
  10,  3,  18,  15,  8,  18,  18,  17, // cases 16 - 23
  18,  15,  11,  10,  18,  17,  16,  15, // cases 24 - 31
  10,  18,  3,  15,  18,  11,  15,  10, // cases 32 - 39
  8,  18,  18,  17,  18,  16,  17,  15, // cases 40 - 47
  3,  15,  15,  2,  18,  16,  17,  15, // cases 48 - 55
  18,  17,  16,  15,  4,  13,  13,  3, // cases 56 - 63
  10,  8,  18,  18,  3,  18,  15,  17, // cases 64 - 71
  18,  18,  11,  16,  15,  17,  10,  15, // cases 72 - 79
  18,  18,  11,  16,  18,  4,  16,  13, // cases 80 - 87
  11,  16,  9,  8,  16,  13,  8,  7, // cases 88 - 95
  3,  18,  15,  17,  15,  16,  2,  15, // cases 96 - 103
  18,  4,  16,  13,  17,  13,  15,  3, // cases 104 - 111
  15,  17,  10,  15,  17,  13,  15,  3, // cases 112 - 119
  16,  13,  8,  7,  13,  8,  7,  10, // cases 120 - 127
  10,  18,  8,  18,  18,  11,  18,  16, // cases 128 - 135
  3,  15,  18,  17,  15,  10,  17,  15, // cases 136 - 143
  3,  15,  18,  17,  18,  16,  4,  13, // cases 144 - 151
  15,  2,  16,  15,  17,  15,  13,  3, // cases 152 - 159
  18,  11,  18,  16,  11,  9,  16,  8, // cases 160 - 167
  18,  16,  4,  13,  16,  8,  13,  7, // cases 168 - 175
  15,  10,  17,  15,  16,  8,  13,  7, // cases 176 - 183
  17,  15,  13,  3,  13,  7,  8,  10, // cases 184 - 191
  3,  18,  18,  4,  15,  16,  17,  13, // cases 192 - 199
  15,  17,  16,  13,  2,  15,  15,  3, // cases 200 - 207
  15,  17,  16,  13,  17,  13,  13,  8, // cases 208 - 215
  10,  15,  8,  7,  15,  3,  7,  10, // cases 216 - 223
  15,  16,  17,  13,  10,  8,  15,  7, // cases 224 - 231
  17,  13,  13,  8,  15,  7,  3,  10, // cases 232 - 239
  2,  15,  15,  3,  15,  7,  3,  10, // cases 240 - 247
  15,  3,  7,  10,  3,  10,  10,  1  // cases 248 - 255
};

int startClipShapesHex[256] = {
  0, 10, 80, 150, 176, 246, 361, 387, // cases 0 - 7
  488, 558, 584, 699, 800, 826, 927, 1028, // cases 8 - 15
  1048, 1118, 1144, 1259, 1360, 1412, 1531, 1650, // cases 16 - 23
  1764, 1879, 1980, 2056, 2124, 2243, 2357, 2465, // cases 24 - 31
  2566, 2636, 2751, 2777, 2878, 2993, 3069, 3170, // cases 32 - 39
  3238, 3290, 3409, 3528, 3642, 3761, 3869, 3983, // cases 40 - 47
  4084, 4110, 4211, 4312, 4332, 4451, 4559, 4673, // cases 48 - 55
  4774, 4893, 5007, 5115, 5216, 5252, 5343, 5434, // cases 56 - 63
  5460, 5530, 5582, 5697, 5816, 5842, 5961, 6062, // cases 64 - 71
  6176, 6291, 6410, 6486, 6594, 6695, 6809, 6877, // cases 72 - 79
  6978, 7093, 7212, 7288, 7396, 7515, 7551, 7659, // cases 80 - 87
  7750, 7826, 7934, 7996, 8050, 8158, 8249, 8303, // cases 88 - 95
  8350, 8376, 8495, 8596, 8710, 8811, 8919, 8939, // cases 96 - 103
  9040, 9159, 9195, 9303, 9394, 9508, 9599, 9700, // cases 104 - 111
  9726, 9827, 9941, 10009, 10110, 10224, 10315, 10416, // cases 112 - 119
  10442, 10550, 10641, 10695, 10742, 10833, 10885, 10932, // cases 120 - 127
  11002, 11072, 11187, 11239, 11358, 11473, 11549, 11668, // cases 128 - 135
  11776, 11802, 11903, 12022, 12136, 12237, 12305, 12419, // cases 136 - 143
  12520, 12546, 12647, 12766, 12880, 12999, 13107, 13143, // cases 144 - 151
  13234, 13335, 13355, 13463, 13564, 13678, 13779, 13870, // cases 152 - 159
  13896, 14011, 14087, 14206, 14314, 14390, 14452, 14560, // cases 160 - 167
  14614, 14733, 14841, 14877, 14968, 15076, 15130, 15221, // cases 168 - 175
  15268, 15369, 15437, 15551, 15652, 15760, 15814, 15905, // cases 176 - 183
  15952, 16066, 16167, 16258, 16284, 16375, 16422, 16474, // cases 184 - 191
  16544, 16570, 16689, 16808, 16844, 16945, 17053, 17167, // cases 192 - 199
  17258, 17359, 17473, 17581, 17672, 17692, 17793, 17894, // cases 200 - 207
  17920, 18021, 18135, 18243, 18334, 18448, 18539, 18630, // cases 208 - 215
  18682, 18750, 18851, 18905, 18952, 19053, 19079, 19126, // cases 216 - 223
  19196, 19297, 19405, 19519, 19610, 19678, 19732, 19833, // cases 224 - 231
  19880, 19994, 20085, 20176, 20228, 20329, 20376, 20402, // cases 232 - 239
  20472, 20492, 20593, 20694, 20720, 20821, 20868, 20894, // cases 240 - 247
  20964, 21065, 21091, 21138, 21208, 21234, 21304, 21374  // cases 248 - 255
};

unsigned char clipShapesHex[] = {
 // Case #0: Unique case #1
  ST_HEX, COLOR0, P0, P1, P2, P3, P4, P5, P6, P7, 
 // Case #1: Unique case #2
  ST_PNT, 0, COLOR0, 7, P1, P2, P3, P4, P5, P6, P7, 
  ST_WDG, COLOR0, P1, P3, P4, EA, ED, EI, 
  ST_TET, COLOR0, P1, P3, P4, N0, 
  ST_TET, COLOR0, P1, P2, P3, N0, 
  ST_PYR, COLOR0, P6, P7, P3, P2, N0, 
  ST_PYR, COLOR0, P5, P6, P2, P1, N0, 
  ST_PYR, COLOR0, P4, P7, P6, P5, N0, 
  ST_TET, COLOR0, P3, P7, P4, N0, 
  ST_TET, COLOR0, P4, P5, P1, N0, 
  ST_TET, COLOR1, P0, EA, ED, EI, 
 // Case #2: (cloned #1)
  ST_PNT, 0, COLOR0, 7, P5, P4, P0, P2, P6, P7, P3, 
  ST_WDG, COLOR0, EJ, EA, EB, P5, P0, P2, 
  ST_TET, COLOR0, P5, P2, P0, N0, 
  ST_TET, COLOR0, P5, P0, P4, N0, 
  ST_PYR, COLOR0, P7, P4, P0, P3, N0, 
  ST_PYR, COLOR0, P6, P5, P4, P7, N0, 
  ST_PYR, COLOR0, P2, P6, P7, P3, N0, 
  ST_TET, COLOR0, P0, P2, P3, N0, 
  ST_TET, COLOR0, P2, P5, P6, N0, 
  ST_TET, COLOR1, P1, EA, EJ, EB, 
 // Case #3: Unique case #3
  ST_HEX, COLOR0, EB, P2, P3, ED, EJ, P5, P4, EI, 
  ST_WDG, COLOR0, P2, P6, P5, P3, P7, P4, 
  ST_WDG, COLOR1, P1, EB, EJ, P0, ED, EI, 
 // Case #4: (cloned #1)
  ST_PNT, 0, COLOR0, 7, P6, P5, P1, P3, P7, P4, P0, 
  ST_WDG, COLOR0, EL, EB, EC, P6, P1, P3, 
  ST_TET, COLOR0, P6, P3, P1, N0, 
  ST_TET, COLOR0, P6, P1, P5, N0, 
  ST_PYR, COLOR0, P4, P5, P1, P0, N0, 
  ST_PYR, COLOR0, P7, P6, P5, P4, N0, 
  ST_PYR, COLOR0, P3, P7, P4, P0, N0, 
  ST_TET, COLOR0, P1, P3, P0, N0, 
  ST_TET, COLOR0, P3, P6, P7, N0, 
  ST_TET, COLOR1, P2, EB, EL, EC, 
 // Case #5: Unique case #4
  ST_PNT, 0, NOCOLOR, 2, EI, EL, 
  ST_PYR, COLOR0, P4, P7, P6, P5, N0, 
  ST_TET, COLOR0, P5, P6, P1, N0, 
  ST_TET, COLOR0, P4, P5, P1, N0, 
  ST_TET, COLOR0, P3, P7, P4, N0, 
  ST_TET, COLOR0, P6, P7, P3, N0, 
  ST_PYR, COLOR0, P6, P3, EC, EL, N0, 
  ST_PYR, COLOR0, P1, P6, EL, EB, N0, 
  ST_TET, COLOR0, P1, EB, EA, N0, 
  ST_PYR, COLOR0, P4, P1, EA, EI, N0, 
  ST_PYR, COLOR0, P4, EI, ED, P3, N0, 
  ST_TET, COLOR0, P3, ED, EC, N0, 
  ST_PYR, COLOR1, P0, P2, EC, ED, N0, 
  ST_PYR, COLOR1, EA, EB, P2, P0, N0, 
  ST_TET, COLOR1, EB, EL, P2, N0, 
  ST_TET, COLOR1, P2, EL, EC, N0, 
  ST_TET, COLOR1, EA, N0, P0, EI, 
  ST_TET, COLOR1, ED, EI, P0, N0, 
 // Case #6: (cloned #3)
  ST_HEX, COLOR0, EC, P3, P0, EA, EL, P6, P5, EJ, 
  ST_WDG, COLOR0, P3, P7, P6, P0, P4, P5, 
  ST_WDG, COLOR1, P2, EC, EL, P1, EA, EJ, 
 // Case #7: Unique case #5
  ST_PNT, 0, NOCOLOR, 5, EI, EJ, ED, EC, EL, 
  ST_PYR, COLOR0, P4, P7, P6, P5, N0, 
  ST_TET, COLOR0, P6, P3, N0, P7, 
  ST_PYR, COLOR0, P5, P6, EL, EJ, N0, 
  ST_PYR, COLOR0, EI, P4, P5, EJ, N0, 
  ST_TET, COLOR0, P3, P7, P4, N0, 
  ST_PYR, COLOR0, P3, P4, EI, ED, N0, 
  ST_TET, COLOR0, P3, ED, EC, N0, 
  ST_PYR, COLOR0, EL, P6, P3, EC, N0, 
  ST_PYR, COLOR1, EJ, EL, P2, P1, N0, 
  ST_PYR, COLOR1, EI, EJ, P1, P0, N0, 
  ST_TET, COLOR1, ED, EI, P0, N0, 
  ST_TET, COLOR1, P0, P1, P2, N0, 
  ST_PYR, COLOR1, ED, P0, P2, EC, N0, 
  ST_TET, COLOR1, P2, EL, EC, N0, 
 // Case #8: (cloned #1)
  ST_PNT, 0, COLOR0, 7, P2, P1, P0, P7, P6, P5, P4, 
  ST_WDG, COLOR0, EC, ED, EK, P2, P0, P7, 
  ST_TET, COLOR0, P2, P7, P0, N0, 
  ST_TET, COLOR0, P2, P0, P1, N0, 
  ST_PYR, COLOR0, P5, P1, P0, P4, N0, 
  ST_PYR, COLOR0, P6, P2, P1, P5, N0, 
  ST_PYR, COLOR0, P7, P6, P5, P4, N0, 
  ST_TET, COLOR0, P0, P7, P4, N0, 
  ST_TET, COLOR0, P7, P2, P6, N0, 
  ST_TET, COLOR1, P3, ED, EC, EK, 
 // Case #9: (cloned #3)
  ST_HEX, COLOR0, EK, P7, P4, EI, EC, P2, P1, EA, 
  ST_WDG, COLOR0, P7, P6, P2, P4, P5, P1, 
  ST_WDG, COLOR1, P3, EK, EC, P0, EI, EA, 
 // Case #10: (cloned #5)
  ST_PNT, 0, NOCOLOR, 2, EK, EJ, 
  ST_PYR, COLOR0, P7, P6, P5, P4, N0, 
  ST_TET, COLOR0, P6, P2, P5, N0, 
  ST_TET, COLOR0, P7, P2, P6, N0, 
  ST_TET, COLOR0, P0, P7, P4, N0, 
  ST_TET, COLOR0, P5, P0, P4, N0, 
  ST_PYR, COLOR0, P5, EJ, EA, P0, N0, 
  ST_PYR, COLOR0, P2, EB, EJ, P5, N0, 
  ST_TET, COLOR0, P2, EC, EB, N0, 
  ST_PYR, COLOR0, P7, EK, EC, P2, N0, 
  ST_PYR, COLOR0, P7, P0, ED, EK, N0, 
  ST_TET, COLOR0, P0, EA, ED, N0, 
  ST_PYR, COLOR1, P3, ED, EA, P1, N0, 
  ST_PYR, COLOR1, EC, P3, P1, EB, N0, 
  ST_TET, COLOR1, EB, P1, EJ, N0, 
  ST_TET, COLOR1, P1, EA, EJ, N0, 
  ST_TET, COLOR1, EC, P3, N0, EK, 
  ST_TET, COLOR1, ED, P3, EK, N0, 
 // Case #11: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EJ, EI, EB, EC, EK, 
  ST_PYR, COLOR0, P5, P4, P7, P6, N0, 
  ST_TET, COLOR0, P7, N0, P2, P6, 
  ST_PYR, COLOR0, P4, EI, EK, P7, N0, 
  ST_PYR, COLOR0, EJ, EI, P4, P5, N0, 
  ST_TET, COLOR0, P2, P5, P6, N0, 
  ST_PYR, COLOR0, P2, EB, EJ, P5, N0, 
  ST_TET, COLOR0, P2, EC, EB, N0, 
  ST_PYR, COLOR0, EK, EC, P2, P7, N0, 
  ST_PYR, COLOR1, EI, P0, P3, EK, N0, 
  ST_PYR, COLOR1, EJ, P1, P0, EI, N0, 
  ST_TET, COLOR1, EB, P1, EJ, N0, 
  ST_TET, COLOR1, P1, P3, P0, N0, 
  ST_PYR, COLOR1, EB, EC, P3, P1, N0, 
  ST_TET, COLOR1, P3, EC, EK, N0, 
 // Case #12: (cloned #3)
  ST_HEX, COLOR0, EL, P6, P7, EK, EB, P1, P0, ED, 
  ST_WDG, COLOR0, P0, P4, P7, P1, P5, P6, 
  ST_WDG, COLOR1, P3, ED, EK, P2, EB, EL, 
 // Case #13: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EI, EK, EA, EB, EL, 
  ST_PYR, COLOR0, P4, P7, P6, P5, N0, 
  ST_TET, COLOR0, P6, N0, P1, P5, 
  ST_PYR, COLOR0, P7, EK, EL, P6, N0, 
  ST_PYR, COLOR0, EI, EK, P7, P4, N0, 
  ST_TET, COLOR0, P1, P4, P5, N0, 
  ST_PYR, COLOR0, P1, EA, EI, P4, N0, 
  ST_TET, COLOR0, P1, EB, EA, N0, 
  ST_PYR, COLOR0, EL, EB, P1, P6, N0, 
  ST_PYR, COLOR1, EK, P3, P2, EL, N0, 
  ST_PYR, COLOR1, EI, P0, P3, EK, N0, 
  ST_TET, COLOR1, EA, P0, EI, N0, 
  ST_TET, COLOR1, P0, P2, P3, N0, 
  ST_PYR, COLOR1, EA, EB, P2, P0, N0, 
  ST_TET, COLOR1, P2, EB, EL, N0, 
 // Case #14: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EK, EL, ED, EA, EJ, 
  ST_PYR, COLOR0, P7, P6, P5, P4, N0, 
  ST_TET, COLOR0, P5, N0, P0, P4, 
  ST_PYR, COLOR0, P6, EL, EJ, P5, N0, 
  ST_PYR, COLOR0, EK, EL, P6, P7, N0, 
  ST_TET, COLOR0, P0, P7, P4, N0, 
  ST_PYR, COLOR0, P0, ED, EK, P7, N0, 
  ST_TET, COLOR0, P0, EA, ED, N0, 
  ST_PYR, COLOR0, EJ, EA, P0, P5, N0, 
  ST_PYR, COLOR1, EL, P2, P1, EJ, N0, 
  ST_PYR, COLOR1, EK, P3, P2, EL, N0, 
  ST_TET, COLOR1, ED, P3, EK, N0, 
  ST_TET, COLOR1, P3, P1, P2, N0, 
  ST_PYR, COLOR1, ED, EA, P1, P3, N0, 
  ST_TET, COLOR1, P1, EA, EJ, N0, 
 // Case #15: Unique case #6
  ST_HEX, COLOR0, EI, EJ, EL, EK, P4, P5, P6, P7, 
  ST_HEX, COLOR1, P0, P1, P2, P3, EI, EJ, EL, EK, 
 // Case #16: (cloned #1)
  ST_PNT, 0, COLOR0, 7, P5, P1, P0, P7, P6, P2, P3, 
  ST_WDG, COLOR0, P5, P0, P7, EE, EI, EH, 
  ST_TET, COLOR0, P5, P0, P7, N0, 
  ST_TET, COLOR0, P5, P1, P0, N0, 
  ST_PYR, COLOR0, P2, P3, P0, P1, N0, 
  ST_PYR, COLOR0, P6, P2, P1, P5, N0, 
  ST_PYR, COLOR0, P7, P3, P2, P6, N0, 
  ST_TET, COLOR0, P0, P3, P7, N0, 
  ST_TET, COLOR0, P7, P6, P5, N0, 
  ST_TET, COLOR1, P4, EE, EI, EH, 
 // Case #17: (cloned #3)
  ST_HEX, COLOR0, EE, P5, P1, EA, EH, P7, P3, ED, 
  ST_WDG, COLOR0, P3, P2, P1, P7, P6, P5, 
  ST_WDG, COLOR1, P0, ED, EA, P4, EH, EE, 
 // Case #18: (cloned #5)
  ST_PNT, 0, NOCOLOR, 2, EH, EB, 
  ST_PYR, COLOR0, P7, P3, P2, P6, N0, 
  ST_TET, COLOR0, P6, P2, P5, N0, 
  ST_TET, COLOR0, P7, P6, P5, N0, 
  ST_TET, COLOR0, P0, P3, P7, N0, 
  ST_TET, COLOR0, P2, P3, P0, N0, 
  ST_PYR, COLOR0, P2, P0, EA, EB, N0, 
  ST_PYR, COLOR0, P5, P2, EB, EJ, N0, 
  ST_TET, COLOR0, P5, EJ, EE, N0, 
  ST_PYR, COLOR0, P7, P5, EE, EH, N0, 
  ST_PYR, COLOR0, P7, EH, EI, P0, N0, 
  ST_TET, COLOR0, P0, EI, EA, N0, 
  ST_PYR, COLOR1, P4, P1, EA, EI, N0, 
  ST_PYR, COLOR1, EE, EJ, P1, P4, N0, 
  ST_TET, COLOR1, EJ, EB, P1, N0, 
  ST_TET, COLOR1, P1, EB, EA, N0, 
  ST_TET, COLOR1, EE, N0, P4, EH, 
  ST_TET, COLOR1, EI, EH, P4, N0, 
 // Case #19: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EB, ED, EJ, EE, EH, 
  ST_PYR, COLOR0, P2, P6, P7, P3, N0, 
  ST_TET, COLOR0, P7, P5, N0, P6, 
  ST_PYR, COLOR0, P3, P7, EH, ED, N0, 
  ST_PYR, COLOR0, EB, P2, P3, ED, N0, 
  ST_TET, COLOR0, P5, P6, P2, N0, 
  ST_PYR, COLOR0, P5, P2, EB, EJ, N0, 
  ST_TET, COLOR0, P5, EJ, EE, N0, 
  ST_PYR, COLOR0, EH, P7, P5, EE, N0, 
  ST_PYR, COLOR1, ED, EH, P4, P0, N0, 
  ST_PYR, COLOR1, EB, ED, P0, P1, N0, 
  ST_TET, COLOR1, EJ, EB, P1, N0, 
  ST_TET, COLOR1, P1, P0, P4, N0, 
  ST_PYR, COLOR1, EJ, P1, P4, EE, N0, 
  ST_TET, COLOR1, P4, EH, EE, N0, 
 // Case #20: Unique case #7
  ST_WDG, COLOR0, EB, EC, EL, P1, P3, P6, 
  ST_WDG, COLOR0, P0, P7, P5, EI, EH, EE, 
  ST_TET, COLOR0, P3, P1, P6, P7, 
  ST_TET, COLOR0, P5, P7, P6, P1, 
  ST_TET, COLOR0, P0, P5, P1, P7, 
  ST_TET, COLOR0, P3, P7, P0, P1, 
  ST_TET, COLOR1, P4, EE, EI, EH, 
  ST_TET, COLOR1, P2, EC, EB, EL, 
 // Case #21: Unique case #8
  ST_PNT, 0, NOCOLOR, 4, EE, EH, EL, EL, 
  ST_PYR, COLOR0, P6, P3, EC, EL, N0, 
  ST_TET, COLOR0, EC, P3, ED, N0, 
  ST_PYR, COLOR0, P7, EH, ED, P3, N0, 
  ST_TET, COLOR0, P6, P7, P3, N0, 
  ST_TET, COLOR0, P1, EB, EA, N0, 
  ST_TET, COLOR0, P5, P6, P1, N0, 
  ST_PYR, COLOR0, P1, P6, EL, EB, N0, 
  ST_TET, COLOR0, P5, P7, P6, N0, 
  ST_PYR, COLOR0, P5, EE, EH, P7, N0, 
  ST_PYR, COLOR0, P5, P1, EA, EE, N0, 
  ST_PYR, COLOR1, P2, EC, ED, P0, N0, 
  ST_PYR, COLOR1, EA, EB, P2, P0, N0, 
  ST_TET, COLOR1, P2, EL, EC, N0, 
  ST_TET, COLOR1, EB, EL, P2, N0, 
  ST_PYR, COLOR1, ED, EH, P4, P0, N0, 
  ST_PYR, COLOR1, P0, P4, EE, EA, N0, 
  ST_TET, COLOR1, EE, P4, EH, N0, 
 // Case #22: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EL, EC, EH, EH, 
  ST_PYR, COLOR0, P7, EH, EI, P0, N0, 
  ST_TET, COLOR0, EI, EA, P0, N0, 
  ST_PYR, COLOR0, P3, P0, EA, EC, N0, 
  ST_TET, COLOR0, P7, P0, P3, N0, 
  ST_TET, COLOR0, P5, EJ, EE, N0, 
  ST_TET, COLOR0, P6, P5, P7, N0, 
  ST_PYR, COLOR0, P5, EE, EH, P7, N0, 
  ST_TET, COLOR0, P6, P7, P3, N0, 
  ST_PYR, COLOR0, P6, P3, EC, EL, N0, 
  ST_PYR, COLOR0, P6, EL, EJ, P5, N0, 
  ST_PYR, COLOR1, P4, P1, EA, EI, N0, 
  ST_PYR, COLOR1, EJ, P1, P4, EE, N0, 
  ST_TET, COLOR1, P4, EI, EH, N0, 
  ST_TET, COLOR1, EE, P4, EH, N0, 
  ST_PYR, COLOR1, EA, P1, P2, EC, N0, 
  ST_PYR, COLOR1, P1, EJ, EL, P2, N0, 
  ST_TET, COLOR1, EL, EC, P2, N0, 
 // Case #23: Unique case #9
  ST_PNT, 0, NOCOLOR, 6, ED, EC, EL, EJ, EE, EH, 
  ST_TET, COLOR0, P6, P5, P7, N0, 
  ST_PYR, COLOR0, P6, EL, EJ, P5, N0, 
  ST_TET, COLOR0, P3, P6, P7, N0, 
  ST_PYR, COLOR0, P3, EC, EL, P6, N0, 
  ST_TET, COLOR0, ED, EC, P3, N0, 
  ST_PYR, COLOR0, P3, P7, EH, ED, N0, 
  ST_PYR, COLOR0, EH, P7, P5, EE, N0, 
  ST_TET, COLOR0, P5, EJ, EE, N0, 
  ST_TET, COLOR1, P0, P1, P2, N0, 
  ST_PYR, COLOR1, ED, P0, P2, EC, N0, 
  ST_PYR, COLOR1, ED, EH, P4, P0, N0, 
  ST_TET, COLOR1, P4, P1, P0, N0, 
  ST_TET, COLOR1, P4, EH, EE, N0, 
  ST_PYR, COLOR1, P4, EE, EJ, P1, N0, 
  ST_PYR, COLOR1, EJ, EL, P2, P1, N0, 
  ST_TET, COLOR1, EL, EC, P2, N0, 
 // Case #24: (cloned #5)
  ST_PNT, 0, NOCOLOR, 2, EC, EE, 
  ST_PYR, COLOR0, P2, P1, P5, P6, N0, 
  ST_TET, COLOR0, P6, P5, P7, N0, 
  ST_TET, COLOR0, P2, P6, P7, N0, 
  ST_TET, COLOR0, P0, P1, P2, N0, 
  ST_TET, COLOR0, P5, P1, P0, N0, 
  ST_PYR, COLOR0, P5, P0, EI, EE, N0, 
  ST_PYR, COLOR0, P7, P5, EE, EH, N0, 
  ST_TET, COLOR0, P7, EH, EK, N0, 
  ST_PYR, COLOR0, P2, P7, EK, EC, N0, 
  ST_PYR, COLOR0, P2, EC, ED, P0, N0, 
  ST_TET, COLOR0, P0, ED, EI, N0, 
  ST_PYR, COLOR1, P3, P4, EI, ED, N0, 
  ST_PYR, COLOR1, EK, EH, P4, P3, N0, 
  ST_TET, COLOR1, EH, EE, P4, N0, 
  ST_TET, COLOR1, P4, EE, EI, N0, 
  ST_TET, COLOR1, EK, N0, P3, EC, 
  ST_TET, COLOR1, ED, EC, P3, N0, 
 // Case #25: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EE, EA, EH, EK, EC, 
  ST_PYR, COLOR0, P5, P6, P2, P1, N0, 
  ST_TET, COLOR0, P2, P7, N0, P6, 
  ST_PYR, COLOR0, P1, P2, EC, EA, N0, 
  ST_PYR, COLOR0, EE, P5, P1, EA, N0, 
  ST_TET, COLOR0, P7, P6, P5, N0, 
  ST_PYR, COLOR0, P7, P5, EE, EH, N0, 
  ST_TET, COLOR0, P7, EH, EK, N0, 
  ST_PYR, COLOR0, EC, P2, P7, EK, N0, 
  ST_PYR, COLOR1, EA, EC, P3, P0, N0, 
  ST_PYR, COLOR1, EE, EA, P0, P4, N0, 
  ST_TET, COLOR1, EH, EE, P4, N0, 
  ST_TET, COLOR1, P4, P0, P3, N0, 
  ST_PYR, COLOR1, EH, P4, P3, EK, N0, 
  ST_TET, COLOR1, P3, EC, EK, N0, 
 // Case #26: Unique case #10
  ST_TET, COLOR0, P0, EA, ED, EI, 
  ST_TET, COLOR0, P5, P7, P6, P2, 
  ST_PYR, COLOR0, EC, P2, P7, EK, EH, 
  ST_PYR, COLOR0, EB, EJ, P5, P2, EE, 
  ST_PYR, COLOR0, P7, P5, EE, EH, P2, 
  ST_PYR, COLOR0, EH, EE, EB, EC, P2, 
  ST_WDG, COLOR1, ED, EA, EI, P3, P1, P4, 
  ST_PYR, COLOR1, P3, EK, EH, P4, EC, 
  ST_PYR, COLOR1, EE, EJ, P1, P4, EB, 
  ST_PYR, COLOR1, EC, P3, P1, EB, P4, 
  ST_PYR, COLOR1, EC, EB, EE, EH, P4, 
 // Case #27: Unique case #11
  ST_TET, COLOR0, P5, P7, P6, P2, 
  ST_PYR, COLOR0, EC, P2, P7, EK, EH, 
  ST_PYR, COLOR0, EB, EJ, P5, P2, EE, 
  ST_PYR, COLOR0, P7, P5, EE, EH, P2, 
  ST_PYR, COLOR0, EH, EE, EB, EC, P2, 
  ST_TET, COLOR1, P0, P1, P3, P4, 
  ST_PYR, COLOR1, EH, P4, P3, EK, EC, 
  ST_PYR, COLOR1, EE, EJ, P1, P4, EB, 
  ST_PYR, COLOR1, P3, P1, EB, EC, P4, 
  ST_PYR, COLOR1, EH, EC, EB, EE, P4, 
 // Case #28: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EL, EB, EE, EE, 
  ST_PYR, COLOR0, P5, P0, EI, EE, N0, 
  ST_TET, COLOR0, EI, P0, ED, N0, 
  ST_PYR, COLOR0, P1, EB, ED, P0, N0, 
  ST_TET, COLOR0, P5, P1, P0, N0, 
  ST_TET, COLOR0, P7, EH, EK, N0, 
  ST_TET, COLOR0, P6, P5, P7, N0, 
  ST_PYR, COLOR0, P7, P5, EE, EH, N0, 
  ST_TET, COLOR0, P6, P1, P5, N0, 
  ST_PYR, COLOR0, P6, EL, EB, P1, N0, 
  ST_PYR, COLOR0, P6, P7, EK, EL, N0, 
  ST_PYR, COLOR1, P4, EI, ED, P3, N0, 
  ST_PYR, COLOR1, EK, EH, P4, P3, N0, 
  ST_TET, COLOR1, P4, EE, EI, N0, 
  ST_TET, COLOR1, EH, EE, P4, N0, 
  ST_PYR, COLOR1, ED, EB, P2, P3, N0, 
  ST_PYR, COLOR1, P3, P2, EL, EK, N0, 
  ST_TET, COLOR1, EL, P2, EB, N0, 
 // Case #29: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EA, EB, EL, EK, EH, EE, 
  ST_TET, COLOR0, P6, P5, P7, N0, 
  ST_PYR, COLOR0, P6, P7, EK, EL, N0, 
  ST_TET, COLOR0, P1, P5, P6, N0, 
  ST_PYR, COLOR0, P1, P6, EL, EB, N0, 
  ST_TET, COLOR0, EA, P1, EB, N0, 
  ST_PYR, COLOR0, P1, EA, EE, P5, N0, 
  ST_PYR, COLOR0, EE, EH, P7, P5, N0, 
  ST_TET, COLOR0, P7, EH, EK, N0, 
  ST_TET, COLOR1, P0, P2, P3, N0, 
  ST_PYR, COLOR1, EA, EB, P2, P0, N0, 
  ST_PYR, COLOR1, EA, P0, P4, EE, N0, 
  ST_TET, COLOR1, P4, P0, P3, N0, 
  ST_TET, COLOR1, P4, EH, EE, N0, 
  ST_PYR, COLOR1, P4, P3, EK, EH, N0, 
  ST_PYR, COLOR1, EK, P3, P2, EL, N0, 
  ST_TET, COLOR1, EL, P2, EB, N0, 
 // Case #30: Unique case #12
  ST_PNT, 0, NOCOLOR, 5, EL, EJ, EK, EH, EE, 
  ST_TET, COLOR0, P0, EA, ED, EI, 
  ST_PYR, COLOR0, P5, P6, EL, EJ, N0, 
  ST_PYR, COLOR0, P6, P7, EK, EL, N0, 
  ST_TET, COLOR0, P7, EH, EK, N0, 
  ST_TET, COLOR0, P6, P5, P7, N0, 
  ST_PYR, COLOR0, P7, P5, EE, EH, N0, 
  ST_TET, COLOR0, P5, EJ, EE, N0, 
  ST_WDG, COLOR1, ED, EA, EI, P3, P1, P4, 
  ST_TET, COLOR1, P1, P3, P4, N0, 
  ST_PYR, COLOR1, P3, EK, EH, P4, N0, 
  ST_TET, COLOR1, P2, P3, P1, N0, 
  ST_PYR, COLOR1, EJ, EL, P2, P1, N0, 
  ST_PYR, COLOR1, EL, EK, P3, P2, N0, 
  ST_PYR, COLOR1, P4, EE, EJ, P1, N0, 
  ST_TET, COLOR1, EH, EE, P4, N0, 
 // Case #31: Unique case #13
  ST_PNT, 0, NOCOLOR, 5, EJ, EL, EK, EE, EH, 
  ST_PYR, COLOR0, P6, P7, EK, EL, N0, 
  ST_TET, COLOR0, P7, EH, EK, N0, 
  ST_PYR, COLOR0, P5, P6, EL, EJ, N0, 
  ST_TET, COLOR0, EE, P5, EJ, N0, 
  ST_PYR, COLOR0, EH, P7, P5, EE, N0, 
  ST_TET, COLOR0, P7, P6, P5, N0, 
  ST_PYR, COLOR1, P0, P1, P2, P3, N0, 
  ST_TET, COLOR1, P3, P4, P0, N0, 
  ST_TET, COLOR1, P4, P1, P0, N0, 
  ST_PYR, COLOR1, P4, EE, EJ, P1, N0, 
  ST_PYR, COLOR1, EJ, EL, P2, P1, N0, 
  ST_PYR, COLOR1, EL, EK, P3, P2, N0, 
  ST_PYR, COLOR1, EK, EH, P4, P3, N0, 
  ST_TET, COLOR1, EE, P4, EH, N0, 
 // Case #32: (cloned #1)
  ST_PNT, 0, COLOR0, 7, P6, P2, P1, P4, P7, P3, P0, 
  ST_WDG, COLOR0, P6, P1, P4, EF, EJ, EE, 
  ST_TET, COLOR0, P6, P1, P4, N0, 
  ST_TET, COLOR0, P6, P2, P1, N0, 
  ST_PYR, COLOR0, P3, P0, P1, P2, N0, 
  ST_PYR, COLOR0, P7, P3, P2, P6, N0, 
  ST_PYR, COLOR0, P4, P0, P3, P7, N0, 
  ST_TET, COLOR0, P1, P0, P4, N0, 
  ST_TET, COLOR0, P4, P7, P6, N0, 
  ST_TET, COLOR1, P5, EF, EJ, EE, 
 // Case #33: (cloned #5)
  ST_PNT, 0, NOCOLOR, 2, ED, EF, 
  ST_PYR, COLOR0, P3, P2, P6, P7, N0, 
  ST_TET, COLOR0, P2, P1, P6, N0, 
  ST_TET, COLOR0, P3, P1, P2, N0, 
  ST_TET, COLOR0, P4, P3, P7, N0, 
  ST_TET, COLOR0, P6, P4, P7, N0, 
  ST_PYR, COLOR0, P6, EF, EE, P4, N0, 
  ST_PYR, COLOR0, P1, EJ, EF, P6, N0, 
  ST_TET, COLOR0, P1, EA, EJ, N0, 
  ST_PYR, COLOR0, P3, ED, EA, P1, N0, 
  ST_PYR, COLOR0, P3, P4, EI, ED, N0, 
  ST_TET, COLOR0, P4, EE, EI, N0, 
  ST_PYR, COLOR1, P0, EI, EE, P5, N0, 
  ST_PYR, COLOR1, EA, P0, P5, EJ, N0, 
  ST_TET, COLOR1, EJ, P5, EF, N0, 
  ST_TET, COLOR1, P5, EE, EF, N0, 
  ST_TET, COLOR1, EA, P0, N0, ED, 
  ST_TET, COLOR1, EI, P0, ED, N0, 
 // Case #34: (cloned #3)
  ST_HEX, COLOR0, EF, P6, P2, EB, EE, P4, P0, EA, 
  ST_WDG, COLOR0, P0, P3, P2, P4, P7, P6, 
  ST_WDG, COLOR1, P1, EA, EB, P5, EE, EF, 
 // Case #35: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, ED, EB, EI, EE, EF, 
  ST_PYR, COLOR0, P3, P2, P6, P7, N0, 
  ST_TET, COLOR0, P6, N0, P4, P7, 
  ST_PYR, COLOR0, P2, EB, EF, P6, N0, 
  ST_PYR, COLOR0, ED, EB, P2, P3, N0, 
  ST_TET, COLOR0, P4, P3, P7, N0, 
  ST_PYR, COLOR0, P4, EI, ED, P3, N0, 
  ST_TET, COLOR0, P4, EE, EI, N0, 
  ST_PYR, COLOR0, EF, EE, P4, P6, N0, 
  ST_PYR, COLOR1, EB, P1, P5, EF, N0, 
  ST_PYR, COLOR1, ED, P0, P1, EB, N0, 
  ST_TET, COLOR1, EI, P0, ED, N0, 
  ST_TET, COLOR1, P0, P5, P1, N0, 
  ST_PYR, COLOR1, EI, EE, P5, P0, N0, 
  ST_TET, COLOR1, P5, EE, EF, N0, 
 // Case #36: (cloned #5)
  ST_PNT, 0, NOCOLOR, 2, EC, EE, 
  ST_PYR, COLOR0, P3, P7, P4, P0, N0, 
  ST_TET, COLOR0, P7, P6, P4, N0, 
  ST_TET, COLOR0, P3, P6, P7, N0, 
  ST_TET, COLOR0, P1, P3, P0, N0, 
  ST_TET, COLOR0, P4, P1, P0, N0, 
  ST_PYR, COLOR0, P4, EE, EJ, P1, N0, 
  ST_PYR, COLOR0, P6, EF, EE, P4, N0, 
  ST_TET, COLOR0, P6, EL, EF, N0, 
  ST_PYR, COLOR0, P3, EC, EL, P6, N0, 
  ST_PYR, COLOR0, P3, P1, EB, EC, N0, 
  ST_TET, COLOR0, P1, EJ, EB, N0, 
  ST_PYR, COLOR1, P2, EB, EJ, P5, N0, 
  ST_PYR, COLOR1, EL, P2, P5, EF, N0, 
  ST_TET, COLOR1, EF, P5, EE, N0, 
  ST_TET, COLOR1, P5, EJ, EE, N0, 
  ST_TET, COLOR1, EL, P2, N0, EC, 
  ST_TET, COLOR1, EB, P2, EC, N0, 
 // Case #37: (cloned #26)
  ST_TET, COLOR0, P1, EA, EJ, EB, 
  ST_TET, COLOR0, P6, P7, P3, P4, 
  ST_PYR, COLOR0, EI, ED, P3, P4, EC, 
  ST_PYR, COLOR0, EE, P4, P6, EF, EL, 
  ST_PYR, COLOR0, P3, EC, EL, P6, P4, 
  ST_PYR, COLOR0, EC, EI, EE, EL, P4, 
  ST_WDG, COLOR1, P0, P5, P2, EA, EJ, EB, 
  ST_PYR, COLOR1, P0, P2, EC, ED, EI, 
  ST_PYR, COLOR1, EL, P2, P5, EF, EE, 
  ST_PYR, COLOR1, EI, EE, P5, P0, P2, 
  ST_PYR, COLOR1, EI, EC, EL, EE, P2, 
 // Case #38: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EE, EA, EF, EL, EC, 
  ST_PYR, COLOR0, P4, P0, P3, P7, N0, 
  ST_TET, COLOR0, P3, N0, P6, P7, 
  ST_PYR, COLOR0, P0, EA, EC, P3, N0, 
  ST_PYR, COLOR0, EE, EA, P0, P4, N0, 
  ST_TET, COLOR0, P6, P4, P7, N0, 
  ST_PYR, COLOR0, P6, EF, EE, P4, N0, 
  ST_TET, COLOR0, P6, EL, EF, N0, 
  ST_PYR, COLOR0, EC, EL, P6, P3, N0, 
  ST_PYR, COLOR1, EA, P1, P2, EC, N0, 
  ST_PYR, COLOR1, EE, P5, P1, EA, N0, 
  ST_TET, COLOR1, EF, P5, EE, N0, 
  ST_TET, COLOR1, P5, P2, P1, N0, 
  ST_PYR, COLOR1, EF, EL, P2, P5, N0, 
  ST_TET, COLOR1, P2, EL, EC, N0, 
 // Case #39: (cloned #27)
  ST_TET, COLOR0, P6, P7, P3, P4, 
  ST_PYR, COLOR0, EI, ED, P3, P4, EC, 
  ST_PYR, COLOR0, EE, P4, P6, EF, EL, 
  ST_PYR, COLOR0, P3, EC, EL, P6, P4, 
  ST_PYR, COLOR0, EC, EI, EE, EL, P4, 
  ST_TET, COLOR1, P1, P0, P5, P2, 
  ST_PYR, COLOR1, EC, ED, P0, P2, EI, 
  ST_PYR, COLOR1, EL, P2, P5, EF, EE, 
  ST_PYR, COLOR1, P0, EI, EE, P5, P2, 
  ST_PYR, COLOR1, EC, EL, EE, EI, P2, 
 // Case #40: (cloned #20)
  ST_WDG, COLOR0, P1, P4, P6, EJ, EE, EF, 
  ST_WDG, COLOR0, ED, EK, EC, P0, P7, P2, 
  ST_TET, COLOR0, P4, P6, P1, P7, 
  ST_TET, COLOR0, P2, P6, P7, P1, 
  ST_TET, COLOR0, P0, P1, P2, P7, 
  ST_TET, COLOR0, P4, P0, P7, P1, 
  ST_TET, COLOR1, P3, ED, EC, EK, 
  ST_TET, COLOR1, P5, EJ, EE, EF, 
 // Case #41: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EC, EK, EF, EF, 
  ST_PYR, COLOR0, P6, EF, EE, P4, N0, 
  ST_TET, COLOR0, EE, EI, P4, N0, 
  ST_PYR, COLOR0, P7, P4, EI, EK, N0, 
  ST_TET, COLOR0, P6, P4, P7, N0, 
  ST_TET, COLOR0, P1, EA, EJ, N0, 
  ST_TET, COLOR0, P2, P1, P6, N0, 
  ST_PYR, COLOR0, P1, EJ, EF, P6, N0, 
  ST_TET, COLOR0, P2, P6, P7, N0, 
  ST_PYR, COLOR0, P2, P7, EK, EC, N0, 
  ST_PYR, COLOR0, P2, EC, EA, P1, N0, 
  ST_PYR, COLOR1, P5, P0, EI, EE, N0, 
  ST_PYR, COLOR1, EA, P0, P5, EJ, N0, 
  ST_TET, COLOR1, P5, EE, EF, N0, 
  ST_TET, COLOR1, EJ, P5, EF, N0, 
  ST_PYR, COLOR1, EI, P0, P3, EK, N0, 
  ST_PYR, COLOR1, P0, EA, EC, P3, N0, 
  ST_TET, COLOR1, EC, EK, P3, N0, 
 // Case #42: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EF, EE, EK, EK, 
  ST_PYR, COLOR0, P7, P0, ED, EK, N0, 
  ST_TET, COLOR0, ED, P0, EA, N0, 
  ST_PYR, COLOR0, P4, EE, EA, P0, N0, 
  ST_TET, COLOR0, P7, P4, P0, N0, 
  ST_TET, COLOR0, P2, EC, EB, N0, 
  ST_TET, COLOR0, P6, P7, P2, N0, 
  ST_PYR, COLOR0, P2, P7, EK, EC, N0, 
  ST_TET, COLOR0, P6, P4, P7, N0, 
  ST_PYR, COLOR0, P6, EF, EE, P4, N0, 
  ST_PYR, COLOR0, P6, P2, EB, EF, N0, 
  ST_PYR, COLOR1, P3, ED, EA, P1, N0, 
  ST_PYR, COLOR1, EB, EC, P3, P1, N0, 
  ST_TET, COLOR1, P3, EK, ED, N0, 
  ST_TET, COLOR1, EC, EK, P3, N0, 
  ST_PYR, COLOR1, EA, EE, P5, P1, N0, 
  ST_PYR, COLOR1, P1, P5, EF, EB, N0, 
  ST_TET, COLOR1, EF, P5, EE, N0, 
 // Case #43: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EI, EE, EF, EB, EC, EK, 
  ST_TET, COLOR0, P6, P7, P2, N0, 
  ST_PYR, COLOR0, P6, P2, EB, EF, N0, 
  ST_TET, COLOR0, P4, P7, P6, N0, 
  ST_PYR, COLOR0, P4, P6, EF, EE, N0, 
  ST_TET, COLOR0, EI, P4, EE, N0, 
  ST_PYR, COLOR0, P4, EI, EK, P7, N0, 
  ST_PYR, COLOR0, EK, EC, P2, P7, N0, 
  ST_TET, COLOR0, P2, EC, EB, N0, 
  ST_TET, COLOR1, P0, P5, P1, N0, 
  ST_PYR, COLOR1, EI, EE, P5, P0, N0, 
  ST_PYR, COLOR1, EI, P0, P3, EK, N0, 
  ST_TET, COLOR1, P3, P0, P1, N0, 
  ST_TET, COLOR1, P3, EC, EK, N0, 
  ST_PYR, COLOR1, P3, P1, EB, EC, N0, 
  ST_PYR, COLOR1, EB, P1, P5, EF, N0, 
  ST_TET, COLOR1, EF, P5, EE, N0, 
 // Case #44: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EK, ED, EE, EE, 
  ST_PYR, COLOR0, P4, EE, EJ, P1, N0, 
  ST_TET, COLOR0, EJ, EB, P1, N0, 
  ST_PYR, COLOR0, P0, P1, EB, ED, N0, 
  ST_TET, COLOR0, P4, P1, P0, N0, 
  ST_TET, COLOR0, P6, EL, EF, N0, 
  ST_TET, COLOR0, P7, P6, P4, N0, 
  ST_PYR, COLOR0, P6, EF, EE, P4, N0, 
  ST_TET, COLOR0, P7, P4, P0, N0, 
  ST_PYR, COLOR0, P7, P0, ED, EK, N0, 
  ST_PYR, COLOR0, P7, EK, EL, P6, N0, 
  ST_PYR, COLOR1, P5, P2, EB, EJ, N0, 
  ST_PYR, COLOR1, EL, P2, P5, EF, N0, 
  ST_TET, COLOR1, P5, EJ, EE, N0, 
  ST_TET, COLOR1, EF, P5, EE, N0, 
  ST_PYR, COLOR1, EB, P2, P3, ED, N0, 
  ST_PYR, COLOR1, P2, EL, EK, P3, N0, 
  ST_TET, COLOR1, EK, ED, P3, N0, 
 // Case #45: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EK, EL, EI, EE, EF, 
  ST_TET, COLOR0, P1, EB, EA, EJ, 
  ST_PYR, COLOR0, P6, P7, EK, EL, N0, 
  ST_PYR, COLOR0, P7, P4, EI, EK, N0, 
  ST_TET, COLOR0, P4, EE, EI, N0, 
  ST_TET, COLOR0, P7, P6, P4, N0, 
  ST_PYR, COLOR0, P4, P6, EF, EE, N0, 
  ST_TET, COLOR0, P6, EL, EF, N0, 
  ST_WDG, COLOR1, EA, EB, EJ, P0, P2, P5, 
  ST_TET, COLOR1, P2, P0, P5, N0, 
  ST_PYR, COLOR1, P0, EI, EE, P5, N0, 
  ST_TET, COLOR1, P3, P0, P2, N0, 
  ST_PYR, COLOR1, EL, EK, P3, P2, N0, 
  ST_PYR, COLOR1, EK, EI, P0, P3, N0, 
  ST_PYR, COLOR1, P5, EF, EL, P2, N0, 
  ST_TET, COLOR1, EE, EF, P5, N0, 
 // Case #46: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EA, ED, EK, EL, EF, EE, 
  ST_TET, COLOR0, P7, P6, P4, N0, 
  ST_PYR, COLOR0, P7, EK, EL, P6, N0, 
  ST_TET, COLOR0, P0, P7, P4, N0, 
  ST_PYR, COLOR0, P0, ED, EK, P7, N0, 
  ST_TET, COLOR0, EA, ED, P0, N0, 
  ST_PYR, COLOR0, P0, P4, EE, EA, N0, 
  ST_PYR, COLOR0, EE, P4, P6, EF, N0, 
  ST_TET, COLOR0, P6, EL, EF, N0, 
  ST_TET, COLOR1, P1, P2, P3, N0, 
  ST_PYR, COLOR1, EA, P1, P3, ED, N0, 
  ST_PYR, COLOR1, EA, EE, P5, P1, N0, 
  ST_TET, COLOR1, P5, P2, P1, N0, 
  ST_TET, COLOR1, P5, EE, EF, N0, 
  ST_PYR, COLOR1, P5, EF, EL, P2, N0, 
  ST_PYR, COLOR1, EL, EK, P3, P2, N0, 
  ST_TET, COLOR1, EK, ED, P3, N0, 
 // Case #47: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EL, EK, EI, EF, EE, 
  ST_PYR, COLOR0, P7, P4, EI, EK, N0, 
  ST_TET, COLOR0, P4, EE, EI, N0, 
  ST_PYR, COLOR0, P6, P7, EK, EL, N0, 
  ST_TET, COLOR0, EF, P6, EL, N0, 
  ST_PYR, COLOR0, EE, P4, P6, EF, N0, 
  ST_TET, COLOR0, P4, P7, P6, N0, 
  ST_PYR, COLOR1, P1, P2, P3, P0, N0, 
  ST_TET, COLOR1, P0, P5, P1, N0, 
  ST_TET, COLOR1, P5, P2, P1, N0, 
  ST_PYR, COLOR1, P5, EF, EL, P2, N0, 
  ST_PYR, COLOR1, EL, EK, P3, P2, N0, 
  ST_PYR, COLOR1, EK, EI, P0, P3, N0, 
  ST_PYR, COLOR1, EI, EE, P5, P0, N0, 
  ST_TET, COLOR1, EF, P5, EE, N0, 
 // Case #48: (cloned #3)
  ST_HEX, COLOR0, EJ, P1, P0, EI, EF, P6, P7, EH, 
  ST_WDG, COLOR0, P1, P2, P6, P0, P3, P7, 
  ST_WDG, COLOR1, P5, EJ, EF, P4, EI, EH, 
 // Case #49: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, ED, EH, EA, EJ, EF, 
  ST_PYR, COLOR0, P3, P2, P6, P7, N0, 
  ST_TET, COLOR0, P6, P1, N0, P2, 
  ST_PYR, COLOR0, P7, P6, EF, EH, N0, 
  ST_PYR, COLOR0, ED, P3, P7, EH, N0, 
  ST_TET, COLOR0, P1, P2, P3, N0, 
  ST_PYR, COLOR0, P1, P3, ED, EA, N0, 
  ST_TET, COLOR0, P1, EA, EJ, N0, 
  ST_PYR, COLOR0, EF, P6, P1, EJ, N0, 
  ST_PYR, COLOR1, EH, EF, P5, P4, N0, 
  ST_PYR, COLOR1, ED, EH, P4, P0, N0, 
  ST_TET, COLOR1, EA, ED, P0, N0, 
  ST_TET, COLOR1, P0, P4, P5, N0, 
  ST_PYR, COLOR1, EA, P0, P5, EJ, N0, 
  ST_TET, COLOR1, P5, EF, EJ, N0, 
 // Case #50: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EH, EF, EI, EA, EB, 
  ST_PYR, COLOR0, P7, P3, P2, P6, N0, 
  ST_TET, COLOR0, P2, P0, N0, P3, 
  ST_PYR, COLOR0, P6, P2, EB, EF, N0, 
  ST_PYR, COLOR0, EH, P7, P6, EF, N0, 
  ST_TET, COLOR0, P0, P3, P7, N0, 
  ST_PYR, COLOR0, P0, P7, EH, EI, N0, 
  ST_TET, COLOR0, P0, EI, EA, N0, 
  ST_PYR, COLOR0, EB, P2, P0, EA, N0, 
  ST_PYR, COLOR1, EF, EB, P1, P5, N0, 
  ST_PYR, COLOR1, EH, EF, P5, P4, N0, 
  ST_TET, COLOR1, EI, EH, P4, N0, 
  ST_TET, COLOR1, P4, P5, P1, N0, 
  ST_PYR, COLOR1, EI, P4, P1, EA, N0, 
  ST_TET, COLOR1, P1, EB, EA, N0, 
 // Case #51: (cloned #15)
  ST_HEX, COLOR0, P3, P2, P6, P7, ED, EB, EF, EH, 
  ST_HEX, COLOR1, ED, EB, EF, EH, P0, P1, P5, P4, 
 // Case #52: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EH, EI, EC, EC, 
  ST_PYR, COLOR0, P3, P1, EB, EC, N0, 
  ST_TET, COLOR0, EB, P1, EJ, N0, 
  ST_PYR, COLOR0, P0, EI, EJ, P1, N0, 
  ST_TET, COLOR0, P3, P0, P1, N0, 
  ST_TET, COLOR0, P6, EL, EF, N0, 
  ST_TET, COLOR0, P7, P3, P6, N0, 
  ST_PYR, COLOR0, P6, P3, EC, EL, N0, 
  ST_TET, COLOR0, P7, P0, P3, N0, 
  ST_PYR, COLOR0, P7, EH, EI, P0, N0, 
  ST_PYR, COLOR0, P7, P6, EF, EH, N0, 
  ST_PYR, COLOR1, P2, EB, EJ, P5, N0, 
  ST_PYR, COLOR1, EF, EL, P2, P5, N0, 
  ST_TET, COLOR1, P2, EC, EB, N0, 
  ST_TET, COLOR1, EL, EC, P2, N0, 
  ST_PYR, COLOR1, EJ, EI, P4, P5, N0, 
  ST_PYR, COLOR1, P5, P4, EH, EF, N0, 
  ST_TET, COLOR1, EH, P4, EI, N0, 
 // Case #53: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EH, EF, ED, EC, EL, 
  ST_TET, COLOR0, P1, EA, EJ, EB, 
  ST_PYR, COLOR0, P6, EF, EH, P7, N0, 
  ST_PYR, COLOR0, P7, EH, ED, P3, N0, 
  ST_TET, COLOR0, P3, ED, EC, N0, 
  ST_TET, COLOR0, P7, P3, P6, N0, 
  ST_PYR, COLOR0, P3, EC, EL, P6, N0, 
  ST_TET, COLOR0, P6, EL, EF, N0, 
  ST_WDG, COLOR1, P0, P5, P2, EA, EJ, EB, 
  ST_TET, COLOR1, P5, P2, P0, N0, 
  ST_PYR, COLOR1, P0, P2, EC, ED, N0, 
  ST_TET, COLOR1, P4, P5, P0, N0, 
  ST_PYR, COLOR1, EF, P5, P4, EH, N0, 
  ST_PYR, COLOR1, EH, P4, P0, ED, N0, 
  ST_PYR, COLOR1, P2, P5, EF, EL, N0, 
  ST_TET, COLOR1, EC, P2, EL, N0, 
 // Case #54: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EA, EI, EH, EF, EL, EC, 
  ST_TET, COLOR0, P7, P3, P6, N0, 
  ST_PYR, COLOR0, P7, P6, EF, EH, N0, 
  ST_TET, COLOR0, P0, P3, P7, N0, 
  ST_PYR, COLOR0, P0, P7, EH, EI, N0, 
  ST_TET, COLOR0, EA, P0, EI, N0, 
  ST_PYR, COLOR0, P0, EA, EC, P3, N0, 
  ST_PYR, COLOR0, EC, EL, P6, P3, N0, 
  ST_TET, COLOR0, P6, EL, EF, N0, 
  ST_TET, COLOR1, P1, P4, P5, N0, 
  ST_PYR, COLOR1, EA, EI, P4, P1, N0, 
  ST_PYR, COLOR1, EA, P1, P2, EC, N0, 
  ST_TET, COLOR1, P2, P1, P5, N0, 
  ST_TET, COLOR1, P2, EL, EC, N0, 
  ST_PYR, COLOR1, P2, P5, EF, EL, N0, 
  ST_PYR, COLOR1, EF, P5, P4, EH, N0, 
  ST_TET, COLOR1, EH, P4, EI, N0, 
 // Case #55: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EF, EH, ED, EL, EC, 
  ST_PYR, COLOR0, P7, EH, ED, P3, N0, 
  ST_TET, COLOR0, P3, ED, EC, N0, 
  ST_PYR, COLOR0, P6, EF, EH, P7, N0, 
  ST_TET, COLOR0, EL, EF, P6, N0, 
  ST_PYR, COLOR0, EC, EL, P6, P3, N0, 
  ST_TET, COLOR0, P3, P6, P7, N0, 
  ST_PYR, COLOR1, P1, P0, P4, P5, N0, 
  ST_TET, COLOR1, P0, P1, P2, N0, 
  ST_TET, COLOR1, P2, P1, P5, N0, 
  ST_PYR, COLOR1, P2, P5, EF, EL, N0, 
  ST_PYR, COLOR1, EF, P5, P4, EH, N0, 
  ST_PYR, COLOR1, EH, P4, P0, ED, N0, 
  ST_PYR, COLOR1, ED, P0, P2, EC, N0, 
  ST_TET, COLOR1, EL, EC, P2, N0, 
 // Case #56: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EF, EJ, EC, EC, 
  ST_PYR, COLOR0, P2, EC, ED, P0, N0, 
  ST_TET, COLOR0, ED, EI, P0, N0, 
  ST_PYR, COLOR0, P1, P0, EI, EJ, N0, 
  ST_TET, COLOR0, P2, P0, P1, N0, 
  ST_TET, COLOR0, P7, EH, EK, N0, 
  ST_TET, COLOR0, P6, P7, P2, N0, 
  ST_PYR, COLOR0, P7, EK, EC, P2, N0, 
  ST_TET, COLOR0, P6, P2, P1, N0, 
  ST_PYR, COLOR0, P6, P1, EJ, EF, N0, 
  ST_PYR, COLOR0, P6, EF, EH, P7, N0, 
  ST_PYR, COLOR1, P3, P4, EI, ED, N0, 
  ST_PYR, COLOR1, EH, P4, P3, EK, N0, 
  ST_TET, COLOR1, P3, ED, EC, N0, 
  ST_TET, COLOR1, EK, P3, EC, N0, 
  ST_PYR, COLOR1, EI, P4, P5, EJ, N0, 
  ST_PYR, COLOR1, P4, EH, EF, P5, N0, 
  ST_TET, COLOR1, EF, EJ, P5, N0, 
 // Case #57: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EA, EJ, EF, EH, EK, EC, 
  ST_TET, COLOR0, P6, P7, P2, N0, 
  ST_PYR, COLOR0, P6, EF, EH, P7, N0, 
  ST_TET, COLOR0, P1, P6, P2, N0, 
  ST_PYR, COLOR0, P1, EJ, EF, P6, N0, 
  ST_TET, COLOR0, EA, EJ, P1, N0, 
  ST_PYR, COLOR0, P1, P2, EC, EA, N0, 
  ST_PYR, COLOR0, EC, P2, P7, EK, N0, 
  ST_TET, COLOR0, P7, EH, EK, N0, 
  ST_TET, COLOR1, P0, P4, P5, N0, 
  ST_PYR, COLOR1, EA, P0, P5, EJ, N0, 
  ST_PYR, COLOR1, EA, EC, P3, P0, N0, 
  ST_TET, COLOR1, P3, P4, P0, N0, 
  ST_TET, COLOR1, P3, EC, EK, N0, 
  ST_PYR, COLOR1, P3, EK, EH, P4, N0, 
  ST_PYR, COLOR1, EH, EF, P5, P4, N0, 
  ST_TET, COLOR1, EF, EJ, P5, N0, 
 // Case #58: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EF, EB, EH, EK, EC, 
  ST_TET, COLOR0, P0, EI, EA, ED, 
  ST_PYR, COLOR0, P2, EB, EF, P6, N0, 
  ST_PYR, COLOR0, P6, EF, EH, P7, N0, 
  ST_TET, COLOR0, P7, EH, EK, N0, 
  ST_TET, COLOR0, P6, P7, P2, N0, 
  ST_PYR, COLOR0, P7, EK, EC, P2, N0, 
  ST_TET, COLOR0, P2, EC, EB, N0, 
  ST_WDG, COLOR1, P4, P1, P3, EI, EA, ED, 
  ST_TET, COLOR1, P1, P3, P4, N0, 
  ST_PYR, COLOR1, P4, P3, EK, EH, N0, 
  ST_TET, COLOR1, P5, P1, P4, N0, 
  ST_PYR, COLOR1, EB, P1, P5, EF, N0, 
  ST_PYR, COLOR1, EF, P5, P4, EH, N0, 
  ST_PYR, COLOR1, P3, P1, EB, EC, N0, 
  ST_TET, COLOR1, EK, P3, EC, N0, 
 // Case #59: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EB, EF, EH, EC, EK, 
  ST_PYR, COLOR0, P6, EF, EH, P7, N0, 
  ST_TET, COLOR0, P7, EH, EK, N0, 
  ST_PYR, COLOR0, P2, EB, EF, P6, N0, 
  ST_TET, COLOR0, EC, EB, P2, N0, 
  ST_PYR, COLOR0, EK, EC, P2, P7, N0, 
  ST_TET, COLOR0, P7, P2, P6, N0, 
  ST_PYR, COLOR1, P0, P4, P5, P1, N0, 
  ST_TET, COLOR1, P4, P0, P3, N0, 
  ST_TET, COLOR1, P3, P0, P1, N0, 
  ST_PYR, COLOR1, P3, P1, EB, EC, N0, 
  ST_PYR, COLOR1, EB, P1, P5, EF, N0, 
  ST_PYR, COLOR1, EF, P5, P4, EH, N0, 
  ST_PYR, COLOR1, EH, P4, P3, EK, N0, 
  ST_TET, COLOR1, EC, EK, P3, N0, 
 // Case #60: Unique case #14
  ST_WDG, COLOR0, P1, EB, EJ, P0, ED, EI, 
  ST_WDG, COLOR0, P6, EF, EL, P7, EH, EK, 
  ST_HEX, COLOR1, P3, P4, P5, P2, EK, EH, EF, EL, 
  ST_HEX, COLOR1, ED, EI, EJ, EB, P3, P4, P5, P2, 
 // Case #61: Unique case #15
  ST_PNT, 0, COLOR1, 6, P0, P2, P3, P4, EF, EH, 
  ST_WDG, COLOR0, EH, P7, EK, EF, P6, EL, 
  ST_TET, COLOR0, EA, P1, EB, EJ, 
  ST_WDG, COLOR1, P0, P5, P2, EA, EJ, EB, 
  ST_PYR, COLOR1, EH, EF, P5, P4, N0, 
  ST_TET, COLOR1, P4, P5, P0, N0, 
  ST_TET, COLOR1, P4, P0, P3, N0, 
  ST_PYR, COLOR1, EK, EH, P4, P3, N0, 
  ST_PYR, COLOR1, EL, EK, P3, P2, N0, 
  ST_TET, COLOR1, P3, P0, P2, N0, 
  ST_PYR, COLOR1, EF, EH, EK, EL, N0, 
  ST_TET, COLOR1, P2, P0, P5, N0, 
  ST_PYR, COLOR1, EF, EL, P2, P5, N0, 
 // Case #62: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P1, P3, P2, P5, EH, EF, 
  ST_WDG, COLOR0, EH, P7, EK, EF, P6, EL, 
  ST_TET, COLOR0, EA, ED, P0, EI, 
  ST_WDG, COLOR1, EA, EI, ED, P1, P4, P3, 
  ST_PYR, COLOR1, EF, P5, P4, EH, N0, 
  ST_TET, COLOR1, P5, P1, P4, N0, 
  ST_TET, COLOR1, P5, P2, P1, N0, 
  ST_PYR, COLOR1, EL, P2, P5, EF, N0, 
  ST_PYR, COLOR1, EK, P3, P2, EL, N0, 
  ST_TET, COLOR1, P2, P3, P1, N0, 
  ST_PYR, COLOR1, EH, EK, EL, EF, N0, 
  ST_TET, COLOR1, P3, P4, P1, N0, 
  ST_PYR, COLOR1, EH, P4, P3, EK, N0, 
 // Case #63: Unique case #16
  ST_WDG, COLOR0, P7, EK, EH, P6, EL, EF, 
  ST_HEX, COLOR1, P3, P4, P5, P2, EK, EH, EF, EL, 
  ST_WDG, COLOR1, P1, P2, P5, P0, P3, P4, 
 // Case #64: (cloned #1)
  ST_PNT, 0, COLOR0, 7, P7, P4, P5, P2, P3, P0, P1, 
  ST_WDG, COLOR0, EG, EF, EL, P7, P5, P2, 
  ST_TET, COLOR0, P7, P2, P5, N0, 
  ST_TET, COLOR0, P7, P5, P4, N0, 
  ST_PYR, COLOR0, P0, P4, P5, P1, N0, 
  ST_PYR, COLOR0, P3, P7, P4, P0, N0, 
  ST_PYR, COLOR0, P2, P3, P0, P1, N0, 
  ST_TET, COLOR0, P5, P2, P1, N0, 
  ST_TET, COLOR0, P2, P7, P3, N0, 
  ST_TET, COLOR1, P6, EF, EG, EL, 
 // Case #65: (cloned #20)
  ST_WDG, COLOR0, P5, P7, P2, EF, EG, EL, 
  ST_WDG, COLOR0, EI, ED, EA, P4, P3, P1, 
  ST_TET, COLOR0, P7, P2, P5, P3, 
  ST_TET, COLOR0, P1, P2, P3, P5, 
  ST_TET, COLOR0, P4, P5, P1, P3, 
  ST_TET, COLOR0, P7, P4, P3, P5, 
  ST_TET, COLOR1, P0, EI, EA, ED, 
  ST_TET, COLOR1, P6, EF, EG, EL, 
 // Case #66: (cloned #5)
  ST_PNT, 0, NOCOLOR, 2, EA, EG, 
  ST_PYR, COLOR0, P0, P3, P7, P4, N0, 
  ST_TET, COLOR0, P4, P7, P5, N0, 
  ST_TET, COLOR0, P0, P4, P5, N0, 
  ST_TET, COLOR0, P2, P3, P0, N0, 
  ST_TET, COLOR0, P7, P3, P2, N0, 
  ST_PYR, COLOR0, P7, P2, EL, EG, N0, 
  ST_PYR, COLOR0, P5, P7, EG, EF, N0, 
  ST_TET, COLOR0, P5, EF, EJ, N0, 
  ST_PYR, COLOR0, P0, P5, EJ, EA, N0, 
  ST_PYR, COLOR0, P0, EA, EB, P2, N0, 
  ST_TET, COLOR0, P2, EB, EL, N0, 
  ST_PYR, COLOR1, P1, P6, EL, EB, N0, 
  ST_PYR, COLOR1, EJ, EF, P6, P1, N0, 
  ST_TET, COLOR1, EF, EG, P6, N0, 
  ST_TET, COLOR1, P6, EG, EL, N0, 
  ST_TET, COLOR1, EJ, N0, P1, EA, 
  ST_TET, COLOR1, EB, EA, P1, N0, 
 // Case #67: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EI, ED, EG, EG, 
  ST_PYR, COLOR0, P7, P2, EL, EG, N0, 
  ST_TET, COLOR0, EL, P2, EB, N0, 
  ST_PYR, COLOR0, P3, ED, EB, P2, N0, 
  ST_TET, COLOR0, P7, P3, P2, N0, 
  ST_TET, COLOR0, P5, EF, EJ, N0, 
  ST_TET, COLOR0, P4, P7, P5, N0, 
  ST_PYR, COLOR0, P5, P7, EG, EF, N0, 
  ST_TET, COLOR0, P4, P3, P7, N0, 
  ST_PYR, COLOR0, P4, EI, ED, P3, N0, 
  ST_PYR, COLOR0, P4, P5, EJ, EI, N0, 
  ST_PYR, COLOR1, P6, EL, EB, P1, N0, 
  ST_PYR, COLOR1, EJ, EF, P6, P1, N0, 
  ST_TET, COLOR1, P6, EG, EL, N0, 
  ST_TET, COLOR1, EF, EG, P6, N0, 
  ST_PYR, COLOR1, EB, ED, P0, P1, N0, 
  ST_PYR, COLOR1, P1, P0, EI, EJ, N0, 
  ST_TET, COLOR1, EI, P0, ED, N0, 
 // Case #68: (cloned #3)
  ST_HEX, COLOR0, EG, P7, P3, EC, EF, P5, P1, EB, 
  ST_WDG, COLOR0, P1, P0, P3, P5, P4, P7, 
  ST_WDG, COLOR1, P2, EB, EC, P6, EF, EG, 
 // Case #69: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EG, EF, EI, EI, 
  ST_PYR, COLOR0, P4, P1, EA, EI, N0, 
  ST_TET, COLOR0, EA, P1, EB, N0, 
  ST_PYR, COLOR0, P5, EF, EB, P1, N0, 
  ST_TET, COLOR0, P4, P5, P1, N0, 
  ST_TET, COLOR0, P3, ED, EC, N0, 
  ST_TET, COLOR0, P7, P4, P3, N0, 
  ST_PYR, COLOR0, P3, P4, EI, ED, N0, 
  ST_TET, COLOR0, P7, P5, P4, N0, 
  ST_PYR, COLOR0, P7, EG, EF, P5, N0, 
  ST_PYR, COLOR0, P7, P3, EC, EG, N0, 
  ST_PYR, COLOR1, P0, EA, EB, P2, N0, 
  ST_PYR, COLOR1, EC, ED, P0, P2, N0, 
  ST_TET, COLOR1, P0, EI, EA, N0, 
  ST_TET, COLOR1, ED, EI, P0, N0, 
  ST_PYR, COLOR1, EB, EF, P6, P2, N0, 
  ST_PYR, COLOR1, P2, P6, EG, EC, N0, 
  ST_TET, COLOR1, EG, P6, EF, N0, 
 // Case #70: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EA, EC, EJ, EF, EG, 
  ST_PYR, COLOR0, P0, P3, P7, P4, N0, 
  ST_TET, COLOR0, P7, N0, P5, P4, 
  ST_PYR, COLOR0, P3, EC, EG, P7, N0, 
  ST_PYR, COLOR0, EA, EC, P3, P0, N0, 
  ST_TET, COLOR0, P5, P0, P4, N0, 
  ST_PYR, COLOR0, P5, EJ, EA, P0, N0, 
  ST_TET, COLOR0, P5, EF, EJ, N0, 
  ST_PYR, COLOR0, EG, EF, P5, P7, N0, 
  ST_PYR, COLOR1, EC, P2, P6, EG, N0, 
  ST_PYR, COLOR1, EA, P1, P2, EC, N0, 
  ST_TET, COLOR1, EJ, P1, EA, N0, 
  ST_TET, COLOR1, P1, P6, P2, N0, 
  ST_PYR, COLOR1, EJ, EF, P6, P1, N0, 
  ST_TET, COLOR1, P6, EF, EG, N0, 
 // Case #71: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EJ, EF, EG, EC, ED, EI, 
  ST_TET, COLOR0, P7, P4, P3, N0, 
  ST_PYR, COLOR0, P7, P3, EC, EG, N0, 
  ST_TET, COLOR0, P5, P4, P7, N0, 
  ST_PYR, COLOR0, P5, P7, EG, EF, N0, 
  ST_TET, COLOR0, EJ, P5, EF, N0, 
  ST_PYR, COLOR0, P5, EJ, EI, P4, N0, 
  ST_PYR, COLOR0, EI, ED, P3, P4, N0, 
  ST_TET, COLOR0, P3, ED, EC, N0, 
  ST_TET, COLOR1, P1, P6, P2, N0, 
  ST_PYR, COLOR1, EJ, EF, P6, P1, N0, 
  ST_PYR, COLOR1, EJ, P1, P0, EI, N0, 
  ST_TET, COLOR1, P0, P1, P2, N0, 
  ST_TET, COLOR1, P0, ED, EI, N0, 
  ST_PYR, COLOR1, P0, P2, EC, ED, N0, 
  ST_PYR, COLOR1, EC, P2, P6, EG, N0, 
  ST_TET, COLOR1, EG, P6, EF, N0, 
 // Case #72: (cloned #5)
  ST_PNT, 0, NOCOLOR, 2, ED, EF, 
  ST_PYR, COLOR0, P0, P4, P5, P1, N0, 
  ST_TET, COLOR0, P1, P5, P2, N0, 
  ST_TET, COLOR0, P0, P1, P2, N0, 
  ST_TET, COLOR0, P7, P4, P0, N0, 
  ST_TET, COLOR0, P5, P4, P7, N0, 
  ST_PYR, COLOR0, P5, P7, EG, EF, N0, 
  ST_PYR, COLOR0, P2, P5, EF, EL, N0, 
  ST_TET, COLOR0, P2, EL, EC, N0, 
  ST_PYR, COLOR0, P0, P2, EC, ED, N0, 
  ST_PYR, COLOR0, P0, ED, EK, P7, N0, 
  ST_TET, COLOR0, P7, EK, EG, N0, 
  ST_PYR, COLOR1, P3, P6, EG, EK, N0, 
  ST_PYR, COLOR1, EC, EL, P6, P3, N0, 
  ST_TET, COLOR1, EL, EF, P6, N0, 
  ST_TET, COLOR1, P6, EF, EG, N0, 
  ST_TET, COLOR1, EC, N0, P3, ED, 
  ST_TET, COLOR1, EK, ED, P3, N0, 
 // Case #73: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EA, EI, EF, EF, 
  ST_PYR, COLOR0, P5, P7, EG, EF, N0, 
  ST_TET, COLOR0, EG, P7, EK, N0, 
  ST_PYR, COLOR0, P4, EI, EK, P7, N0, 
  ST_TET, COLOR0, P5, P4, P7, N0, 
  ST_TET, COLOR0, P2, EL, EC, N0, 
  ST_TET, COLOR0, P1, P5, P2, N0, 
  ST_PYR, COLOR0, P2, P5, EF, EL, N0, 
  ST_TET, COLOR0, P1, P4, P5, N0, 
  ST_PYR, COLOR0, P1, EA, EI, P4, N0, 
  ST_PYR, COLOR0, P1, P2, EC, EA, N0, 
  ST_PYR, COLOR1, P6, EG, EK, P3, N0, 
  ST_PYR, COLOR1, EC, EL, P6, P3, N0, 
  ST_TET, COLOR1, P6, EF, EG, N0, 
  ST_TET, COLOR1, EL, EF, P6, N0, 
  ST_PYR, COLOR1, EK, EI, P0, P3, N0, 
  ST_PYR, COLOR1, P3, P0, EA, EC, N0, 
  ST_TET, COLOR1, EA, P0, EI, N0, 
 // Case #74: (cloned #26)
  ST_TET, COLOR0, P2, EB, EL, EC, 
  ST_TET, COLOR0, P7, P4, P0, P5, 
  ST_PYR, COLOR0, EJ, EA, P0, P5, ED, 
  ST_PYR, COLOR0, EF, P5, P7, EG, EK, 
  ST_PYR, COLOR0, P0, ED, EK, P7, P5, 
  ST_PYR, COLOR0, ED, EJ, EF, EK, P5, 
  ST_WDG, COLOR1, P1, P6, P3, EB, EL, EC, 
  ST_PYR, COLOR1, P1, P3, ED, EA, EJ, 
  ST_PYR, COLOR1, EK, P3, P6, EG, EF, 
  ST_PYR, COLOR1, EJ, EF, P6, P1, P3, 
  ST_PYR, COLOR1, EJ, ED, EK, EF, P3, 
 // Case #75: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EI, EK, EJ, EF, EG, 
  ST_TET, COLOR0, P2, EC, EB, EL, 
  ST_PYR, COLOR0, P7, P4, EI, EK, N0, 
  ST_PYR, COLOR0, P4, P5, EJ, EI, N0, 
  ST_TET, COLOR0, P5, EF, EJ, N0, 
  ST_TET, COLOR0, P4, P7, P5, N0, 
  ST_PYR, COLOR0, P5, P7, EG, EF, N0, 
  ST_TET, COLOR0, P7, EK, EG, N0, 
  ST_WDG, COLOR1, EB, EC, EL, P1, P3, P6, 
  ST_TET, COLOR1, P3, P1, P6, N0, 
  ST_PYR, COLOR1, P1, EJ, EF, P6, N0, 
  ST_TET, COLOR1, P0, P1, P3, N0, 
  ST_PYR, COLOR1, EK, EI, P0, P3, N0, 
  ST_PYR, COLOR1, EI, EJ, P1, P0, N0, 
  ST_PYR, COLOR1, P6, EG, EK, P3, N0, 
  ST_TET, COLOR1, EF, EG, P6, N0, 
 // Case #76: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, ED, EB, EK, EG, EF, 
  ST_PYR, COLOR0, P0, P4, P5, P1, N0, 
  ST_TET, COLOR0, P5, P7, N0, P4, 
  ST_PYR, COLOR0, P1, P5, EF, EB, N0, 
  ST_PYR, COLOR0, ED, P0, P1, EB, N0, 
  ST_TET, COLOR0, P7, P4, P0, N0, 
  ST_PYR, COLOR0, P7, P0, ED, EK, N0, 
  ST_TET, COLOR0, P7, EK, EG, N0, 
  ST_PYR, COLOR0, EF, P5, P7, EG, N0, 
  ST_PYR, COLOR1, EB, EF, P6, P2, N0, 
  ST_PYR, COLOR1, ED, EB, P2, P3, N0, 
  ST_TET, COLOR1, EK, ED, P3, N0, 
  ST_TET, COLOR1, P3, P2, P6, N0, 
  ST_PYR, COLOR1, EK, P3, P6, EG, N0, 
  ST_TET, COLOR1, P6, EF, EG, N0, 
 // Case #77: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EK, EG, EF, EB, EA, EI, 
  ST_TET, COLOR0, P5, P1, P4, N0, 
  ST_PYR, COLOR0, P5, EF, EB, P1, N0, 
  ST_TET, COLOR0, P7, P5, P4, N0, 
  ST_PYR, COLOR0, P7, EG, EF, P5, N0, 
  ST_TET, COLOR0, EK, EG, P7, N0, 
  ST_PYR, COLOR0, P7, P4, EI, EK, N0, 
  ST_PYR, COLOR0, EI, P4, P1, EA, N0, 
  ST_TET, COLOR0, P1, EB, EA, N0, 
  ST_TET, COLOR1, P3, P2, P6, N0, 
  ST_PYR, COLOR1, EK, P3, P6, EG, N0, 
  ST_PYR, COLOR1, EK, EI, P0, P3, N0, 
  ST_TET, COLOR1, P0, P2, P3, N0, 
  ST_TET, COLOR1, P0, EI, EA, N0, 
  ST_PYR, COLOR1, P0, EA, EB, P2, N0, 
  ST_PYR, COLOR1, EB, EF, P6, P2, N0, 
  ST_TET, COLOR1, EF, EG, P6, N0, 
 // Case #78: (cloned #27)
  ST_TET, COLOR0, P7, P4, P0, P5, 
  ST_PYR, COLOR0, EJ, EA, P0, P5, ED, 
  ST_PYR, COLOR0, EF, P5, P7, EG, EK, 
  ST_PYR, COLOR0, P0, ED, EK, P7, P5, 
  ST_PYR, COLOR0, ED, EJ, EF, EK, P5, 
  ST_TET, COLOR1, P2, P1, P6, P3, 
  ST_PYR, COLOR1, ED, EA, P1, P3, EJ, 
  ST_PYR, COLOR1, EK, P3, P6, EG, EF, 
  ST_PYR, COLOR1, P1, EJ, EF, P6, P3, 
  ST_PYR, COLOR1, ED, EK, EF, EJ, P3, 
 // Case #79: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EK, EI, EJ, EG, EF, 
  ST_PYR, COLOR0, P4, P5, EJ, EI, N0, 
  ST_TET, COLOR0, P5, EF, EJ, N0, 
  ST_PYR, COLOR0, P7, P4, EI, EK, N0, 
  ST_TET, COLOR0, EG, P7, EK, N0, 
  ST_PYR, COLOR0, EF, P5, P7, EG, N0, 
  ST_TET, COLOR0, P5, P4, P7, N0, 
  ST_PYR, COLOR1, P2, P3, P0, P1, N0, 
  ST_TET, COLOR1, P1, P6, P2, N0, 
  ST_TET, COLOR1, P6, P3, P2, N0, 
  ST_PYR, COLOR1, P6, EG, EK, P3, N0, 
  ST_PYR, COLOR1, EK, EI, P0, P3, N0, 
  ST_PYR, COLOR1, EI, EJ, P1, P0, N0, 
  ST_PYR, COLOR1, EJ, EF, P6, P1, N0, 
  ST_TET, COLOR1, EG, P6, EF, N0, 
 // Case #80: (cloned #5)
  ST_PNT, 0, NOCOLOR, 2, EI, EL, 
  ST_PYR, COLOR0, P0, P1, P2, P3, N0, 
  ST_TET, COLOR0, P1, P5, P2, N0, 
  ST_TET, COLOR0, P0, P5, P1, N0, 
  ST_TET, COLOR0, P7, P0, P3, N0, 
  ST_TET, COLOR0, P2, P7, P3, N0, 
  ST_PYR, COLOR0, P2, EL, EG, P7, N0, 
  ST_PYR, COLOR0, P5, EF, EL, P2, N0, 
  ST_TET, COLOR0, P5, EE, EF, N0, 
  ST_PYR, COLOR0, P0, EI, EE, P5, N0, 
  ST_PYR, COLOR0, P0, P7, EH, EI, N0, 
  ST_TET, COLOR0, P7, EG, EH, N0, 
  ST_PYR, COLOR1, P4, EH, EG, P6, N0, 
  ST_PYR, COLOR1, EE, P4, P6, EF, N0, 
  ST_TET, COLOR1, EF, P6, EL, N0, 
  ST_TET, COLOR1, P6, EG, EL, N0, 
  ST_TET, COLOR1, EE, P4, N0, EI, 
  ST_TET, COLOR1, EH, P4, EI, N0, 
 // Case #81: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EA, ED, EL, EL, 
  ST_PYR, COLOR0, P2, EL, EG, P7, N0, 
  ST_TET, COLOR0, EG, EH, P7, N0, 
  ST_PYR, COLOR0, P3, P7, EH, ED, N0, 
  ST_TET, COLOR0, P2, P7, P3, N0, 
  ST_TET, COLOR0, P5, EE, EF, N0, 
  ST_TET, COLOR0, P1, P5, P2, N0, 
  ST_PYR, COLOR0, P5, EF, EL, P2, N0, 
  ST_TET, COLOR0, P1, P2, P3, N0, 
  ST_PYR, COLOR0, P1, P3, ED, EA, N0, 
  ST_PYR, COLOR0, P1, EA, EE, P5, N0, 
  ST_PYR, COLOR1, P6, P4, EH, EG, N0, 
  ST_PYR, COLOR1, EE, P4, P6, EF, N0, 
  ST_TET, COLOR1, P6, EG, EL, N0, 
  ST_TET, COLOR1, EF, P6, EL, N0, 
  ST_PYR, COLOR1, EH, P4, P0, ED, N0, 
  ST_PYR, COLOR1, P4, EE, EA, P0, N0, 
  ST_TET, COLOR1, EA, ED, P0, N0, 
 // Case #82: (cloned #26)
  ST_TET, COLOR0, P5, EF, EJ, EE, 
  ST_TET, COLOR0, P7, P0, P3, P2, 
  ST_PYR, COLOR0, EB, P2, P0, EA, EI, 
  ST_PYR, COLOR0, EL, EG, P7, P2, EH, 
  ST_PYR, COLOR0, P0, P7, EH, EI, P2, 
  ST_PYR, COLOR0, EI, EH, EL, EB, P2, 
  ST_WDG, COLOR1, EJ, EF, EE, P1, P6, P4, 
  ST_PYR, COLOR1, P1, EA, EI, P4, EB, 
  ST_PYR, COLOR1, EH, EG, P6, P4, EL, 
  ST_PYR, COLOR1, EB, P1, P6, EL, P4, 
  ST_PYR, COLOR1, EB, EL, EH, EI, P4, 
 // Case #83: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, ED, EH, EB, EL, EG, 
  ST_TET, COLOR0, P5, EJ, EE, EF, 
  ST_PYR, COLOR0, P7, EH, ED, P3, N0, 
  ST_PYR, COLOR0, P3, ED, EB, P2, N0, 
  ST_TET, COLOR0, P2, EB, EL, N0, 
  ST_TET, COLOR0, P3, P2, P7, N0, 
  ST_PYR, COLOR0, P2, EL, EG, P7, N0, 
  ST_TET, COLOR0, P7, EG, EH, N0, 
  ST_WDG, COLOR1, P1, P4, P6, EJ, EE, EF, 
  ST_TET, COLOR1, P4, P6, P1, N0, 
  ST_PYR, COLOR1, P1, P6, EL, EB, N0, 
  ST_TET, COLOR1, P0, P4, P1, N0, 
  ST_PYR, COLOR1, EH, P4, P0, ED, N0, 
  ST_PYR, COLOR1, ED, P0, P1, EB, N0, 
  ST_PYR, COLOR1, P6, P4, EH, EG, N0, 
  ST_TET, COLOR1, EL, P6, EG, N0, 
 // Case #84: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EC, EB, EI, EI, 
  ST_PYR, COLOR0, P0, EI, EE, P5, N0, 
  ST_TET, COLOR0, EE, EF, P5, N0, 
  ST_PYR, COLOR0, P1, P5, EF, EB, N0, 
  ST_TET, COLOR0, P0, P5, P1, N0, 
  ST_TET, COLOR0, P7, EG, EH, N0, 
  ST_TET, COLOR0, P3, P7, P0, N0, 
  ST_PYR, COLOR0, P7, EH, EI, P0, N0, 
  ST_TET, COLOR0, P3, P0, P1, N0, 
  ST_PYR, COLOR0, P3, P1, EB, EC, N0, 
  ST_PYR, COLOR0, P3, EC, EG, P7, N0, 
  ST_PYR, COLOR1, P4, P6, EF, EE, N0, 
  ST_PYR, COLOR1, EG, P6, P4, EH, N0, 
  ST_TET, COLOR1, P4, EE, EI, N0, 
  ST_TET, COLOR1, EH, P4, EI, N0, 
  ST_PYR, COLOR1, EF, P6, P2, EB, N0, 
  ST_PYR, COLOR1, P6, EG, EC, P2, N0, 
  ST_TET, COLOR1, EC, EB, P2, N0, 
 // Case #85: (cloned #60)
  ST_WDG, COLOR0, P7, EH, EG, P3, ED, EC, 
  ST_WDG, COLOR0, P5, EF, EE, P1, EB, EA, 
  ST_HEX, COLOR1, P0, P2, P6, P4, EA, EB, EF, EE, 
  ST_HEX, COLOR1, ED, EC, EG, EH, P0, P2, P6, P4, 
 // Case #86: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EC, EG, EA, EI, EH, 
  ST_TET, COLOR0, P5, EF, EJ, EE, 
  ST_PYR, COLOR0, P7, P3, EC, EG, N0, 
  ST_PYR, COLOR0, P3, P0, EA, EC, N0, 
  ST_TET, COLOR0, P0, EI, EA, N0, 
  ST_TET, COLOR0, P3, P7, P0, N0, 
  ST_PYR, COLOR0, P0, P7, EH, EI, N0, 
  ST_TET, COLOR0, P7, EG, EH, N0, 
  ST_WDG, COLOR1, EJ, EF, EE, P1, P6, P4, 
  ST_TET, COLOR1, P6, P1, P4, N0, 
  ST_PYR, COLOR1, P1, EA, EI, P4, N0, 
  ST_TET, COLOR1, P2, P1, P6, N0, 
  ST_PYR, COLOR1, EG, EC, P2, P6, N0, 
  ST_PYR, COLOR1, EC, EA, P1, P2, N0, 
  ST_PYR, COLOR1, P4, EH, EG, P6, N0, 
  ST_TET, COLOR1, EI, EH, P4, N0, 
 // Case #87: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P1, P4, P0, P2, EG, EC, 
  ST_WDG, COLOR0, EG, P7, EH, EC, P3, ED, 
  ST_TET, COLOR0, EJ, EE, P5, EF, 
  ST_WDG, COLOR1, EJ, EF, EE, P1, P6, P4, 
  ST_PYR, COLOR1, EC, P2, P6, EG, N0, 
  ST_TET, COLOR1, P2, P1, P6, N0, 
  ST_TET, COLOR1, P2, P0, P1, N0, 
  ST_PYR, COLOR1, ED, P0, P2, EC, N0, 
  ST_PYR, COLOR1, EH, P4, P0, ED, N0, 
  ST_TET, COLOR1, P0, P4, P1, N0, 
  ST_PYR, COLOR1, EG, EH, ED, EC, N0, 
  ST_TET, COLOR1, P4, P6, P1, N0, 
  ST_PYR, COLOR1, EG, P6, P4, EH, N0, 
 // Case #88: (cloned #26)
  ST_TET, COLOR0, P7, EG, EH, EK, 
  ST_TET, COLOR0, P2, P0, P1, P5, 
  ST_PYR, COLOR0, EE, P5, P0, EI, ED, 
  ST_PYR, COLOR0, EF, EL, P2, P5, EC, 
  ST_PYR, COLOR0, P0, P2, EC, ED, P5, 
  ST_PYR, COLOR0, ED, EC, EF, EE, P5, 
  ST_WDG, COLOR1, EH, EG, EK, P4, P6, P3, 
  ST_PYR, COLOR1, P4, EI, ED, P3, EE, 
  ST_PYR, COLOR1, EC, EL, P6, P3, EF, 
  ST_PYR, COLOR1, EE, P4, P6, EF, P3, 
  ST_PYR, COLOR1, EE, EF, EC, ED, P3, 
 // Case #89: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EA, EC, EE, EF, EL, 
  ST_TET, COLOR0, P7, EH, EK, EG, 
  ST_PYR, COLOR0, P2, EC, EA, P1, N0, 
  ST_PYR, COLOR0, P1, EA, EE, P5, N0, 
  ST_TET, COLOR0, P5, EE, EF, N0, 
  ST_TET, COLOR0, P1, P5, P2, N0, 
  ST_PYR, COLOR0, P5, EF, EL, P2, N0, 
  ST_TET, COLOR0, P2, EL, EC, N0, 
  ST_WDG, COLOR1, P4, P3, P6, EH, EK, EG, 
  ST_TET, COLOR1, P3, P6, P4, N0, 
  ST_PYR, COLOR1, P4, P6, EF, EE, N0, 
  ST_TET, COLOR1, P0, P3, P4, N0, 
  ST_PYR, COLOR1, EC, P3, P0, EA, N0, 
  ST_PYR, COLOR1, EA, P0, P4, EE, N0, 
  ST_PYR, COLOR1, P6, P3, EC, EL, N0, 
  ST_TET, COLOR1, EF, P6, EL, N0, 
 // Case #90: Unique case #17
  ST_TET, COLOR0, EH, EG, EK, P7, 
  ST_TET, COLOR0, EI, ED, EA, P0, 
  ST_TET, COLOR0, EE, EJ, EF, P5, 
  ST_TET, COLOR0, EB, EC, EL, P2, 
  ST_WDG, COLOR1, EB, EC, EL, P1, P3, P6, 
  ST_TET, COLOR1, P1, P6, P3, P4, 
  ST_WDG, COLOR1, P4, P6, P1, EE, EF, EJ, 
  ST_WDG, COLOR1, P3, P4, P1, ED, EI, EA, 
  ST_WDG, COLOR1, P6, P4, P3, EG, EH, EK, 
 // Case #91: Unique case #18
  ST_TET, COLOR0, EE, EJ, EF, P5, 
  ST_TET, COLOR0, EH, EK, P7, EG, 
  ST_TET, COLOR0, EB, P2, EC, EL, 
  ST_WDG, COLOR1, P6, P3, P1, EL, EC, EB, 
  ST_WDG, COLOR1, EH, EG, EK, P4, P6, P3, 
  ST_WDG, COLOR1, P4, P6, P1, EE, EF, EJ, 
  ST_TET, COLOR1, P6, P3, P1, P4, 
  ST_TET, COLOR1, P4, P1, P0, P3, 
 // Case #92: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EB, EF, ED, EI, EE, 
  ST_TET, COLOR0, P7, EK, EG, EH, 
  ST_PYR, COLOR0, P5, EF, EB, P1, N0, 
  ST_PYR, COLOR0, P1, EB, ED, P0, N0, 
  ST_TET, COLOR0, P0, ED, EI, N0, 
  ST_TET, COLOR0, P1, P0, P5, N0, 
  ST_PYR, COLOR0, P0, EI, EE, P5, N0, 
  ST_TET, COLOR0, P5, EE, EF, N0, 
  ST_WDG, COLOR1, P3, P6, P4, EK, EG, EH, 
  ST_TET, COLOR1, P6, P4, P3, N0, 
  ST_PYR, COLOR1, P3, P4, EI, ED, N0, 
  ST_TET, COLOR1, P2, P6, P3, N0, 
  ST_PYR, COLOR1, EF, P6, P2, EB, N0, 
  ST_PYR, COLOR1, EB, P2, P3, ED, N0, 
  ST_PYR, COLOR1, P4, P6, EF, EE, N0, 
  ST_TET, COLOR1, EI, P4, EE, N0, 
 // Case #93: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P3, P4, P0, P2, EF, EB, 
  ST_WDG, COLOR0, EB, P1, EA, EF, P5, EE, 
  ST_TET, COLOR0, EK, P7, EH, EG, 
  ST_WDG, COLOR1, P3, P6, P4, EK, EG, EH, 
  ST_PYR, COLOR1, EB, EF, P6, P2, N0, 
  ST_TET, COLOR1, P2, P6, P3, N0, 
  ST_TET, COLOR1, P2, P3, P0, N0, 
  ST_PYR, COLOR1, EA, EB, P2, P0, N0, 
  ST_PYR, COLOR1, EE, EA, P0, P4, N0, 
  ST_TET, COLOR1, P0, P3, P4, N0, 
  ST_PYR, COLOR1, EF, EB, EA, EE, N0, 
  ST_TET, COLOR1, P4, P3, P6, N0, 
  ST_PYR, COLOR1, EF, EE, P4, P6, N0, 
 // Case #94: (cloned #91)
  ST_TET, COLOR0, EK, EH, EG, P7, 
  ST_TET, COLOR0, ED, P0, EA, EI, 
  ST_TET, COLOR0, EF, EJ, P5, EE, 
  ST_WDG, COLOR1, EE, EJ, EF, P4, P1, P6, 
  ST_WDG, COLOR1, P3, P4, P1, ED, EI, EA, 
  ST_WDG, COLOR1, EK, EH, EG, P3, P4, P6, 
  ST_TET, COLOR1, P4, P6, P1, P3, 
  ST_TET, COLOR1, P3, P2, P6, P1, 
 // Case #95: Unique case #19
  ST_TET, COLOR0, EG, EK, EH, P7, 
  ST_TET, COLOR0, EF, EE, EJ, P5, 
  ST_WDG, COLOR1, P4, P6, P1, EE, EF, EJ, 
  ST_WDG, COLOR1, EH, EG, EK, P4, P6, P3, 
  ST_PYR, COLOR1, P0, P1, P2, P3, P4, 
  ST_TET, COLOR1, P6, P3, P2, P4, 
  ST_TET, COLOR1, P6, P2, P1, P4, 
 // Case #96: (cloned #3)
  ST_HEX, COLOR0, EL, P2, P1, EJ, EG, P7, P4, EE, 
  ST_WDG, COLOR0, P2, P3, P7, P1, P0, P4, 
  ST_WDG, COLOR1, P6, EL, EG, P5, EJ, EE, 
 // Case #97: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EG, EL, ED, ED, 
  ST_PYR, COLOR0, P3, ED, EA, P1, N0, 
  ST_TET, COLOR0, EA, EJ, P1, N0, 
  ST_PYR, COLOR0, P2, P1, EJ, EL, N0, 
  ST_TET, COLOR0, P3, P1, P2, N0, 
  ST_TET, COLOR0, P4, EE, EI, N0, 
  ST_TET, COLOR0, P7, P4, P3, N0, 
  ST_PYR, COLOR0, P4, EI, ED, P3, N0, 
  ST_TET, COLOR0, P7, P3, P2, N0, 
  ST_PYR, COLOR0, P7, P2, EL, EG, N0, 
  ST_PYR, COLOR0, P7, EG, EE, P4, N0, 
  ST_PYR, COLOR1, P0, P5, EJ, EA, N0, 
  ST_PYR, COLOR1, EE, P5, P0, EI, N0, 
  ST_TET, COLOR1, P0, EA, ED, N0, 
  ST_TET, COLOR1, EI, P0, ED, N0, 
  ST_PYR, COLOR1, EJ, P5, P6, EL, N0, 
  ST_PYR, COLOR1, P5, EE, EG, P6, N0, 
  ST_TET, COLOR1, EG, EL, P6, N0, 
 // Case #98: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EA, EE, EB, EL, EG, 
  ST_PYR, COLOR0, P0, P3, P7, P4, N0, 
  ST_TET, COLOR0, P7, P2, N0, P3, 
  ST_PYR, COLOR0, P4, P7, EG, EE, N0, 
  ST_PYR, COLOR0, EA, P0, P4, EE, N0, 
  ST_TET, COLOR0, P2, P3, P0, N0, 
  ST_PYR, COLOR0, P2, P0, EA, EB, N0, 
  ST_TET, COLOR0, P2, EB, EL, N0, 
  ST_PYR, COLOR0, EG, P7, P2, EL, N0, 
  ST_PYR, COLOR1, EE, EG, P6, P5, N0, 
  ST_PYR, COLOR1, EA, EE, P5, P1, N0, 
  ST_TET, COLOR1, EB, EA, P1, N0, 
  ST_TET, COLOR1, P1, P5, P6, N0, 
  ST_PYR, COLOR1, EB, P1, P6, EL, N0, 
  ST_TET, COLOR1, P6, EG, EL, N0, 
 // Case #99: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EB, EL, EG, EE, EI, ED, 
  ST_TET, COLOR0, P7, P4, P3, N0, 
  ST_PYR, COLOR0, P7, EG, EE, P4, N0, 
  ST_TET, COLOR0, P2, P7, P3, N0, 
  ST_PYR, COLOR0, P2, EL, EG, P7, N0, 
  ST_TET, COLOR0, EB, EL, P2, N0, 
  ST_PYR, COLOR0, P2, P3, ED, EB, N0, 
  ST_PYR, COLOR0, ED, P3, P4, EI, N0, 
  ST_TET, COLOR0, P4, EE, EI, N0, 
  ST_TET, COLOR1, P1, P5, P6, N0, 
  ST_PYR, COLOR1, EB, P1, P6, EL, N0, 
  ST_PYR, COLOR1, EB, ED, P0, P1, N0, 
  ST_TET, COLOR1, P0, P5, P1, N0, 
  ST_TET, COLOR1, P0, ED, EI, N0, 
  ST_PYR, COLOR1, P0, EI, EE, P5, N0, 
  ST_PYR, COLOR1, EE, EG, P6, P5, N0, 
  ST_TET, COLOR1, EG, EL, P6, N0, 
 // Case #100: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EC, EG, EB, EJ, EE, 
  ST_PYR, COLOR0, P3, P7, P4, P0, N0, 
  ST_TET, COLOR0, P4, N0, P1, P0, 
  ST_PYR, COLOR0, P7, EG, EE, P4, N0, 
  ST_PYR, COLOR0, EC, EG, P7, P3, N0, 
  ST_TET, COLOR0, P1, P3, P0, N0, 
  ST_PYR, COLOR0, P1, EB, EC, P3, N0, 
  ST_TET, COLOR0, P1, EJ, EB, N0, 
  ST_PYR, COLOR0, EE, EJ, P1, P4, N0, 
  ST_PYR, COLOR1, EG, P6, P5, EE, N0, 
  ST_PYR, COLOR1, EC, P2, P6, EG, N0, 
  ST_TET, COLOR1, EB, P2, EC, N0, 
  ST_TET, COLOR1, P2, P5, P6, N0, 
  ST_PYR, COLOR1, EB, EJ, P5, P2, N0, 
  ST_TET, COLOR1, P5, EJ, EE, N0, 
 // Case #101: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EG, EE, EC, ED, EI, 
  ST_TET, COLOR0, P1, EJ, EB, EA, 
  ST_PYR, COLOR0, P4, P7, EG, EE, N0, 
  ST_PYR, COLOR0, P7, P3, EC, EG, N0, 
  ST_TET, COLOR0, P3, ED, EC, N0, 
  ST_TET, COLOR0, P7, P4, P3, N0, 
  ST_PYR, COLOR0, P3, P4, EI, ED, N0, 
  ST_TET, COLOR0, P4, EE, EI, N0, 
  ST_WDG, COLOR1, EB, EJ, EA, P2, P5, P0, 
  ST_TET, COLOR1, P5, P2, P0, N0, 
  ST_PYR, COLOR1, P2, EC, ED, P0, N0, 
  ST_TET, COLOR1, P6, P2, P5, N0, 
  ST_PYR, COLOR1, EE, EG, P6, P5, N0, 
  ST_PYR, COLOR1, EG, EC, P2, P6, N0, 
  ST_PYR, COLOR1, P0, EI, EE, P5, N0, 
  ST_TET, COLOR1, ED, EI, P0, N0, 
 // Case #102: (cloned #15)
  ST_HEX, COLOR0, EA, EE, EG, EC, P0, P4, P7, P3, 
  ST_HEX, COLOR1, P1, P5, P6, P2, EA, EE, EG, EC, 
 // Case #103: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EE, EG, EC, EI, ED, 
  ST_PYR, COLOR0, P7, P3, EC, EG, N0, 
  ST_TET, COLOR0, P3, ED, EC, N0, 
  ST_PYR, COLOR0, P4, P7, EG, EE, N0, 
  ST_TET, COLOR0, EI, P4, EE, N0, 
  ST_PYR, COLOR0, ED, P3, P4, EI, N0, 
  ST_TET, COLOR0, P3, P7, P4, N0, 
  ST_PYR, COLOR1, P1, P5, P6, P2, N0, 
  ST_TET, COLOR1, P2, P0, P1, N0, 
  ST_TET, COLOR1, P0, P5, P1, N0, 
  ST_PYR, COLOR1, P0, EI, EE, P5, N0, 
  ST_PYR, COLOR1, EE, EG, P6, P5, N0, 
  ST_PYR, COLOR1, EG, EC, P2, P6, N0, 
  ST_PYR, COLOR1, EC, ED, P0, P2, N0, 
  ST_TET, COLOR1, EI, P0, ED, N0, 
 // Case #104: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EE, EJ, ED, ED, 
  ST_PYR, COLOR0, P0, P2, EC, ED, N0, 
  ST_TET, COLOR0, EC, P2, EL, N0, 
  ST_PYR, COLOR0, P1, EJ, EL, P2, N0, 
  ST_TET, COLOR0, P0, P1, P2, N0, 
  ST_TET, COLOR0, P7, EK, EG, N0, 
  ST_TET, COLOR0, P4, P0, P7, N0, 
  ST_PYR, COLOR0, P7, P0, ED, EK, N0, 
  ST_TET, COLOR0, P4, P1, P0, N0, 
  ST_PYR, COLOR0, P4, EE, EJ, P1, N0, 
  ST_PYR, COLOR0, P4, P7, EG, EE, N0, 
  ST_PYR, COLOR1, P3, EC, EL, P6, N0, 
  ST_PYR, COLOR1, EG, EK, P3, P6, N0, 
  ST_TET, COLOR1, P3, ED, EC, N0, 
  ST_TET, COLOR1, EK, ED, P3, N0, 
  ST_PYR, COLOR1, EL, EJ, P5, P6, N0, 
  ST_PYR, COLOR1, P6, P5, EE, EG, N0, 
  ST_TET, COLOR1, EE, P5, EJ, N0, 
 // Case #105: (cloned #60)
  ST_WDG, COLOR0, P4, EI, EE, P7, EK, EG, 
  ST_WDG, COLOR0, P1, EJ, EA, P2, EL, EC, 
  ST_HEX, COLOR1, EA, EJ, EL, EC, P0, P5, P6, P3, 
  ST_HEX, COLOR1, P0, P5, P6, P3, EI, EE, EG, EK, 
 // Case #106: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EE, EG, EA, ED, EK, 
  ST_TET, COLOR0, P2, EB, EL, EC, 
  ST_PYR, COLOR0, P7, EG, EE, P4, N0, 
  ST_PYR, COLOR0, P4, EE, EA, P0, N0, 
  ST_TET, COLOR0, P0, EA, ED, N0, 
  ST_TET, COLOR0, P4, P0, P7, N0, 
  ST_PYR, COLOR0, P0, ED, EK, P7, N0, 
  ST_TET, COLOR0, P7, EK, EG, N0, 
  ST_WDG, COLOR1, P1, P6, P3, EB, EL, EC, 
  ST_TET, COLOR1, P6, P3, P1, N0, 
  ST_PYR, COLOR1, P1, P3, ED, EA, N0, 
  ST_TET, COLOR1, P5, P6, P1, N0, 
  ST_PYR, COLOR1, EG, P6, P5, EE, N0, 
  ST_PYR, COLOR1, EE, P5, P1, EA, N0, 
  ST_PYR, COLOR1, P3, P6, EG, EK, N0, 
  ST_TET, COLOR1, ED, P3, EK, N0, 
 // Case #107: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P1, P3, P0, P5, EG, EE, 
  ST_WDG, COLOR0, EE, P4, EI, EG, P7, EK, 
  ST_TET, COLOR0, EB, P2, EC, EL, 
  ST_WDG, COLOR1, P1, P6, P3, EB, EL, EC, 
  ST_PYR, COLOR1, EE, EG, P6, P5, N0, 
  ST_TET, COLOR1, P5, P6, P1, N0, 
  ST_TET, COLOR1, P5, P1, P0, N0, 
  ST_PYR, COLOR1, EI, EE, P5, P0, N0, 
  ST_PYR, COLOR1, EK, EI, P0, P3, N0, 
  ST_TET, COLOR1, P0, P1, P3, N0, 
  ST_PYR, COLOR1, EG, EE, EI, EK, N0, 
  ST_TET, COLOR1, P3, P1, P6, N0, 
  ST_PYR, COLOR1, EG, EK, P3, P6, N0, 
 // Case #108: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EB, EJ, EE, EG, EK, ED, 
  ST_TET, COLOR0, P4, P0, P7, N0, 
  ST_PYR, COLOR0, P4, P7, EG, EE, N0, 
  ST_TET, COLOR0, P1, P0, P4, N0, 
  ST_PYR, COLOR0, P1, P4, EE, EJ, N0, 
  ST_TET, COLOR0, EB, P1, EJ, N0, 
  ST_PYR, COLOR0, P1, EB, ED, P0, N0, 
  ST_PYR, COLOR0, ED, EK, P7, P0, N0, 
  ST_TET, COLOR0, P7, EK, EG, N0, 
  ST_TET, COLOR1, P2, P5, P6, N0, 
  ST_PYR, COLOR1, EB, EJ, P5, P2, N0, 
  ST_PYR, COLOR1, EB, P2, P3, ED, N0, 
  ST_TET, COLOR1, P3, P2, P6, N0, 
  ST_TET, COLOR1, P3, EK, ED, N0, 
  ST_PYR, COLOR1, P3, P6, EG, EK, N0, 
  ST_PYR, COLOR1, EG, P6, P5, EE, N0, 
  ST_TET, COLOR1, EE, P5, EJ, N0, 
 // Case #109: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P2, P0, P3, P6, EE, EG, 
  ST_WDG, COLOR0, EE, P4, EI, EG, P7, EK, 
  ST_TET, COLOR0, EB, EA, P1, EJ, 
  ST_WDG, COLOR1, EB, EJ, EA, P2, P5, P0, 
  ST_PYR, COLOR1, EG, P6, P5, EE, N0, 
  ST_TET, COLOR1, P6, P2, P5, N0, 
  ST_TET, COLOR1, P6, P3, P2, N0, 
  ST_PYR, COLOR1, EK, P3, P6, EG, N0, 
  ST_PYR, COLOR1, EI, P0, P3, EK, N0, 
  ST_TET, COLOR1, P3, P0, P2, N0, 
  ST_PYR, COLOR1, EE, EI, EK, EG, N0, 
  ST_TET, COLOR1, P0, P5, P2, N0, 
  ST_PYR, COLOR1, EE, P5, P0, EI, N0, 
 // Case #110: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EG, EE, EA, EK, ED, 
  ST_PYR, COLOR0, P4, EE, EA, P0, N0, 
  ST_TET, COLOR0, P0, EA, ED, N0, 
  ST_PYR, COLOR0, P7, EG, EE, P4, N0, 
  ST_TET, COLOR0, EK, EG, P7, N0, 
  ST_PYR, COLOR0, ED, EK, P7, P0, N0, 
  ST_TET, COLOR0, P0, P7, P4, N0, 
  ST_PYR, COLOR1, P2, P1, P5, P6, N0, 
  ST_TET, COLOR1, P1, P2, P3, N0, 
  ST_TET, COLOR1, P3, P2, P6, N0, 
  ST_PYR, COLOR1, P3, P6, EG, EK, N0, 
  ST_PYR, COLOR1, EG, P6, P5, EE, N0, 
  ST_PYR, COLOR1, EE, P5, P1, EA, N0, 
  ST_PYR, COLOR1, EA, P1, P3, ED, N0, 
  ST_TET, COLOR1, EK, ED, P3, N0, 
 // Case #111: (cloned #63)
  ST_WDG, COLOR0, P4, EI, EE, P7, EK, EG, 
  ST_HEX, COLOR1, P0, P5, P6, P3, EI, EE, EG, EK, 
  ST_WDG, COLOR1, P2, P3, P6, P1, P0, P5, 
 // Case #112: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EI, EJ, EH, EG, EL, 
  ST_PYR, COLOR0, P0, P1, P2, P3, N0, 
  ST_TET, COLOR0, P2, N0, P7, P3, 
  ST_PYR, COLOR0, P1, EJ, EL, P2, N0, 
  ST_PYR, COLOR0, EI, EJ, P1, P0, N0, 
  ST_TET, COLOR0, P7, P0, P3, N0, 
  ST_PYR, COLOR0, P7, EH, EI, P0, N0, 
  ST_TET, COLOR0, P7, EG, EH, N0, 
  ST_PYR, COLOR0, EL, EG, P7, P2, N0, 
  ST_PYR, COLOR1, EJ, P5, P6, EL, N0, 
  ST_PYR, COLOR1, EI, P4, P5, EJ, N0, 
  ST_TET, COLOR1, EH, P4, EI, N0, 
  ST_TET, COLOR1, P4, P6, P5, N0, 
  ST_PYR, COLOR1, EH, EG, P6, P4, N0, 
  ST_TET, COLOR1, P6, EG, EL, N0, 
 // Case #113: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EH, EG, EL, EJ, EA, ED, 
  ST_TET, COLOR0, P2, P3, P1, N0, 
  ST_PYR, COLOR0, P2, P1, EJ, EL, N0, 
  ST_TET, COLOR0, P7, P3, P2, N0, 
  ST_PYR, COLOR0, P7, P2, EL, EG, N0, 
  ST_TET, COLOR0, EH, P7, EG, N0, 
  ST_PYR, COLOR0, P7, EH, ED, P3, N0, 
  ST_PYR, COLOR0, ED, EA, P1, P3, N0, 
  ST_TET, COLOR0, P1, EA, EJ, N0, 
  ST_TET, COLOR1, P4, P6, P5, N0, 
  ST_PYR, COLOR1, EH, EG, P6, P4, N0, 
  ST_PYR, COLOR1, EH, P4, P0, ED, N0, 
  ST_TET, COLOR1, P0, P4, P5, N0, 
  ST_TET, COLOR1, P0, EA, ED, N0, 
  ST_PYR, COLOR1, P0, P5, EJ, EA, N0, 
  ST_PYR, COLOR1, EJ, P5, P6, EL, N0, 
  ST_TET, COLOR1, EL, P6, EG, N0, 
 // Case #114: (cloned #27)
  ST_TET, COLOR0, P7, P0, P3, P2, 
  ST_PYR, COLOR0, EB, P2, P0, EA, EI, 
  ST_PYR, COLOR0, EL, EG, P7, P2, EH, 
  ST_PYR, COLOR0, P0, P7, EH, EI, P2, 
  ST_PYR, COLOR0, EI, EH, EL, EB, P2, 
  ST_TET, COLOR1, P5, P6, P1, P4, 
  ST_PYR, COLOR1, EI, P4, P1, EA, EB, 
  ST_PYR, COLOR1, EH, EG, P6, P4, EL, 
  ST_PYR, COLOR1, P1, P6, EL, EB, P4, 
  ST_PYR, COLOR1, EI, EB, EL, EH, P4, 
 // Case #115: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EH, ED, EB, EG, EL, 
  ST_PYR, COLOR0, P3, ED, EB, P2, N0, 
  ST_TET, COLOR0, P2, EB, EL, N0, 
  ST_PYR, COLOR0, P7, EH, ED, P3, N0, 
  ST_TET, COLOR0, EG, EH, P7, N0, 
  ST_PYR, COLOR0, EL, EG, P7, P2, N0, 
  ST_TET, COLOR0, P2, P7, P3, N0, 
  ST_PYR, COLOR1, P5, P1, P0, P4, N0, 
  ST_TET, COLOR1, P1, P5, P6, N0, 
  ST_TET, COLOR1, P6, P5, P4, N0, 
  ST_PYR, COLOR1, P6, P4, EH, EG, N0, 
  ST_PYR, COLOR1, EH, P4, P0, ED, N0, 
  ST_PYR, COLOR1, ED, P0, P1, EB, N0, 
  ST_PYR, COLOR1, EB, P1, P6, EL, N0, 
  ST_TET, COLOR1, EG, EL, P6, N0, 
 // Case #116: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EJ, EB, EC, EG, EH, EI, 
  ST_TET, COLOR0, P3, P7, P0, N0, 
  ST_PYR, COLOR0, P3, EC, EG, P7, N0, 
  ST_TET, COLOR0, P1, P3, P0, N0, 
  ST_PYR, COLOR0, P1, EB, EC, P3, N0, 
  ST_TET, COLOR0, EJ, EB, P1, N0, 
  ST_PYR, COLOR0, P1, P0, EI, EJ, N0, 
  ST_PYR, COLOR0, EI, P0, P7, EH, N0, 
  ST_TET, COLOR0, P7, EG, EH, N0, 
  ST_TET, COLOR1, P5, P6, P2, N0, 
  ST_PYR, COLOR1, EJ, P5, P2, EB, N0, 
  ST_PYR, COLOR1, EJ, EI, P4, P5, N0, 
  ST_TET, COLOR1, P4, P6, P5, N0, 
  ST_TET, COLOR1, P4, EI, EH, N0, 
  ST_PYR, COLOR1, P4, EH, EG, P6, N0, 
  ST_PYR, COLOR1, EG, EC, P2, P6, N0, 
  ST_TET, COLOR1, EC, EB, P2, N0, 
 // Case #117: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P5, P0, P4, P6, EC, EG, 
  ST_WDG, COLOR0, EG, P7, EH, EC, P3, ED, 
  ST_TET, COLOR0, EJ, P1, EA, EB, 
  ST_WDG, COLOR1, P5, P2, P0, EJ, EB, EA, 
  ST_PYR, COLOR1, EG, EC, P2, P6, N0, 
  ST_TET, COLOR1, P6, P2, P5, N0, 
  ST_TET, COLOR1, P6, P5, P4, N0, 
  ST_PYR, COLOR1, EH, EG, P6, P4, N0, 
  ST_PYR, COLOR1, ED, EH, P4, P0, N0, 
  ST_TET, COLOR1, P4, P5, P0, N0, 
  ST_PYR, COLOR1, EC, EG, EH, ED, N0, 
  ST_TET, COLOR1, P0, P5, P2, N0, 
  ST_PYR, COLOR1, EC, ED, P0, P2, N0, 
 // Case #118: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EG, EC, EA, EH, EI, 
  ST_PYR, COLOR0, P3, P0, EA, EC, N0, 
  ST_TET, COLOR0, P0, EI, EA, N0, 
  ST_PYR, COLOR0, P7, P3, EC, EG, N0, 
  ST_TET, COLOR0, EH, P7, EG, N0, 
  ST_PYR, COLOR0, EI, P0, P7, EH, N0, 
  ST_TET, COLOR0, P0, P3, P7, N0, 
  ST_PYR, COLOR1, P5, P6, P2, P1, N0, 
  ST_TET, COLOR1, P1, P4, P5, N0, 
  ST_TET, COLOR1, P4, P6, P5, N0, 
  ST_PYR, COLOR1, P4, EH, EG, P6, N0, 
  ST_PYR, COLOR1, EG, EC, P2, P6, N0, 
  ST_PYR, COLOR1, EC, EA, P1, P2, N0, 
  ST_PYR, COLOR1, EA, EI, P4, P1, N0, 
  ST_TET, COLOR1, EH, P4, EI, N0, 
 // Case #119: (cloned #63)
  ST_WDG, COLOR0, P7, EH, EG, P3, ED, EC, 
  ST_HEX, COLOR1, ED, EC, EG, EH, P0, P2, P6, P4, 
  ST_WDG, COLOR1, P1, P0, P2, P5, P4, P6, 
 // Case #120: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EJ, EL, EI, ED, EC, 
  ST_TET, COLOR0, P7, EG, EH, EK, 
  ST_PYR, COLOR0, P2, P1, EJ, EL, N0, 
  ST_PYR, COLOR0, P1, P0, EI, EJ, N0, 
  ST_TET, COLOR0, P0, ED, EI, N0, 
  ST_TET, COLOR0, P1, P2, P0, N0, 
  ST_PYR, COLOR0, P0, P2, EC, ED, N0, 
  ST_TET, COLOR0, P2, EL, EC, N0, 
  ST_WDG, COLOR1, EH, EG, EK, P4, P6, P3, 
  ST_TET, COLOR1, P6, P4, P3, N0, 
  ST_PYR, COLOR1, P4, EI, ED, P3, N0, 
  ST_TET, COLOR1, P5, P4, P6, N0, 
  ST_PYR, COLOR1, EL, EJ, P5, P6, N0, 
  ST_PYR, COLOR1, EJ, EI, P4, P5, N0, 
  ST_PYR, COLOR1, P3, EC, EL, P6, N0, 
  ST_TET, COLOR1, ED, EC, P3, N0, 
 // Case #121: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P4, P3, P0, P5, EL, EJ, 
  ST_WDG, COLOR0, EL, P2, EC, EJ, P1, EA, 
  ST_TET, COLOR0, EH, EK, P7, EG, 
  ST_WDG, COLOR1, EH, EG, EK, P4, P6, P3, 
  ST_PYR, COLOR1, EJ, P5, P6, EL, N0, 
  ST_TET, COLOR1, P5, P4, P6, N0, 
  ST_TET, COLOR1, P5, P0, P4, N0, 
  ST_PYR, COLOR1, EA, P0, P5, EJ, N0, 
  ST_PYR, COLOR1, EC, P3, P0, EA, N0, 
  ST_TET, COLOR1, P0, P3, P4, N0, 
  ST_PYR, COLOR1, EL, EC, EA, EJ, N0, 
  ST_TET, COLOR1, P3, P6, P4, N0, 
  ST_PYR, COLOR1, EL, P6, P3, EC, N0, 
 // Case #122: (cloned #91)
  ST_TET, COLOR0, EH, EG, EK, P7, 
  ST_TET, COLOR0, EI, EA, P0, ED, 
  ST_TET, COLOR0, EL, P2, EB, EC, 
  ST_WDG, COLOR1, P3, P1, P6, EC, EB, EL, 
  ST_WDG, COLOR1, EI, ED, EA, P4, P3, P1, 
  ST_WDG, COLOR1, P4, P3, P6, EH, EK, EG, 
  ST_TET, COLOR1, P3, P1, P6, P4, 
  ST_TET, COLOR1, P4, P6, P5, P1, 
 // Case #123: (cloned #95)
  ST_TET, COLOR0, EG, EK, EH, P7, 
  ST_TET, COLOR0, EL, EB, EC, P2, 
  ST_WDG, COLOR1, EC, EL, EB, P3, P6, P1, 
  ST_WDG, COLOR1, P3, P6, P4, EK, EG, EH, 
  ST_PYR, COLOR1, P0, P4, P5, P1, P3, 
  ST_TET, COLOR1, P6, P5, P4, P3, 
  ST_TET, COLOR1, P6, P1, P5, P3, 
 // Case #124: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P6, P4, P5, P2, ED, EB, 
  ST_WDG, COLOR0, ED, P0, EI, EB, P1, EJ, 
  ST_TET, COLOR0, EG, EH, P7, EK, 
  ST_WDG, COLOR1, EG, EK, EH, P6, P3, P4, 
  ST_PYR, COLOR1, EB, P2, P3, ED, N0, 
  ST_TET, COLOR1, P2, P6, P3, N0, 
  ST_TET, COLOR1, P2, P5, P6, N0, 
  ST_PYR, COLOR1, EJ, P5, P2, EB, N0, 
  ST_PYR, COLOR1, EI, P4, P5, EJ, N0, 
  ST_TET, COLOR1, P5, P4, P6, N0, 
  ST_PYR, COLOR1, ED, EI, EJ, EB, N0, 
  ST_TET, COLOR1, P4, P3, P6, N0, 
  ST_PYR, COLOR1, ED, P3, P4, EI, N0, 
 // Case #125: Unique case #20
  ST_TET, COLOR0, EG, EK, EH, P7, 
  ST_TET, COLOR0, EJ, EA, EB, P1, 
  ST_WDG, COLOR1, EH, EG, EK, P4, P6, P3, 
  ST_WDG, COLOR1, EJ, EA, EB, P5, P0, P2, 
  ST_TET, COLOR1, P2, P3, P0, P5, 
  ST_TET, COLOR1, P5, P4, P6, P3, 
  ST_TET, COLOR1, P4, P5, P0, P3, 
  ST_TET, COLOR1, P5, P6, P2, P3, 
 // Case #126: (cloned #95)
  ST_TET, COLOR0, EI, ED, EA, P0, 
  ST_TET, COLOR0, EH, EG, EK, P7, 
  ST_WDG, COLOR1, EK, EH, EG, P3, P4, P6, 
  ST_WDG, COLOR1, P3, P4, P1, ED, EI, EA, 
  ST_PYR, COLOR1, P2, P1, P5, P6, P3, 
  ST_TET, COLOR1, P4, P5, P1, P3, 
  ST_TET, COLOR1, P4, P6, P5, P3, 
 // Case #127: Unique case #21
  ST_PNT, 0, COLOR1, 7, P0, P1, P2, P3, P4, P5, P6, 
  ST_TET, COLOR0, EH, EG, EK, P7, 
  ST_WDG, COLOR1, EH, EG, EK, P4, P6, P3, 
  ST_TET, COLOR1, P4, P3, P6, N0, 
  ST_PYR, COLOR1, P5, P6, P2, P1, N0, 
  ST_TET, COLOR1, P6, P3, P2, N0, 
  ST_PYR, COLOR1, P0, P1, P2, P3, N0, 
  ST_TET, COLOR1, P0, P3, P4, N0, 
  ST_PYR, COLOR1, P0, P4, P5, P1, N0, 
  ST_TET, COLOR1, P4, P6, P5, N0, 
 // Case #128: (cloned #1)
  ST_PNT, 0, COLOR0, 7, P6, P5, P4, P3, P2, P1, P0, 
  ST_WDG, COLOR0, P6, P4, P3, EG, EH, EK, 
  ST_TET, COLOR0, P6, P4, P3, N0, 
  ST_TET, COLOR0, P6, P5, P4, N0, 
  ST_PYR, COLOR0, P1, P0, P4, P5, N0, 
  ST_PYR, COLOR0, P2, P1, P5, P6, N0, 
  ST_PYR, COLOR0, P3, P0, P1, P2, N0, 
  ST_TET, COLOR0, P4, P0, P3, N0, 
  ST_TET, COLOR0, P3, P2, P6, N0, 
  ST_TET, COLOR1, P7, EG, EH, EK, 
 // Case #129: (cloned #5)
  ST_PNT, 0, NOCOLOR, 2, EA, EG, 
  ST_PYR, COLOR0, P1, P5, P6, P2, N0, 
  ST_TET, COLOR0, P5, P4, P6, N0, 
  ST_TET, COLOR0, P1, P4, P5, N0, 
  ST_TET, COLOR0, P3, P1, P2, N0, 
  ST_TET, COLOR0, P6, P3, P2, N0, 
  ST_PYR, COLOR0, P6, EG, EK, P3, N0, 
  ST_PYR, COLOR0, P4, EH, EG, P6, N0, 
  ST_TET, COLOR0, P4, EI, EH, N0, 
  ST_PYR, COLOR0, P1, EA, EI, P4, N0, 
  ST_PYR, COLOR0, P1, P3, ED, EA, N0, 
  ST_TET, COLOR0, P3, EK, ED, N0, 
  ST_PYR, COLOR1, P0, ED, EK, P7, N0, 
  ST_PYR, COLOR1, EI, P0, P7, EH, N0, 
  ST_TET, COLOR1, EH, P7, EG, N0, 
  ST_TET, COLOR1, P7, EK, EG, N0, 
  ST_TET, COLOR1, EI, P0, N0, EA, 
  ST_TET, COLOR1, ED, P0, EA, N0, 
 // Case #130: (cloned #20)
  ST_WDG, COLOR0, P4, P3, P6, EH, EK, EG, 
  ST_WDG, COLOR0, EA, EB, EJ, P0, P2, P5, 
  ST_TET, COLOR0, P3, P6, P4, P2, 
  ST_TET, COLOR0, P5, P6, P2, P4, 
  ST_TET, COLOR0, P0, P4, P5, P2, 
  ST_TET, COLOR0, P3, P0, P2, P4, 
  ST_TET, COLOR1, P1, EA, EJ, EB, 
  ST_TET, COLOR1, P7, EH, EK, EG, 
 // Case #131: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EJ, EB, EG, EG, 
  ST_PYR, COLOR0, P6, EG, EK, P3, N0, 
  ST_TET, COLOR0, EK, ED, P3, N0, 
  ST_PYR, COLOR0, P2, P3, ED, EB, N0, 
  ST_TET, COLOR0, P6, P3, P2, N0, 
  ST_TET, COLOR0, P4, EI, EH, N0, 
  ST_TET, COLOR0, P5, P4, P6, N0, 
  ST_PYR, COLOR0, P4, EH, EG, P6, N0, 
  ST_TET, COLOR0, P5, P6, P2, N0, 
  ST_PYR, COLOR0, P5, P2, EB, EJ, N0, 
  ST_PYR, COLOR0, P5, EJ, EI, P4, N0, 
  ST_PYR, COLOR1, P7, P0, ED, EK, N0, 
  ST_PYR, COLOR1, EI, P0, P7, EH, N0, 
  ST_TET, COLOR1, P7, EK, EG, N0, 
  ST_TET, COLOR1, EH, P7, EG, N0, 
  ST_PYR, COLOR1, ED, P0, P1, EB, N0, 
  ST_PYR, COLOR1, P0, EI, EJ, P1, N0, 
  ST_TET, COLOR1, EJ, EB, P1, N0, 
 // Case #132: (cloned #5)
  ST_PNT, 0, NOCOLOR, 2, EH, EB, 
  ST_PYR, COLOR0, P4, P5, P1, P0, N0, 
  ST_TET, COLOR0, P5, P6, P1, N0, 
  ST_TET, COLOR0, P4, P6, P5, N0, 
  ST_TET, COLOR0, P3, P4, P0, N0, 
  ST_TET, COLOR0, P1, P3, P0, N0, 
  ST_PYR, COLOR0, P1, EB, EC, P3, N0, 
  ST_PYR, COLOR0, P6, EL, EB, P1, N0, 
  ST_TET, COLOR0, P6, EG, EL, N0, 
  ST_PYR, COLOR0, P4, EH, EG, P6, N0, 
  ST_PYR, COLOR0, P4, P3, EK, EH, N0, 
  ST_TET, COLOR0, P3, EC, EK, N0, 
  ST_PYR, COLOR1, P7, EK, EC, P2, N0, 
  ST_PYR, COLOR1, EG, P7, P2, EL, N0, 
  ST_TET, COLOR1, EL, P2, EB, N0, 
  ST_TET, COLOR1, P2, EC, EB, N0, 
  ST_TET, COLOR1, EG, P7, N0, EH, 
  ST_TET, COLOR1, EK, P7, EH, N0, 
 // Case #133: (cloned #26)
  ST_TET, COLOR0, P3, ED, EC, EK, 
  ST_TET, COLOR0, P6, P5, P4, P1, 
  ST_PYR, COLOR0, EA, EI, P4, P1, EH, 
  ST_PYR, COLOR0, EB, P1, P6, EL, EG, 
  ST_PYR, COLOR0, P4, EH, EG, P6, P1, 
  ST_PYR, COLOR0, EH, EA, EB, EG, P1, 
  ST_WDG, COLOR1, P0, P2, P7, ED, EC, EK, 
  ST_PYR, COLOR1, P0, P7, EH, EI, EA, 
  ST_PYR, COLOR1, EG, P7, P2, EL, EB, 
  ST_PYR, COLOR1, EA, EB, P2, P0, P7, 
  ST_PYR, COLOR1, EA, EH, EG, EB, P7, 
 // Case #134: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EJ, EA, EH, EH, 
  ST_PYR, COLOR0, P4, P3, EK, EH, N0, 
  ST_TET, COLOR0, EK, P3, EC, N0, 
  ST_PYR, COLOR0, P0, EA, EC, P3, N0, 
  ST_TET, COLOR0, P4, P0, P3, N0, 
  ST_TET, COLOR0, P6, EG, EL, N0, 
  ST_TET, COLOR0, P5, P4, P6, N0, 
  ST_PYR, COLOR0, P6, P4, EH, EG, N0, 
  ST_TET, COLOR0, P5, P0, P4, N0, 
  ST_PYR, COLOR0, P5, EJ, EA, P0, N0, 
  ST_PYR, COLOR0, P5, P6, EL, EJ, N0, 
  ST_PYR, COLOR1, P7, EK, EC, P2, N0, 
  ST_PYR, COLOR1, EL, EG, P7, P2, N0, 
  ST_TET, COLOR1, P7, EH, EK, N0, 
  ST_TET, COLOR1, EG, EH, P7, N0, 
  ST_PYR, COLOR1, EC, EA, P1, P2, N0, 
  ST_PYR, COLOR1, P2, P1, EJ, EL, N0, 
  ST_TET, COLOR1, EJ, P1, EA, N0, 
 // Case #135: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EJ, EL, EI, EH, EG, 
  ST_TET, COLOR0, P3, ED, EC, EK, 
  ST_PYR, COLOR0, P6, EL, EJ, P5, N0, 
  ST_PYR, COLOR0, P5, EJ, EI, P4, N0, 
  ST_TET, COLOR0, P4, EI, EH, N0, 
  ST_TET, COLOR0, P5, P4, P6, N0, 
  ST_PYR, COLOR0, P4, EH, EG, P6, N0, 
  ST_TET, COLOR0, P6, EG, EL, N0, 
  ST_WDG, COLOR1, P0, P2, P7, ED, EC, EK, 
  ST_TET, COLOR1, P2, P7, P0, N0, 
  ST_PYR, COLOR1, P0, P7, EH, EI, N0, 
  ST_TET, COLOR1, P1, P2, P0, N0, 
  ST_PYR, COLOR1, EL, P2, P1, EJ, N0, 
  ST_PYR, COLOR1, EJ, P1, P0, EI, N0, 
  ST_PYR, COLOR1, P7, P2, EL, EG, N0, 
  ST_TET, COLOR1, EH, P7, EG, N0, 
 // Case #136: (cloned #3)
  ST_HEX, COLOR0, EH, P4, P0, ED, EG, P6, P2, EC, 
  ST_WDG, COLOR0, P4, P5, P6, P0, P1, P2, 
  ST_WDG, COLOR1, P7, EH, EG, P3, ED, EC, 
 // Case #137: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EA, EC, EI, EH, EG, 
  ST_PYR, COLOR0, P1, P5, P6, P2, N0, 
  ST_TET, COLOR0, P6, P4, N0, P5, 
  ST_PYR, COLOR0, P2, P6, EG, EC, N0, 
  ST_PYR, COLOR0, EA, P1, P2, EC, N0, 
  ST_TET, COLOR0, P4, P5, P1, N0, 
  ST_PYR, COLOR0, P4, P1, EA, EI, N0, 
  ST_TET, COLOR0, P4, EI, EH, N0, 
  ST_PYR, COLOR0, EG, P6, P4, EH, N0, 
  ST_PYR, COLOR1, EC, EG, P7, P3, N0, 
  ST_PYR, COLOR1, EA, EC, P3, P0, N0, 
  ST_TET, COLOR1, EI, EA, P0, N0, 
  ST_TET, COLOR1, P0, P3, P7, N0, 
  ST_PYR, COLOR1, EI, P0, P7, EH, N0, 
  ST_TET, COLOR1, P7, EG, EH, N0, 
 // Case #138: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EG, EH, EJ, EJ, 
  ST_PYR, COLOR0, P5, EJ, EA, P0, N0, 
  ST_TET, COLOR0, EA, ED, P0, N0, 
  ST_PYR, COLOR0, P4, P0, ED, EH, N0, 
  ST_TET, COLOR0, P5, P0, P4, N0, 
  ST_TET, COLOR0, P2, EC, EB, N0, 
  ST_TET, COLOR0, P6, P2, P5, N0, 
  ST_PYR, COLOR0, P2, EB, EJ, P5, N0, 
  ST_TET, COLOR0, P6, P5, P4, N0, 
  ST_PYR, COLOR0, P6, P4, EH, EG, N0, 
  ST_PYR, COLOR0, P6, EG, EC, P2, N0, 
  ST_PYR, COLOR1, P1, P3, ED, EA, N0, 
  ST_PYR, COLOR1, EC, P3, P1, EB, N0, 
  ST_TET, COLOR1, P1, EA, EJ, N0, 
  ST_TET, COLOR1, EB, P1, EJ, N0, 
  ST_PYR, COLOR1, ED, P3, P7, EH, N0, 
  ST_PYR, COLOR1, P3, EC, EG, P7, N0, 
  ST_TET, COLOR1, EG, EH, P7, N0, 
 // Case #139: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EI, EH, EG, EC, EB, EJ, 
  ST_TET, COLOR0, P6, P2, P5, N0, 
  ST_PYR, COLOR0, P6, EG, EC, P2, N0, 
  ST_TET, COLOR0, P4, P6, P5, N0, 
  ST_PYR, COLOR0, P4, EH, EG, P6, N0, 
  ST_TET, COLOR0, EI, EH, P4, N0, 
  ST_PYR, COLOR0, P4, P5, EJ, EI, N0, 
  ST_PYR, COLOR0, EJ, P5, P2, EB, N0, 
  ST_TET, COLOR0, P2, EC, EB, N0, 
  ST_TET, COLOR1, P0, P3, P7, N0, 
  ST_PYR, COLOR1, EI, P0, P7, EH, N0, 
  ST_PYR, COLOR1, EI, EJ, P1, P0, N0, 
  ST_TET, COLOR1, P1, P3, P0, N0, 
  ST_TET, COLOR1, P1, EJ, EB, N0, 
  ST_PYR, COLOR1, P1, EB, EC, P3, N0, 
  ST_PYR, COLOR1, EC, EG, P7, P3, N0, 
  ST_TET, COLOR1, EG, EH, P7, N0, 
 // Case #140: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EB, ED, EL, EG, EH, 
  ST_PYR, COLOR0, P1, P0, P4, P5, N0, 
  ST_TET, COLOR0, P4, N0, P6, P5, 
  ST_PYR, COLOR0, P0, ED, EH, P4, N0, 
  ST_PYR, COLOR0, EB, ED, P0, P1, N0, 
  ST_TET, COLOR0, P6, P1, P5, N0, 
  ST_PYR, COLOR0, P6, EL, EB, P1, N0, 
  ST_TET, COLOR0, P6, EG, EL, N0, 
  ST_PYR, COLOR0, EH, EG, P6, P4, N0, 
  ST_PYR, COLOR1, ED, P3, P7, EH, N0, 
  ST_PYR, COLOR1, EB, P2, P3, ED, N0, 
  ST_TET, COLOR1, EL, P2, EB, N0, 
  ST_TET, COLOR1, P2, P7, P3, N0, 
  ST_PYR, COLOR1, EL, EG, P7, P2, N0, 
  ST_TET, COLOR1, P7, EG, EH, N0, 
 // Case #141: (cloned #27)
  ST_TET, COLOR0, P6, P5, P4, P1, 
  ST_PYR, COLOR0, EA, EI, P4, P1, EH, 
  ST_PYR, COLOR0, EB, P1, P6, EL, EG, 
  ST_PYR, COLOR0, P4, EH, EG, P6, P1, 
  ST_PYR, COLOR0, EH, EA, EB, EG, P1, 
  ST_TET, COLOR1, P3, P0, P2, P7, 
  ST_PYR, COLOR1, EH, EI, P0, P7, EA, 
  ST_PYR, COLOR1, EG, P7, P2, EL, EB, 
  ST_PYR, COLOR1, P0, EA, EB, P2, P7, 
  ST_PYR, COLOR1, EH, EG, EB, EA, P7, 
 // Case #142: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, ED, EA, EJ, EL, EG, EH, 
  ST_TET, COLOR0, P5, P4, P6, N0, 
  ST_PYR, COLOR0, P5, P6, EL, EJ, N0, 
  ST_TET, COLOR0, P0, P4, P5, N0, 
  ST_PYR, COLOR0, P0, P5, EJ, EA, N0, 
  ST_TET, COLOR0, ED, P0, EA, N0, 
  ST_PYR, COLOR0, P0, ED, EH, P4, N0, 
  ST_PYR, COLOR0, EH, EG, P6, P4, N0, 
  ST_TET, COLOR0, P6, EG, EL, N0, 
  ST_TET, COLOR1, P3, P1, P2, N0, 
  ST_PYR, COLOR1, ED, EA, P1, P3, N0, 
  ST_PYR, COLOR1, ED, P3, P7, EH, N0, 
  ST_TET, COLOR1, P7, P3, P2, N0, 
  ST_TET, COLOR1, P7, EG, EH, N0, 
  ST_PYR, COLOR1, P7, P2, EL, EG, N0, 
  ST_PYR, COLOR1, EL, P2, P1, EJ, N0, 
  ST_TET, COLOR1, EJ, P1, EA, N0, 
 // Case #143: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EL, EJ, EI, EG, EH, 
  ST_PYR, COLOR0, P5, EJ, EI, P4, N0, 
  ST_TET, COLOR0, P4, EI, EH, N0, 
  ST_PYR, COLOR0, P6, EL, EJ, P5, N0, 
  ST_TET, COLOR0, EG, EL, P6, N0, 
  ST_PYR, COLOR0, EH, EG, P6, P4, N0, 
  ST_TET, COLOR0, P4, P6, P5, N0, 
  ST_PYR, COLOR1, P3, P0, P1, P2, N0, 
  ST_TET, COLOR1, P0, P3, P7, N0, 
  ST_TET, COLOR1, P7, P3, P2, N0, 
  ST_PYR, COLOR1, P7, P2, EL, EG, N0, 
  ST_PYR, COLOR1, EL, P2, P1, EJ, N0, 
  ST_PYR, COLOR1, EJ, P1, P0, EI, N0, 
  ST_PYR, COLOR1, EI, P0, P7, EH, N0, 
  ST_TET, COLOR1, EG, EH, P7, N0, 
 // Case #144: (cloned #3)
  ST_HEX, COLOR0, EG, P6, P5, EE, EK, P3, P0, EI, 
  ST_WDG, COLOR0, P0, P1, P5, P3, P2, P6, 
  ST_WDG, COLOR1, P4, EI, EE, P7, EK, EG, 
 // Case #145: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EA, EE, ED, EK, EG, 
  ST_PYR, COLOR0, P1, P5, P6, P2, N0, 
  ST_TET, COLOR0, P6, N0, P3, P2, 
  ST_PYR, COLOR0, P5, EE, EG, P6, N0, 
  ST_PYR, COLOR0, EA, EE, P5, P1, N0, 
  ST_TET, COLOR0, P3, P1, P2, N0, 
  ST_PYR, COLOR0, P3, ED, EA, P1, N0, 
  ST_TET, COLOR0, P3, EK, ED, N0, 
  ST_PYR, COLOR0, EG, EK, P3, P6, N0, 
  ST_PYR, COLOR1, EE, P4, P7, EG, N0, 
  ST_PYR, COLOR1, EA, P0, P4, EE, N0, 
  ST_TET, COLOR1, ED, P0, EA, N0, 
  ST_TET, COLOR1, P0, P7, P4, N0, 
  ST_PYR, COLOR1, ED, EK, P7, P0, N0, 
  ST_TET, COLOR1, P7, EK, EG, N0, 
 // Case #146: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EG, EK, EB, EB, 
  ST_PYR, COLOR0, P2, P0, EA, EB, N0, 
  ST_TET, COLOR0, EA, P0, EI, N0, 
  ST_PYR, COLOR0, P3, EK, EI, P0, N0, 
  ST_TET, COLOR0, P2, P3, P0, N0, 
  ST_TET, COLOR0, P5, EJ, EE, N0, 
  ST_TET, COLOR0, P6, P2, P5, N0, 
  ST_PYR, COLOR0, P5, P2, EB, EJ, N0, 
  ST_TET, COLOR0, P6, P3, P2, N0, 
  ST_PYR, COLOR0, P6, EG, EK, P3, N0, 
  ST_PYR, COLOR0, P6, P5, EE, EG, N0, 
  ST_PYR, COLOR1, P1, EA, EI, P4, N0, 
  ST_PYR, COLOR1, EE, EJ, P1, P4, N0, 
  ST_TET, COLOR1, P1, EB, EA, N0, 
  ST_TET, COLOR1, EJ, EB, P1, N0, 
  ST_PYR, COLOR1, EI, EK, P7, P4, N0, 
  ST_PYR, COLOR1, P4, P7, EG, EE, N0, 
  ST_TET, COLOR1, EG, P7, EK, N0, 
 // Case #147: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, ED, EK, EG, EE, EJ, EB, 
  ST_TET, COLOR0, P6, P2, P5, N0, 
  ST_PYR, COLOR0, P6, P5, EE, EG, N0, 
  ST_TET, COLOR0, P3, P2, P6, N0, 
  ST_PYR, COLOR0, P3, P6, EG, EK, N0, 
  ST_TET, COLOR0, ED, P3, EK, N0, 
  ST_PYR, COLOR0, P3, ED, EB, P2, N0, 
  ST_PYR, COLOR0, EB, EJ, P5, P2, N0, 
  ST_TET, COLOR0, P5, EJ, EE, N0, 
  ST_TET, COLOR1, P0, P7, P4, N0, 
  ST_PYR, COLOR1, ED, EK, P7, P0, N0, 
  ST_PYR, COLOR1, ED, P0, P1, EB, N0, 
  ST_TET, COLOR1, P1, P0, P4, N0, 
  ST_TET, COLOR1, P1, EJ, EB, N0, 
  ST_PYR, COLOR1, P1, P4, EE, EJ, N0, 
  ST_PYR, COLOR1, EE, P4, P7, EG, N0, 
  ST_TET, COLOR1, EG, P7, EK, N0, 
 // Case #148: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EE, EI, EB, EB, 
  ST_PYR, COLOR0, P1, EB, EC, P3, N0, 
  ST_TET, COLOR0, EC, EK, P3, N0, 
  ST_PYR, COLOR0, P0, P3, EK, EI, N0, 
  ST_TET, COLOR0, P1, P3, P0, N0, 
  ST_TET, COLOR0, P6, EG, EL, N0, 
  ST_TET, COLOR0, P5, P6, P1, N0, 
  ST_PYR, COLOR0, P6, EL, EB, P1, N0, 
  ST_TET, COLOR0, P5, P1, P0, N0, 
  ST_PYR, COLOR0, P5, P0, EI, EE, N0, 
  ST_PYR, COLOR0, P5, EE, EG, P6, N0, 
  ST_PYR, COLOR1, P2, P7, EK, EC, N0, 
  ST_PYR, COLOR1, EG, P7, P2, EL, N0, 
  ST_TET, COLOR1, P2, EC, EB, N0, 
  ST_TET, COLOR1, EL, P2, EB, N0, 
  ST_PYR, COLOR1, EK, P7, P4, EI, N0, 
  ST_PYR, COLOR1, P7, EG, EE, P4, N0, 
  ST_TET, COLOR1, EE, EI, P4, N0, 
 // Case #149: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EE, EG, EA, EB, EL, 
  ST_TET, COLOR0, P3, EK, ED, EC, 
  ST_PYR, COLOR0, P6, P5, EE, EG, N0, 
  ST_PYR, COLOR0, P5, P1, EA, EE, N0, 
  ST_TET, COLOR0, P1, EB, EA, N0, 
  ST_TET, COLOR0, P5, P6, P1, N0, 
  ST_PYR, COLOR0, P1, P6, EL, EB, N0, 
  ST_TET, COLOR0, P6, EG, EL, N0, 
  ST_WDG, COLOR1, ED, EK, EC, P0, P7, P2, 
  ST_TET, COLOR1, P7, P0, P2, N0, 
  ST_PYR, COLOR1, P0, EA, EB, P2, N0, 
  ST_TET, COLOR1, P4, P0, P7, N0, 
  ST_PYR, COLOR1, EG, EE, P4, P7, N0, 
  ST_PYR, COLOR1, EE, EA, P0, P4, N0, 
  ST_PYR, COLOR1, P2, EL, EG, P7, N0, 
  ST_TET, COLOR1, EB, EL, P2, N0, 
 // Case #150: (cloned #60)
  ST_WDG, COLOR0, P3, EK, EC, P0, EI, EA, 
  ST_WDG, COLOR0, P6, EL, EG, P5, EJ, EE, 
  ST_HEX, COLOR1, P4, P1, P2, P7, EE, EJ, EL, EG, 
  ST_HEX, COLOR1, EI, EA, EC, EK, P4, P1, P2, P7, 
 // Case #151: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P0, P7, P4, P1, EL, EJ, 
  ST_WDG, COLOR0, EJ, P5, EE, EL, P6, EG, 
  ST_TET, COLOR0, ED, P3, EK, EC, 
  ST_WDG, COLOR1, P0, P2, P7, ED, EC, EK, 
  ST_PYR, COLOR1, EJ, EL, P2, P1, N0, 
  ST_TET, COLOR1, P1, P2, P0, N0, 
  ST_TET, COLOR1, P1, P0, P4, N0, 
  ST_PYR, COLOR1, EE, EJ, P1, P4, N0, 
  ST_PYR, COLOR1, EG, EE, P4, P7, N0, 
  ST_TET, COLOR1, P4, P0, P7, N0, 
  ST_PYR, COLOR1, EL, EJ, EE, EG, N0, 
  ST_TET, COLOR1, P7, P0, P2, N0, 
  ST_PYR, COLOR1, EL, EG, P7, P2, N0, 
 // Case #152: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EC, EG, ED, EI, EE, 
  ST_PYR, COLOR0, P2, P1, P5, P6, N0, 
  ST_TET, COLOR0, P5, P0, N0, P1, 
  ST_PYR, COLOR0, P6, P5, EE, EG, N0, 
  ST_PYR, COLOR0, EC, P2, P6, EG, N0, 
  ST_TET, COLOR0, P0, P1, P2, N0, 
  ST_PYR, COLOR0, P0, P2, EC, ED, N0, 
  ST_TET, COLOR0, P0, ED, EI, N0, 
  ST_PYR, COLOR0, EE, P5, P0, EI, N0, 
  ST_PYR, COLOR1, EG, EE, P4, P7, N0, 
  ST_PYR, COLOR1, EC, EG, P7, P3, N0, 
  ST_TET, COLOR1, ED, EC, P3, N0, 
  ST_TET, COLOR1, P3, P7, P4, N0, 
  ST_PYR, COLOR1, ED, P3, P4, EI, N0, 
  ST_TET, COLOR1, P4, EE, EI, N0, 
 // Case #153: (cloned #15)
  ST_HEX, COLOR0, P1, P5, P6, P2, EA, EE, EG, EC, 
  ST_HEX, COLOR1, EA, EE, EG, EC, P0, P4, P7, P3, 
 // Case #154: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EG, EE, EC, EB, EJ, 
  ST_TET, COLOR0, P0, ED, EI, EA, 
  ST_PYR, COLOR0, P5, EE, EG, P6, N0, 
  ST_PYR, COLOR0, P6, EG, EC, P2, N0, 
  ST_TET, COLOR0, P2, EC, EB, N0, 
  ST_TET, COLOR0, P6, P2, P5, N0, 
  ST_PYR, COLOR0, P2, EB, EJ, P5, N0, 
  ST_TET, COLOR0, P5, EJ, EE, N0, 
  ST_WDG, COLOR1, P3, P4, P1, ED, EI, EA, 
  ST_TET, COLOR1, P4, P1, P3, N0, 
  ST_PYR, COLOR1, P3, P1, EB, EC, N0, 
  ST_TET, COLOR1, P7, P4, P3, N0, 
  ST_PYR, COLOR1, EE, P4, P7, EG, N0, 
  ST_PYR, COLOR1, EG, P7, P3, EC, N0, 
  ST_PYR, COLOR1, P1, P4, EE, EJ, N0, 
  ST_TET, COLOR1, EB, P1, EJ, N0, 
 // Case #155: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EE, EG, EC, EJ, EB, 
  ST_PYR, COLOR0, P6, EG, EC, P2, N0, 
  ST_TET, COLOR0, P2, EC, EB, N0, 
  ST_PYR, COLOR0, P5, EE, EG, P6, N0, 
  ST_TET, COLOR0, EJ, EE, P5, N0, 
  ST_PYR, COLOR0, EB, EJ, P5, P2, N0, 
  ST_TET, COLOR0, P2, P5, P6, N0, 
  ST_PYR, COLOR1, P0, P3, P7, P4, N0, 
  ST_TET, COLOR1, P3, P0, P1, N0, 
  ST_TET, COLOR1, P1, P0, P4, N0, 
  ST_PYR, COLOR1, P1, P4, EE, EJ, N0, 
  ST_PYR, COLOR1, EE, P4, P7, EG, N0, 
  ST_PYR, COLOR1, EG, P7, P3, EC, N0, 
  ST_PYR, COLOR1, EC, P3, P1, EB, N0, 
  ST_TET, COLOR1, EJ, EB, P1, N0, 
 // Case #156: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, ED, EI, EE, EG, EL, EB, 
  ST_TET, COLOR0, P5, P6, P1, N0, 
  ST_PYR, COLOR0, P5, EE, EG, P6, N0, 
  ST_TET, COLOR0, P0, P5, P1, N0, 
  ST_PYR, COLOR0, P0, EI, EE, P5, N0, 
  ST_TET, COLOR0, ED, EI, P0, N0, 
  ST_PYR, COLOR0, P0, P1, EB, ED, N0, 
  ST_PYR, COLOR0, EB, P1, P6, EL, N0, 
  ST_TET, COLOR0, P6, EG, EL, N0, 
  ST_TET, COLOR1, P3, P7, P4, N0, 
  ST_PYR, COLOR1, ED, P3, P4, EI, N0, 
  ST_PYR, COLOR1, ED, EB, P2, P3, N0, 
  ST_TET, COLOR1, P2, P7, P3, N0, 
  ST_TET, COLOR1, P2, EB, EL, N0, 
  ST_PYR, COLOR1, P2, EL, EG, P7, N0, 
  ST_PYR, COLOR1, EG, EE, P4, P7, N0, 
  ST_TET, COLOR1, EE, EI, P4, N0, 
 // Case #157: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EG, EE, EA, EL, EB, 
  ST_PYR, COLOR0, P5, P1, EA, EE, N0, 
  ST_TET, COLOR0, P1, EB, EA, N0, 
  ST_PYR, COLOR0, P6, P5, EE, EG, N0, 
  ST_TET, COLOR0, EL, P6, EG, N0, 
  ST_PYR, COLOR0, EB, P1, P6, EL, N0, 
  ST_TET, COLOR0, P1, P5, P6, N0, 
  ST_PYR, COLOR1, P3, P7, P4, P0, N0, 
  ST_TET, COLOR1, P0, P2, P3, N0, 
  ST_TET, COLOR1, P2, P7, P3, N0, 
  ST_PYR, COLOR1, P2, EL, EG, P7, N0, 
  ST_PYR, COLOR1, EG, EE, P4, P7, N0, 
  ST_PYR, COLOR1, EE, EA, P0, P4, N0, 
  ST_PYR, COLOR1, EA, EB, P2, P0, N0, 
  ST_TET, COLOR1, EL, P2, EB, N0, 
 // Case #158: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P3, P4, P7, P2, EJ, EL, 
  ST_WDG, COLOR0, EJ, P5, EE, EL, P6, EG, 
  ST_TET, COLOR0, ED, EI, P0, EA, 
  ST_WDG, COLOR1, ED, EA, EI, P3, P1, P4, 
  ST_PYR, COLOR1, EL, P2, P1, EJ, N0, 
  ST_TET, COLOR1, P2, P3, P1, N0, 
  ST_TET, COLOR1, P2, P7, P3, N0, 
  ST_PYR, COLOR1, EG, P7, P2, EL, N0, 
  ST_PYR, COLOR1, EE, P4, P7, EG, N0, 
  ST_TET, COLOR1, P7, P4, P3, N0, 
  ST_PYR, COLOR1, EJ, EE, EG, EL, N0, 
  ST_TET, COLOR1, P4, P1, P3, N0, 
  ST_PYR, COLOR1, EJ, P1, P4, EE, N0, 
 // Case #159: (cloned #63)
  ST_WDG, COLOR0, P5, EE, EJ, P6, EG, EL, 
  ST_HEX, COLOR1, P4, P1, P2, P7, EE, EJ, EL, EG, 
  ST_WDG, COLOR1, P3, P7, P2, P0, P4, P1, 
 // Case #160: (cloned #5)
  ST_PNT, 0, NOCOLOR, 2, EK, EJ, 
  ST_PYR, COLOR0, P3, P0, P1, P2, N0, 
  ST_TET, COLOR0, P2, P1, P6, N0, 
  ST_TET, COLOR0, P3, P2, P6, N0, 
  ST_TET, COLOR0, P4, P0, P3, N0, 
  ST_TET, COLOR0, P1, P0, P4, N0, 
  ST_PYR, COLOR0, P1, P4, EE, EJ, N0, 
  ST_PYR, COLOR0, P6, P1, EJ, EF, N0, 
  ST_TET, COLOR0, P6, EF, EG, N0, 
  ST_PYR, COLOR0, P3, P6, EG, EK, N0, 
  ST_PYR, COLOR0, P3, EK, EH, P4, N0, 
  ST_TET, COLOR0, P4, EH, EE, N0, 
  ST_PYR, COLOR1, P7, P5, EE, EH, N0, 
  ST_PYR, COLOR1, EG, EF, P5, P7, N0, 
  ST_TET, COLOR1, EF, EJ, P5, N0, 
  ST_TET, COLOR1, P5, EJ, EE, N0, 
  ST_TET, COLOR1, EG, N0, P7, EK, 
  ST_TET, COLOR1, EH, EK, P7, N0, 
 // Case #161: (cloned #26)
  ST_TET, COLOR0, P4, EE, EI, EH, 
  ST_TET, COLOR0, P6, P3, P2, P1, 
  ST_PYR, COLOR0, EA, P1, P3, ED, EK, 
  ST_PYR, COLOR0, EJ, EF, P6, P1, EG, 
  ST_PYR, COLOR0, P3, P6, EG, EK, P1, 
  ST_PYR, COLOR0, EK, EG, EJ, EA, P1, 
  ST_WDG, COLOR1, EI, EE, EH, P0, P5, P7, 
  ST_PYR, COLOR1, P0, ED, EK, P7, EA, 
  ST_PYR, COLOR1, EG, EF, P5, P7, EJ, 
  ST_PYR, COLOR1, EA, P0, P5, EJ, P7, 
  ST_PYR, COLOR1, EA, EJ, EG, EK, P7, 
 // Case #162: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EB, EA, EK, EK, 
  ST_PYR, COLOR0, P3, EK, EH, P4, N0, 
  ST_TET, COLOR0, EH, EE, P4, N0, 
  ST_PYR, COLOR0, P0, P4, EE, EA, N0, 
  ST_TET, COLOR0, P3, P4, P0, N0, 
  ST_TET, COLOR0, P6, EF, EG, N0, 
  ST_TET, COLOR0, P2, P6, P3, N0, 
  ST_PYR, COLOR0, P6, EG, EK, P3, N0, 
  ST_TET, COLOR0, P2, P3, P0, N0, 
  ST_PYR, COLOR0, P2, P0, EA, EB, N0, 
  ST_PYR, COLOR0, P2, EB, EF, P6, N0, 
  ST_PYR, COLOR1, P7, P5, EE, EH, N0, 
  ST_PYR, COLOR1, EF, P5, P7, EG, N0, 
  ST_TET, COLOR1, P7, EH, EK, N0, 
  ST_TET, COLOR1, EG, P7, EK, N0, 
  ST_PYR, COLOR1, EE, P5, P1, EA, N0, 
  ST_PYR, COLOR1, P5, EF, EB, P1, N0, 
  ST_TET, COLOR1, EB, EA, P1, N0, 
 // Case #163: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EB, EF, ED, EK, EG, 
  ST_TET, COLOR0, P4, EE, EI, EH, 
  ST_PYR, COLOR0, P6, P2, EB, EF, N0, 
  ST_PYR, COLOR0, P2, P3, ED, EB, N0, 
  ST_TET, COLOR0, P3, EK, ED, N0, 
  ST_TET, COLOR0, P2, P6, P3, N0, 
  ST_PYR, COLOR0, P3, P6, EG, EK, N0, 
  ST_TET, COLOR0, P6, EF, EG, N0, 
  ST_WDG, COLOR1, EI, EE, EH, P0, P5, P7, 
  ST_TET, COLOR1, P5, P0, P7, N0, 
  ST_PYR, COLOR1, P0, ED, EK, P7, N0, 
  ST_TET, COLOR1, P1, P0, P5, N0, 
  ST_PYR, COLOR1, EF, EB, P1, P5, N0, 
  ST_PYR, COLOR1, EB, ED, P0, P1, N0, 
  ST_PYR, COLOR1, P7, EG, EF, P5, N0, 
  ST_TET, COLOR1, EK, EG, P7, N0, 
 // Case #164: (cloned #26)
  ST_TET, COLOR0, P6, EF, EG, EL, 
  ST_TET, COLOR0, P3, P0, P1, P4, 
  ST_PYR, COLOR0, EE, EJ, P1, P4, EB, 
  ST_PYR, COLOR0, EH, P4, P3, EK, EC, 
  ST_PYR, COLOR0, P1, EB, EC, P3, P4, 
  ST_PYR, COLOR0, EB, EE, EH, EC, P4, 
  ST_WDG, COLOR1, P5, P7, P2, EF, EG, EL, 
  ST_PYR, COLOR1, P5, P2, EB, EJ, EE, 
  ST_PYR, COLOR1, EC, P2, P7, EK, EH, 
  ST_PYR, COLOR1, EE, EH, P7, P5, P2, 
  ST_PYR, COLOR1, EE, EB, EC, EH, P2, 
 // Case #165: (cloned #90)
  ST_TET, COLOR0, EH, EI, EE, P4, 
  ST_TET, COLOR0, EK, EC, ED, P3, 
  ST_TET, COLOR0, EG, EF, EL, P6, 
  ST_TET, COLOR0, EB, EJ, EA, P1, 
  ST_WDG, COLOR1, P2, P0, P5, EB, EA, EJ, 
  ST_TET, COLOR1, P2, P0, P5, P7, 
  ST_WDG, COLOR1, EG, EF, EL, P7, P5, P2, 
  ST_WDG, COLOR1, ED, EK, EC, P0, P7, P2, 
  ST_WDG, COLOR1, EE, EH, EI, P5, P7, P0, 
 // Case #166: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EA, EC, EE, EH, EK, 
  ST_TET, COLOR0, P6, EL, EF, EG, 
  ST_PYR, COLOR0, P3, P0, EA, EC, N0, 
  ST_PYR, COLOR0, P0, P4, EE, EA, N0, 
  ST_TET, COLOR0, P4, EH, EE, N0, 
  ST_TET, COLOR0, P0, P3, P4, N0, 
  ST_PYR, COLOR0, P4, P3, EK, EH, N0, 
  ST_TET, COLOR0, P3, EC, EK, N0, 
  ST_WDG, COLOR1, EF, EL, EG, P5, P2, P7, 
  ST_TET, COLOR1, P2, P5, P7, N0, 
  ST_PYR, COLOR1, P5, EE, EH, P7, N0, 
  ST_TET, COLOR1, P1, P5, P2, N0, 
  ST_PYR, COLOR1, EC, EA, P1, P2, N0, 
  ST_PYR, COLOR1, EA, EE, P5, P1, N0, 
  ST_PYR, COLOR1, P7, EK, EC, P2, N0, 
  ST_TET, COLOR1, EH, EK, P7, N0, 
 // Case #167: (cloned #91)
  ST_TET, COLOR0, EL, EG, EF, P6, 
  ST_TET, COLOR0, EC, P3, ED, EK, 
  ST_TET, COLOR0, EE, EI, P4, EH, 
  ST_WDG, COLOR1, EH, EI, EE, P7, P0, P5, 
  ST_WDG, COLOR1, P2, P7, P0, EC, EK, ED, 
  ST_WDG, COLOR1, EL, EG, EF, P2, P7, P5, 
  ST_TET, COLOR1, P7, P5, P0, P2, 
  ST_TET, COLOR1, P2, P1, P5, P0, 
 // Case #168: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EC, ED, EJ, EJ, 
  ST_PYR, COLOR0, P1, P4, EE, EJ, N0, 
  ST_TET, COLOR0, EE, P4, EH, N0, 
  ST_PYR, COLOR0, P0, ED, EH, P4, N0, 
  ST_TET, COLOR0, P1, P0, P4, N0, 
  ST_TET, COLOR0, P6, EF, EG, N0, 
  ST_TET, COLOR0, P2, P1, P6, N0, 
  ST_PYR, COLOR0, P6, P1, EJ, EF, N0, 
  ST_TET, COLOR0, P2, P0, P1, N0, 
  ST_PYR, COLOR0, P2, EC, ED, P0, N0, 
  ST_PYR, COLOR0, P2, P6, EG, EC, N0, 
  ST_PYR, COLOR1, P5, EE, EH, P7, N0, 
  ST_PYR, COLOR1, EG, EF, P5, P7, N0, 
  ST_TET, COLOR1, P5, EJ, EE, N0, 
  ST_TET, COLOR1, EF, EJ, P5, N0, 
  ST_PYR, COLOR1, EH, ED, P3, P7, N0, 
  ST_PYR, COLOR1, P7, P3, EC, EG, N0, 
  ST_TET, COLOR1, EC, P3, ED, N0, 
 // Case #169: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EC, EG, EA, EJ, EF, 
  ST_TET, COLOR0, P4, EI, EH, EE, 
  ST_PYR, COLOR0, P6, EG, EC, P2, N0, 
  ST_PYR, COLOR0, P2, EC, EA, P1, N0, 
  ST_TET, COLOR0, P1, EA, EJ, N0, 
  ST_TET, COLOR0, P2, P1, P6, N0, 
  ST_PYR, COLOR0, P1, EJ, EF, P6, N0, 
  ST_TET, COLOR0, P6, EF, EG, N0, 
  ST_WDG, COLOR1, P0, P7, P5, EI, EH, EE, 
  ST_TET, COLOR1, P7, P5, P0, N0, 
  ST_PYR, COLOR1, P0, P5, EJ, EA, N0, 
  ST_TET, COLOR1, P3, P7, P0, N0, 
  ST_PYR, COLOR1, EG, P7, P3, EC, N0, 
  ST_PYR, COLOR1, EC, P3, P0, EA, N0, 
  ST_PYR, COLOR1, P5, P7, EG, EF, N0, 
  ST_TET, COLOR1, EJ, P5, EF, N0, 
 // Case #170: (cloned #60)
  ST_WDG, COLOR0, P0, ED, EA, P4, EH, EE, 
  ST_WDG, COLOR0, P2, EB, EC, P6, EF, EG, 
  ST_HEX, COLOR1, EC, EB, EF, EG, P3, P1, P5, P7, 
  ST_HEX, COLOR1, P3, P1, P5, P7, ED, EA, EE, EH, 
 // Case #171: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P0, P7, P3, P1, EF, EB, 
  ST_WDG, COLOR0, EF, P6, EG, EB, P2, EC, 
  ST_TET, COLOR0, EI, EH, P4, EE, 
  ST_WDG, COLOR1, EI, EE, EH, P0, P5, P7, 
  ST_PYR, COLOR1, EB, P1, P5, EF, N0, 
  ST_TET, COLOR1, P1, P0, P5, N0, 
  ST_TET, COLOR1, P1, P3, P0, N0, 
  ST_PYR, COLOR1, EC, P3, P1, EB, N0, 
  ST_PYR, COLOR1, EG, P7, P3, EC, N0, 
  ST_TET, COLOR1, P3, P7, P0, N0, 
  ST_PYR, COLOR1, EF, EG, EC, EB, N0, 
  ST_TET, COLOR1, P7, P5, P0, N0, 
  ST_PYR, COLOR1, EF, P5, P7, EG, N0, 
 // Case #172: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, ED, EH, EB, EJ, EE, 
  ST_TET, COLOR0, P6, EG, EL, EF, 
  ST_PYR, COLOR0, P4, P0, ED, EH, N0, 
  ST_PYR, COLOR0, P0, P1, EB, ED, N0, 
  ST_TET, COLOR0, P1, EJ, EB, N0, 
  ST_TET, COLOR0, P0, P4, P1, N0, 
  ST_PYR, COLOR0, P1, P4, EE, EJ, N0, 
  ST_TET, COLOR0, P4, EH, EE, N0, 
  ST_WDG, COLOR1, EL, EG, EF, P2, P7, P5, 
  ST_TET, COLOR1, P7, P2, P5, N0, 
  ST_PYR, COLOR1, P2, EB, EJ, P5, N0, 
  ST_TET, COLOR1, P3, P2, P7, N0, 
  ST_PYR, COLOR1, EH, ED, P3, P7, N0, 
  ST_PYR, COLOR1, ED, EB, P2, P3, N0, 
  ST_PYR, COLOR1, P5, EE, EH, P7, N0, 
  ST_TET, COLOR1, EJ, EE, P5, N0, 
 // Case #173: (cloned #91)
  ST_TET, COLOR0, EG, EF, EL, P6, 
  ST_TET, COLOR0, EH, P4, EI, EE, 
  ST_TET, COLOR0, EB, EA, P1, EJ, 
  ST_WDG, COLOR1, EJ, EA, EB, P5, P0, P2, 
  ST_WDG, COLOR1, P7, P5, P0, EH, EE, EI, 
  ST_WDG, COLOR1, EG, EF, EL, P7, P5, P2, 
  ST_TET, COLOR1, P5, P2, P0, P7, 
  ST_TET, COLOR1, P7, P3, P2, P0, 
 // Case #174: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P2, P5, P1, P3, EH, ED, 
  ST_WDG, COLOR0, EH, P4, EE, ED, P0, EA, 
  ST_TET, COLOR0, EL, EF, P6, EG, 
  ST_WDG, COLOR1, EL, EG, EF, P2, P7, P5, 
  ST_PYR, COLOR1, ED, P3, P7, EH, N0, 
  ST_TET, COLOR1, P3, P2, P7, N0, 
  ST_TET, COLOR1, P3, P1, P2, N0, 
  ST_PYR, COLOR1, EA, P1, P3, ED, N0, 
  ST_PYR, COLOR1, EE, P5, P1, EA, N0, 
  ST_TET, COLOR1, P1, P5, P2, N0, 
  ST_PYR, COLOR1, EH, EE, EA, ED, N0, 
  ST_TET, COLOR1, P5, P7, P2, N0, 
  ST_PYR, COLOR1, EH, P7, P5, EE, N0, 
 // Case #175: (cloned #95)
  ST_TET, COLOR0, EE, EH, EI, P4, 
  ST_TET, COLOR0, EF, EL, EG, P6, 
  ST_WDG, COLOR1, EG, EF, EL, P7, P5, P2, 
  ST_WDG, COLOR1, P7, P5, P0, EH, EE, EI, 
  ST_PYR, COLOR1, P3, P0, P1, P2, P7, 
  ST_TET, COLOR1, P5, P1, P0, P7, 
  ST_TET, COLOR1, P5, P2, P1, P7, 
 // Case #176: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EJ, EI, EF, EG, EK, 
  ST_PYR, COLOR0, P1, P2, P3, P0, N0, 
  ST_TET, COLOR0, P3, P6, N0, P2, 
  ST_PYR, COLOR0, P0, P3, EK, EI, N0, 
  ST_PYR, COLOR0, EJ, P1, P0, EI, N0, 
  ST_TET, COLOR0, P6, P2, P1, N0, 
  ST_PYR, COLOR0, P6, P1, EJ, EF, N0, 
  ST_TET, COLOR0, P6, EF, EG, N0, 
  ST_PYR, COLOR0, EK, P3, P6, EG, N0, 
  ST_PYR, COLOR1, EI, EK, P7, P4, N0, 
  ST_PYR, COLOR1, EJ, EI, P4, P5, N0, 
  ST_TET, COLOR1, EF, EJ, P5, N0, 
  ST_TET, COLOR1, P5, P4, P7, N0, 
  ST_PYR, COLOR1, EF, P5, P7, EG, N0, 
  ST_TET, COLOR1, P7, EK, EG, N0, 
 // Case #177: (cloned #27)
  ST_TET, COLOR0, P6, P3, P2, P1, 
  ST_PYR, COLOR0, EA, P1, P3, ED, EK, 
  ST_PYR, COLOR0, EJ, EF, P6, P1, EG, 
  ST_PYR, COLOR0, P3, P6, EG, EK, P1, 
  ST_PYR, COLOR0, EK, EG, EJ, EA, P1, 
  ST_TET, COLOR1, P4, P5, P0, P7, 
  ST_PYR, COLOR1, EK, P7, P0, ED, EA, 
  ST_PYR, COLOR1, EG, EF, P5, P7, EJ, 
  ST_PYR, COLOR1, P0, P5, EJ, EA, P7, 
  ST_PYR, COLOR1, EK, EA, EJ, EG, P7, 
 // Case #178: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EI, EA, EB, EF, EG, EK, 
  ST_TET, COLOR0, P2, P6, P3, N0, 
  ST_PYR, COLOR0, P2, EB, EF, P6, N0, 
  ST_TET, COLOR0, P0, P2, P3, N0, 
  ST_PYR, COLOR0, P0, EA, EB, P2, N0, 
  ST_TET, COLOR0, EI, EA, P0, N0, 
  ST_PYR, COLOR0, P0, P3, EK, EI, N0, 
  ST_PYR, COLOR0, EK, P3, P6, EG, N0, 
  ST_TET, COLOR0, P6, EF, EG, N0, 
  ST_TET, COLOR1, P4, P5, P1, N0, 
  ST_PYR, COLOR1, EI, P4, P1, EA, N0, 
  ST_PYR, COLOR1, EI, EK, P7, P4, N0, 
  ST_TET, COLOR1, P7, P5, P4, N0, 
  ST_TET, COLOR1, P7, EK, EG, N0, 
  ST_PYR, COLOR1, P7, EG, EF, P5, N0, 
  ST_PYR, COLOR1, EF, EB, P1, P5, N0, 
  ST_TET, COLOR1, EB, EA, P1, N0, 
 // Case #179: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EF, EB, ED, EG, EK, 
  ST_PYR, COLOR0, P2, P3, ED, EB, N0, 
  ST_TET, COLOR0, P3, EK, ED, N0, 
  ST_PYR, COLOR0, P6, P2, EB, EF, N0, 
  ST_TET, COLOR0, EG, P6, EF, N0, 
  ST_PYR, COLOR0, EK, P3, P6, EG, N0, 
  ST_TET, COLOR0, P3, P2, P6, N0, 
  ST_PYR, COLOR1, P4, P5, P1, P0, N0, 
  ST_TET, COLOR1, P0, P7, P4, N0, 
  ST_TET, COLOR1, P7, P5, P4, N0, 
  ST_PYR, COLOR1, P7, EG, EF, P5, N0, 
  ST_PYR, COLOR1, EF, EB, P1, P5, N0, 
  ST_PYR, COLOR1, EB, ED, P0, P1, N0, 
  ST_PYR, COLOR1, ED, EK, P7, P0, N0, 
  ST_TET, COLOR1, EG, P7, EK, N0, 
 // Case #180: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EI, EK, EJ, EB, EC, 
  ST_TET, COLOR0, P6, EF, EG, EL, 
  ST_PYR, COLOR0, P3, EK, EI, P0, N0, 
  ST_PYR, COLOR0, P0, EI, EJ, P1, N0, 
  ST_TET, COLOR0, P1, EJ, EB, N0, 
  ST_TET, COLOR0, P0, P1, P3, N0, 
  ST_PYR, COLOR0, P1, EB, EC, P3, N0, 
  ST_TET, COLOR0, P3, EC, EK, N0, 
  ST_WDG, COLOR1, P5, P7, P2, EF, EG, EL, 
  ST_TET, COLOR1, P7, P2, P5, N0, 
  ST_PYR, COLOR1, P5, P2, EB, EJ, N0, 
  ST_TET, COLOR1, P4, P7, P5, N0, 
  ST_PYR, COLOR1, EK, P7, P4, EI, N0, 
  ST_PYR, COLOR1, EI, P4, P5, EJ, N0, 
  ST_PYR, COLOR1, P2, P7, EK, EC, N0, 
  ST_TET, COLOR1, EB, P2, EC, N0, 
 // Case #181: (cloned #91)
  ST_TET, COLOR0, EG, EF, EL, P6, 
  ST_TET, COLOR0, EK, ED, P3, EC, 
  ST_TET, COLOR0, EJ, P1, EA, EB, 
  ST_WDG, COLOR1, P2, P0, P5, EB, EA, EJ, 
  ST_WDG, COLOR1, EK, EC, ED, P7, P2, P0, 
  ST_WDG, COLOR1, P7, P2, P5, EG, EL, EF, 
  ST_TET, COLOR1, P2, P0, P5, P7, 
  ST_TET, COLOR1, P7, P5, P4, P0, 
 // Case #182: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P5, P2, P1, P4, EK, EI, 
  ST_WDG, COLOR0, EI, P0, EA, EK, P3, EC, 
  ST_TET, COLOR0, EF, P6, EL, EG, 
  ST_WDG, COLOR1, P5, P7, P2, EF, EG, EL, 
  ST_PYR, COLOR1, EI, EK, P7, P4, N0, 
  ST_TET, COLOR1, P4, P7, P5, N0, 
  ST_TET, COLOR1, P4, P5, P1, N0, 
  ST_PYR, COLOR1, EA, EI, P4, P1, N0, 
  ST_PYR, COLOR1, EC, EA, P1, P2, N0, 
  ST_TET, COLOR1, P1, P5, P2, N0, 
  ST_PYR, COLOR1, EK, EI, EA, EC, N0, 
  ST_TET, COLOR1, P2, P5, P7, N0, 
  ST_PYR, COLOR1, EK, EC, P2, P7, N0, 
 // Case #183: (cloned #95)
  ST_TET, COLOR0, EC, ED, EK, P3, 
  ST_TET, COLOR0, EL, EG, EF, P6, 
  ST_WDG, COLOR1, P7, P2, P5, EG, EL, EF, 
  ST_WDG, COLOR1, EK, EC, ED, P7, P2, P0, 
  ST_PYR, COLOR1, P4, P5, P1, P0, P7, 
  ST_TET, COLOR1, P2, P0, P1, P7, 
  ST_TET, COLOR1, P2, P1, P5, P7, 
 // Case #184: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EI, ED, EC, EG, EF, EJ, 
  ST_TET, COLOR0, P2, P1, P6, N0, 
  ST_PYR, COLOR0, P2, P6, EG, EC, N0, 
  ST_TET, COLOR0, P0, P1, P2, N0, 
  ST_PYR, COLOR0, P0, P2, EC, ED, N0, 
  ST_TET, COLOR0, EI, P0, ED, N0, 
  ST_PYR, COLOR0, P0, EI, EJ, P1, N0, 
  ST_PYR, COLOR0, EJ, EF, P6, P1, N0, 
  ST_TET, COLOR0, P6, EF, EG, N0, 
  ST_TET, COLOR1, P4, P3, P7, N0, 
  ST_PYR, COLOR1, EI, ED, P3, P4, N0, 
  ST_PYR, COLOR1, EI, P4, P5, EJ, N0, 
  ST_TET, COLOR1, P5, P4, P7, N0, 
  ST_TET, COLOR1, P5, EF, EJ, N0, 
  ST_PYR, COLOR1, P5, P7, EG, EF, N0, 
  ST_PYR, COLOR1, EG, P7, P3, EC, N0, 
  ST_TET, COLOR1, EC, P3, ED, N0, 
 // Case #185: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EG, EC, EA, EF, EJ, 
  ST_PYR, COLOR0, P2, EC, EA, P1, N0, 
  ST_TET, COLOR0, P1, EA, EJ, N0, 
  ST_PYR, COLOR0, P6, EG, EC, P2, N0, 
  ST_TET, COLOR0, EF, EG, P6, N0, 
  ST_PYR, COLOR0, EJ, EF, P6, P1, N0, 
  ST_TET, COLOR0, P1, P6, P2, N0, 
  ST_PYR, COLOR1, P4, P0, P3, P7, N0, 
  ST_TET, COLOR1, P0, P4, P5, N0, 
  ST_TET, COLOR1, P5, P4, P7, N0, 
  ST_PYR, COLOR1, P5, P7, EG, EF, N0, 
  ST_PYR, COLOR1, EG, P7, P3, EC, N0, 
  ST_PYR, COLOR1, EC, P3, P0, EA, N0, 
  ST_PYR, COLOR1, EA, P0, P5, EJ, N0, 
  ST_TET, COLOR1, EF, EJ, P5, N0, 
 // Case #186: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P4, P3, P7, P5, EB, EF, 
  ST_WDG, COLOR0, EF, P6, EG, EB, P2, EC, 
  ST_TET, COLOR0, EI, P0, ED, EA, 
  ST_WDG, COLOR1, P4, P1, P3, EI, EA, ED, 
  ST_PYR, COLOR1, EF, EB, P1, P5, N0, 
  ST_TET, COLOR1, P5, P1, P4, N0, 
  ST_TET, COLOR1, P5, P4, P7, N0, 
  ST_PYR, COLOR1, EG, EF, P5, P7, N0, 
  ST_PYR, COLOR1, EC, EG, P7, P3, N0, 
  ST_TET, COLOR1, P7, P4, P3, N0, 
  ST_PYR, COLOR1, EB, EF, EG, EC, N0, 
  ST_TET, COLOR1, P3, P4, P1, N0, 
  ST_PYR, COLOR1, EB, EC, P3, P1, N0, 
 // Case #187: (cloned #63)
  ST_WDG, COLOR0, P6, EG, EF, P2, EC, EB, 
  ST_HEX, COLOR1, EC, EB, EF, EG, P3, P1, P5, P7, 
  ST_WDG, COLOR1, P0, P3, P1, P4, P7, P5, 
 // Case #188: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P7, P5, P4, P3, EB, ED, 
  ST_WDG, COLOR0, ED, P0, EI, EB, P1, EJ, 
  ST_TET, COLOR0, EG, P6, EF, EL, 
  ST_WDG, COLOR1, P7, P2, P5, EG, EL, EF, 
  ST_PYR, COLOR1, ED, EB, P2, P3, N0, 
  ST_TET, COLOR1, P3, P2, P7, N0, 
  ST_TET, COLOR1, P3, P7, P4, N0, 
  ST_PYR, COLOR1, EI, ED, P3, P4, N0, 
  ST_PYR, COLOR1, EJ, EI, P4, P5, N0, 
  ST_TET, COLOR1, P4, P7, P5, N0, 
  ST_PYR, COLOR1, EB, ED, EI, EJ, N0, 
  ST_TET, COLOR1, P5, P7, P2, N0, 
  ST_PYR, COLOR1, EB, EJ, P5, P2, N0, 
 // Case #189: (cloned #95)
  ST_TET, COLOR0, EJ, EA, EB, P1, 
  ST_TET, COLOR0, EF, EL, EG, P6, 
  ST_WDG, COLOR1, P2, P5, P7, EL, EF, EG, 
  ST_WDG, COLOR1, EB, EJ, EA, P2, P5, P0, 
  ST_PYR, COLOR1, P3, P7, P4, P0, P2, 
  ST_TET, COLOR1, P5, P0, P4, P2, 
  ST_TET, COLOR1, P5, P4, P7, P2, 
 // Case #190: (cloned #125)
  ST_TET, COLOR0, EA, EI, ED, P0, 
  ST_TET, COLOR0, EL, EG, EF, P6, 
  ST_WDG, COLOR1, ED, EA, EI, P3, P1, P4, 
  ST_WDG, COLOR1, EL, EG, EF, P2, P7, P5, 
  ST_TET, COLOR1, P5, P4, P7, P2, 
  ST_TET, COLOR1, P2, P3, P1, P4, 
  ST_TET, COLOR1, P3, P2, P7, P4, 
  ST_TET, COLOR1, P2, P1, P5, P4, 
 // Case #191: (cloned #127)
  ST_PNT, 0, COLOR1, 7, P1, P0, P3, P2, P5, P4, P7, 
  ST_TET, COLOR0, EF, EL, EG, P6, 
  ST_WDG, COLOR1, P5, P7, P2, EF, EG, EL, 
  ST_TET, COLOR1, P5, P7, P2, N0, 
  ST_PYR, COLOR1, P4, P0, P3, P7, N0, 
  ST_TET, COLOR1, P7, P3, P2, N0, 
  ST_PYR, COLOR1, P1, P2, P3, P0, N0, 
  ST_TET, COLOR1, P1, P5, P2, N0, 
  ST_PYR, COLOR1, P1, P0, P4, P5, N0, 
  ST_TET, COLOR1, P5, P4, P7, N0, 
 // Case #192: (cloned #3)
  ST_HEX, COLOR0, EF, P5, P4, EH, EL, P2, P3, EK, 
  ST_WDG, COLOR0, P5, P1, P2, P4, P0, P3, 
  ST_WDG, COLOR1, P6, EF, EL, P7, EH, EK, 
 // Case #193: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EL, EF, EA, EA, 
  ST_PYR, COLOR0, P1, EA, EI, P4, N0, 
  ST_TET, COLOR0, EI, EH, P4, N0, 
  ST_PYR, COLOR0, P5, P4, EH, EF, N0, 
  ST_TET, COLOR0, P1, P4, P5, N0, 
  ST_TET, COLOR0, P3, EK, ED, N0, 
  ST_TET, COLOR0, P2, P3, P1, N0, 
  ST_PYR, COLOR0, P3, ED, EA, P1, N0, 
  ST_TET, COLOR0, P2, P1, P5, N0, 
  ST_PYR, COLOR0, P2, P5, EF, EL, N0, 
  ST_PYR, COLOR0, P2, EL, EK, P3, N0, 
  ST_PYR, COLOR1, P0, P7, EH, EI, N0, 
  ST_PYR, COLOR1, EK, P7, P0, ED, N0, 
  ST_TET, COLOR1, P0, EI, EA, N0, 
  ST_TET, COLOR1, ED, P0, EA, N0, 
  ST_PYR, COLOR1, EH, P7, P6, EF, N0, 
  ST_PYR, COLOR1, P7, EK, EL, P6, N0, 
  ST_TET, COLOR1, EL, EF, P6, N0, 
 // Case #194: (cloned #21)
  ST_PNT, 0, NOCOLOR, 4, EK, EH, EA, EA, 
  ST_PYR, COLOR0, P0, P5, EJ, EA, N0, 
  ST_TET, COLOR0, EJ, P5, EF, N0, 
  ST_PYR, COLOR0, P4, EH, EF, P5, N0, 
  ST_TET, COLOR0, P0, P4, P5, N0, 
  ST_TET, COLOR0, P2, EB, EL, N0, 
  ST_TET, COLOR0, P3, P0, P2, N0, 
  ST_PYR, COLOR0, P2, P0, EA, EB, N0, 
  ST_TET, COLOR0, P3, P4, P0, N0, 
  ST_PYR, COLOR0, P3, EK, EH, P4, N0, 
  ST_PYR, COLOR0, P3, P2, EL, EK, N0, 
  ST_PYR, COLOR1, P1, EJ, EF, P6, N0, 
  ST_PYR, COLOR1, EL, EB, P1, P6, N0, 
  ST_TET, COLOR1, P1, EA, EJ, N0, 
  ST_TET, COLOR1, EB, EA, P1, N0, 
  ST_PYR, COLOR1, EF, EH, P7, P6, N0, 
  ST_PYR, COLOR1, P6, P7, EK, EL, N0, 
  ST_TET, COLOR1, EK, P7, EH, N0, 
 // Case #195: (cloned #60)
  ST_WDG, COLOR0, P3, ED, EK, P2, EB, EL, 
  ST_WDG, COLOR0, P4, EH, EI, P5, EF, EJ, 
  ST_HEX, COLOR1, EI, EH, EF, EJ, P0, P7, P6, P1, 
  ST_HEX, COLOR1, P0, P7, P6, P1, ED, EK, EL, EB, 
 // Case #196: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EH, EF, EK, EC, EB, 
  ST_PYR, COLOR0, P4, P5, P1, P0, N0, 
  ST_TET, COLOR0, P1, N0, P3, P0, 
  ST_PYR, COLOR0, P5, EF, EB, P1, N0, 
  ST_PYR, COLOR0, EH, EF, P5, P4, N0, 
  ST_TET, COLOR0, P3, P4, P0, N0, 
  ST_PYR, COLOR0, P3, EK, EH, P4, N0, 
  ST_TET, COLOR0, P3, EC, EK, N0, 
  ST_PYR, COLOR0, EB, EC, P3, P1, N0, 
  ST_PYR, COLOR1, EF, P6, P2, EB, N0, 
  ST_PYR, COLOR1, EH, P7, P6, EF, N0, 
  ST_TET, COLOR1, EK, P7, EH, N0, 
  ST_TET, COLOR1, P7, P2, P6, N0, 
  ST_PYR, COLOR1, EK, EC, P2, P7, N0, 
  ST_TET, COLOR1, P2, EC, EB, N0, 
 // Case #197: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EF, EB, EH, EI, EA, 
  ST_TET, COLOR0, P3, EC, EK, ED, 
  ST_PYR, COLOR0, P1, P5, EF, EB, N0, 
  ST_PYR, COLOR0, P5, P4, EH, EF, N0, 
  ST_TET, COLOR0, P4, EI, EH, N0, 
  ST_TET, COLOR0, P5, P1, P4, N0, 
  ST_PYR, COLOR0, P4, P1, EA, EI, N0, 
  ST_TET, COLOR0, P1, EB, EA, N0, 
  ST_WDG, COLOR1, EK, EC, ED, P7, P2, P0, 
  ST_TET, COLOR1, P2, P7, P0, N0, 
  ST_PYR, COLOR1, P7, EH, EI, P0, N0, 
  ST_TET, COLOR1, P6, P7, P2, N0, 
  ST_PYR, COLOR1, EB, EF, P6, P2, N0, 
  ST_PYR, COLOR1, EF, EH, P7, P6, N0, 
  ST_PYR, COLOR1, P0, EA, EB, P2, N0, 
  ST_TET, COLOR1, EI, EA, P0, N0, 
 // Case #198: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EC, EK, EH, EF, EJ, EA, 
  ST_TET, COLOR0, P4, P5, P0, N0, 
  ST_PYR, COLOR0, P4, EH, EF, P5, N0, 
  ST_TET, COLOR0, P3, P4, P0, N0, 
  ST_PYR, COLOR0, P3, EK, EH, P4, N0, 
  ST_TET, COLOR0, EC, EK, P3, N0, 
  ST_PYR, COLOR0, P3, P0, EA, EC, N0, 
  ST_PYR, COLOR0, EA, P0, P5, EJ, N0, 
  ST_TET, COLOR0, P5, EF, EJ, N0, 
  ST_TET, COLOR1, P2, P6, P7, N0, 
  ST_PYR, COLOR1, EC, P2, P7, EK, N0, 
  ST_PYR, COLOR1, EC, EA, P1, P2, N0, 
  ST_TET, COLOR1, P1, P6, P2, N0, 
  ST_TET, COLOR1, P1, EA, EJ, N0, 
  ST_PYR, COLOR1, P1, EJ, EF, P6, N0, 
  ST_PYR, COLOR1, EF, EH, P7, P6, N0, 
  ST_TET, COLOR1, EH, EK, P7, N0, 
 // Case #199: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P2, P0, P1, P6, EH, EF, 
  ST_WDG, COLOR0, EF, P5, EJ, EH, P4, EI, 
  ST_TET, COLOR0, EC, P3, ED, EK, 
  ST_WDG, COLOR1, P2, P7, P0, EC, EK, ED, 
  ST_PYR, COLOR1, EF, EH, P7, P6, N0, 
  ST_TET, COLOR1, P6, P7, P2, N0, 
  ST_TET, COLOR1, P6, P2, P1, N0, 
  ST_PYR, COLOR1, EJ, EF, P6, P1, N0, 
  ST_PYR, COLOR1, EI, EJ, P1, P0, N0, 
  ST_TET, COLOR1, P1, P2, P0, N0, 
  ST_PYR, COLOR1, EH, EF, EJ, EI, N0, 
  ST_TET, COLOR1, P0, P2, P7, N0, 
  ST_PYR, COLOR1, EH, EI, P0, P7, N0, 
 // Case #200: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, ED, EH, EC, EL, EF, 
  ST_PYR, COLOR0, P0, P4, P5, P1, N0, 
  ST_TET, COLOR0, P5, N0, P2, P1, 
  ST_PYR, COLOR0, P4, EH, EF, P5, N0, 
  ST_PYR, COLOR0, ED, EH, P4, P0, N0, 
  ST_TET, COLOR0, P2, P0, P1, N0, 
  ST_PYR, COLOR0, P2, EC, ED, P0, N0, 
  ST_TET, COLOR0, P2, EL, EC, N0, 
  ST_PYR, COLOR0, EF, EL, P2, P5, N0, 
  ST_PYR, COLOR1, EH, P7, P6, EF, N0, 
  ST_PYR, COLOR1, ED, P3, P7, EH, N0, 
  ST_TET, COLOR1, EC, P3, ED, N0, 
  ST_TET, COLOR1, P3, P6, P7, N0, 
  ST_PYR, COLOR1, EC, EL, P6, P3, N0, 
  ST_TET, COLOR1, P6, EL, EF, N0, 
 // Case #201: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EC, EL, EF, EH, EI, EA, 
  ST_TET, COLOR0, P5, P1, P4, N0, 
  ST_PYR, COLOR0, P5, P4, EH, EF, N0, 
  ST_TET, COLOR0, P2, P1, P5, N0, 
  ST_PYR, COLOR0, P2, P5, EF, EL, N0, 
  ST_TET, COLOR0, EC, P2, EL, N0, 
  ST_PYR, COLOR0, P2, EC, EA, P1, N0, 
  ST_PYR, COLOR0, EA, EI, P4, P1, N0, 
  ST_TET, COLOR0, P4, EI, EH, N0, 
  ST_TET, COLOR1, P3, P6, P7, N0, 
  ST_PYR, COLOR1, EC, EL, P6, P3, N0, 
  ST_PYR, COLOR1, EC, P3, P0, EA, N0, 
  ST_TET, COLOR1, P0, P3, P7, N0, 
  ST_TET, COLOR1, P0, EI, EA, N0, 
  ST_PYR, COLOR1, P0, P7, EH, EI, N0, 
  ST_PYR, COLOR1, EH, P7, P6, EF, N0, 
  ST_TET, COLOR1, EF, P6, EL, N0, 
 // Case #202: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EH, EF, ED, EA, EJ, 
  ST_TET, COLOR0, P2, EL, EC, EB, 
  ST_PYR, COLOR0, P5, P4, EH, EF, N0, 
  ST_PYR, COLOR0, P4, P0, ED, EH, N0, 
  ST_TET, COLOR0, P0, EA, ED, N0, 
  ST_TET, COLOR0, P4, P5, P0, N0, 
  ST_PYR, COLOR0, P0, P5, EJ, EA, N0, 
  ST_TET, COLOR0, P5, EF, EJ, N0, 
  ST_WDG, COLOR1, EC, EL, EB, P3, P6, P1, 
  ST_TET, COLOR1, P6, P3, P1, N0, 
  ST_PYR, COLOR1, P3, ED, EA, P1, N0, 
  ST_TET, COLOR1, P7, P3, P6, N0, 
  ST_PYR, COLOR1, EF, EH, P7, P6, N0, 
  ST_PYR, COLOR1, EH, ED, P3, P7, N0, 
  ST_PYR, COLOR1, P1, EJ, EF, P6, N0, 
  ST_TET, COLOR1, EA, EJ, P1, N0, 
 // Case #203: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P3, P1, P0, P7, EF, EH, 
  ST_WDG, COLOR0, EF, P5, EJ, EH, P4, EI, 
  ST_TET, COLOR0, EC, EB, P2, EL, 
  ST_WDG, COLOR1, EC, EL, EB, P3, P6, P1, 
  ST_PYR, COLOR1, EH, P7, P6, EF, N0, 
  ST_TET, COLOR1, P7, P3, P6, N0, 
  ST_TET, COLOR1, P7, P0, P3, N0, 
  ST_PYR, COLOR1, EI, P0, P7, EH, N0, 
  ST_PYR, COLOR1, EJ, P1, P0, EI, N0, 
  ST_TET, COLOR1, P0, P1, P3, N0, 
  ST_PYR, COLOR1, EF, EJ, EI, EH, N0, 
  ST_TET, COLOR1, P1, P6, P3, N0, 
  ST_PYR, COLOR1, EF, P6, P1, EJ, N0, 
 // Case #204: (cloned #15)
  ST_HEX, COLOR0, ED, EB, EF, EH, P0, P1, P5, P4, 
  ST_HEX, COLOR1, P3, P2, P6, P7, ED, EB, EF, EH, 
 // Case #205: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EB, EF, EH, EA, EI, 
  ST_PYR, COLOR0, P5, P4, EH, EF, N0, 
  ST_TET, COLOR0, P4, EI, EH, N0, 
  ST_PYR, COLOR0, P1, P5, EF, EB, N0, 
  ST_TET, COLOR0, EA, P1, EB, N0, 
  ST_PYR, COLOR0, EI, P4, P1, EA, N0, 
  ST_TET, COLOR0, P4, P5, P1, N0, 
  ST_PYR, COLOR1, P3, P2, P6, P7, N0, 
  ST_TET, COLOR1, P7, P0, P3, N0, 
  ST_TET, COLOR1, P0, P2, P3, N0, 
  ST_PYR, COLOR1, P0, EA, EB, P2, N0, 
  ST_PYR, COLOR1, EB, EF, P6, P2, N0, 
  ST_PYR, COLOR1, EF, EH, P7, P6, N0, 
  ST_PYR, COLOR1, EH, EI, P0, P7, N0, 
  ST_TET, COLOR1, EA, P0, EI, N0, 
 // Case #206: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EF, EH, ED, EJ, EA, 
  ST_PYR, COLOR0, P4, P0, ED, EH, N0, 
  ST_TET, COLOR0, P0, EA, ED, N0, 
  ST_PYR, COLOR0, P5, P4, EH, EF, N0, 
  ST_TET, COLOR0, EJ, P5, EF, N0, 
  ST_PYR, COLOR0, EA, P0, P5, EJ, N0, 
  ST_TET, COLOR0, P0, P4, P5, N0, 
  ST_PYR, COLOR1, P2, P6, P7, P3, N0, 
  ST_TET, COLOR1, P3, P1, P2, N0, 
  ST_TET, COLOR1, P1, P6, P2, N0, 
  ST_PYR, COLOR1, P1, EJ, EF, P6, N0, 
  ST_PYR, COLOR1, EF, EH, P7, P6, N0, 
  ST_PYR, COLOR1, EH, ED, P3, P7, N0, 
  ST_PYR, COLOR1, ED, EA, P1, P3, N0, 
  ST_TET, COLOR1, EJ, P1, EA, N0, 
 // Case #207: (cloned #63)
  ST_WDG, COLOR0, P5, EJ, EF, P4, EI, EH, 
  ST_HEX, COLOR1, EI, EH, EF, EJ, P0, P7, P6, P1, 
  ST_WDG, COLOR1, P3, P0, P7, P2, P1, P6, 
 // Case #208: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EI, EK, EE, EF, EL, 
  ST_PYR, COLOR0, P0, P1, P2, P3, N0, 
  ST_TET, COLOR0, P2, P5, N0, P1, 
  ST_PYR, COLOR0, P3, P2, EL, EK, N0, 
  ST_PYR, COLOR0, EI, P0, P3, EK, N0, 
  ST_TET, COLOR0, P5, P1, P0, N0, 
  ST_PYR, COLOR0, P5, P0, EI, EE, N0, 
  ST_TET, COLOR0, P5, EE, EF, N0, 
  ST_PYR, COLOR0, EL, P2, P5, EF, N0, 
  ST_PYR, COLOR1, EK, EL, P6, P7, N0, 
  ST_PYR, COLOR1, EI, EK, P7, P4, N0, 
  ST_TET, COLOR1, EE, EI, P4, N0, 
  ST_TET, COLOR1, P4, P7, P6, N0, 
  ST_PYR, COLOR1, EE, P4, P6, EF, N0, 
  ST_TET, COLOR1, P6, EL, EF, N0, 
 // Case #209: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EE, EF, EL, EK, ED, EA, 
  ST_TET, COLOR0, P2, P3, P1, N0, 
  ST_PYR, COLOR0, P2, EL, EK, P3, N0, 
  ST_TET, COLOR0, P5, P2, P1, N0, 
  ST_PYR, COLOR0, P5, EF, EL, P2, N0, 
  ST_TET, COLOR0, EE, EF, P5, N0, 
  ST_PYR, COLOR0, P5, P1, EA, EE, N0, 
  ST_PYR, COLOR0, EA, P1, P3, ED, N0, 
  ST_TET, COLOR0, P3, EK, ED, N0, 
  ST_TET, COLOR1, P4, P7, P6, N0, 
  ST_PYR, COLOR1, EE, P4, P6, EF, N0, 
  ST_PYR, COLOR1, EE, EA, P0, P4, N0, 
  ST_TET, COLOR1, P0, P7, P4, N0, 
  ST_TET, COLOR1, P0, EA, ED, N0, 
  ST_PYR, COLOR1, P0, ED, EK, P7, N0, 
  ST_PYR, COLOR1, EK, EL, P6, P7, N0, 
  ST_TET, COLOR1, EL, EF, P6, N0, 
 // Case #210: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EK, EL, EI, EA, EB, 
  ST_TET, COLOR0, P5, EE, EF, EJ, 
  ST_PYR, COLOR0, P2, EL, EK, P3, N0, 
  ST_PYR, COLOR0, P3, EK, EI, P0, N0, 
  ST_TET, COLOR0, P0, EI, EA, N0, 
  ST_TET, COLOR0, P3, P0, P2, N0, 
  ST_PYR, COLOR0, P0, EA, EB, P2, N0, 
  ST_TET, COLOR0, P2, EB, EL, N0, 
  ST_WDG, COLOR1, P4, P6, P1, EE, EF, EJ, 
  ST_TET, COLOR1, P6, P1, P4, N0, 
  ST_PYR, COLOR1, P4, P1, EA, EI, N0, 
  ST_TET, COLOR1, P7, P6, P4, N0, 
  ST_PYR, COLOR1, EL, P6, P7, EK, N0, 
  ST_PYR, COLOR1, EK, P7, P4, EI, N0, 
  ST_PYR, COLOR1, P1, P6, EL, EB, N0, 
  ST_TET, COLOR1, EA, P1, EB, N0, 
 // Case #211: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P4, P1, P0, P7, EL, EK, 
  ST_WDG, COLOR0, EK, P3, ED, EL, P2, EB, 
  ST_TET, COLOR0, EE, P5, EJ, EF, 
  ST_WDG, COLOR1, P4, P6, P1, EE, EF, EJ, 
  ST_PYR, COLOR1, EK, EL, P6, P7, N0, 
  ST_TET, COLOR1, P7, P6, P4, N0, 
  ST_TET, COLOR1, P7, P4, P0, N0, 
  ST_PYR, COLOR1, ED, EK, P7, P0, N0, 
  ST_PYR, COLOR1, EB, ED, P0, P1, N0, 
  ST_TET, COLOR1, P0, P4, P1, N0, 
  ST_PYR, COLOR1, EL, EK, ED, EB, N0, 
  ST_TET, COLOR1, P1, P4, P6, N0, 
  ST_PYR, COLOR1, EL, EB, P1, P6, N0, 
 // Case #212: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EK, EC, EB, EF, EE, EI, 
  ST_TET, COLOR0, P1, P0, P5, N0, 
  ST_PYR, COLOR0, P1, P5, EF, EB, N0, 
  ST_TET, COLOR0, P3, P0, P1, N0, 
  ST_PYR, COLOR0, P3, P1, EB, EC, N0, 
  ST_TET, COLOR0, EK, P3, EC, N0, 
  ST_PYR, COLOR0, P3, EK, EI, P0, N0, 
  ST_PYR, COLOR0, EI, EE, P5, P0, N0, 
  ST_TET, COLOR0, P5, EE, EF, N0, 
  ST_TET, COLOR1, P7, P2, P6, N0, 
  ST_PYR, COLOR1, EK, EC, P2, P7, N0, 
  ST_PYR, COLOR1, EK, P7, P4, EI, N0, 
  ST_TET, COLOR1, P4, P7, P6, N0, 
  ST_TET, COLOR1, P4, EE, EI, N0, 
  ST_PYR, COLOR1, P4, P6, EF, EE, N0, 
  ST_PYR, COLOR1, EF, P6, P2, EB, N0, 
  ST_TET, COLOR1, EB, P2, EC, N0, 
 // Case #213: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P7, P0, P4, P6, EB, EF, 
  ST_WDG, COLOR0, EB, P1, EA, EF, P5, EE, 
  ST_TET, COLOR0, EK, ED, P3, EC, 
  ST_WDG, COLOR1, EK, EC, ED, P7, P2, P0, 
  ST_PYR, COLOR1, EF, P6, P2, EB, N0, 
  ST_TET, COLOR1, P6, P7, P2, N0, 
  ST_TET, COLOR1, P6, P4, P7, N0, 
  ST_PYR, COLOR1, EE, P4, P6, EF, N0, 
  ST_PYR, COLOR1, EA, P0, P4, EE, N0, 
  ST_TET, COLOR1, P4, P0, P7, N0, 
  ST_PYR, COLOR1, EB, EA, EE, EF, N0, 
  ST_TET, COLOR1, P0, P2, P7, N0, 
  ST_PYR, COLOR1, EB, P2, P0, EA, N0, 
 // Case #214: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P6, P1, P2, P7, EI, EK, 
  ST_WDG, COLOR0, EI, P0, EA, EK, P3, EC, 
  ST_TET, COLOR0, EF, EJ, P5, EE, 
  ST_WDG, COLOR1, EF, EE, EJ, P6, P4, P1, 
  ST_PYR, COLOR1, EK, P7, P4, EI, N0, 
  ST_TET, COLOR1, P7, P6, P4, N0, 
  ST_TET, COLOR1, P7, P2, P6, N0, 
  ST_PYR, COLOR1, EC, P2, P7, EK, N0, 
  ST_PYR, COLOR1, EA, P1, P2, EC, N0, 
  ST_TET, COLOR1, P2, P1, P6, N0, 
  ST_PYR, COLOR1, EI, EA, EC, EK, N0, 
  ST_TET, COLOR1, P1, P4, P6, N0, 
  ST_PYR, COLOR1, EI, P4, P1, EA, N0, 
 // Case #215: (cloned #125)
  ST_TET, COLOR0, EF, EE, EJ, P5, 
  ST_TET, COLOR0, EC, ED, EK, P3, 
  ST_WDG, COLOR1, EJ, EF, EE, P1, P6, P4, 
  ST_WDG, COLOR1, EC, ED, EK, P2, P0, P7, 
  ST_TET, COLOR1, P7, P4, P0, P2, 
  ST_TET, COLOR1, P2, P1, P6, P4, 
  ST_TET, COLOR1, P1, P2, P0, P4, 
  ST_TET, COLOR1, P2, P6, P7, P4, 
 // Case #216: (cloned #27)
  ST_TET, COLOR0, P2, P0, P1, P5, 
  ST_PYR, COLOR0, EE, P5, P0, EI, ED, 
  ST_PYR, COLOR0, EF, EL, P2, P5, EC, 
  ST_PYR, COLOR0, P0, P2, EC, ED, P5, 
  ST_PYR, COLOR0, ED, EC, EF, EE, P5, 
  ST_TET, COLOR1, P7, P6, P4, P3, 
  ST_PYR, COLOR1, ED, P3, P4, EI, EE, 
  ST_PYR, COLOR1, EC, EL, P6, P3, EF, 
  ST_PYR, COLOR1, P4, P6, EF, EE, P3, 
  ST_PYR, COLOR1, ED, EE, EF, EC, P3, 
 // Case #217: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EC, EA, EE, EL, EF, 
  ST_PYR, COLOR0, P1, EA, EE, P5, N0, 
  ST_TET, COLOR0, P5, EE, EF, N0, 
  ST_PYR, COLOR0, P2, EC, EA, P1, N0, 
  ST_TET, COLOR0, EL, EC, P2, N0, 
  ST_PYR, COLOR0, EF, EL, P2, P5, N0, 
  ST_TET, COLOR0, P5, P2, P1, N0, 
  ST_PYR, COLOR1, P7, P4, P0, P3, N0, 
  ST_TET, COLOR1, P4, P7, P6, N0, 
  ST_TET, COLOR1, P6, P7, P3, N0, 
  ST_PYR, COLOR1, P6, P3, EC, EL, N0, 
  ST_PYR, COLOR1, EC, P3, P0, EA, N0, 
  ST_PYR, COLOR1, EA, P0, P4, EE, N0, 
  ST_PYR, COLOR1, EE, P4, P6, EF, N0, 
  ST_TET, COLOR1, EL, EF, P6, N0, 
 // Case #218: (cloned #91)
  ST_TET, COLOR0, EC, EL, EB, P2, 
  ST_TET, COLOR0, ED, EI, P0, EA, 
  ST_TET, COLOR0, EF, P5, EE, EJ, 
  ST_WDG, COLOR1, P1, P4, P6, EJ, EE, EF, 
  ST_WDG, COLOR1, ED, EA, EI, P3, P1, P4, 
  ST_WDG, COLOR1, P3, P1, P6, EC, EB, EL, 
  ST_TET, COLOR1, P1, P4, P6, P3, 
  ST_TET, COLOR1, P3, P6, P7, P4, 
 // Case #219: (cloned #95)
  ST_TET, COLOR0, EL, EB, EC, P2, 
  ST_TET, COLOR0, EF, EE, EJ, P5, 
  ST_WDG, COLOR1, EJ, EF, EE, P1, P6, P4, 
  ST_WDG, COLOR1, P1, P6, P3, EB, EL, EC, 
  ST_PYR, COLOR1, P0, P3, P7, P4, P1, 
  ST_TET, COLOR1, P6, P7, P3, P1, 
  ST_TET, COLOR1, P6, P4, P7, P1, 
 // Case #220: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EF, EB, ED, EE, EI, 
  ST_PYR, COLOR0, P1, EB, ED, P0, N0, 
  ST_TET, COLOR0, P0, ED, EI, N0, 
  ST_PYR, COLOR0, P5, EF, EB, P1, N0, 
  ST_TET, COLOR0, EE, EF, P5, N0, 
  ST_PYR, COLOR0, EI, EE, P5, P0, N0, 
  ST_TET, COLOR0, P0, P5, P1, N0, 
  ST_PYR, COLOR1, P7, P3, P2, P6, N0, 
  ST_TET, COLOR1, P3, P7, P4, N0, 
  ST_TET, COLOR1, P4, P7, P6, N0, 
  ST_PYR, COLOR1, P4, P6, EF, EE, N0, 
  ST_PYR, COLOR1, EF, P6, P2, EB, N0, 
  ST_PYR, COLOR1, EB, P2, P3, ED, N0, 
  ST_PYR, COLOR1, ED, P3, P4, EI, N0, 
  ST_TET, COLOR1, EE, EI, P4, N0, 
 // Case #221: (cloned #63)
  ST_WDG, COLOR0, P1, EA, EB, P5, EE, EF, 
  ST_HEX, COLOR1, P0, P2, P6, P4, EA, EB, EF, EE, 
  ST_WDG, COLOR1, P7, P4, P6, P3, P0, P2, 
 // Case #222: (cloned #95)
  ST_TET, COLOR0, EA, EI, ED, P0, 
  ST_TET, COLOR0, EJ, EF, EE, P5, 
  ST_WDG, COLOR1, EE, EJ, EF, P4, P1, P6, 
  ST_WDG, COLOR1, P4, P1, P3, EI, EA, ED, 
  ST_PYR, COLOR1, P7, P3, P2, P6, P4, 
  ST_TET, COLOR1, P1, P2, P3, P4, 
  ST_TET, COLOR1, P1, P6, P2, P4, 
 // Case #223: (cloned #127)
  ST_PNT, 0, COLOR1, 7, P0, P3, P7, P4, P1, P2, P6, 
  ST_TET, COLOR0, EJ, EF, EE, P5, 
  ST_WDG, COLOR1, EJ, EF, EE, P1, P6, P4, 
  ST_TET, COLOR1, P1, P4, P6, N0, 
  ST_PYR, COLOR1, P2, P6, P7, P3, N0, 
  ST_TET, COLOR1, P6, P4, P7, N0, 
  ST_PYR, COLOR1, P0, P3, P7, P4, N0, 
  ST_TET, COLOR1, P0, P4, P1, N0, 
  ST_PYR, COLOR1, P0, P1, P2, P3, N0, 
  ST_TET, COLOR1, P1, P6, P2, N0, 
 // Case #224: (cloned #7)
  ST_PNT, 0, NOCOLOR, 5, EK, EL, EH, EE, EJ, 
  ST_PYR, COLOR0, P3, P0, P1, P2, N0, 
  ST_TET, COLOR0, P1, P4, N0, P0, 
  ST_PYR, COLOR0, P2, P1, EJ, EL, N0, 
  ST_PYR, COLOR0, EK, P3, P2, EL, N0, 
  ST_TET, COLOR0, P4, P0, P3, N0, 
  ST_PYR, COLOR0, P4, P3, EK, EH, N0, 
  ST_TET, COLOR0, P4, EH, EE, N0, 
  ST_PYR, COLOR0, EJ, P1, P4, EE, N0, 
  ST_PYR, COLOR1, EL, EJ, P5, P6, N0, 
  ST_PYR, COLOR1, EK, EL, P6, P7, N0, 
  ST_TET, COLOR1, EH, EK, P7, N0, 
  ST_TET, COLOR1, P7, P6, P5, N0, 
  ST_PYR, COLOR1, EH, P7, P5, EE, N0, 
  ST_TET, COLOR1, P5, EJ, EE, N0, 
 // Case #225: (cloned #30)
  ST_PNT, 0, NOCOLOR, 5, EL, EJ, EK, ED, EA, 
  ST_TET, COLOR0, P4, EH, EE, EI, 
  ST_PYR, COLOR0, P1, EJ, EL, P2, N0, 
  ST_PYR, COLOR0, P2, EL, EK, P3, N0, 
  ST_TET, COLOR0, P3, EK, ED, N0, 
  ST_TET, COLOR0, P2, P3, P1, N0, 
  ST_PYR, COLOR0, P3, ED, EA, P1, N0, 
  ST_TET, COLOR0, P1, EA, EJ, N0, 
  ST_WDG, COLOR1, P7, P5, P0, EH, EE, EI, 
  ST_TET, COLOR1, P5, P0, P7, N0, 
  ST_PYR, COLOR1, P7, P0, ED, EK, N0, 
  ST_TET, COLOR1, P6, P5, P7, N0, 
  ST_PYR, COLOR1, EJ, P5, P6, EL, N0, 
  ST_PYR, COLOR1, EL, P6, P7, EK, N0, 
  ST_PYR, COLOR1, P0, P5, EJ, EA, N0, 
  ST_TET, COLOR1, ED, P0, EA, N0, 
 // Case #226: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EE, EH, EK, EL, EB, EA, 
  ST_TET, COLOR0, P3, P0, P2, N0, 
  ST_PYR, COLOR0, P3, P2, EL, EK, N0, 
  ST_TET, COLOR0, P4, P0, P3, N0, 
  ST_PYR, COLOR0, P4, P3, EK, EH, N0, 
  ST_TET, COLOR0, EE, P4, EH, N0, 
  ST_PYR, COLOR0, P4, EE, EA, P0, N0, 
  ST_PYR, COLOR0, EA, EB, P2, P0, N0, 
  ST_TET, COLOR0, P2, EB, EL, N0, 
  ST_TET, COLOR1, P5, P7, P6, N0, 
  ST_PYR, COLOR1, EE, EH, P7, P5, N0, 
  ST_PYR, COLOR1, EE, P5, P1, EA, N0, 
  ST_TET, COLOR1, P1, P5, P6, N0, 
  ST_TET, COLOR1, P1, EB, EA, N0, 
  ST_PYR, COLOR1, P1, P6, EL, EB, N0, 
  ST_PYR, COLOR1, EL, P6, P7, EK, N0, 
  ST_TET, COLOR1, EK, P7, EH, N0, 
 // Case #227: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P5, P0, P1, P6, EK, EL, 
  ST_WDG, COLOR0, EK, P3, ED, EL, P2, EB, 
  ST_TET, COLOR0, EE, EI, P4, EH, 
  ST_WDG, COLOR1, EE, EH, EI, P5, P7, P0, 
  ST_PYR, COLOR1, EL, P6, P7, EK, N0, 
  ST_TET, COLOR1, P6, P5, P7, N0, 
  ST_TET, COLOR1, P6, P1, P5, N0, 
  ST_PYR, COLOR1, EB, P1, P6, EL, N0, 
  ST_PYR, COLOR1, ED, P0, P1, EB, N0, 
  ST_TET, COLOR1, P1, P0, P5, N0, 
  ST_PYR, COLOR1, EK, ED, EB, EL, N0, 
  ST_TET, COLOR1, P0, P7, P5, N0, 
  ST_PYR, COLOR1, EK, P7, P0, ED, N0, 
 // Case #228: (cloned #27)
  ST_TET, COLOR0, P3, P0, P1, P4, 
  ST_PYR, COLOR0, EE, EJ, P1, P4, EB, 
  ST_PYR, COLOR0, EH, P4, P3, EK, EC, 
  ST_PYR, COLOR0, P1, EB, EC, P3, P4, 
  ST_PYR, COLOR0, EB, EE, EH, EC, P4, 
  ST_TET, COLOR1, P6, P5, P7, P2, 
  ST_PYR, COLOR1, EB, EJ, P5, P2, EE, 
  ST_PYR, COLOR1, EC, P2, P7, EK, EH, 
  ST_PYR, COLOR1, P5, EE, EH, P7, P2, 
  ST_PYR, COLOR1, EB, EC, EH, EE, P2, 
 // Case #229: (cloned #91)
  ST_TET, COLOR0, EC, ED, EK, P3, 
  ST_TET, COLOR0, EB, P1, EJ, EA, 
  ST_TET, COLOR0, EH, EE, P4, EI, 
  ST_WDG, COLOR1, EI, EE, EH, P0, P5, P7, 
  ST_WDG, COLOR1, P2, P0, P5, EB, EA, EJ, 
  ST_WDG, COLOR1, EC, ED, EK, P2, P0, P7, 
  ST_TET, COLOR1, P0, P7, P5, P2, 
  ST_TET, COLOR1, P2, P6, P7, P5, 
 // Case #230: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EC, EA, EE, EK, EH, 
  ST_PYR, COLOR0, P0, P4, EE, EA, N0, 
  ST_TET, COLOR0, P4, EH, EE, N0, 
  ST_PYR, COLOR0, P3, P0, EA, EC, N0, 
  ST_TET, COLOR0, EK, P3, EC, N0, 
  ST_PYR, COLOR0, EH, P4, P3, EK, N0, 
  ST_TET, COLOR0, P4, P0, P3, N0, 
  ST_PYR, COLOR1, P6, P2, P1, P5, N0, 
  ST_TET, COLOR1, P5, P7, P6, N0, 
  ST_TET, COLOR1, P7, P2, P6, N0, 
  ST_PYR, COLOR1, P7, EK, EC, P2, N0, 
  ST_PYR, COLOR1, EC, EA, P1, P2, N0, 
  ST_PYR, COLOR1, EA, EE, P5, P1, N0, 
  ST_PYR, COLOR1, EE, EH, P7, P5, N0, 
  ST_TET, COLOR1, EK, P7, EH, N0, 
 // Case #231: (cloned #95)
  ST_TET, COLOR0, EK, EC, ED, P3, 
  ST_TET, COLOR0, EH, EI, EE, P4, 
  ST_WDG, COLOR1, P0, P7, P5, EI, EH, EE, 
  ST_WDG, COLOR1, ED, EK, EC, P0, P7, P2, 
  ST_PYR, COLOR1, P1, P5, P6, P2, P0, 
  ST_TET, COLOR1, P7, P2, P6, P0, 
  ST_TET, COLOR1, P7, P6, P5, P0, 
 // Case #232: (cloned #23)
  ST_PNT, 0, NOCOLOR, 6, EH, EE, EJ, EL, EC, ED, 
  ST_TET, COLOR0, P1, P2, P0, N0, 
  ST_PYR, COLOR0, P1, EJ, EL, P2, N0, 
  ST_TET, COLOR0, P4, P1, P0, N0, 
  ST_PYR, COLOR0, P4, EE, EJ, P1, N0, 
  ST_TET, COLOR0, EH, EE, P4, N0, 
  ST_PYR, COLOR0, P4, P0, ED, EH, N0, 
  ST_PYR, COLOR0, ED, P0, P2, EC, N0, 
  ST_TET, COLOR0, P2, EL, EC, N0, 
  ST_TET, COLOR1, P7, P6, P5, N0, 
  ST_PYR, COLOR1, EH, P7, P5, EE, N0, 
  ST_PYR, COLOR1, EH, ED, P3, P7, N0, 
  ST_TET, COLOR1, P3, P6, P7, N0, 
  ST_TET, COLOR1, P3, ED, EC, N0, 
  ST_PYR, COLOR1, P3, EC, EL, P6, N0, 
  ST_PYR, COLOR1, EL, EJ, P5, P6, N0, 
  ST_TET, COLOR1, EJ, EE, P5, N0, 
 // Case #233: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P7, P0, P3, P6, EJ, EL, 
  ST_WDG, COLOR0, EL, P2, EC, EJ, P1, EA, 
  ST_TET, COLOR0, EH, P4, EI, EE, 
  ST_WDG, COLOR1, P7, P5, P0, EH, EE, EI, 
  ST_PYR, COLOR1, EL, EJ, P5, P6, N0, 
  ST_TET, COLOR1, P6, P5, P7, N0, 
  ST_TET, COLOR1, P6, P7, P3, N0, 
  ST_PYR, COLOR1, EC, EL, P6, P3, N0, 
  ST_PYR, COLOR1, EA, EC, P3, P0, N0, 
  ST_TET, COLOR1, P3, P7, P0, N0, 
  ST_PYR, COLOR1, EJ, EL, EC, EA, N0, 
  ST_TET, COLOR1, P0, P7, P5, N0, 
  ST_PYR, COLOR1, EJ, EA, P0, P5, N0, 
 // Case #234: (cloned #61)
  ST_PNT, 0, COLOR1, 6, P6, P1, P5, P7, ED, EH, 
  ST_WDG, COLOR0, EH, P4, EE, ED, P0, EA, 
  ST_TET, COLOR0, EL, P2, EB, EC, 
  ST_WDG, COLOR1, P6, P3, P1, EL, EC, EB, 
  ST_PYR, COLOR1, EH, ED, P3, P7, N0, 
  ST_TET, COLOR1, P7, P3, P6, N0, 
  ST_TET, COLOR1, P7, P6, P5, N0, 
  ST_PYR, COLOR1, EE, EH, P7, P5, N0, 
  ST_PYR, COLOR1, EA, EE, P5, P1, N0, 
  ST_TET, COLOR1, P5, P6, P1, N0, 
  ST_PYR, COLOR1, ED, EH, EE, EA, N0, 
  ST_TET, COLOR1, P1, P6, P3, N0, 
  ST_PYR, COLOR1, ED, EA, P1, P3, N0, 
 // Case #235: (cloned #125)
  ST_TET, COLOR0, EL, EB, EC, P2, 
  ST_TET, COLOR0, EE, EH, EI, P4, 
  ST_WDG, COLOR1, P1, P6, P3, EB, EL, EC, 
  ST_WDG, COLOR1, P5, P0, P7, EE, EI, EH, 
  ST_TET, COLOR1, P7, P0, P3, P5, 
  ST_TET, COLOR1, P5, P6, P1, P3, 
  ST_TET, COLOR1, P1, P0, P5, P3, 
  ST_TET, COLOR1, P5, P7, P6, P3, 
 // Case #236: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EH, ED, EB, EE, EJ, 
  ST_PYR, COLOR0, P0, P1, EB, ED, N0, 
  ST_TET, COLOR0, P1, EJ, EB, N0, 
  ST_PYR, COLOR0, P4, P0, ED, EH, N0, 
  ST_TET, COLOR0, EE, P4, EH, N0, 
  ST_PYR, COLOR0, EJ, P1, P4, EE, N0, 
  ST_TET, COLOR0, P1, P0, P4, N0, 
  ST_PYR, COLOR1, P6, P7, P3, P2, N0, 
  ST_TET, COLOR1, P2, P5, P6, N0, 
  ST_TET, COLOR1, P5, P7, P6, N0, 
  ST_PYR, COLOR1, P5, EE, EH, P7, N0, 
  ST_PYR, COLOR1, EH, ED, P3, P7, N0, 
  ST_PYR, COLOR1, ED, EB, P2, P3, N0, 
  ST_PYR, COLOR1, EB, EJ, P5, P2, N0, 
  ST_TET, COLOR1, EE, P5, EJ, N0, 
 // Case #237: (cloned #95)
  ST_TET, COLOR0, EE, EH, EI, P4, 
  ST_TET, COLOR0, EJ, EA, EB, P1, 
  ST_WDG, COLOR1, P0, P5, P2, EA, EJ, EB, 
  ST_WDG, COLOR1, EI, EE, EH, P0, P5, P7, 
  ST_PYR, COLOR1, P3, P2, P6, P7, P0, 
  ST_TET, COLOR1, P5, P7, P6, P0, 
  ST_TET, COLOR1, P5, P6, P2, P0, 
 // Case #238: (cloned #63)
  ST_WDG, COLOR0, P4, EE, EH, P0, EA, ED, 
  ST_HEX, COLOR1, EA, ED, EH, EE, P1, P3, P7, P5, 
  ST_WDG, COLOR1, P2, P1, P3, P6, P5, P7, 
 // Case #239: (cloned #127)
  ST_PNT, 0, COLOR1, 7, P3, P2, P1, P0, P7, P6, P5, 
  ST_TET, COLOR0, EH, EI, EE, P4, 
  ST_WDG, COLOR1, P7, P5, P0, EH, EE, EI, 
  ST_TET, COLOR1, P7, P5, P0, N0, 
  ST_PYR, COLOR1, P6, P2, P1, P5, N0, 
  ST_TET, COLOR1, P5, P1, P0, N0, 
  ST_PYR, COLOR1, P3, P0, P1, P2, N0, 
  ST_TET, COLOR1, P3, P7, P0, N0, 
  ST_PYR, COLOR1, P3, P2, P6, P7, N0, 
  ST_TET, COLOR1, P7, P6, P5, N0, 
 // Case #240: (cloned #15)
  ST_HEX, COLOR0, P0, P1, P2, P3, EI, EJ, EL, EK, 
  ST_HEX, COLOR1, EI, EJ, EL, EK, P4, P5, P6, P7, 
 // Case #241: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EJ, EL, EK, EA, ED, 
  ST_PYR, COLOR0, P2, EL, EK, P3, N0, 
  ST_TET, COLOR0, P3, EK, ED, N0, 
  ST_PYR, COLOR0, P1, EJ, EL, P2, N0, 
  ST_TET, COLOR0, EA, EJ, P1, N0, 
  ST_PYR, COLOR0, ED, EA, P1, P3, N0, 
  ST_TET, COLOR0, P3, P1, P2, N0, 
  ST_PYR, COLOR1, P4, P7, P6, P5, N0, 
  ST_TET, COLOR1, P7, P4, P0, N0, 
  ST_TET, COLOR1, P0, P4, P5, N0, 
  ST_PYR, COLOR1, P0, P5, EJ, EA, N0, 
  ST_PYR, COLOR1, EJ, P5, P6, EL, N0, 
  ST_PYR, COLOR1, EL, P6, P7, EK, N0, 
  ST_PYR, COLOR1, EK, P7, P0, ED, N0, 
  ST_TET, COLOR1, EA, ED, P0, N0, 
 // Case #242: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EL, EK, EI, EB, EA, 
  ST_PYR, COLOR0, P3, EK, EI, P0, N0, 
  ST_TET, COLOR0, P0, EI, EA, N0, 
  ST_PYR, COLOR0, P2, EL, EK, P3, N0, 
  ST_TET, COLOR0, EB, EL, P2, N0, 
  ST_PYR, COLOR0, EA, EB, P2, P0, N0, 
  ST_TET, COLOR0, P0, P2, P3, N0, 
  ST_PYR, COLOR1, P5, P4, P7, P6, N0, 
  ST_TET, COLOR1, P4, P5, P1, N0, 
  ST_TET, COLOR1, P1, P5, P6, N0, 
  ST_PYR, COLOR1, P1, P6, EL, EB, N0, 
  ST_PYR, COLOR1, EL, P6, P7, EK, N0, 
  ST_PYR, COLOR1, EK, P7, P4, EI, N0, 
  ST_PYR, COLOR1, EI, P4, P1, EA, N0, 
  ST_TET, COLOR1, EB, EA, P1, N0, 
 // Case #243: (cloned #63)
  ST_WDG, COLOR0, P3, ED, EK, P2, EB, EL, 
  ST_HEX, COLOR1, P0, P7, P6, P1, ED, EK, EL, EB, 
  ST_WDG, COLOR1, P5, P1, P6, P4, P0, P7, 
 // Case #244: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EK, EI, EJ, EC, EB, 
  ST_PYR, COLOR0, P0, EI, EJ, P1, N0, 
  ST_TET, COLOR0, P1, EJ, EB, N0, 
  ST_PYR, COLOR0, P3, EK, EI, P0, N0, 
  ST_TET, COLOR0, EC, EK, P3, N0, 
  ST_PYR, COLOR0, EB, EC, P3, P1, N0, 
  ST_TET, COLOR0, P1, P3, P0, N0, 
  ST_PYR, COLOR1, P6, P5, P4, P7, N0, 
  ST_TET, COLOR1, P5, P6, P2, N0, 
  ST_TET, COLOR1, P2, P6, P7, N0, 
  ST_PYR, COLOR1, P2, P7, EK, EC, N0, 
  ST_PYR, COLOR1, EK, P7, P4, EI, N0, 
  ST_PYR, COLOR1, EI, P4, P5, EJ, N0, 
  ST_PYR, COLOR1, EJ, P5, P2, EB, N0, 
  ST_TET, COLOR1, EC, EB, P2, N0, 
 // Case #245: (cloned #95)
  ST_TET, COLOR0, EC, ED, EK, P3, 
  ST_TET, COLOR0, EB, EJ, EA, P1, 
  ST_WDG, COLOR1, EA, EB, EJ, P0, P2, P5, 
  ST_WDG, COLOR1, P0, P2, P7, ED, EC, EK, 
  ST_PYR, COLOR1, P4, P7, P6, P5, P0, 
  ST_TET, COLOR1, P2, P6, P7, P0, 
  ST_TET, COLOR1, P2, P5, P6, P0, 
 // Case #246: (cloned #63)
  ST_WDG, COLOR0, P0, EA, EI, P3, EC, EK, 
  ST_HEX, COLOR1, P1, P4, P7, P2, EA, EI, EK, EC, 
  ST_WDG, COLOR1, P6, P2, P7, P5, P1, P4, 
 // Case #247: (cloned #127)
  ST_PNT, 0, COLOR1, 7, P4, P5, P1, P0, P7, P6, P2, 
  ST_TET, COLOR0, EK, EC, ED, P3, 
  ST_WDG, COLOR1, EK, EC, ED, P7, P2, P0, 
  ST_TET, COLOR1, P7, P0, P2, N0, 
  ST_PYR, COLOR1, P6, P2, P1, P5, N0, 
  ST_TET, COLOR1, P2, P0, P1, N0, 
  ST_PYR, COLOR1, P4, P5, P1, P0, N0, 
  ST_TET, COLOR1, P4, P0, P7, N0, 
  ST_PYR, COLOR1, P4, P7, P6, P5, N0, 
  ST_TET, COLOR1, P7, P2, P6, N0, 
 // Case #248: (cloned #31)
  ST_PNT, 0, NOCOLOR, 5, EL, EJ, EI, EC, ED, 
  ST_PYR, COLOR0, P1, P0, EI, EJ, N0, 
  ST_TET, COLOR0, P0, ED, EI, N0, 
  ST_PYR, COLOR0, P2, P1, EJ, EL, N0, 
  ST_TET, COLOR0, EC, P2, EL, N0, 
  ST_PYR, COLOR0, ED, P0, P2, EC, N0, 
  ST_TET, COLOR0, P0, P1, P2, N0, 
  ST_PYR, COLOR1, P7, P6, P5, P4, N0, 
  ST_TET, COLOR1, P4, P3, P7, N0, 
  ST_TET, COLOR1, P3, P6, P7, N0, 
  ST_PYR, COLOR1, P3, EC, EL, P6, N0, 
  ST_PYR, COLOR1, EL, EJ, P5, P6, N0, 
  ST_PYR, COLOR1, EJ, EI, P4, P5, N0, 
  ST_PYR, COLOR1, EI, ED, P3, P4, N0, 
  ST_TET, COLOR1, EC, P3, ED, N0, 
 // Case #249: (cloned #63)
  ST_WDG, COLOR0, P2, EC, EL, P1, EA, EJ, 
  ST_HEX, COLOR1, EA, EJ, EL, EC, P0, P5, P6, P3, 
  ST_WDG, COLOR1, P4, P0, P5, P7, P3, P6, 
 // Case #250: (cloned #95)
  ST_TET, COLOR0, EA, EI, ED, P0, 
  ST_TET, COLOR0, EB, EC, EL, P2, 
  ST_WDG, COLOR1, P3, P1, P6, EC, EB, EL, 
  ST_WDG, COLOR1, ED, EA, EI, P3, P1, P4, 
  ST_PYR, COLOR1, P7, P6, P5, P4, P3, 
  ST_TET, COLOR1, P1, P4, P5, P3, 
  ST_TET, COLOR1, P1, P5, P6, P3, 
 // Case #251: (cloned #127)
  ST_PNT, 0, COLOR1, 7, P0, P4, P7, P3, P1, P5, P6, 
  ST_TET, COLOR0, EB, EC, EL, P2, 
  ST_WDG, COLOR1, P1, P6, P3, EB, EL, EC, 
  ST_TET, COLOR1, P1, P6, P3, N0, 
  ST_PYR, COLOR1, P5, P4, P7, P6, N0, 
  ST_TET, COLOR1, P6, P7, P3, N0, 
  ST_PYR, COLOR1, P0, P3, P7, P4, N0, 
  ST_TET, COLOR1, P0, P1, P3, N0, 
  ST_PYR, COLOR1, P0, P4, P5, P1, N0, 
  ST_TET, COLOR1, P1, P5, P6, N0, 
 // Case #252: (cloned #63)
  ST_WDG, COLOR0, P0, EI, ED, P1, EJ, EB, 
  ST_HEX, COLOR1, P4, P3, P2, P5, EI, ED, EB, EJ, 
  ST_WDG, COLOR1, P6, P5, P2, P7, P4, P3, 
 // Case #253: (cloned #127)
  ST_PNT, 0, COLOR1, 7, P3, P7, P4, P0, P2, P6, P5, 
  ST_TET, COLOR0, EB, EJ, EA, P1, 
  ST_WDG, COLOR1, EB, EJ, EA, P2, P5, P0, 
  ST_TET, COLOR1, P2, P0, P5, N0, 
  ST_PYR, COLOR1, P6, P5, P4, P7, N0, 
  ST_TET, COLOR1, P5, P0, P4, N0, 
  ST_PYR, COLOR1, P3, P7, P4, P0, N0, 
  ST_TET, COLOR1, P3, P0, P2, N0, 
  ST_PYR, COLOR1, P3, P2, P6, P7, N0, 
  ST_TET, COLOR1, P2, P5, P6, N0, 
 // Case #254: (cloned #127)
  ST_PNT, 0, COLOR1, 7, P7, P6, P5, P4, P3, P2, P1, 
  ST_TET, COLOR0, ED, EA, EI, P0, 
  ST_WDG, COLOR1, ED, EA, EI, P3, P1, P4, 
  ST_TET, COLOR1, P3, P4, P1, N0, 
  ST_PYR, COLOR1, P2, P1, P5, P6, N0, 
  ST_TET, COLOR1, P1, P4, P5, N0, 
  ST_PYR, COLOR1, P7, P6, P5, P4, N0, 
  ST_TET, COLOR1, P7, P4, P3, N0, 
  ST_PYR, COLOR1, P7, P3, P2, P6, N0, 
  ST_TET, COLOR1, P3, P1, P2, N0, 
 // Case #255: Unique case #22
  ST_HEX, COLOR1, P0, P1, P2, P3, P4, P5, P6, P7, 
 // Dummy
  0
};

