#!/usr/bin/perl
use strict;
use warnings;
use blib;
use Test::More; 
use File::Spec;
use Cwd;
use DBI;
use File::Copy;
use Shell;

version_test();

sub version_test {
    my $version = nmap("-V");
    chomp($version);
    $version =~ s/\n//;
    $version = $& if ($version =~ /\d\.\d\d/);
    if ($version =~ /3\.\d{2}/ or $version =~ /4\.0\d/ or $version =~ /4\.1\d/){
        if ($version > 4.11){
            #print "nmap old version";
            exit;
        }
        else{
            #print "nmap new version\n";
            return "ok";
        }
        
        
        #print "version is $version\n";
        #print "Nmap version is too new for these Tests";
        #exit;
    }
    else{
        exit 1;
    }
}


BEGIN { 
    eval { require Test::DatabaseRow; Test::DatabaseRow->import };
    if ($@)
    {
        print "1..0 # Skipped no Test::DatabaseRow\n";
        plan ( tests => 3);
    
    if ($^O eq 'MSWin32'){
            is(system("perl scanpbnj -x \"t\\change1.xml\" "),0,"Scanpbnj input from change1.xml");
            is(system("perl scanpbnj -x \"t\\change2.xml\" "),0,"Scanpbnj input from change2.xml");
            is(system("perl scanpbnj -x \"t\\change3.xml\"" ),0,"Scanpbnj input from change3.xml");
    }
    else{
            is(system("./scanpbnj -x t/change1.xml > /dev/null"),0,"Scanpbnj input from change1.xml");
            is(system("./scanpbnj -x t/change2.xml > /dev/null"),0,"Scanpbnj input from change2.xml");
            is(system("./scanpbnj -x t/change3.xml > /dev/null"),0,"Scanpbnj input from change3.xml");
        }
        exit;
    }
}



use Test::DatabaseRow;
plan ( tests => 116);
my $test_file = 'change1.xml';
use vars qw($host $np $session $svc $os $FH);

if ($^O eq 'MSWin32'){
	is(system("perl scanpbnj -x \"t\\$test_file\" "),0,"Scanpbnj input from change1.xml");
}
else{
	is(system("./scanpbnj -x t/$test_file > /dev/null"),0,"Scanpbnj input from $test_file");
}

my $dbh = DBI->connect('dbi:SQLite:dbname=data.dbl');
# set the default database handle
local $Test::DatabaseRow::dbh = $dbh;

sub testService{
   my ($href) = @_;

   die "testService: port not defined"      unless defined $href->{port};
   die "testService: service not defined" unless defined $href->{service};
   die "testService: version not defined"    unless defined $href->{version};
   die "testService: proto not defined"  unless defined $href->{proto};
   die "testService: state not defined"      unless defined $href->{state};
   die "testService: updated_on not defined" unless defined $href->{updated_on};
   die "testService: machine_updated not defined"
     unless defined $href->{machine_updated};

   my $service         = $href->{service};
   my $port            = $href->{port};
   my $version         = $href->{version};
   my $proto           = $href->{proto};
   my $state           = $href->{state};
   my $updated         = $href->{updated_on};
   my $machine_updated = $href->{machine_updated};


    is(row_ok( 
        sql   => "SELECT service FROM services WHERE mid = '1' and port=$port",
        tests => [ service => $service ],
        label => "Testing $service port $port element:service"),
    1);
    is(row_ok( 
        sql   => "SELECT port FROM services WHERE mid = '1' and port=$port",
        tests => [ port => $port ],
        label => "Testing $service element:port")
    ,1);
    is(row_ok( 
        sql   => "SELECT protocol FROM services WHERE mid = '1' and
port=$port",        
        tests => [ protocol => $proto ],
        label => "Testing $service element:protocol")
    ,1);

    is(row_ok( 
        sql   => "SELECT state FROM services WHERE mid = '1' and port=$port",
        tests => [ state => $state ],
        label => "Testing $service element:state")
    ,1);

    is(row_ok( 
        sql   => "SELECT version FROM services WHERE mid = '1' and port=$port",
        tests => [ version => $version ],
        label => "Testing $service element:protocol")
    ,1);

    is(row_ok( 
        sql   => "SELECT machine_updated FROM services WHERE mid = '1'  and
        port=$port",
        tests => [ machine_updated => $machine_updated ],
        label => "Testing $service element:machine_updated")
    ,1);

    is(row_ok( 
        sql   => "SELECT updated_on FROM services WHERE mid = '1' and port=$port",
        tests => [ updated_on => $updated ],
        label => "Testing $service element:updated_on")
    ,1);
 }


### 04change2


sub testServiceChange{
 my ($href) = @_;

   die "testService: port not defined"      unless defined $href->{port};
   die "testService: service not defined" unless defined $href->{service};
   die "testService: version not defined"    unless defined $href->{version};
   die "testService: proto not defined"  unless defined $href->{proto};
   die "testService: state not defined"      unless defined $href->{state};
   die "testService: updated_on not defined" unless defined $href->{updated_on};   
   die "testService: machine_updated not defined" unless defined $href->{machine_updated};

   my $service         = $href->{service};
   my $port            = $href->{port};
   my $version         = $href->{version};
   my $proto           = $href->{proto};
   my $state           = $href->{state};
   my $updated         = $href->{updated_on};
   my $machine_updated = $href->{machine_updated};

    row_ok(
        sql   => "SELECT service FROM services WHERE mid = '1' and port=$port",
        tests => [ service => $service ],
        label => "Testing $service port $port element:service");
    row_ok(
        sql   => "SELECT port FROM services WHERE mid = '1' and port=$port",
        tests => [ port => $port ],
        label => "Testing $service element:port");
    row_ok(
        sql   => "SELECT protocol FROM services WHERE mid = '1' and port=$port",
        tests => [ protocol => $proto ],
        label => "Testing $service element:protocol");
    row_ok(
        sql   => "SELECT state FROM services WHERE mid = '1' and port=$port and machine_updated=$machine_updated",
        tests => [ state => $state ],
        label => "Testing $service element:state");

    row_ok(
        sql   => "SELECT version FROM services WHERE mid = '1' and port=$port",
        tests => [ version => $version ],
        label => "Testing $service element:protocol");

    row_ok(
        sql   => "SELECT machine_updated FROM services WHERE mid = '1' and
port=$port and machine_updated=$machine_updated",
        tests => [ machine_updated => $machine_updated ],
        label => "Testing $service element:machine_updated");

    row_ok(
        sql   => "SELECT updated_on FROM services WHERE mid = '1' and port=$port and machine_updated=$machine_updated",
        tests => [ updated_on => $updated ],
        label => "Testing $service element:updated_on");
 }
print "Testing insert into new database from $test_file\n";
# service 25
testService( {
        service         => 'ssh',
        port            => 22,
        proto           => 'tcp',
        version         => '4.2p1 Debian-7ubuntu3',
        state           => 'up',
        banner          => 'OpenSSH',
        updated_on      => 'Sat May 27 19:02:53 2006',
        machine_updated => '1148770973'
        });
testService( {
        service         => 'ipp',
        port            => 631,         
        proto           => 'tcp',
        version         => '1.2',         
        state           => 'up',
        banner          => 'CUPS',
        updated_on      => 'Sat May 27 19:02:53 2006',
        machine_updated => '1148770973'
        });
testService( {
        service         => 'smtp',
        port            => 25,
        proto           => 'tcp',
        version         => 'unknown version',
        state           => 'up',
        banner          => 'Postfix smtpd',
        updated_on      => 'Sat May 27 19:02:53 2006',
        machine_updated => '1148770973'
        });




##############################################################################
# 
# 04change2
#
##############################################################################

$test_file = 'change2.xml';
if ($^O eq 'MSWin32'){
    is(system("perl scanpbnj -x \"t\\$test_file\" "),0,"Scanpbnj input from change2.xml");
}
else{
    is(system("perl scanpbnj -x t/$test_file > /dev/null"),0,"Scanpbnj input from $test_file");
}

print "Testing insert of services into database from $test_file\n";
# service 25
testService( {
        service         => 'ssh',
        port            => 22,
        proto           => 'tcp',
        version         => '4.2p1 Debian-7ubuntu3',
        state           => 'up',
        banner          => 'OpenSSH',
        updated_on      => 'Sat May 27 19:02:53 2006',
        machine_updated => '1148770973'
        });
testService( {
        service         => 'ipp',
        port            => 631,
        proto           => 'tcp',
        version         => '1.2',
        state           => 'up',
        banner          => 'CUPS',
        updated_on      => 'Sat May 27 19:02:53 2006',
        machine_updated => '1148770973'
        });
testService( {
        service         => 'smtp',
        port            => 25,
        proto           => 'tcp',
        version         => 'unknown version',
        state           => 'up',
        banner          => 'Postfix smtpd',
        updated_on      => 'Sat May 27 19:02:53 2006',
        machine_updated => '1148770973'
        });
print "Testing SSH service down in database from $test_file\n";
testServiceChange( {
        service         => 'ssh',
        port            => 22,
        proto           => 'tcp',
        version         => '4.2p1 Debian-7ubuntu3',
        state           => 'down',
        banner          => 'OpenSSH',
        updated_on      => 'Sat May 27 19:03:24 2006',
        machine_updated => '1148771004'
        });


##############################################################################
#
# 04change3
#
##############################################################################


$test_file = 'change3.xml';
if ($^O eq 'MSWin32'){
    is(system("perl scanpbnj -x \"t\\$test_file\" "),0,"Scanpbnj input from change3.xml");
}
else {
    is(system("perl scanpbnj -x t/$test_file > /dev/null"),0,"Scanpbnj input from $test_file");
}

print "Testing SSH service up and SMTP and IPP down in database from $test_file\n";
testServiceChange( {
        service         => 'ssh',
        port            => 22,
        proto           => 'tcp',
        version         => '4.2p1 Debian-7ubuntu3',
        state           => 'up',
        banner          => 'OpenSSH',
        updated_on      => 'Sat May 27 20:00:10 2006',
        machine_updated => '1148774410'
        });

testServiceChange( {
        service         => 'smtp',
        port            => 25,
        proto           => 'tcp',
        version         => 'unknown version',
        state           => 'down',
        banner          => 'Postfix smtpd',
        updated_on      => 'Sat May 27 20:00:10 2006',
        machine_updated => '1148774410'
        });
testServiceChange( {
        service         => 'ipp',
        port            => 631,
        proto           => 'tcp',
        version         => '1.2',
        state           => 'down',
        banner          => 'CUPS',
        updated_on      => 'Sat May 27 20:00:10 2006',
        machine_updated => '1148774410'
        });

	
is(system("rm data.dbl"),0,"remove database");
