/*
    scconfig - detect I/O features of the system
    Copyright (C) 2010  Tibor Palinkas

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

		Project page: http://repo.hu/projects/scconfig
		Contact via email: scconfig [at] igor2.repo.hu
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "libs.h"
#include "log.h"
#include "db.h"
#include "dep.h"

int find_io_pipe(const char *name, int logdepth, int fatal)
{
	char *test_c =
		NL "#include <unistd.h>"
		NL "int main() {"
		NL "	int fd[2];"
		NL "	if (pipe(fd) == 0)"
		NL "		puts(\"OK\");"
		NL "	return 0;"
		NL "}"
		NL;

	require("cc/cc", logdepth, fatal);

	report("Checking for pipe(2)... ");
	logprintf(logdepth, "find_io_pipe: trying to find pipe(2)...\n");
	logdepth++;


	if (try_icl(logdepth, "libs/io/pipe", test_c, NULL, NULL, NULL)) return 0;
	return try_fail(logdepth, "libs/io/pipe");
}

int find_io_dup2(const char *name, int logdepth, int fatal)
{
	char *test_c =
		NL "#include <unistd.h>"
		NL "int main() {"
		NL "	int fd;"
		NL "	if (dup2(1, 4) == 4)"
		NL "		write(4, \"OK\\n\", 3); "
		NL "	return 0;"
		NL "}"
		NL;

	require("cc/cc", logdepth, fatal);

	report("Checking for dup2(2)... ");
	logprintf(logdepth, "find_io_dup2: trying to find dup2(2)...\n");
	logdepth++;

	if (try_icl(logdepth, "libs/io/dup2", test_c, NULL, NULL, NULL)) return 0;
	return try_fail(logdepth, "libs/io/dup2");
}


int find_io_fileno(const char *name, int logdepth, int fatal)
{
	char test_c[256];
	char *test_c_ =
		NL "#include <stdio.h>"
		NL "int main() {"
		NL no_implicit(int, "%s", "%s")
		NL "	if (%s(stdout) >= 0)"
		NL "		puts(\"OK\"); "
		NL "	return 0;"
		NL "}"
		NL;

	require("cc/cc", logdepth, fatal);

	report("Checking for fileno(3)... ");
	logprintf(logdepth, "find_io_fileno: trying to find fileno(3)...\n");
	logdepth++;

	/* UNIX */
	sprintf(test_c, test_c_, "fileno", "fileno", "fileno");
	if (try_icl(logdepth, "libs/io/fileno", test_c, "#include <unistd.h>\n", NULL, NULL)) {
		put("libs/io/fileno/call", "fileno");
		return 0;
	}

	sprintf(test_c, test_c_, "fileno", "fileno", "fileno");
	if (try_icl(logdepth, "libs/io/fileno", test_c, "#define _XOPEN_SOURCE\n#include <unistd.h>\n", NULL, NULL)) {
		put("libs/io/fileno/call", "fileno");
		return 0;
	}

	/* windows */
	sprintf(test_c, test_c_, "_fileno", "_fileno", "_fileno");
	if (try_icl(logdepth, "libs/io/fileno", test_c, "#include <stdio.h>\n", NULL, NULL)) {
		put("libs/io/fileno/call", "_fileno");
		return 0;
	}

	return try_fail(logdepth, "libs/io/fileno");
}

