/*
    scconfig - detection of POSIX library features: file system specific calls
    Copyright (C) 2018  Tibor Palinkas

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

		Project page: http://repo.hu/projects/scconfig
		Contact via email: scconfig [at] igor2.repo.hu
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "libs.h"
#include "log.h"
#include "db.h"
#include "dep.h"

int find_posix_fallocate(const char *name, int logdepth, int fatal)
{
	char *tmpf;
	char *test_c_in =
		NL "#include <stdio.h>"
		NL "#include <sys/types.h>"
		NL "#include <sys/stat.h>"
		NL "int main()"
		NL "{"
		NL "	int fd = open(\"%s\", O_WRONLY);"
		NL "	if (posix_fallocate(fd, 0, 1024) == 0)"
		NL "		puts(\"OK\");"
		NL "	return 0;"
		NL "}"
		NL;
	char test_c[8250];

	require("cc/cc", logdepth, fatal);

	report("Checking for posix_fallocate... ");
	logprintf(logdepth, "find_posix_fallocate: trying to find posix_fallocate()...\n");
	logdepth++;

	tmpf = tempfile_new(".psx");
	sprintf(test_c, test_c_in, tmpf);

	if (try_icl(logdepth, "libs/posix/fs/posix_fallocate", test_c, "#define _XOPEN_SOURCE 600\n#include <fcntl.h>", NULL, NULL)) {
		unlink(tmpf);
		return 0;
	}
	unlink(tmpf);
	return try_fail(logdepth, "libs/posix/fs/posix_fallocate");
}
