/*
 * window_main_permission.cc
 * Copyright (C) Martin Singer 2009-2011 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "window_main_permission.h"


/*** Expander : Permission ****************************************************/

// Constructor
cExpander_Permissions::cExpander_Permissions()
:
	Gtk::Expander( _("_Permissions") , true ),	// label , mnemonic

	mHBox_Permissions( false , Pdfchain::SPACING ),	// homogenous , spacing

	mTable_Features( 4 , 2 , false ),	// y_rows , x_columns , homogenous

	mFrame_Features(		_("Features")		),	// label
	mFrame_PasswordOwner(	_("Owner password")	),
	mFrame_PasswordUser(	_("User password")	),
	mFrame_Encryption(		_("Encryption")		),

	mCButton_Printing(			_("Printing")			, false ),	// label , mnemonic
	mCButton_DegradedPrinting(	_("Degraded printing")	, false ),
	mCButton_ModifyContents(	_("Modify contents")	, false ),
	mCButton_Assembly(			_("Assembly")			, false ),
	mCButton_CopyContents(		_("Copy contents")		, false ),
	mCButton_Screenreaders(		_("Screenreaders")		, false ),
	mCButton_ModifyAnnotations(	_("Modify annotations")	, false ),
	mCButton_FillIn(			_("Fill in")			, false ),

	mRButton_EncryptNone(	_("None")		, false ),	// label , mnemonic
	mRButton_Encrypt40Bit(	_("40 bit")		, false ),
	mRButton_Encrypt128Bit(	_("128 bit")	, false )
{
	mAlign_PasswordOwner.set_border_width( Pdfchain::BORDER );
	mAlign_PasswordUser.set_border_width( Pdfchain::BORDER );
	
	mEntry_PasswordOwner.set_icon_from_stock(	Gtk::Stock::CLEAR , Gtk::ENTRY_ICON_SECONDARY );
	mEntry_PasswordUser.set_icon_from_stock(	Gtk::Stock::CLEAR , Gtk::ENTRY_ICON_SECONDARY );

	mRBGroup_Encrypt = mRButton_EncryptNone.get_group();
	mRButton_Encrypt40Bit.set_group(	mRBGroup_Encrypt );
	mRButton_Encrypt128Bit.set_group(	mRBGroup_Encrypt );

	mTable_Features.set_border_width( Pdfchain::BORDER );
	mTable_Features.set_col_spacings( Pdfchain::SPACING );
	mTable_Features.attach( mCButton_Printing				, 0 , 1 , 0 , 1 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::EXPAND , Pdfchain::PADDING , Pdfchain::PADDING );
	mTable_Features.attach( mCButton_DegradedPrinting		, 0 , 1 , 1 , 2 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::EXPAND , Pdfchain::PADDING , Pdfchain::PADDING );
	mTable_Features.attach( mCButton_ModifyContents			, 0 , 1 , 2 , 3 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::EXPAND , Pdfchain::PADDING , Pdfchain::PADDING );
	mTable_Features.attach( mCButton_Assembly				, 0 , 1 , 3 , 4 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::EXPAND , Pdfchain::PADDING , Pdfchain::PADDING );
	mTable_Features.attach( mCButton_CopyContents			, 1 , 2 , 0 , 1 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::EXPAND , Pdfchain::PADDING , Pdfchain::PADDING );
	mTable_Features.attach( mCButton_Screenreaders			, 1 , 2 , 1 , 2 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::EXPAND , Pdfchain::PADDING , Pdfchain::PADDING );
	mTable_Features.attach( mCButton_ModifyAnnotations		, 1 , 2 , 2 , 3 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::EXPAND , Pdfchain::PADDING , Pdfchain::PADDING );
	mTable_Features.attach( mCButton_FillIn					, 1 , 2 , 3 , 4 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::EXPAND , Pdfchain::PADDING , Pdfchain::PADDING );

	mVBox_Encryption.set_border_width( Pdfchain::BORDER );
	mVBox_Encryption.pack_start( mRButton_EncryptNone	, true	, true	, Pdfchain::PADDING );
	mVBox_Encryption.pack_start( mRButton_Encrypt40Bit	, true	, true	, Pdfchain::PADDING );
	mVBox_Encryption.pack_start( mRButton_Encrypt128Bit	, true	, true	, Pdfchain::PADDING );

	mAlign_PasswordOwner.add( mEntry_PasswordOwner );
	mAlign_PasswordUser.add( mEntry_PasswordUser );

	mFrame_Features.add( mTable_Features );
	mFrame_PasswordOwner.add( mAlign_PasswordOwner );
	mFrame_PasswordUser.add( mAlign_PasswordUser );
	mFrame_Encryption.add( mVBox_Encryption );
	
	mVBox_Passwords.pack_start( mFrame_PasswordOwner	, true	, true	, Pdfchain::PADDING );
	mVBox_Passwords.pack_start( mFrame_PasswordUser		, true	, true	, Pdfchain::PADDING );
	
	mHBox_Permissions.pack_start( mFrame_Features	, false	, false	, Pdfchain::PADDING );	// widget , expand , fill , padding
	mHBox_Permissions.pack_start( mVBox_Passwords	, true	, true	, Pdfchain::PADDING );
	mHBox_Permissions.pack_start( mFrame_Encryption	, false	, false	, Pdfchain::PADDING );

	mAlign_Permissions.set_padding( 0 , Pdfchain::BORDER , 0 , 0 );	// top , bottom , left , right
	mAlign_Permissions.add( mHBox_Permissions );
	
	add( mAlign_Permissions );
	
	mEntry_PasswordOwner.signal_icon_press().connect(	sigc::mem_fun( *this , &cExpander_Permissions::onEntryIcon_PasswordOwner_pressed	) );
	mEntry_PasswordUser.signal_icon_press().connect(	sigc::mem_fun( *this , &cExpander_Permissions::onEntryIcon_PasswordUser_pressed		) );

	init();
}


// Destructor
cExpander_Permissions::~cExpander_Permissions()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cExpander_Permission::~cExpander_Permission()";	//TEST
#endif
}


// Method (public) : clear()
void
cExpander_Permissions::clear()
{
	init();
	return;
}


// Method (public) : create command
Glib::ustring
cExpander_Permissions::createCommand()
{
	Glib::ustring str_command = "";

	// Passwords
	if ( "" != mEntry_PasswordOwner.get_text() )	str_command += " " + Pdfchain::Cmd::PASSWORD_OWNER + " " + mEntry_PasswordOwner.get_text();
	if ( "" != mEntry_PasswordUser.get_text() )		str_command += " " + Pdfchain::Cmd::PASSWORD_USER  + " " + mEntry_PasswordUser.get_text();

	// Features
	str_command += " " + Pdfchain::Cmd::ALLOW;

	if ( mCButton_Printing.get_active()				&&
	     mCButton_DegradedPrinting.get_active()		&&
	     mCButton_ModifyContents.get_active()		&&
	     mCButton_Assembly.get_active()				&&
	     mCButton_CopyContents.get_active()			&&
	     mCButton_Screenreaders.get_active()		&&
	     mCButton_ModifyAnnotations.get_active()	&&
	     mCButton_FillIn.get_active()				)		str_command += " " + Pdfchain::Cmd::ALL_FEATURES;

	else {
		if ( mCButton_Printing.get_active()				)	str_command += " " + Pdfchain::Cmd::PRINTING;
		if ( mCButton_DegradedPrinting.get_active()		)	str_command += " " + Pdfchain::Cmd::DEGRADED_PRINTING;
		if ( mCButton_ModifyContents.get_active()		)	str_command += " " + Pdfchain::Cmd::MODIFY_CONTENTS;
		if ( mCButton_Assembly.get_active()				)	str_command += " " + Pdfchain::Cmd::ASSEMBLY;
		if ( mCButton_CopyContents.get_active()			)	str_command += " " + Pdfchain::Cmd::COPY_CONTENTS;
		if ( mCButton_Screenreaders.get_active()		)	str_command += " " + Pdfchain::Cmd::SCREEN_READERS;
		if ( mCButton_ModifyAnnotations.get_active()	)	str_command += " " + Pdfchain::Cmd::MODIFY_ANNOTATIONS;
		if ( mCButton_FillIn.get_active()				)	str_command += " " + Pdfchain::Cmd::FILL_IN;
	}

	// Encryption
	if (		mRButton_EncryptNone.get_active()	);	// Nothing to do!
	else if (	mRButton_Encrypt40Bit.get_active()	)	str_command += " " + Pdfchain::Cmd::ENCRYPT_40BIT;
	else if (	mRButton_Encrypt128Bit.get_active()	)	str_command += " " + Pdfchain::Cmd::ENCRYPT_128BIT;
	
	return str_command;
}


// Method (protected) : init()
void
cExpander_Permissions::init()
{
	mCButton_Printing.set_active( true );
	mCButton_DegradedPrinting.set_active( true );
	mCButton_ModifyContents.set_active( true );
	mCButton_Assembly.set_active( true );
	mCButton_CopyContents.set_active( true );
	mCButton_Screenreaders.set_active( true );
	mCButton_ModifyAnnotations.set_active( true );
	mCButton_FillIn.set_active( true );

	mEntry_PasswordOwner.set_text( "" );
	mEntry_PasswordUser.set_text( "" );
	
	mRButton_EncryptNone.set_active( true );
	
	return;
}