/***********************************************************************************************************************************
Common Types
***********************************************************************************************************************************/
#ifndef TYPE_H
#define TYPE_H

/***********************************************************************************************************************************
Include true/false
***********************************************************************************************************************************/
#include <stdbool.h>

/***********************************************************************************************************************************
Include NULL
***********************************************************************************************************************************/
#include <stdio.h>

/***********************************************************************************************************************************
Include limits for data types
***********************************************************************************************************************************/
#include <limits.h>

/***********************************************************************************************************************************
Define standard integer types for portability
***********************************************************************************************************************************/
#include <stdint.h>

typedef uint8_t uint8;
typedef uint16_t uint16;
typedef uint32_t uint32;
typedef uint64_t uint64;

typedef int8_t int8;
typedef int16_t int16;
typedef int32_t int32;
typedef int64_t int64;

/***********************************************************************************************************************************
Ensure that ints are at least 32 bits
***********************************************************************************************************************************/
#if INT_MAX < 2147483647L
    #error "int type must be at least 32 bits"
#endif

/***********************************************************************************************************************************
Include all header files in type directory for convenience
***********************************************************************************************************************************/
#include "common/type/buffer.h"
#include "common/type/list.h"
#include "common/type/string.h"
#include "common/type/stringList.h"
#include "common/type/variant.h"
#include "common/type/variantList.h"

#endif
