/***********************************************************************************************************************************
Cipher General Init and Free
***********************************************************************************************************************************/
#include <openssl/conf.h>
#include <openssl/evp.h>
#include <openssl/err.h>

#include "cipher/cipher.h"

/***********************************************************************************************************************************
Flag to indicate if OpenSSL has already been initialized
***********************************************************************************************************************************/
static bool cipherInitDone = false;

/***********************************************************************************************************************************
Initialize ciphers
***********************************************************************************************************************************/
void
cipherInit()
{
    if (!cipherInitDone)
    {
        ERR_load_crypto_strings();
        OpenSSL_add_all_algorithms();

        cipherInitDone = true;
    }
}

/***********************************************************************************************************************************
Have the ciphers been initialized?
***********************************************************************************************************************************/
bool
cipherIsInit()
{
    return cipherInitDone;
}

/***********************************************************************************************************************************
Free ciphers
***********************************************************************************************************************************/
void
cipherFree()
{
    if (cipherInitDone)
    {
        FIPS_mode_set(0);
        EVP_cleanup();
        CRYPTO_cleanup_all_ex_data();
        ERR_remove_thread_state(NULL);
        ERR_free_strings();

        cipherInitDone = false;
    }
}
