/***********************************************************************************************************************************
Buffer Handler
***********************************************************************************************************************************/
#ifndef COMMON_TYPE_BUFFER_H
#define COMMON_TYPE_BUFFER_H

#include "common/type.h"

/***********************************************************************************************************************************
Buffer object
***********************************************************************************************************************************/
typedef struct Buffer Buffer;

/***********************************************************************************************************************************
Functions
***********************************************************************************************************************************/
#include "common/type/string.h"

Buffer *bufNew(size_t size);
Buffer *bufNewStr(const String *string);
Buffer *bufResize(Buffer *this, size_t size);
size_t bufSize(const Buffer *this);
unsigned char *bufPtr(const Buffer *this);
void bufFree(Buffer *this);

#endif
