CREATE TABLE {$NAMESPACE}_badges.badges_badge (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
  phid VARBINARY(64) NOT NULL,
  name VARCHAR(255) NOT NULL COLLATE {$COLLATE_TEXT},
  flavor VARCHAR(255) NOT NULL COLLATE {$COLLATE_TEXT},
  description LONGTEXT NOT NULL,
  icon VARCHAR(255) NOT NULL,
  quality VARCHAR(255) NOT NULL,
  status VARCHAR(32) NOT NULL COLLATE {$COLLATE_TEXT},
  dateCreated INT UNSIGNED NOT NULL,
  dateModified INT UNSIGNED NOT NULL,
  viewPolicy VARBINARY(64) NOT NULL,
  editPolicy VARBINARY(64) NOT NULL,
  creatorPHID varbinary(64) NOT NULL,
  UNIQUE KEY `key_phid` (phid),
  KEY `key_creator` (creatorPHID, dateModified)
) ENGINE=InnoDB, COLLATE {$COLLATE_TEXT};

CREATE TABLE {$NAMESPACE}_badges.badges_transaction (
  id INT UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT,
  phid VARBINARY(64) NOT NULL,
  authorPHID VARBINARY(64) NOT NULL,
  objectPHID VARBINARY(64) NOT NULL,
  viewPolicy VARBINARY(64) NOT NULL,
  editPolicy VARBINARY(64) NOT NULL,
  commentPHID VARBINARY(64),
  commentVersion INT UNSIGNED NOT NULL,
  transactionType VARCHAR(32) NOT NULL COLLATE {$COLLATE_TEXT},
  oldValue LONGTEXT NOT NULL COLLATE {$COLLATE_TEXT},
  newValue LONGTEXT NOT NULL COLLATE {$COLLATE_TEXT},
  contentSource LONGTEXT NOT NULL COLLATE {$COLLATE_TEXT},
  metadata LONGTEXT NOT NULL COLLATE {$COLLATE_TEXT},
  dateCreated INT UNSIGNED NOT NULL,
  dateModified INT UNSIGNED NOT NULL,
  UNIQUE KEY `key_phid` (phid),
  KEY `key_object` (objectPHID)
) ENGINE=InnoDB, COLLATE {$COLLATE_TEXT};

CREATE TABLE {$NAMESPACE}_badges.edge (
  src VARBINARY(64) NOT NULL,
  type INT UNSIGNED NOT NULL,
  dst VARBINARY(64) NOT NULL,
  dateCreated INT UNSIGNED NOT NULL,
  seq INT UNSIGNED NOT NULL,
  dataID INT UNSIGNED,
  PRIMARY KEY (src, type, dst),
  KEY `src` (src, type, dateCreated, seq),
  UNIQUE KEY `key_dst` (dst, type, src)
) ENGINE=InnoDB, COLLATE {$COLLATE_TEXT};

CREATE TABLE {$NAMESPACE}_badges.edgedata (
  id INT UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT,
  data LONGTEXT NOT NULL COLLATE {$COLLATE_TEXT}
) ENGINE=InnoDB, COLLATE {$COLLATE_TEXT};
