# Generated Hydrator

A [hydrator](http://framework.zend.com/manual/2.1/en/modules/zend.stdlib.hydrator.html) is an object capable of
extracting data from other objects, or filling them with data.

ProxyManager uses proxying to instantiate very fast hydrators, since this will allow access to protected properties
of the object to be handled by the hydrator.

Also, a hydrator of ProxyManager implements `Zend\Stdlib\Hydrator\HydratorInterface`.

## Installation

To use the generated hydrators, you will need `zendframework/zend-stdlib`:

```sh
php composer.phar require zendframework/zend-stdlib:2.*
```


## Usage

Here's an example of how you can create and use a hydrator generated by ProxyManager:

```php
<?php

use ProxyManager\Configuration;
use ProxyManager\Factory\HydratorFactory as Factory;

require_once __DIR__ . '/vendor/autoload.php';

class Example
{
    public    $foo = 1;
    protected $bar = 2;
    protected $baz = 3;
}

$config  = new Configuration();
$factory = new Factory($config);

$hydrator = $factory->createProxy('Foo');

$object = new Example();

var_dump($hydrator->extract($object)); // array('foo' => 1, 'bar' => 2, 'baz' => 3)
$hydrator->hydrate(
    array('foo' => 4, 'bar' => 5, 'baz' => 6),
    $object
);
var_dump($hydrator->extract($object)); // array('foo' => 4, 'bar' => 5, 'baz' => 6)
```

## Performance comparison

A hydrator generated by ProxyManager is very fast.
Here's the performance of the various hydrators of `Zend\Stdlib\Hydrator` compared to a ProxyManager's generated proxy:

```php
<?php
require_once __DIR__ . '/vendor/autoload.php';

$iterations = 10000;

class Example
{
    public $foo;
    public $bar;
    public $baz;
    public function setFoo($foo) { $this->foo = $foo; }
    public function setBar($bar) { $this->bar = $bar; }
    public function setBaz($baz) { $this->baz = $baz; }
    public function getFoo() { return $this->foo; }
    public function getBar() { return $this->bar; }
    public function getBaz() { return $this->baz; }
    public function exchangeArray($data) {
        $this->foo = $data['foo']; $this->bar = $data['bar']; $this->baz = $data['baz'];
    }
    public function getArrayCopy() {
        return array('foo' => $this->foo, 'bar' => $this->bar, 'baz' => $this->baz);
    }
}

$object    = new Example();
$data      = array('foo' => 1, 'bar' => 2, 'baz' => 3);
$factory   = new ProxyManager\Factory\HydratorFactory(new ProxyManager\Configuration());
$hydrators = array(
    $factory->createProxy('Example'),
    new Zend\Stdlib\Hydrator\ClassMethods(),
    new Zend\Stdlib\Hydrator\Reflection(),
    new Zend\Stdlib\Hydrator\ArraySerializable(),
);

foreach ($hydrators as $hydrator) {
    $start = microtime(true);

    for ($i = 0; $i < $iterations; $i += 1) {
        $hydrator->hydrate($data, $object);
        $hydrator->extract($object);
    }

    var_dump(microtime(true) - $start);
}
```

This will produce something like following:

```php
0.028156042098999s
2.606673002243s
0.56710886955261s
0.60278487205505s
```

As you can see, the generated proxy is 20 times faster than `Zend\Stdlib\Hydrator\Reflection`
and `Zend\Stdlib\Hydrator\ArraySerializable`, and more than 90 times faster than
`Zend\Stdlib\Hydrator\ClassMethods`.

## Tuning performance for production

See [Tuning ProxyManager for Production](https://github.com/Ocramius/ProxyManager/blob/master/docs/tuning-for-production.md).
