/*
    PPApplication.h

    Copyright 2013-2017 Josh Freeman
    http://www.twilightedge.com

    This file is part of PikoPixel for Mac OS X and GNUstep.
    PikoPixel is a graphical application for drawing & editing pixel-art images.

    PikoPixel is free software: you can redistribute it and/or modify it under
    the terms of the GNU Affero General Public License as published by the
    Free Software Foundation, either version 3 of the License, or (at your
    option) any later version approved for PikoPixel by its copyright holder (or
    an authorized proxy).

    PikoPixel is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
    FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
    details.

    You should have received a copy of the GNU Affero General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

#import <Cocoa/Cocoa.h>


@interface PPApplication : NSApplication
{
    IBOutlet NSMenuItem *_pasteMenuItem;
    IBOutlet NSMenuItem *_canvasDisplayModeMenuItem;
    IBOutlet NSMenuItem *_layerOperationTargetMenuItem;
    IBOutlet NSMenuItem *_zoomInMenuItem;
    IBOutlet NSMenuItem *_zoomOutMenuItem;
    IBOutlet NSMenuItem *_zoomToFitMenuItem;
    IBOutlet NSMenuItem *_toggleActivePanelsMenuItem;
    IBOutlet NSMenuItem *_toggleColorPickerMenuItem;

    IBOutlet NSMenuItem *_leftArrowKeyEquivalentMenuItem;
    IBOutlet NSMenuItem *_rightArrowKeyEquivalentMenuItem;

    IBOutlet NSMenuItem *_previousWindowMenuItem;
}

- (IBAction) editHotkeySettings: (id) sender;
- (IBAction) newDocumentFromPasteboard: (id) sender;

- (IBAction) activateNextDocumentWindow: (id) sender;
- (IBAction) activatePreviousDocumentWindow: (id) sender;

@end
