/*
    PPGNUstepGlue_DefaultTheme.m

    Copyright 2014-2017 Josh Freeman
    http://www.twilightedge.com

    This file is part of PikoPixel for GNUstep.
    PikoPixel is a graphical application for drawing & editing pixel-art images.

    PikoPixel is free software: you can redistribute it and/or modify it under
    the terms of the GNU Affero General Public License as published by the
    Free Software Foundation, either version 3 of the License, or (at your
    option) any later version approved for PikoPixel by its copyright holder (or
    an authorized proxy).

    PikoPixel is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
    FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
    details.

    You should have received a copy of the GNU Affero General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Patches for the default GNUstep theme

#ifdef GNUSTEP

#import <Cocoa/Cocoa.h>
#import "NSObject_PPUtilities.h"
#import "PPAppBootUtilities.h"
#import "GNUstepGUI/GSTheme.h"


@implementation NSObject (PPGNUstepGlue_DefaultTheme)

+ (void) ppGSGlue_DefaultTheme_InstallPatches
{
    macroSwizzleInstanceMethod(GSTheme, drawButton:in:view:style:state:,
                                ppGSPatch_DrawButton:in:view:style:state:);
}

+ (void) load
{
    macroPerformNSObjectSelectorAfterAppLoads(ppGSGlue_DefaultTheme_InstallPatches);
}

@end

@implementation GSTheme (PPGNUStepGlue_DefaultTheme)

// PATCH: -[GSTheme drawButton:in:view:style:state:]
// Overrides the default theme's button drawing for rounded-style & regular-square-style
// buttons to instead draw them as NeXT-style square buttons. (OS X has been drawing rounded
// buttons as squares for the last several versions, and GNUstep's default theme currently
// draws regular-square-style buttons with just a simple frame outline & no highlights or
// shadows, so they look flat & different from other buttons).

- (void) ppGSPatch_DrawButton: (NSRect)frame
            in: (NSCell*)cell
            view: (NSView*)view
            style: (int)style
            state: (GSThemeControlState)state
{
    if (style == NSRoundedBezelStyle)
    {
        style = NSNeXTBezelStyle;

        // tweak frame to make up for different bezel width between RoundedBezel & NeXTBezel
        frame = NSInsetRect(frame, 3, 3);
    }
    else if (style == NSRegularSquareBezelStyle)
    {
        style = NSNeXTBezelStyle;

        // tweak frame to make up for different bezel width between SquareBezel & NeXTBezel
        frame = NSInsetRect(frame, 1, 1);
        frame.origin.y += 1;
    }

    [self ppGSPatch_DrawButton: frame in: cell view: view style: style state: state];
}

@end

#endif  // GNUSTEP

