/*	Theater_Protocol_Exception

PIRL CVS ID: Theater_Protocol_Exception.java,v 1.7 2012/04/16 06:04:12 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/
package	PIRL.Conductor.Maestro;

import	java.io.IOException;


/**	A <i>Theater_Protocol_Exception</i> is thrown when a Theater method
	call encounters a problem with the Stage_Manager protocol.
<p>
	A Theater_Protocol_Exception may have a message, reason and cause.
	Usually the message is provided by the caller to descrbe the context
	of the exception and/or provide information that may be useful is
	solving the problem. A reason code is intended to indicate the category
	of the problem. 
<p>
	@author		Bradford Castalia - UA/PIRL
	@version	1.7
	@see	Theater
*/
public class Theater_Protocol_Exception
	extends IOException
{
public static final String
	ID = "PIRL.Conductor.Maestro.Theater_Protocol_Exception (1.7 2012/04/16 06:04:12)";


/**	The default {@link #Reason() reason} code indicating that categorization
	of the exception was not specified.
*/
public static final int
	UNSPECIFIED				= 0;

/**	The {@link #Reason() reason} code indicating that the operation did
	not complete within the allowed timeout period.
*/
public static final int
	TIMEOUT					= 1;

/**	The {@link #Reason() reason} code indicating that the identity
	authentication during the initial handshake with the Stage_Manager
	was not successful.
*/
public static final int
	UNAUTHENTICATED			= 2;

/**	The {@link #Reason() reason} code indicating that a protocol Message
	contained invalid content.
*/
public static final int
	INVALID_MESSAGE			= 3;

private int
	Reason					= UNSPECIFIED;

/*==============================================================================
	Constructors
*/
/**	Construct a Theater_Protocol_Exception with a message, reason and cause.
<p>
	@param	message	A message String providing a context dependent
		description for the exception. May be null.
	@param	reason	An integer indicating the category of the reason for the
		exception.
	@param	cause	A Throwable that caused this Theater_Protocol_Exception
		to be thrown.May be null.
	@see	Throwable#getMessage()
	@see	#Reason()
	@see	Throwable#getCause()
*/
public Theater_Protocol_Exception
	(
	String		message,
	int			reason,
	Throwable	cause
	)
{
super (message);
initCause (cause);
Reason = reason;
}

/**	Construct a Theater_Protocol_Exception with a message and reason.
<p>
	A {@link Throwable#initCause(Throwable) cause} will not be intialized.
<p>
	@param	message	A message String providing a context dependent
		description for the exception. May be null.
	@param	reason	An integer indicating the category of the reason for the
		exception.
	@see	Throwable#getMessage()
	@see	#Reason()
*/
public Theater_Protocol_Exception
	(
	String		message,
	int			reason
	)
{
super (message);
Reason = reason;
}

/**	Construct a Theater_Protocol_Exception with a reason and cause.
<p>
	The exception {@link Throwable#getMessage() message} will be set to
	the {@link #ID} of this class.
<p>
	@param	reason	An integer indicating the category of the reason for the
		exception.
	@param	cause	A Throwable that caused this Theater_Protocol_Exception
		to be thrown.May be null.
	@see	#Reason()
	@see	Throwable#getCause()
*/
public Theater_Protocol_Exception
	(
	int			reason,
	Throwable	cause
	)
{this (ID, reason, cause);}

/**	Construct a Theater_Protocol_Exception with a message and cause.
<p>
	The {@link #Reason() reason} for the exception will be {@link
	#UNSPECIFIED}.
<p>
	@param	message	A message String providing a context dependent
		description for the exception. May be null.
	@param	cause	A Throwable that caused this Theater_Protocol_Exception
		to be thrown.May be null.
	@see	Throwable#getMessage()
	@see	Throwable#getCause()
*/
public Theater_Protocol_Exception
	(
	String		message,
	Throwable	cause
	)
{this (message, UNSPECIFIED, cause);}

/**	Construct a Theater_Protocol_Exception with a message.
<p>
	The {@link #Reason() reason} for the exception will be {@link
	#UNSPECIFIED}.
<p>
	A {@link Throwable#initCause(Throwable) cause} will not be intialized.
<p>
	@param	message	A message String providing a context dependent
		description for the exception. May be null.
	@see	Throwable#getMessage()
*/
public Theater_Protocol_Exception
	(
	String		message
	)
{this (message, UNSPECIFIED);}

/**	Construct a Theater_Protocol_Exception with a cause.
<p>
	The exception {@link Throwable#getMessage() message} will be set to
	the {@link #ID} of this class.
<p>
	The {@link #Reason() reason} for the exception will be {@link
	#UNSPECIFIED}.
<p>
	@param	cause	A Throwable that caused this Theater_Protocol_Exception
		to be thrown.May be null.
	@see	Throwable#getCause()
*/
public Theater_Protocol_Exception
	(
	Throwable	cause
	)
{this (ID, UNSPECIFIED, cause);}

/**	Construct an empty Theater_Protocol_Exception.
*/
public Theater_Protocol_Exception ()
{}

/*==============================================================================
	Accessors
*/
/**	Get the Reason code for the exception.
<p>
	The common reason codes known to Theater_Protocol_Exception are:
<p><dl>
<dt>{@link #UNSPECIFIED}
	<dd>The reason for the exception has not been specified.
<dt>{@link #TIMEOUT}
	<dd>The communication channel connection operation, or the receipt
		of an expected Message, did not complete within the allowed
		timeout period.
<dt>{@link #UNAUTHENTICATED}
	<dd>The identity authentication during the initial handshake with
		the Stage_Manager was not successful.
<dt>{@link #INVALID_MESSAGE}
	<dd>A protocol Message contained invalid content.
</dl><p>
	<b>N.B.</b>: Other reason codes may be used, and the common reason
	codes may be used for other than the expected meaning. The
	descriptions listed above are the uses that are known.
<p>
	@return	An integer indicating the category of the reason for the
		exception.
*/
public int Reason ()
{return Reason;}


}
