/*	test_File

PIRL CVS ID: test_File.java,v 1.12 2012/04/16 06:18:24 castalia Exp

Copyright (C) 2006-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import java.io.IOException;
import java.io.FileWriter;
import java.net.URI;

import PIRL.Configuration.Configuration;
import PIRL.PVL.*;
import PIRL.Utilities.Checker;
import PIRL.Utilities.File;
import PIRL.Strings.String_Buffer;

public class test_File
{
public static void main
	(
	String[]	args
	)
{
int status = 0;
Checker checker = new Checker();
Configuration configuration = null;
String test_Canonical_Directory = "test_dir";
String test_Logical_Link = "test_link";
String Canonical_Path 	= "/my/canonical/path/name", 
	   Logical_Path 	= "/the/logical/path", 
	   File_Name 		= "foo.txt";

try
	{
	// Set up the configuration
	String config_list = 
		"GROUP						= " + File.PATHNAMES_MAP_GROUP + "\n" 
		+ Canonical_Path + "=" + Logical_Path + "\n" 
		+ "END_GROUP\n" 
		+ "END";

	Parameter parameter = new Parameter(File.PATHNAMES_MAP_GROUP,
			(Parser) (new Parser(config_list).Strict(false)
					.Crosshatch_Comments(true).Filter_Input(false)));

	configuration = new Configuration(parameter);

	String file_a = Canonical_Path + "/" + File_Name;

	System.out.println("Constructor Tests:");

	//String tests ====================================================
	File myfile = new File(file_a);
	checker.Check("File.Logical_Path(), from new File(String)",
			Canonical_Path + "/" + File_Name, myfile.Logical_Path());

	myfile = new File(file_a).Pathnames_Map(configuration);
	checker.Check("File.Logical_Path(), from new File(String).Pathnames_Map(Configuration)",
			Logical_Path + "/" + File_Name, myfile.Logical_Path());

	//URI tests
	URI fileuri = new URI("file:///my/canonical/path/name/foo.txt");
	myfile = new File(fileuri);
	checker.Check("File.Logical_Path(), from new File(URI)", Canonical_Path + "/" + File_Name, myfile
			.Logical_Path());

	myfile = new File(fileuri).Pathnames_Map(configuration);
	checker.Check("File.Logical_Path, from new File(URI).Pathnames_Map(Configuration)", Logical_Path + "/"
			+ File_Name, myfile.Logical_Path());

	// String Parent, String Child constructor tests
	myfile = new File(Canonical_Path, File_Name);
	checker.Check("File.Logical_Path(), from new File(String Parent, String Child)", Canonical_Path
			+ "/" + File_Name, myfile.Logical_Path());

	myfile = new File(Canonical_Path, File_Name)
			.Pathnames_Map(configuration);
	checker.Check("File.Logical_Path(), from new File(String Parent, String Child).Pathnames_MapConfiguration)",
			Logical_Path + "/" + File_Name, myfile.Logical_Path());

	// File Parent, String Child constructor tests

	File parent_file = new File(Canonical_Path);
	myfile = new File(parent_file, File_Name);
	checker.Check("File.Logical_Path(), from new File(File Parent, String Child)", Canonical_Path
			+ "/" + File_Name, myfile.Logical_Path());

	myfile = new File(parent_file, File_Name).Pathnames_Map(configuration);
	checker.Check("File.Logical_Path(), from new File(File Parent, String Child).Pathnames_Map(Configuration)",
			Logical_Path + "/" + File_Name, myfile.Logical_Path());

	// No matching path test

	myfile = new File("/this/path/will/not/match");
	checker.Check("No matching Canonical Path Test",
			"/this/path/will/not/match", myfile.Logical_Path());

	// Real file test

	myfile = new File("PIRL_Utilities_File_test_file.txt");
	if (!myfile.exists())
		{
			myfile.createNewFile();
			// if the file doesn't exist then delete it when the application exits
			myfile.deleteOnExit();
		}
	checker.Check(
			"Real File Test, no matching logical path", 
			myfile.getCanonicalPath(), 
			myfile.Logical_Path());

	// Real file test with matching logical path

	File directory = new File(test_Canonical_Directory);
	String working_directory = (new File(directory.getCanonicalPath())).getParent();

	if(!directory.mkdir())
		throw new IOException("Cannot create test directory " + directory.getName());
	//delete the directory on exit
	directory.deleteOnExit();

	myfile = new File(directory,File_Name);
	myfile.deleteOnExit();

	if(!myfile.createNewFile())
		throw new IOException("Cannot create test file " + myfile.getPath());

	// Create a symbolic link using a system call, since there is no
	// native java implementation of symbolic links.

	String symlink_command = "ln -s " + test_Canonical_Directory + " " 
							 + test_Logical_Link;

	Process p = Runtime.getRuntime().exec(symlink_command);
	if(p.waitFor() != 0)
		throw new IOException("Symlink creation failed for: " + symlink_command);

	p.destroy();

	// Create a file object for the newly created symlink and delete it
	// on exit.

	File symlink_file = new File(test_Logical_Link);
	symlink_file.deleteOnExit();

	checker.Check("logical symbolic link exists",true, symlink_file.exists());

	config_list =
		"GROUP                       	= " + File.PATHNAMES_MAP_GROUP + "\n"
		+ test_Canonical_Directory + "=" + test_Logical_Link +"\n"
		+ "END_GROUP\n"
		+ "END";
	parameter = new Parameter(File.PATHNAMES_MAP_GROUP,
			(Parser) (new Parser(config_list)
					.Strict(false)
					.Crosshatch_Comments(true)
					.Filter_Input(false)));
	configuration = new Configuration(parameter);

	myfile = myfile.Pathnames_Map(configuration);

	String Expected_Logical_Path = working_directory + "/" + test_Logical_Link + "/" + File_Name;

	checker.Check("local file logical path test",Expected_Logical_Path, myfile.Logical_Path());

	checker.Check("File.exists()", true, myfile.exists());
	checker.Check("File.canRead()", true, myfile.canRead());
	checker.Check("File.canWrite()", true, myfile.canWrite());


	//Configuration tests

	System.out.println("\nConfiguration Tests:");
	config_list = 
		  "GROUP						= " + File.PATHNAMES_MAP_GROUP + "\n" 
		+ Canonical_Path + "=" + Logical_Path + "\n" 
		+ "END_GROUP\n" 
		+ "END";

	parameter = new Parameter(File.PATHNAMES_MAP_GROUP,
		(Parser) (new Parser(config_list)
				.Strict(false)
				.Crosshatch_Comments(true)
				.Filter_Input(false)));

	configuration = new Configuration(parameter);

	myfile = new File(Canonical_Path,File_Name).Pathnames_Map(configuration);

	checker.Check("File.getAbsolutePath",Canonical_Path + "/" + File_Name,myfile.getAbsolutePath());

	File config_file = new File(File.DEFAULT_CONFIGURATION_FILENAME);
	if(!config_file.createNewFile())
		throw new IOException("Default configuration file: " + 
				File.DEFAULT_CONFIGURATION_FILENAME + " exists.\n");

	config_file.deleteOnExit();

	FileWriter filewriter = new FileWriter(config_file);
	filewriter.write(config_list);
	filewriter.close();

	myfile = new File(file_a);
	checker.Check("default configuration file test",
			Logical_Path + "/" + File_Name, myfile.Logical_Path());

	//System.out.println("File Name: " + myfile.getName());
	//System.out.println("The absolute path is: " + myfile.getAbsolutePath());
	//System.out.println("The logical path is: " + myfile.Logical_Path());

} catch (Exception exception)
{
	status = 1;
	System.err.println("\n!!! Unexpected Exception:\n"
			+ exception + exception.getMessage());
}

System.out.println("\nChecks: " + checker.Checks_Total );
System.out.println("Passed: " + checker.Checks_Passed);
System.exit(status);

}

}
