# pkg-perl/no_perl_modules -- lintian check script for depending in perl-modules -*- perl -*-
#
# Copyright © 2013 Niels Thykier <niels@thykier.net>
# Copyright © 2013 gregor herrmann <gregoa@debian.org>
# Copyright © 2013 Axel Beckert <abe@debian.org>
# Copyright © 2014 Damyan Ivanov <dmn@debian.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, you can find it on the World Wide
# Web at http://www.gnu.org/copyleft/gpl.html, or write to the Free
# Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
# MA 02110-1301, USA.

package Lintian::pkg_perl::no_perl_modules;

use strict;
use warnings;

use Lintian::Tags qw(tag);

sub run {
    my ( $pkg, $type, $info, $proc, $group ) = @_;

    my @rels = qw(Pre-Depends Depends Recommends Suggests Conflicts Breaks);
    for my $rel (@rels) {
        tag 'depends-on-perl-modules', $rel
            if $info->relation($rel)->matches(qr(^perl-modules$));
    }

    return;
}

1;
