#!/usr/bin/env python

"""
CharsetMapping.py   $Id: CharsetMapping.py,v 1.5 2002/05/18 10:28:24 nordstrom Exp $

This file contain two arrays, the first "NamedCharsets" map charset names
to the right MIBenum values, the second "MIBenumNames" map the MIBenum
values to charset names.

If you call it as a script you could specify a textfile contain charset
infos (as found on http://www.iana.org/assignments/character-sets) as a
parameter and the scrip parse this file and create the two arrys.

Copyright 2001 by Dirk Heiser <plucker@dirk-heiser.de>

Distributable under the GNU General Public License Version 2 or newer.
"""

import getopt, os, sys, re, string

############### START PASTE HERE #####################################


NamedCharsets = {
                  'tactis'                                       : 2259,
                  'utf8'                                         :  106,
                  'iso-646dk'                                    :   99,
                  'utf'                                          :  106,
                  'sjis'                                         :   17,
                  'jis7'                                         :   39,
                  'iso8859-15'                                   :  111,
                  'eucjp'                                        :   18,
                  'euccn'                                        : 2025,
                  'euckr'                                        :   38,
                  'iso8859-1'                                    :    4,
                  'iso8859-2'                                    :    5,
                  'iso8859-3'                                    :    6,
                  'iso8859-4'                                    :    7,
                  'iso8859-5'                                    :    8,
                  'iso8859-6'                                    :    9,
                  'iso8859-7'                                    :   10,
                  'iso8859-8'                                    :   11,
                  'euctw'                                        : 2026,
                  'ansi_x3.4-1968'                               :    3,
                  'iso-ir-6'                                     :    3,
                  'ansi_x3.4-1986'                               :    3,
                  'iso_646.irv:1991'                             :    3,
                  'ascii'                                        :    3,
                  'iso646-us'                                    :    3,
                  'us-ascii'                                     :    3,
                  'us'                                           :    3,
                  'ibm367'                                       :    3,
                  'cp367'                                        :    3,
                  'csascii'                                      :    3,
                  'iso-10646-utf-1'                              :   27,
                  'csiso10646utf1'                               :   27,
                  'iso_646.basic:1983'                           :   28,
                  'ref'                                          :   28,
                  'csiso646basic1983'                            :   28,
                  'invariant'                                    :   29,
                  'csinvariant'                                  :   29,
                  'iso_646.irv:1983'                             :   30,
                  'iso-ir-2'                                     :   30,
                  'irv'                                          :   30,
                  'csiso2intlrefversion'                         :   30,
                  'bs_4730'                                      :   20,
                  'iso-ir-4'                                     :   20,
                  'iso646-gb'                                    :   20,
                  'gb'                                           :   20,
                  'uk'                                           :   20,
                  'csiso4unitedkingdom'                          :   20,
                  'nats-sefi'                                    :   31,
                  'iso-ir-8-1'                                   :   31,
                  'csnatssefi'                                   :   31,
                  'nats-sefi-add'                                :   32,
                  'iso-ir-8-2'                                   :   32,
                  'csnatssefiadd'                                :   32,
                  'nats-dano'                                    :   33,
                  'iso-ir-9-1'                                   :   33,
                  'csnatsdano'                                   :   33,
                  'nats-dano-add'                                :   34,
                  'iso-ir-9-2'                                   :   34,
                  'csnatsdanoadd'                                :   34,
                  'sen_850200_b'                                 :   35,
                  'iso-ir-10'                                    :   35,
                  'fi'                                           :   35,
                  'iso646-fi'                                    :   35,
                  'iso646-se'                                    :   35,
                  'se'                                           :   35,
                  'csiso10swedish'                               :   35,
                  'sen_850200_c'                                 :   21,
                  'iso-ir-11'                                    :   21,
                  'iso646-se2'                                   :   21,
                  'se2'                                          :   21,
                  'csiso11swedishfornames'                       :   21,
                  'ks_c_5601-1987'                               :   36,
                  'iso-ir-149'                                   :   36,
                  'ks_c_5601-1989'                               :   36,
                  'ksc_5601'                                     :   36,
                  'korean'                                       :   36,
                  'csksc56011987'                                :   36,
                  'iso-2022-kr'                                  :   37,
                  'csiso2022kr'                                  :   37,
                  'euc-kr'                                       :   38,
                  'cseuckr'                                      :   38,
                  'iso-2022-jp'                                  :   39,
                  'csiso2022jp'                                  :   39,
                  'iso-2022-jp-2'                                :   40,
                  'csiso2022jp2'                                 :   40,
                  'iso-2022-cn'                                  :  104,
                  'iso-2022-cn-ext'                              :  105,
                  'jis_c6220-1969-jp'                            :   41,
                  'jis_c6220-1969'                               :   41,
                  'iso-ir-13'                                    :   41,
                  'katakana'                                     :   41,
                  'x0201-7'                                      :   41,
                  'csiso13jisc6220jp'                            :   41,
                  'jis_c6220-1969-ro'                            :   42,
                  'iso-ir-14'                                    :   42,
                  'jp'                                           :   42,
                  'iso646-jp'                                    :   42,
                  'csiso14jisc6220ro'                            :   42,
                  'it'                                           :   22,
                  'iso-ir-15'                                    :   22,
                  'iso646-it'                                    :   22,
                  'csiso15italian'                               :   22,
                  'pt'                                           :   43,
                  'iso-ir-16'                                    :   43,
                  'iso646-pt'                                    :   43,
                  'csiso16portuguese'                            :   43,
                  'es'                                           :   23,
                  'iso-ir-17'                                    :   23,
                  'iso646-es'                                    :   23,
                  'csiso17spanish'                               :   23,
                  'greek7-old'                                   :   44,
                  'iso-ir-18'                                    :   44,
                  'csiso18greek7old'                             :   44,
                  'latin-greek'                                  :   45,
                  'iso-ir-19'                                    :   45,
                  'csiso19latingreek'                            :   45,
                  'din_66003'                                    :   24,
                  'iso-ir-21'                                    :   24,
                  'de'                                           :   24,
                  'iso646-de'                                    :   24,
                  'csiso21german'                                :   24,
                  'nf_z_62-010_(1973)'                           :   46,
                  'iso-ir-25'                                    :   46,
                  'iso646-fr1'                                   :   46,
                  'csiso25french'                                :   46,
                  'latin-greek-1'                                :   47,
                  'iso-ir-27'                                    :   47,
                  'csiso27latingreek1'                           :   47,
                  'iso_5427'                                     :   48,
                  'iso-ir-37'                                    :   48,
                  'csiso5427cyrillic'                            :   48,
                  'jis_c6226-1978'                               :   49,
                  'iso-ir-42'                                    :   49,
                  'csiso42jisc62261978'                          :   49,
                  'bs_viewdata'                                  :   50,
                  'iso-ir-47'                                    :   50,
                  'csiso47bsviewdata'                            :   50,
                  'inis'                                         :   51,
                  'iso-ir-49'                                    :   51,
                  'csiso49inis'                                  :   51,
                  'inis-8'                                       :   52,
                  'iso-ir-50'                                    :   52,
                  'csiso50inis8'                                 :   52,
                  'inis-cyrillic'                                :   53,
                  'iso-ir-51'                                    :   53,
                  'csiso51iniscyrillic'                          :   53,
                  'iso_5427:1981'                                :   54,
                  'iso-ir-54'                                    :   54,
                  'iso5427cyrillic1981'                          :   54,
                  'iso_5428:1980'                                :   55,
                  'iso-ir-55'                                    :   55,
                  'csiso5428greek'                               :   55,
                  'gb_1988-80'                                   :   56,
                  'iso-ir-57'                                    :   56,
                  'cn'                                           :   56,
                  'iso646-cn'                                    :   56,
                  'csiso57gb1988'                                :   56,
                  'gb_2312-80'                                   :   57,
                  'iso-ir-58'                                    :   57,
                  'chinese'                                      :   57,
                  'csiso58gb231280'                              :   57,
                  'ns_4551-1'                                    :   25,
                  'iso-ir-60'                                    :   25,
                  'iso646-no'                                    :   25,
                  'no'                                           :   25,
                  'csiso60danishnorwegian'                       :   25,
                  'csiso60norwegian1'                            :   25,
                  'ns_4551-2'                                    :   58,
                  'iso646-no2'                                   :   58,
                  'iso-ir-61'                                    :   58,
                  'no2'                                          :   58,
                  'csiso61norwegian2'                            :   58,
                  'nf_z_62-010'                                  :   26,
                  'iso-ir-69'                                    :   26,
                  'iso646-fr'                                    :   26,
                  'fr'                                           :   26,
                  'csiso69french'                                :   26,
                  'videotex-suppl'                               :   59,
                  'iso-ir-70'                                    :   59,
                  'csiso70videotexsupp1'                         :   59,
                  'pt2'                                          :   60,
                  'iso-ir-84'                                    :   60,
                  'iso646-pt2'                                   :   60,
                  'csiso84portuguese2'                           :   60,
                  'es2'                                          :   61,
                  'iso-ir-85'                                    :   61,
                  'iso646-es2'                                   :   61,
                  'csiso85spanish2'                              :   61,
                  'msz_7795.3'                                   :   62,
                  'iso-ir-86'                                    :   62,
                  'iso646-hu'                                    :   62,
                  'hu'                                           :   62,
                  'csiso86hungarian'                             :   62,
                  'jis_c6226-1983'                               :   63,
                  'iso-ir-87'                                    :   63,
                  'x0208'                                        :   63,
                  'jis_x0208-1983'                               :   63,
                  'csiso87jisx0208'                              :   63,
                  'greek7'                                       :   64,
                  'iso-ir-88'                                    :   64,
                  'csiso88greek7'                                :   64,
                  'asmo_449'                                     :   65,
                  'iso_9036'                                     :   65,
                  'arabic7'                                      :   65,
                  'iso-ir-89'                                    :   65,
                  'csiso89asmo449'                               :   65,
                  'iso-ir-90'                                    :   66,
                  'csiso90'                                      :   66,
                  'jis_c6229-1984-a'                             :   67,
                  'iso-ir-91'                                    :   67,
                  'jp-ocr-a'                                     :   67,
                  'csiso91jisc62291984a'                         :   67,
                  'jis_c6229-1984-b'                             :   68,
                  'iso-ir-92'                                    :   68,
                  'iso646-jp-ocr-b'                              :   68,
                  'jp-ocr-b'                                     :   68,
                  'csiso92jisc62991984b'                         :   68,
                  'jis_c6229-1984-b-add'                         :   69,
                  'iso-ir-93'                                    :   69,
                  'jp-ocr-b-add'                                 :   69,
                  'csiso93jis62291984badd'                       :   69,
                  'jis_c6229-1984-hand'                          :   70,
                  'iso-ir-94'                                    :   70,
                  'jp-ocr-hand'                                  :   70,
                  'csiso94jis62291984hand'                       :   70,
                  'jis_c6229-1984-hand-add'                      :   71,
                  'iso-ir-95'                                    :   71,
                  'jp-ocr-hand-add'                              :   71,
                  'csiso95jis62291984handadd'                    :   71,
                  'jis_c6229-1984-kana'                          :   72,
                  'iso-ir-96'                                    :   72,
                  'csiso96jisc62291984kana'                      :   72,
                  'iso_2033-1983'                                :   73,
                  'iso-ir-98'                                    :   73,
                  'e13b'                                         :   73,
                  'csiso2033'                                    :   73,
                  'ansi_x3.110-1983'                             :   74,
                  'iso-ir-99'                                    :   74,
                  'csa_t500-1983'                                :   74,
                  'naplps'                                       :   74,
                  'csiso99naplps'                                :   74,
                  'iso_8859-1:1987'                              :    4,
                  'iso-ir-100'                                   :    4,
                  'iso_8859-1'                                   :    4,
                  'iso-8859-1'                                   :    4,
                  'latin1'                                       :    4,
                  'l1'                                           :    4,
                  'ibm819'                                       :    4,
                  'cp819'                                        :    4,
                  'csisolatin1'                                  :    4,
                  'iso_8859-2:1987'                              :    5,
                  'iso-ir-101'                                   :    5,
                  'iso_8859-2'                                   :    5,
                  'iso-8859-2'                                   :    5,
                  'latin2'                                       :    5,
                  'l2'                                           :    5,
                  'csisolatin2'                                  :    5,
                  't.61-7bit'                                    :   75,
                  'iso-ir-102'                                   :   75,
                  'csiso102t617bit'                              :   75,
                  't.61-8bit'                                    :   76,
                  't.61'                                         :   76,
                  'iso-ir-103'                                   :   76,
                  'csiso103t618bit'                              :   76,
                  'iso_8859-3:1988'                              :    6,
                  'iso-ir-109'                                   :    6,
                  'iso_8859-3'                                   :    6,
                  'iso-8859-3'                                   :    6,
                  'latin3'                                       :    6,
                  'l3'                                           :    6,
                  'csisolatin3'                                  :    6,
                  'iso_8859-4:1988'                              :    7,
                  'iso-ir-110'                                   :    7,
                  'iso_8859-4'                                   :    7,
                  'iso-8859-4'                                   :    7,
                  'latin4'                                       :    7,
                  'l4'                                           :    7,
                  'csisolatin4'                                  :    7,
                  'ecma-cyrillic'                                :   77,
                  'iso-ir-111'                                   :   77,
                  'csiso111ecmacyrillic'                         :   77,
                  'csa_z243.4-1985-1'                            :   78,
                  'iso-ir-121'                                   :   78,
                  'iso646-ca'                                    :   78,
                  'csa7-1'                                       :   78,
                  'ca'                                           :   78,
                  'csiso121canadian1'                            :   78,
                  'csa_z243.4-1985-2'                            :   79,
                  'iso-ir-122'                                   :   79,
                  'iso646-ca2'                                   :   79,
                  'csa7-2'                                       :   79,
                  'csiso122canadian2'                            :   79,
                  'csa_z243.4-1985-gr'                           :   80,
                  'iso-ir-123'                                   :   80,
                  'csiso123csaz24341985gr'                       :   80,
                  'iso_8859-6:1987'                              :    9,
                  'iso-ir-127'                                   :    9,
                  'iso_8859-6'                                   :    9,
                  'iso-8859-6'                                   :    9,
                  'ecma-114'                                     :    9,
                  'asmo-708'                                     :    9,
                  'arabic'                                       :    9,
                  'csisolatinarabic'                             :    9,
                  'iso_8859-6-e'                                 :   81,
                  'csiso88596e'                                  :   81,
                  'iso-8859-6-e'                                 :   81,
                  'iso_8859-6-i'                                 :   82,
                  'csiso88596i'                                  :   82,
                  'iso-8859-6-i'                                 :   82,
                  'iso_8859-7:1987'                              :   10,
                  'iso-ir-126'                                   :   10,
                  'iso_8859-7'                                   :   10,
                  'iso-8859-7'                                   :   10,
                  'elot_928'                                     :   10,
                  'ecma-118'                                     :   10,
                  'greek'                                        :   10,
                  'greek8'                                       :   10,
                  'csisolatingreek'                              :   10,
                  't.101-g2'                                     :   83,
                  'iso-ir-128'                                   :   83,
                  'csiso128t101g2'                               :   83,
                  'iso_8859-8:1988'                              :   11,
                  'iso-ir-138'                                   :   11,
                  'iso_8859-8'                                   :   11,
                  'iso-8859-8'                                   :   11,
                  'hebrew'                                       :   11,
                  'csisolatinhebrew'                             :   11,
                  'iso_8859-8-e'                                 :   84,
                  'csiso88598e'                                  :   84,
                  'iso-8859-8-e'                                 :   84,
                  'iso_8859-8-i'                                 :   85,
                  'csiso88598i'                                  :   85,
                  'iso-8859-8-i'                                 :   85,
                  'csn_369103'                                   :   86,
                  'iso-ir-139'                                   :   86,
                  'csiso139csn369103'                            :   86,
                  'jus_i.b1.002'                                 :   87,
                  'iso-ir-141'                                   :   87,
                  'iso646-yu'                                    :   87,
                  'js'                                           :   87,
                  'yu'                                           :   87,
                  'csiso141jusib1002'                            :   87,
                  'iso_6937-2-add'                               :   14,
                  'iso-ir-142'                                   :   14,
                  'csisotextcomm'                                :   14,
                  'iec_p27-1'                                    :   88,
                  'iso-ir-143'                                   :   88,
                  'csiso143iecp271'                              :   88,
                  'iso_8859-5:1988'                              :    8,
                  'iso-ir-144'                                   :    8,
                  'iso_8859-5'                                   :    8,
                  'iso-8859-5'                                   :    8,
                  'cyrillic'                                     :    8,
                  'csisolatincyrillic'                           :    8,
                  'jus_i.b1.003-serb'                            :   89,
                  'iso-ir-146'                                   :   89,
                  'serbian'                                      :   89,
                  'csiso146serbian'                              :   89,
                  'jus_i.b1.003-mac'                             :   90,
                  'macedonian'                                   :   90,
                  'iso-ir-147'                                   :   90,
                  'csiso147macedonian'                           :   90,
                  'iso_8859-9:1989'                              :   12,
                  'iso-ir-148'                                   :   12,
                  'iso_8859-9'                                   :   12,
                  'iso-8859-9'                                   :   12,
                  'latin5'                                       :   12,
                  'l5'                                           :   12,
                  'csisolatin5'                                  :   12,
                  'greek-ccitt'                                  :   91,
                  'iso-ir-150'                                   :   91,
                  'csiso150'                                     :   91,
                  'csiso150greekccitt'                           :   91,
                  'nc_nc00-10:81'                                :   92,
                  'cuba'                                         :   92,
                  'iso-ir-151'                                   :   92,
                  'iso646-cu'                                    :   92,
                  'csiso151cuba'                                 :   92,
                  'iso_6937-2-25'                                :   93,
                  'iso-ir-152'                                   :   93,
                  'csiso6937add'                                 :   93,
                  'gost_19768-74'                                :   94,
                  'st_sev_358-88'                                :   94,
                  'iso-ir-153'                                   :   94,
                  'csiso153gost1976874'                          :   94,
                  'iso_8859-supp'                                :   95,
                  'iso-ir-154'                                   :   95,
                  'latin1-2-5'                                   :   95,
                  'csiso8859supp'                                :   95,
                  'iso_10367-box'                                :   96,
                  'iso-ir-155'                                   :   96,
                  'csiso10367box'                                :   96,
                  'iso-8859-10'                                  :   13,
                  'iso-ir-157'                                   :   13,
                  'l6'                                           :   13,
                  'iso_8859-10:1992'                             :   13,
                  'csisolatin6'                                  :   13,
                  'latin6'                                       :   13,
                  'latin-lap'                                    :   97,
                  'lap'                                          :   97,
                  'iso-ir-158'                                   :   97,
                  'csiso158lap'                                  :   97,
                  'jis_x0212-1990'                               :   98,
                  'x0212'                                        :   98,
                  'iso-ir-159'                                   :   98,
                  'csiso159jisx02121990'                         :   98,
                  'ds_2089'                                      :   99,
                  'ds2089'                                       :   99,
                  'iso646-dk'                                    :   99,
                  'dk'                                           :   99,
                  'csiso646danish'                               :   99,
                  'us-dk'                                        :  100,
                  'csusdk'                                       :  100,
                  'dk-us'                                        :  101,
                  'csdkus'                                       :  101,
                  'jis_x0201'                                    :   15,
                  'x0201'                                        :   15,
                  'cshalfwidthkatakana'                          :   15,
                  'ksc5636'                                      :  102,
                  'iso646-kr'                                    :  102,
                  'csksc5636'                                    :  102,
                  'iso-10646-ucs-2'                              : 1000,
                  'csunicode'                                    : 1000,
                  'iso-10646-ucs-4'                              : 1001,
                  'csucs4'                                       : 1001,
                  'dec-mcs'                                      : 2008,
                  'dec'                                          : 2008,
                  'csdecmcs'                                     : 2008,
                  'hp-roman8'                                    : 2004,
                  'roman8'                                       : 2004,
                  'r8'                                           : 2004,
                  'cshproman8'                                   : 2004,
                  'macintosh'                                    : 2027,
                  'mac'                                          : 2027,
                  'csmacintosh'                                  : 2027,
                  'ibm037'                                       : 2028,
                  'cp037'                                        : 2028,
                  'ebcdic-cp-us'                                 : 2028,
                  'ebcdic-cp-ca'                                 : 2028,
                  'ebcdic-cp-wt'                                 : 2028,
                  'ebcdic-cp-nl'                                 : 2028,
                  'csibm037'                                     : 2028,
                  'ibm038'                                       : 2029,
                  'ebcdic-int'                                   : 2029,
                  'cp038'                                        : 2029,
                  'csibm038'                                     : 2029,
                  'ibm273'                                       : 2030,
                  'cp273'                                        : 2030,
                  'csibm273'                                     : 2030,
                  'ibm274'                                       : 2031,
                  'ebcdic-be'                                    : 2031,
                  'cp274'                                        : 2031,
                  'csibm274'                                     : 2031,
                  'ibm275'                                       : 2032,
                  'ebcdic-br'                                    : 2032,
                  'cp275'                                        : 2032,
                  'csibm275'                                     : 2032,
                  'ibm277'                                       : 2033,
                  'ebcdic-cp-dk'                                 : 2033,
                  'ebcdic-cp-no'                                 : 2033,
                  'csibm277'                                     : 2033,
                  'ibm278'                                       : 2034,
                  'cp278'                                        : 2034,
                  'ebcdic-cp-fi'                                 : 2034,
                  'ebcdic-cp-se'                                 : 2034,
                  'csibm278'                                     : 2034,
                  'ibm280'                                       : 2035,
                  'cp280'                                        : 2035,
                  'ebcdic-cp-it'                                 : 2035,
                  'csibm280'                                     : 2035,
                  'ibm281'                                       : 2036,
                  'ebcdic-jp-e'                                  : 2036,
                  'cp281'                                        : 2036,
                  'csibm281'                                     : 2036,
                  'ibm284'                                       : 2037,
                  'cp284'                                        : 2037,
                  'ebcdic-cp-es'                                 : 2037,
                  'csibm284'                                     : 2037,
                  'ibm285'                                       : 2038,
                  'cp285'                                        : 2038,
                  'ebcdic-cp-gb'                                 : 2038,
                  'csibm285'                                     : 2038,
                  'ibm290'                                       : 2039,
                  'cp290'                                        : 2039,
                  'ebcdic-jp-kana'                               : 2039,
                  'csibm290'                                     : 2039,
                  'ibm297'                                       : 2040,
                  'cp297'                                        : 2040,
                  'ebcdic-cp-fr'                                 : 2040,
                  'csibm297'                                     : 2040,
                  'ibm420'                                       : 2041,
                  'cp420'                                        : 2041,
                  'ebcdic-cp-ar1'                                : 2041,
                  'csibm420'                                     : 2041,
                  'ibm423'                                       : 2042,
                  'cp423'                                        : 2042,
                  'ebcdic-cp-gr'                                 : 2042,
                  'csibm423'                                     : 2042,
                  'ibm424'                                       : 2043,
                  'cp424'                                        : 2043,
                  'ebcdic-cp-he'                                 : 2043,
                  'csibm424'                                     : 2043,
                  'ibm437'                                       : 2011,
                  'cp437'                                        : 2011,
                  '437'                                          : 2011,
                  'cspc8codepage437'                             : 2011,
                  'ibm500'                                       : 2044,
                  'cp500'                                        : 2044,
                  'ebcdic-cp-be'                                 : 2044,
                  'ebcdic-cp-ch'                                 : 2044,
                  'csibm500'                                     : 2044,
                  'ibm775'                                       : 2087,
                  'cp775'                                        : 2087,
                  'cspc775baltic'                                : 2087,
                  'ibm850'                                       : 2009,
                  'cp850'                                        : 2009,
                  '850'                                          : 2009,
                  'cspc850multilingual'                          : 2009,
                  'ibm851'                                       : 2045,
                  'cp851'                                        : 2045,
                  '851'                                          : 2045,
                  'csibm851'                                     : 2045,
                  'ibm852'                                       : 2010,
                  'cp852'                                        : 2010,
                  '852'                                          : 2010,
                  'cspcp852'                                     : 2010,
                  'ibm855'                                       : 2046,
                  'cp855'                                        : 2046,
                  '855'                                          : 2046,
                  'csibm855'                                     : 2046,
                  'ibm857'                                       : 2047,
                  'cp857'                                        : 2047,
                  '857'                                          : 2047,
                  'csibm857'                                     : 2047,
                  'ibm860'                                       : 2048,
                  'cp860'                                        : 2048,
                  '860'                                          : 2048,
                  'csibm860'                                     : 2048,
                  'ibm861'                                       : 2049,
                  'cp861'                                        : 2049,
                  '861'                                          : 2049,
                  'cp-is'                                        : 2049,
                  'csibm861'                                     : 2049,
                  'ibm862'                                       : 2013,
                  'cp862'                                        : 2013,
                  '862'                                          : 2013,
                  'cspc862latinhebrew'                           : 2013,
                  'ibm863'                                       : 2050,
                  'cp863'                                        : 2050,
                  '863'                                          : 2050,
                  'csibm863'                                     : 2050,
                  'ibm864'                                       : 2051,
                  'cp864'                                        : 2051,
                  'csibm864'                                     : 2051,
                  'ibm865'                                       : 2052,
                  'cp865'                                        : 2052,
                  '865'                                          : 2052,
                  'csibm865'                                     : 2052,
                  'ibm866'                                       : 2086,
                  'cp866'                                        : 2086,
                  '866'                                          : 2086,
                  'csibm866'                                     : 2086,
                  'ibm868'                                       : 2053,
                  'cp868'                                        : 2053,
                  'cp-ar'                                        : 2053,
                  'csibm868'                                     : 2053,
                  'ibm869'                                       : 2054,
                  'cp869'                                        : 2054,
                  '869'                                          : 2054,
                  'cp-gr'                                        : 2054,
                  'csibm869'                                     : 2054,
                  'ibm870'                                       : 2055,
                  'cp870'                                        : 2055,
                  'ebcdic-cp-roece'                              : 2055,
                  'ebcdic-cp-yu'                                 : 2055,
                  'csibm870'                                     : 2055,
                  'ibm871'                                       : 2056,
                  'cp871'                                        : 2056,
                  'ebcdic-cp-is'                                 : 2056,
                  'csibm871'                                     : 2056,
                  'ibm880'                                       : 2057,
                  'cp880'                                        : 2057,
                  'ebcdic-cyrillic'                              : 2057,
                  'csibm880'                                     : 2057,
                  'ibm891'                                       : 2058,
                  'cp891'                                        : 2058,
                  'csibm891'                                     : 2058,
                  'ibm903'                                       : 2059,
                  'cp903'                                        : 2059,
                  'csibm903'                                     : 2059,
                  'ibm904'                                       : 2060,
                  'cp904'                                        : 2060,
                  '904'                                          : 2060,
                  'csibbm904'                                    : 2060,
                  'ibm905'                                       : 2061,
                  'cp905'                                        : 2061,
                  'ebcdic-cp-tr'                                 : 2061,
                  'csibm905'                                     : 2061,
                  'ibm918'                                       : 2062,
                  'cp918'                                        : 2062,
                  'ebcdic-cp-ar2'                                : 2062,
                  'csibm918'                                     : 2062,
                  'ibm1026'                                      : 2063,
                  'cp1026'                                       : 2063,
                  'csibm1026'                                    : 2063,
                  'ebcdic-at-de'                                 : 2064,
                  'csibmebcdicatde'                              : 2064,
                  'ebcdic-at-de-a'                               : 2065,
                  'csebcdicatdea'                                : 2065,
                  'ebcdic-ca-fr'                                 : 2066,
                  'csebcdiccafr'                                 : 2066,
                  'ebcdic-dk-no'                                 : 2067,
                  'csebcdicdkno'                                 : 2067,
                  'ebcdic-dk-no-a'                               : 2068,
                  'csebcdicdknoa'                                : 2068,
                  'ebcdic-fi-se'                                 : 2069,
                  'csebcdicfise'                                 : 2069,
                  'ebcdic-fi-se-a'                               : 2070,
                  'csebcdicfisea'                                : 2070,
                  'ebcdic-fr'                                    : 2071,
                  'csebcdicfr'                                   : 2071,
                  'ebcdic-it'                                    : 2072,
                  'csebcdicit'                                   : 2072,
                  'ebcdic-pt'                                    : 2073,
                  'csebcdicpt'                                   : 2073,
                  'ebcdic-es'                                    : 2074,
                  'csebcdices'                                   : 2074,
                  'ebcdic-es-a'                                  : 2075,
                  'csebcdicesa'                                  : 2075,
                  'ebcdic-es-s'                                  : 2076,
                  'csebcdicess'                                  : 2076,
                  'ebcdic-uk'                                    : 2077,
                  'csebcdicuk'                                   : 2077,
                  'ebcdic-us'                                    : 2078,
                  'csebcdicus'                                   : 2078,
                  'unknown-8bit'                                 : 2079,
                  'csunknown8bit'                                : 2079,
                  'mnemonic'                                     : 2080,
                  'csmnemonic'                                   : 2080,
                  'mnem'                                         : 2081,
                  'csmnem'                                       : 2081,
                  'viscii'                                       : 2082,
                  'csviscii'                                     : 2082,
                  'viqr'                                         : 2083,
                  'csviqr'                                       : 2083,
                  'koi8-r'                                       : 2084,
                  'cskoi8r'                                      : 2084,
                  'koi8-u'                                       : 2088,
                  'ibm00858'                                     : 2089,
                  'ccsid00858'                                   : 2089,
                  'cp00858'                                      : 2089,
                  'pc-multilingual-850+euro'                     : 2089,
                  'ibm00924'                                     : 2090,
                  'ccsid00924'                                   : 2090,
                  'cp00924'                                      : 2090,
                  'ebcdic-latin9--euro'                          : 2090,
                  'ibm01140'                                     : 2091,
                  'ccsid01140'                                   : 2091,
                  'cp01140'                                      : 2091,
                  'ebcdic-us-37+euro'                            : 2091,
                  'ibm01141'                                     : 2092,
                  'ccsid01141'                                   : 2092,
                  'cp01141'                                      : 2092,
                  'ebcdic-de-273+euro'                           : 2092,
                  'ibm01142'                                     : 2093,
                  'ccsid01142'                                   : 2093,
                  'cp01142'                                      : 2093,
                  'ebcdic-dk-277+euro'                           : 2093,
                  'ebcdic-no-277+euro'                           : 2093,
                  'ibm01143'                                     : 2094,
                  'ccsid01143'                                   : 2094,
                  'cp01143'                                      : 2094,
                  'ebcdic-fi-278+euro'                           : 2094,
                  'ebcdic-se-278+euro'                           : 2094,
                  'ibm01144'                                     : 2095,
                  'ccsid01144'                                   : 2095,
                  'cp01144'                                      : 2095,
                  'ebcdic-it-280+euro'                           : 2095,
                  'ibm01145'                                     : 2096,
                  'ccsid01145'                                   : 2096,
                  'cp01145'                                      : 2096,
                  'ebcdic-es-284+euro'                           : 2096,
                  'ibm01146'                                     : 2097,
                  'ccsid01146'                                   : 2097,
                  'cp01146'                                      : 2097,
                  'ebcdic-gb-285+euro'                           : 2097,
                  'ibm01147'                                     : 2098,
                  'ccsid01147'                                   : 2098,
                  'cp01147'                                      : 2098,
                  'ebcdic-fr-297+euro'                           : 2098,
                  'ibm01148'                                     : 2099,
                  'ccsid01148'                                   : 2099,
                  'cp01148'                                      : 2099,
                  'ebcdic-international-500+euro'                : 2099,
                  'ibm01149'                                     : 2100,
                  'ccsid01149'                                   : 2100,
                  'cp01149'                                      : 2100,
                  'ebcdic-is-871+euro'                           : 2100,
                  'big5-hkscs'                                   : 2101,
                  'unicode-1-1'                                  : 1010,
                  'csunicode11'                                  : 1010,
                  'scsu'                                         : 1011,
                  'utf-7'                                        : 1012,
                  'utf-16be'                                     : 1013,
                  'utf-16le'                                     : 1014,
                  'utf-16'                                       : 1015,
                  'unicode-1-1-utf-7'                            :  103,
                  'csunicode11utf7'                              :  103,
                  'utf-8'                                        :  106,
                  'iso-8859-13'                                  :  109,
                  'iso-8859-14'                                  :  110,
                  'iso-ir-199'                                   :  110,
                  'iso_8859-14:1998'                             :  110,
                  'iso_8859-14'                                  :  110,
                  'latin8'                                       :  110,
                  'iso-celtic'                                   :  110,
                  'l8'                                           :  110,
                  'iso-8859-15'                                  :  111,
                  'iso_8859-15'                                  :  111,
                  'iso-8859-16'                                  :  112,
                  'jis_encoding'                                 :   16,
                  'csjisencoding'                                :   16,
                  'shift_jis'                                    :   17,
                  'ms_kanji'                                     :   17,
                  'csshiftjis'                                   :   17,
                  'extended_unix_code_packed_format_for_japanese':   18,
                  'cseucpkdfmtjapanese'                          :   18,
                  'euc-jp'                                       :   18,
                  'extended_unix_code_fixed_width_for_japanese'  :   19,
                  'cseucfixwidjapanese'                          :   19,
                  'iso-10646-ucs-basic'                          : 1002,
                  'csunicodeascii'                               : 1002,
                  'iso-10646-unicode-latin1'                     : 1003,
                  'csunicodelatin1'                              : 1003,
                  'iso-10646'                                    : 1003,
                  'iso-unicode-ibm-1261'                         : 1005,
                  'csunicodeibm1261'                             : 1005,
                  'iso-unicode-ibm-1268'                         : 1006,
                  'csunidoceibm1268'                             : 1006,
                  'iso-unicode-ibm-1276'                         : 1007,
                  'csunicodeibm1276'                             : 1007,
                  'iso-unicode-ibm-1264'                         : 1008,
                  'csunicodeibm1264'                             : 1008,
                  'iso-unicode-ibm-1265'                         : 1009,
                  'csunicodeibm1265'                             : 1009,
                  'iso-8859-1-windows-3.0-latin-1'               : 2000,
                  'cswindows30latin1'                            : 2000,
                  'iso-8859-1-windows-3.1-latin-1'               : 2001,
                  'cswindows31latin1'                            : 2001,
                  'iso-8859-2-windows-latin-2'                   : 2002,
                  'cswindows31latin2'                            : 2002,
                  'iso-8859-9-windows-latin-5'                   : 2003,
                  'cswindows31latin5'                            : 2003,
                  'adobe-standard-encoding'                      : 2005,
                  'csadobestandardencoding'                      : 2005,
                  'ventura-us'                                   : 2006,
                  'csventuraus'                                  : 2006,
                  'ventura-international'                        : 2007,
                  'csventurainternational'                       : 2007,
                  'pc8-danish-norwegian'                         : 2012,
                  'cspc8danishnorwegian'                         : 2012,
                  'pc8-turkish'                                  : 2014,
                  'cspc8turkish'                                 : 2014,
                  'ibm-symbols'                                  : 2015,
                  'csibmsymbols'                                 : 2015,
                  'ibm-thai'                                     : 2016,
                  'csibmthai'                                    : 2016,
                  'hp-legal'                                     : 2017,
                  'cshplegal'                                    : 2017,
                  'hp-pi-font'                                   : 2018,
                  'cshppifont'                                   : 2018,
                  'hp-math8'                                     : 2019,
                  'cshpmath8'                                    : 2019,
                  'adobe-symbol-encoding'                        : 2020,
                  'cshppsmath'                                   : 2020,
                  'hp-desktop'                                   : 2021,
                  'cshpdesktop'                                  : 2021,
                  'ventura-math'                                 : 2022,
                  'csventuramath'                                : 2022,
                  'microsoft-publishing'                         : 2023,
                  'csmicrosoftpublishing'                        : 2023,
                  'windows-31j'                                  : 2024,
                  'cswindows31j'                                 : 2024,
                  'gb2312'                                       : 2025,
                  'csgb2312'                                     : 2025,
                  'big5'                                         : 2026,
                  'csbig5'                                       : 2026,
                  'windows-1250'                                 : 2250,
                  'windows-1251'                                 : 2251,
                  'windows-1252'                                 : 2252,
                  'windows-1253'                                 : 2253,
                  'windows-1254'                                 : 2254,
                  'windows-1255'                                 : 2255,
                  'windows-1256'                                 : 2256,
                  'windows-1257'                                 : 2257,
                  'windows-1258'                                 : 2258,
                  'tis-620'                                      : 2259,
                  'hz-gb-2312'                                   : 2085,
                }


MIBenumNames = {
                     3 : 'US-ASCII',
                    27 : 'ISO-10646-UTF-1',
                    28 : 'ISO_646.basic:1983',
                    29 : 'INVARIANT',
                    30 : 'ISO_646.irv:1983',
                    20 : 'BS_4730',
                    31 : 'NATS-SEFI',
                    32 : 'NATS-SEFI-ADD',
                    33 : 'NATS-DANO',
                    34 : 'NATS-DANO-ADD',
                    35 : 'SEN_850200_B',
                    21 : 'SEN_850200_C',
                    36 : 'KS_C_5601-1987',
                    37 : 'ISO-2022-KR',
                    38 : 'EUC-KR',
                    39 : 'ISO-2022-JP',
                    40 : 'ISO-2022-JP-2',
                   104 : 'ISO-2022-CN',
                   105 : 'ISO-2022-CN-EXT',
                    41 : 'JIS_C6220-1969-jp',
                    42 : 'JIS_C6220-1969-ro',
                    22 : 'IT',
                    43 : 'PT',
                    23 : 'ES',
                    44 : 'greek7-old',
                    45 : 'latin-greek',
                    24 : 'DIN_66003',
                    46 : 'NF_Z_62-010_(1973)',
                    47 : 'Latin-greek-1',
                    48 : 'ISO_5427',
                    49 : 'JIS_C6226-1978',
                    50 : 'BS_viewdata',
                    51 : 'INIS',
                    52 : 'INIS-8',
                    53 : 'INIS-cyrillic',
                    54 : 'ISO_5427:1981',
                    55 : 'ISO_5428:1980',
                    56 : 'GB_1988-80',
                    57 : 'GB_2312-80',
                    25 : 'NS_4551-1',
                    58 : 'NS_4551-2',
                    26 : 'NF_Z_62-010',
                    59 : 'videotex-suppl',
                    60 : 'PT2',
                    61 : 'ES2',
                    62 : 'MSZ_7795.3',
                    63 : 'JIS_C6226-1983',
                    64 : 'greek7',
                    65 : 'ASMO_449',
                    66 : 'iso-ir-90',
                    67 : 'JIS_C6229-1984-a',
                    68 : 'JIS_C6229-1984-b',
                    69 : 'JIS_C6229-1984-b-add',
                    70 : 'JIS_C6229-1984-hand',
                    71 : 'JIS_C6229-1984-hand-add',
                    72 : 'JIS_C6229-1984-kana',
                    73 : 'ISO_2033-1983',
                    74 : 'ANSI_X3.110-1983',
                     4 : 'ISO-8859-1',
                     5 : 'ISO-8859-2',
                    75 : 'T.61-7bit',
                    76 : 'T.61-8bit',
                     6 : 'ISO-8859-3',
                     7 : 'ISO-8859-4',
                    77 : 'ECMA-cyrillic',
                    78 : 'CSA_Z243.4-1985-1',
                    79 : 'CSA_Z243.4-1985-2',
                    80 : 'CSA_Z243.4-1985-gr',
                     9 : 'ISO-8859-6',
                    81 : 'ISO-8859-6-E',
                    82 : 'ISO-8859-6-I',
                    10 : 'ISO-8859-7',
                    83 : 'T.101-G2',
                    11 : 'ISO-8859-8',
                    84 : 'ISO-8859-8-E',
                    85 : 'ISO-8859-8-I',
                    86 : 'CSN_369103',
                    87 : 'JUS_I.B1.002',
                    14 : 'ISO_6937-2-add',
                    88 : 'IEC_P27-1',
                     8 : 'ISO-8859-5',
                    89 : 'JUS_I.B1.003-serb',
                    90 : 'JUS_I.B1.003-mac',
                    12 : 'ISO-8859-9',
                    91 : 'greek-ccitt',
                    92 : 'NC_NC00-10:81',
                    93 : 'ISO_6937-2-25',
                    94 : 'GOST_19768-74',
                    95 : 'ISO_8859-supp',
                    96 : 'ISO_10367-box',
                    13 : 'ISO-8859-10',
                    97 : 'latin-lap',
                    98 : 'JIS_X0212-1990',
                    99 : 'DS_2089',
                   100 : 'us-dk',
                   101 : 'dk-us',
                    15 : 'JIS_X0201',
                   102 : 'KSC5636',
                  1000 : 'ISO-10646-UCS-2',
                  1001 : 'ISO-10646-UCS-4',
                  2008 : 'DEC-MCS',
                  2004 : 'hp-roman8',
                  2027 : 'macintosh',
                  2028 : 'IBM037',
                  2029 : 'IBM038',
                  2030 : 'IBM273',
                  2031 : 'IBM274',
                  2032 : 'IBM275',
                  2033 : 'IBM277',
                  2034 : 'IBM278',
                  2035 : 'IBM280',
                  2036 : 'IBM281',
                  2037 : 'IBM284',
                  2038 : 'IBM285',
                  2039 : 'IBM290',
                  2040 : 'IBM297',
                  2041 : 'IBM420',
                  2042 : 'IBM423',
                  2043 : 'IBM424',
                  2011 : 'IBM437',
                  2044 : 'IBM500',
                  2087 : 'IBM775',
                  2009 : 'IBM850',
                  2045 : 'IBM851',
                  2010 : 'IBM852',
                  2046 : 'IBM855',
                  2047 : 'IBM857',
                  2048 : 'IBM860',
                  2049 : 'IBM861',
                  2013 : 'IBM862',
                  2050 : 'IBM863',
                  2051 : 'IBM864',
                  2052 : 'IBM865',
                  2086 : 'IBM866',
                  2053 : 'IBM868',
                  2054 : 'IBM869',
                  2055 : 'IBM870',
                  2056 : 'IBM871',
                  2057 : 'IBM880',
                  2058 : 'IBM891',
                  2059 : 'IBM903',
                  2060 : 'IBM904',
                  2061 : 'IBM905',
                  2062 : 'IBM918',
                  2063 : 'IBM1026',
                  2064 : 'EBCDIC-AT-DE',
                  2065 : 'EBCDIC-AT-DE-A',
                  2066 : 'EBCDIC-CA-FR',
                  2067 : 'EBCDIC-DK-NO',
                  2068 : 'EBCDIC-DK-NO-A',
                  2069 : 'EBCDIC-FI-SE',
                  2070 : 'EBCDIC-FI-SE-A',
                  2071 : 'EBCDIC-FR',
                  2072 : 'EBCDIC-IT',
                  2073 : 'EBCDIC-PT',
                  2074 : 'EBCDIC-ES',
                  2075 : 'EBCDIC-ES-A',
                  2076 : 'EBCDIC-ES-S',
                  2077 : 'EBCDIC-UK',
                  2078 : 'EBCDIC-US',
                  2079 : 'UNKNOWN-8BIT',
                  2080 : 'MNEMONIC',
                  2081 : 'MNEM',
                  2082 : 'VISCII',
                  2083 : 'VIQR',
                  2084 : 'KOI8-R',
                  2088 : 'KOI8-U',
                  2089 : 'IBM00858',
                  2090 : 'IBM00924',
                  2091 : 'IBM01140',
                  2092 : 'IBM01141',
                  2093 : 'IBM01142',
                  2094 : 'IBM01143',
                  2095 : 'IBM01144',
                  2096 : 'IBM01145',
                  2097 : 'IBM01146',
                  2098 : 'IBM01147',
                  2099 : 'IBM01148',
                  2100 : 'IBM01149',
                  2101 : 'Big5-HKSCS',
                  1010 : 'UNICODE-1-1',
                  1011 : 'SCSU',
                  1012 : 'UTF-7',
                  1013 : 'UTF-16BE',
                  1014 : 'UTF-16LE',
                  1015 : 'UTF-16',
                   103 : 'UNICODE-1-1-UTF-7',
                   106 : 'UTF-8',
                   109 : 'ISO-8859-13',
                   110 : 'ISO-8859-14',
                   111 : 'ISO-8859-15',
                   112 : 'ISO-8859-16',
                    16 : 'JIS_Encoding',
                    17 : 'Shift_JIS',
                    18 : 'EUC-JP',
                    19 : 'Extended_UNIX_Code_Fixed_Width_for_Japanese',
                  1002 : 'ISO-10646-UCS-Basic',
                  1003 : 'ISO-10646-Unicode-Latin1',
                  1005 : 'ISO-Unicode-IBM-1261',
                  1006 : 'ISO-Unicode-IBM-1268',
                  1007 : 'ISO-Unicode-IBM-1276',
                  1008 : 'ISO-Unicode-IBM-1264',
                  1009 : 'ISO-Unicode-IBM-1265',
                  2000 : 'ISO-8859-1-Windows-3.0-Latin-1',
                  2001 : 'ISO-8859-1-Windows-3.1-Latin-1',
                  2002 : 'ISO-8859-2-Windows-Latin-2',
                  2003 : 'ISO-8859-9-Windows-Latin-5',
                  2005 : 'Adobe-Standard-Encoding',
                  2006 : 'Ventura-US',
                  2007 : 'Ventura-International',
                  2012 : 'PC8-Danish-Norwegian',
                  2014 : 'PC8-Turkish',
                  2015 : 'IBM-Symbols',
                  2016 : 'IBM-Thai',
                  2017 : 'HP-Legal',
                  2018 : 'HP-Pi-font',
                  2019 : 'HP-Math8',
                  2020 : 'Adobe-Symbol-Encoding',
                  2021 : 'HP-DeskTop',
                  2022 : 'Ventura-Math',
                  2023 : 'Microsoft-Publishing',
                  2024 : 'Windows-31J',
                  2025 : 'GB2312',
                  2026 : 'Big5',
                  2250 : 'windows-1250',
                  2251 : 'windows-1251',
                  2252 : 'windows-1252',
                  2253 : 'windows-1253',
                  2254 : 'windows-1254',
                  2255 : 'windows-1255',
                  2256 : 'windows-1256',
                  2257 : 'windows-1257',
                  2258 : 'windows-1258',
                  2259 : 'TIS-620',
                  2085 : 'HZ-GB-2312',
               }


############### STOP PASTE HERE ######################################

def charset_name_to_mibenum(name):
    if name is None or type(name) != type(''):
        return None
    name = string.lower(name)
    if re.match('^[0-9]+$', name):
        return int(name)
    elif NamedCharsets.has_key(name):
        return NamedCharsets[name] & 0xFFFF
    else:
        return None

def charset_mibenum_to_name(mibenum):
    return MIBenumNames.has_key(mibenum) and MIBenumNames[mibenum]

def charset_known_name (name):
    return type(name) == type('') and string.lower(name) in NamedCharsets.keys()

def charset_known_names ():
    return NamedCharsets.keys()


if __name__ == '__main__':

    #Here could be add some "name" and "MIBenum" pairs thats not in the list.
    ADDITIONAL = [
                   ['TACTIS',    2259],
                   ['utf8'  ,     106],
                   ['ISO-646DK',   99],
                   ['utf',        106],
                   ['SJIS',        17],
                   ['JIS7',        39],
                   ['ISO8859-15', 111],
                   ['eucJP',       18],
                   ['eucCN',     2025],
                   ['eucKR',       38],
                   ['ISO8859-1',    4],
                   ['ISO8859-2',    5],
                   ['ISO8859-3',    6],
                   ['ISO8859-4',    7],
                   ['ISO8859-5',    8],
                   ['ISO8859-6',    9],
                   ['ISO8859-7',   10],
                   ['ISO8859-8',   11],
                   ['eucTW',     2026]
                 ]

    # Called as a script
    if len(sys.argv) != 2:
        print "Usage: %s <MIBenum textfile>" % sys.argv[0]
        print "  Example: %s character-sets.txt > arrays.txt" % sys.argv[0]
    else:
        #Read and parse the file an put the result to ENTRYS
        IN_BODY = 0
        #ENTRYS hold an array of ENTRY
        ENTRYS = []
        #ENTRY hold an array. The first element are the MIBEnum, the second an
        #index (starting at zero) to the preferred name for the names array, the
        #third is an array of all the names for this charset. For Example: This:
        #-----------------------
        #Name: ISO_8859-1:1987                                    [RFC1345,KXS2]
        #MIBenum: 4
        #Source: ECMA registry
        #Alias: iso-ir-100
        #Alias: ISO_8859-1
        #Alias: ISO-8859-1 (preferred MIME name)
        #Alias: latin1
        #Alias: l1
        #Alias: IBM819
        #Alias: CP819
        #Alias: csISOLatin1
        #-----------------------
        #Will be:
        #[4, 3, ['ISO_8859-1:1987', 'iso-ir-100', 'ISO_8859-1', 'ISO-8859-1', 'latin1', 'l1', 'IBM819', 'CP819', 'csISOLatin1']]
        ENTRY = [None,None,None]
        NAMES = []
        MIBENUM = 0
        PREFERRED = 0
        MAX_NAME_LENGTH = 0
        sys.stderr.write("Reading File: %s\n" % sys.argv[1])
        sys.stderr.write("Parsing File...\n")
        f = open (sys.argv[1], "r")
        for line in f.readlines():
            if not IN_BODY:
                #After that the list of Charsets starts
                match = re.search(r"^-{13} {47}-{9}$", line)
                if match:
                    IN_BODY = 1
            elif IN_BODY:
                #With this line the list end
                match = re.search(r"^REFERENCES.*$", line)
                if not match:
                    match = re.search(r"^Name\: {1,10}(.*?)(?: |\t){0,100}(\(preferred MIME name\)){0,1}(?: |\t){0,100}(?:\[.{1,20}\]){0,1}(?: |\t){0,5}$", line)
                    if match:
                        if NAMES != []:
                            if MIBENUM != 0:
                                ENTRY[0]=MIBENUM
                                ENTRY[1]=PREFERRED
                                ENTRY[2]=NAMES
                                ENTRYS.append(ENTRY);
                            ENTRY = [None,None,None]
                            MIBENUM=0
                            NAMES = []
                            PREFERRED = 0
                        NAMES.append(match.group(1))
                        if len(match.group(1)) > MAX_NAME_LENGTH:
                            MAX_NAME_LENGTH = len(match.group(1))
                    match = re.search(r"^MIBenum\: {1,10}(\d*?)(?: |\t){0,5}$", line)
                    if match:
                        MIBENUM = string.atoi(match.group(1))
                    match = re.search(r"^Alias\: {1,10}(.*?)(?: |\t){0,100}(\(preferred MIME name\)){0,1}(?: |\t){0,5}$", line)
                    if match:
                        if (string.upper(match.group(1)) != "NONE") and (len(match.group(1))>0):
                            NAMES.append(match.group(1))
                            if len(match.group(1)) > MAX_NAME_LENGTH:
                                MAX_NAME_LENGTH = len(match.group(1))
                            if match.group(2) != None:
                                PREFERRED = len(NAMES)-1
        if NAMES != []:
            ENTRY[0]=MIBENUM
            ENTRY[1]=PREFERRED
            ENTRY[2]=NAMES
            ENTRYS.append(ENTRY);
        f.close ()
        sys.stderr.write("Done! Found %d Charsets\n" % len(ENTRYS))

        print "\n"

        sys.stderr.write("Create \"NamedCharsets\" Array...\n")
        #Now write the first array (NamedCharsets)
        print "NamedCharsets = {"
        for PAIR in ADDITIONAL:
            print "\t\t  '%s'%s: %4d," % (string.lower(PAIR[0]), \
                                        " "*(MAX_NAME_LENGTH-len(PAIR[0])), \
                                        #"\t\t", \
                                        PAIR[1])
        for ENTRY in ENTRYS:
            for NAME in ENTRY[2]:
                print "\t\t  '%s'%s: %4d," % (string.lower(NAME), \
                                            " "*(MAX_NAME_LENGTH-len(NAME)), \
                                            #"\t\t", \
                                            ENTRY[0])
        print "\t\t}"

        print "\n\n\n"

        sys.stderr.write("Create \"MIBenumNames\" Array...\n")
        #Now write the second array (MIBenumNames)
        print "MIBenumNames = {"
        for ENTRY in ENTRYS:
            print "\t\t  %4d : '%s'," % (ENTRY[0], ENTRY[2][ENTRY[1]])
        print "\t       }"

        print "\n"

        sys.stderr.write("All done!\n")
