/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.PixelProcessor;
import com.sixlegs.png.PngException;
import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class Defilterer {
    private final InputStream in;
    private final int width;
    private final int bitDepth;
    private final int samples;
    private final PixelProcessor pp;
    private final int bpp;
    private final int[] row;
    private static int[][] bandOffsets = new int[][]{null, {0}, {0, 1}, {0, 1, 2}, {0, 1, 2, 3}};

    public Defilterer(InputStream in, int bitDepth, int samples, int width, PixelProcessor pp) {
        this.in = in;
        this.bitDepth = bitDepth;
        this.samples = samples;
        this.width = width;
        this.pp = pp;
        this.bpp = Math.max(1, bitDepth * samples >> 3);
        this.row = new int[samples * width];
    }

    public boolean defilter(int xOffset, int yOffset, int xStep, int yStep, int passWidth, int passHeight) throws IOException {
        if (passWidth == 0 || passHeight == 0) {
            return true;
        }
        int bytesPerRow = (this.bitDepth * this.samples * passWidth + 7) / 8;
        boolean isShort = this.bitDepth == 16;
        WritableRaster passRow = Defilterer.createInputRaster(this.bitDepth, this.samples, this.width);
        DataBuffer dbuf = passRow.getDataBuffer();
        byte[] byteData = isShort ? null : ((DataBufferByte)dbuf).getData();
        short[] shortData = isShort ? ((DataBufferUShort)dbuf).getData() : null;
        int rowSize = bytesPerRow + this.bpp;
        byte[] prev = new byte[rowSize];
        byte[] cur = new byte[rowSize];
        int srcY = 0;
        int dstY = yOffset;
        while (srcY < passHeight) {
            int filterType = this.in.read();
            if (filterType == -1) {
                throw new EOFException("Unexpected end of image data");
            }
            Defilterer.readFully(this.in, cur, this.bpp, bytesPerRow);
            Defilterer.defilter(cur, prev, this.bpp, filterType);
            if (isShort) {
                int c = 0;
                for (int i = this.bpp; i < rowSize; i += 2) {
                    shortData[c] = (short)(cur[i] << 8 | 0xFF & cur[i + 1]);
                    ++c;
                }
            } else {
                System.arraycopy(cur, this.bpp, byteData, 0, bytesPerRow);
            }
            passRow.getPixels(0, 0, passWidth, 1, this.row);
            if (!this.pp.process(this.row, xOffset, xStep, yStep, dstY, passWidth)) {
                return false;
            }
            byte[] tmp = cur;
            cur = prev;
            prev = tmp;
            ++srcY;
            dstY += yStep;
        }
        return true;
    }

    private static void defilter(byte[] cur, byte[] prev, int bpp, int filterType) throws PngException {
        int rowSize = cur.length;
        switch (filterType) {
            case 0: {
                break;
            }
            case 1: {
                int xc = bpp;
                int xp = 0;
                while (xc < rowSize) {
                    cur[xc] = (byte)(cur[xc] + cur[xp]);
                    ++xc;
                    ++xp;
                }
                break;
            }
            case 2: {
                for (int xc = bpp; xc < rowSize; ++xc) {
                    cur[xc] = (byte)(cur[xc] + prev[xc]);
                }
                break;
            }
            case 3: {
                int xc = bpp;
                int xp = 0;
                while (xc < rowSize) {
                    cur[xc] = (byte)(cur[xc] + ((0xFF & cur[xp]) + (0xFF & prev[xc])) / 2);
                    ++xc;
                    ++xp;
                }
                break;
            }
            case 4: {
                int xc = bpp;
                int xp = 0;
                while (xc < rowSize) {
                    int pc;
                    int pb;
                    byte L = cur[xp];
                    int a = 0xFF & L;
                    byte u = prev[xc];
                    int b = 0xFF & u;
                    byte nw = prev[xp];
                    int c = 0xFF & nw;
                    int p = a + b - c;
                    int pa = p - a;
                    if (pa < 0) {
                        pa = -pa;
                    }
                    if ((pb = p - b) < 0) {
                        pb = -pb;
                    }
                    if ((pc = p - c) < 0) {
                        pc = -pc;
                    }
                    int result = pa <= pb && pa <= pc ? a : (pb <= pc ? b : c);
                    cur[xc] = (byte)(cur[xc] + result);
                    ++xc;
                    ++xp;
                }
                break;
            }
            default: {
                throw new PngException("Unrecognized filter type " + filterType, true);
            }
        }
    }

    private static WritableRaster createInputRaster(int bitDepth, int samples, int width) {
        int rowSize = (bitDepth * samples * width + 7) / 8;
        Point origin = new Point(0, 0);
        if (bitDepth < 8 && samples == 1) {
            DataBufferByte dbuf = new DataBufferByte(rowSize);
            return Raster.createPackedRaster(dbuf, width, 1, bitDepth, origin);
        }
        if (bitDepth <= 8) {
            DataBufferByte dbuf = new DataBufferByte(rowSize);
            return Raster.createInterleavedRaster(dbuf, width, 1, rowSize, samples, bandOffsets[samples], origin);
        }
        DataBufferUShort dbuf = new DataBufferUShort(rowSize / 2);
        return Raster.createInterleavedRaster(dbuf, width, 1, rowSize / 2, samples, bandOffsets[samples], origin);
    }

    private static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        int result;
        for (int total = 0; total < len; total += result) {
            result = in.read(b, off + total, len - total);
            if (result != -1) continue;
            throw new EOFException("Unexpected end of image data");
        }
    }
}

