/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.asm.ClassReader;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

class IoUtils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private IoUtils() {
    }

    public static ClassReader readClass(InputStream in) throws IOException {
        try {
            return new ClassReader(in);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassFormatError(e.getMessage());
        }
    }

    public static String readIntoString(InputStream in) throws IOException {
        StringBuffer sb = new StringBuffer();
        BufferedReader r = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        String line = null;
        while ((line = r.readLine()) != null) {
            sb.append(line).append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public static String escapeStringLiteral(String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        char[] chars = value.toCharArray();
        int size = chars.length;
        block9: for (int i = 0; i < size; ++i) {
            char ch = chars[i];
            switch (ch) {
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    public static byte[] toByteArray(InputStream is, byte[] buf) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IoUtils.pipe(is, baos, buf);
        return baos.toByteArray();
    }

    public static void pipe(InputStream is, OutputStream out, byte[] buf) throws IOException {
        int amt;
        while ((amt = is.read(buf)) >= 0) {
            out.write(buf, 0, amt);
        }
    }
}

