(*
	Copyright (c) 2001
		David C.J. Matthews

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.
	
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*)

structure Locale:
sig
    datatype PrimaryLanguage =
          LANG_AFRIKAANS | LANG_ALBANIAN | LANG_ARABIC | LANG_BASQUE | LANG_BELARUSIAN
        | LANG_BULGARIAN | LANG_CATALAN | LANG_CHINESE | LANG_CROATIAN | LANG_CZECH
        | LANG_DANISH | LANG_DUTCH | LANG_ENGLISH | LANG_ESTONIAN | LANG_FAEROESE
        | LANG_FARSI | LANG_FINNISH | LANG_FRENCH | LANG_GERMAN | LANG_GREEK | LANG_HEBREW
        | LANG_HUNGARIAN | LANG_ICELANDIC | LANG_INDONESIAN | LANG_ITALIAN | LANG_JAPANESE
        | LANG_KOREAN | LANG_LATVIAN | LANG_LITHUANIAN | LANG_NORWEGIAN | LANG_POLISH
		| LANG_PORTUGUESE | LANG_ROMANIAN | LANG_RUSSIAN | LANG_SERBIAN | LANG_SLOVAK
		| LANG_SLOVENIAN | LANG_SPANISH | LANG_SWEDISH | LANG_THAI | LANG_TURKISH
		| LANG_UKRANIAN | LANG_VIETNAMESE | LANG_NEUTRAL
    datatype SubLanguage =
          SUBLANG_ARABIC_ALGERIA | SUBLANG_ARABIC_BAHRAIN | SUBLANG_ARABIC_EGYPT
        | SUBLANG_ARABIC_IRAQ | SUBLANG_ARABIC_JORDAN | SUBLANG_ARABIC_KUWAIT
        | SUBLANG_ARABIC_LEBANON | SUBLANG_ARABIC_LIBYA | SUBLANG_ARABIC_MOROCCO
        | SUBLANG_ARABIC_OMAN | SUBLANG_ARABIC_QATAR | SUBLANG_ARABIC_SAUDI_ARABIA
        | SUBLANG_ARABIC_SYRIA | SUBLANG_ARABIC_TUNISIA | SUBLANG_ARABIC_UAE
        | SUBLANG_ARABIC_YEMEN | SUBLANG_CHINESE_HONGKONG | SUBLANG_CHINESE_SIMPLIFIED
        | SUBLANG_CHINESE_SINGAPORE | SUBLANG_CHINESE_TRADITIONAL | SUBLANG_DUTCH
        | SUBLANG_DUTCH_BELGIAN | SUBLANG_ENGLISH_AUS | SUBLANG_ENGLISH_BELIZE
        | SUBLANG_ENGLISH_CAN | SUBLANG_ENGLISH_CARIBBEAN | SUBLANG_ENGLISH_EIRE
        | SUBLANG_ENGLISH_JAMAICA | SUBLANG_ENGLISH_NZ | SUBLANG_ENGLISH_SOUTH_AFRICA
        | SUBLANG_ENGLISH_TRINIDAD | SUBLANG_ENGLISH_UK | SUBLANG_ENGLISH_US
        | SUBLANG_FRENCH | SUBLANG_FRENCH_BELGIAN | SUBLANG_FRENCH_CANADIAN
        | SUBLANG_FRENCH_LUXEMBOURG | SUBLANG_FRENCH_SWISS | SUBLANG_GERMAN
        | SUBLANG_GERMAN_AUSTRIAN | SUBLANG_GERMAN_LIECHTENSTEIN
        | SUBLANG_GERMAN_LUXEMBOURG | SUBLANG_GERMAN_SWISS | SUBLANG_ITALIAN
        | SUBLANG_ITALIAN_SWISS | SUBLANG_KOREAN | SUBLANG_KOREAN_JOHAB
        | SUBLANG_NORWEGIAN_BOKMAL | SUBLANG_NORWEGIAN_NYNORSK | SUBLANG_PORTUGUESE
        | SUBLANG_PORTUGUESE_BRAZILIAN | SUBLANG_SERBIAN_CYRILLIC | SUBLANG_SERBIAN_LATIN
        | SUBLANG_SPANISH | SUBLANG_SPANISH_ARGENTINA | SUBLANG_SPANISH_BOLIVIA
        | SUBLANG_SPANISH_CHILE | SUBLANG_SPANISH_COLOMBIA | SUBLANG_SPANISH_COSTA_RICA
        | SUBLANG_SPANISH_DOMINICAN_REPUBLIC | SUBLANG_SPANISH_ECUADOR
        | SUBLANG_SPANISH_EL_SALVADOR | SUBLANG_SPANISH_GUATEMALA | SUBLANG_SPANISH_HONDURAS
        | SUBLANG_SPANISH_MEXICAN | SUBLANG_SPANISH_MODERN | SUBLANG_SPANISH_NICARAGUA
        | SUBLANG_SPANISH_PANAMA | SUBLANG_SPANISH_PARAGUAY | SUBLANG_SPANISH_PERU
        | SUBLANG_SPANISH_PUERTO_RICO | SUBLANG_SPANISH_URUGUAY | SUBLANG_SPANISH_VENEZUELA
        | SUBLANG_SWEDISH | SUBLANG_SWEDISH_FINLAND
        | SUBLANG_NEUTRAL | SUBLANG_DEFAULT | SUBLANG_SYS_DEFAULT

    datatype LANGID = MAKELANGID of PrimaryLanguage * SubLanguage
	val GetUserDefaultLangID: unit -> LANGID
	and GetSystemDefaultLangID: unit -> LANGID
end =
struct
	local
		open CInterface Base
	in
		open LocaleBase
		val GetUserDefaultLangID = call0 (kernel "GetUserDefaultLangID") () LANGID
		and GetSystemDefaultLangID = call0 (kernel "GetSystemDefaultLangID") () LANGID
	end
end;
