#ifndef __INCLUDE_GUARD_CCS_H
#define __INCLUDE_GUARD_CCS_H

const char css[] = 
	"<!DOCTYPE html>\n"
	"<html lang='en'>\n"
	"<head>\n"
	"<title>PowerTOP report</title>\n"
	"<meta http-equiv='content-type' content='text/html;charset=utf-8'>\n"
	"\n"
	"<script type='text/javascript'>\n"
	"\n"
	"var powertop = {\n"
	" blocks: {\n"
	"  summary: 'Summary',\n"
	"  cpuidle: 'CPU Idle',\n"
	"  cpufreq: 'CPU Frequency',\n"
	"  software: 'Software Info',\n"
	"  devinfo: 'Device Info',\n"
	"  tuning: 'Tuning',\n"
	"  ahci: 'AHCI'\n"
	" },\n"
	" cadd: function(idx, c){\n"
	"   var el = document.getElementById(idx);\n"
	"   if (el) {\n"
	"      var cn = el.className;\n"
	"      if (cn.indexOf(c) != -1)\n"
	"         return;\n"
	"      cn += ' ' + c;\n"
	"      el.className = cn;\n"
	"   }\n"
	" },\n"
	" crm: function(id, c){\n"
	"   var el = document.getElementById(id);\n"
	"   if (el) {\n"
	"      var cn = el.className\n"
	"      while (cn.indexOf(' ' + c) != -1)\n"
	"         cn = cn.replace(' ' + c,'');\n"
	"      el.className = cn;\n"
	"   }\n"
	" },\n"
	" newbutton: function(id, txt) {\n"
	"  var x = document.createElement('div');\n"
	"  x.id = id + '_button';\n"
	"  x.className = 'nav_button';\n"
	"  x.textContent = txt;\n"
	"  x.innerText = txt;\n"
	"  x.onclick = function() { powertop.toggle(id); };\n"
	"  return x;\n"
	" },\n"
	" setupbuttons: function() {\n"
	"   var t = document.getElementById('main_menu');\n"
	"   if (t) {\n"
	"     for (var b in powertop.blocks) {\n"
	"       t.appendChild(powertop.newbutton(b, powertop.blocks[b]));\n"
	"     }\n"
	"    t.appendChild(powertop.newbutton('all', 'All'));\n"
	"   }\n"
	" },\n"
	" toggle: function(b) {\n"
	"   powertop.baseall();\n"
	"   if (b == 'all') {\n"
	"      for (var c in powertop.blocks) {\n"
	"        powertop.crm(c, 'hide');\n"
	"      }\n"
	"   } else {\n"
	"      powertop.crm(b, 'hide');\n"
	"   }\n"
	"   powertop.cadd(b + '_button', 'pressed');\n"
	" },\n"
	" baseall: function() {\n"
	"   for (var b in powertop.blocks) {\n"
	"     powertop.cadd(b, 'hide');\n"
	"     powertop.crm(b + '_button', 'pressed');\n"
	"   }\n"
	"   powertop.cadd('all', 'hide');\n"
	"   powertop.crm('all_button', 'pressed');\n"
	" },\n"
	" onload: function() {\n"
	"   powertop.setupbuttons();\n"
	"   powertop.toggle('summary');\n"
	" }\n"
	"}\n"
	"</script>\n"
	"\n"
	"<style type='text/css'>\n"
	"/* General CSS */\n"
	"*{\n"
	"	margin:0px;\n"
	"	padding:0px;\n"
	"}\n"
	"\n"
	"body {\n"
	"	background-color: #eee; /* Background color */\n"
	"	color: #222;            /* Font color */\n"
	"	font-family: Helvetica;\n"
	"	font-size: 14px;\n"
	"}\n"
	"\n"
	"#main_container{\n"
	"	width: 960px;\n"
	"	margin: 2px auto;\n"
	"}\n"
	"\n"
	"/* Top logo & system table css */\n"
	"#main_header{\n"
	"	min-width: 960px;\n"
	"	display:block;\n"
	"}\n"
	"\n"
	"img.pwtop_logo{\n"
	"	float:left;\n"
	"	height:40%;\n"
	"	width: 40%;\n"
	"	padding:20px;\n"
	"}\n"
	"\n"
	".sys_info\n"
	"{\n"
	"	float: left;\n"
	"	height:116px;\n"
	"	width:450px;\n"
	"	font-size: 12px;\n"
	"	display: inline;\n"
	"	position: relative;\n"
	"	text-align: left;\n"
	"}\n"
	"\n"
	"th{\n"
	"	text-align: left;\n"
	"}\n"
	"\n"
	"/* CSS Main Content */\n"
	"\n"
	".content_title\n"
	"{\n"
	"	color: #296629;\n"
	"	padding:0px;\n"
	"	margin:2px;\n"
	"}\n"
	"\n"
	"#chart_div{\n"
	"	float: left;\n"
	"}\n"
	"\n"
	".small\n"
	"{\n"
	"	font-size: 10px;\n"
	"}\n"
	"\n"
	"table.emphasis2\n"
	"{\n"
	"	font-size: 13px;\n"
	"	max-width:95%;\n"
	"}\n"
	"\n"
	"\n"
	"th.emph_title {\n"
	"	padding:5px;\n"
	"}\n"
	"\n"
	"tr.emph1:nth-child(odd) {\n"
	"	background: #ffffff;\n"
	"}\n"
	"\n"
	"tr.emph1:nth-child(even) {\n"
	"	background: #ebebeb;\n"
	"}\n"
	"\n"
	"tr.tune:nth-child(odd) {\n"
	"	background: #fffcfc;\n"
	"}\n"
	"tr.tune:nth-child(even) {\n"
	"	background: #fff0f0;\n"
	"}\n"
	"\n"
	"td.no_wrap:first-child {\n"
	"	white-space:nowrap;\n"
	"}\n"
	"\n"
	".side_by_side_left{\n"
	"	float:left;\n"
	"}\n"
	".side_by_side_right{\n"
	"	float:right;\n"
	"}\n"
	"\n"
	"#device{\n"
	"	display: inline-block;\n"
	"}\n"
	".clear_block{\n"
	"	clear:both;\n"
	"}\n"
	"\n"
	"td.package{\n"
	"	background-color: #e0ddfa; /*purple*/\n"
	"}\n"
	"\n"
	"td.core{\n"
	"	background-color: #d1ddff; /*ccebff; /*blue*/\n"
	"}\n"
	"\n"
	"td.cpu{\n"
	"	background-color: #ffffeb; /* yellow */\n"
	"}\n"
	"\n"
	"th.title{\n"
	"	text-align: center;\n"
	"	/*border-bottom: 1px solid #666;*/\n"
	"}\n"
	"\n"
	"\n"
	"li.summary_list\n"
	"{\n"
	"	display: inline;\n"
	"	padding: 5px;\n"
	"	background-color: #f6f6f9;\n"
	"	font-size: 12px;\n"
	"}\n"
	"\n"
	"\n"
	"\n"
	"/* main menu css*/\n"
	"#main_menu {\n"
	"	display: inline-block;\n"
	"	font-weight: bold;\n"
	"	padding: 5px 0;\n"
	"	text-align: center;\n"
	"	background-image: -webkit-gradient(linear, left top, left bottom,\n"
	"		from(#aaa), to(#eee));\n"
	"	background: -moz-linear-gradient(top,  #aaa,  #eee);\n"
	"}\n"
	"\n"
	"\n"
	"#main_menu div {\n"
	"	font-size: 12px;\n"
	"	font-weight: bold;\n"
	"	color: white;\n"
	"}\n"
	"\n"
	"#main_menu div.nav_button {\n"
	"	margin: 0 0.2em;\n"
	"	display: inline;\n"
	"	cursor: pointer;\n"
	"	color: #223232;\n"
	"	font-size: 13px;\n"
	"	font-weight: bold;\n"
	"	padding: 5px;\n"
	"	text-align: center;\n"
	"	text-decoration: none;\n"
	"}\n"
	"\n"
	"div.pressed {\n"
	"	border: -webkit-gradient(linear, left top, left bottom,\n"
	"		from(#b2ffb2), to(#e0ffe0));\n"
	"	border-width:0px 8px 0px 8px;\n"
	"	background: #999;\n"
	"	background-image: -webkit-gradient(linear, left top, left bottom,\n"
	"		from(#b2ffb2), to(#e0ffe0));\n"
	"	background: -moz-linear-gradient(top,  #b2ffb2,  #e0ffe0);\n"
	"}\n"
	"\n"
	"div.hide {\n"
	"	display: none;\n"
	"}\n"
	"</style>\n"
	"</head>\n"
	"\n"
	"<body onload='powertop.onload();'>\n"
	"<div id=\"main_container\">\n"
;
#endif
