/* $Cambridge: hermes/src/prayer/session/draft.h,v 1.4 2008/10/29 16:03:32 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

/* Data structures for message draft */

struct attlist {                /* List of attachments */
    struct attlist *next;       /* Linked list */
    void *hdr;                  /* Header block associated with attachment */
    unsigned long hdr_size;     /* Size of the header block */
    char *name;                 /* Filename for this attachment */
    char *type;                 /* Attachment type e.g: "application/octet-stream" */
    char *encoding;             /* Encoding for attachment e.g: "base64" */
    void *body;                 /* Attachment body */
    unsigned long size;         /* Attachment body size */
};

struct draft {
    BOOL have_draft;            /* Active draft */
    struct session *session;    /* Session associated with this draft */
    struct pool *pool;          /* Pool used for draft msg */
    struct role *role;          /* Current role */
    char *from_personal;        /* Personal component of from line */
    char *from_address;         /* Address component of from line */
    char *to;                   /* To line  */
    char *cc;                   /* Cc line  */
    char *bcc;                  /* Bcc line */
    char *fcc;                  /* Fcc line */
    char *reply_to;             /* Reply to line */
    char *subject;              /* Subject line */
    char *body;                 /* Body     */
    char *in_reply_to;          /* To make threading work */
    char *references;           /* To make threading work */
    struct attlist *attlist;    /* Linked list of attachments */
    BOOL save_copy;             /* Save copy to sent-mail folder */
    BOOL line_wrap;             /* Line wrap first component on send */
    unsigned long reply_validity;       /* UID validity for reply folder    */
    unsigned long reply_msgno;  /* Message is reply to this message */
    unsigned long reply_msguid; /* Message is reply to this message */
    char *reply_folder;         /* Message is reply to this message */
    BOOL rich_headers;          /* Show rich headers */
};

#define PREFERRED_DRAFT_BLOCK_SIZE (4096)

struct draft *draft_create(struct session *s);
void draft_free(struct draft *d);
void draft_copy(struct draft *dst, struct draft *src);

void draft_clear_hdrs(struct draft *d);
void draft_clear_body(struct draft *d);
void draft_init(struct draft *d);

void
draft_set_reply(struct draft *draft,
                MAILSTREAM * stream, char *foldername,
                unsigned long msgno);

void draft_update(struct draft *d, struct assoc *h);
void draft_update_body(struct draft *d, struct assoc *h);
void draft_add_to(struct draft *draft, char *s);
void draft_add_cc(struct draft *draft, char *s);
void draft_add_bcc(struct draft *draft, char *s);

void
draft_add_attachment(struct draft *d,
                     char *name, char *type, char *encoding,
                     char *hdr, unsigned long hdr_size,
                     char *msg, unsigned long msg_size);
void draft_delete_attachment(struct draft *d, unsigned long number);
unsigned long draft_att_count(struct draft *d);
unsigned long draft_att_size(struct draft *d);
void draft_clear_atts(struct draft *d);

void draft_line_wrap_body(struct draft *d);

void draft_role_set(struct draft *d, struct role *role);

void draft_rich_headers(struct draft *d, BOOL enable);
void draft_init_rich_headers(struct draft *d);

char *draft_make_recipients(struct draft *draft,
                            unsigned long *len,
                            unsigned long *countp);

char *draft_make_msg(struct draft *draft, BOOL postpone,
                     unsigned long *len);

/* Operations on postponed message list */

BOOL
draft_restore_postponed(struct draft *d, struct pool *pool,
                        MAILSTREAM * stream, long msgno);

BOOL draft_write(struct draft *draft);

BOOL draft_check(struct session *session);

BOOL draft_delete(struct session *session, unsigned long msgno);

BOOL draft_is_reply(struct draft *draft);

BOOL draft_flag_answered(struct draft *draft);
