/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.visitor.MemberVisitor;

public abstract class ProgramMember
implements Member {
    public int u2accessFlags;
    public int u2nameIndex;
    public int u2descriptorIndex;
    public int u2attributesCount;
    public Attribute[] attributes;
    public Object visitorInfo;

    protected ProgramMember() {
    }

    protected ProgramMember(int n, int n2, int n3, int n4, Attribute[] attributeArray) {
        this.u2accessFlags = n;
        this.u2nameIndex = n2;
        this.u2descriptorIndex = n3;
        this.u2attributesCount = n4;
        this.attributes = attributeArray;
    }

    public String getLineNumberRange(Clazz clazz) {
        CodeAttribute codeAttribute = (CodeAttribute)this.getAttribute(clazz, "Code");
        if (codeAttribute == null) {
            return null;
        }
        LineNumberTableAttribute lineNumberTableAttribute = (LineNumberTableAttribute)codeAttribute.getAttribute(clazz, "LineNumberTable");
        if (lineNumberTableAttribute == null) {
            return null;
        }
        return "" + lineNumberTableAttribute.getLineNumber(0) + ":" + lineNumberTableAttribute.getLineNumber(Integer.MAX_VALUE);
    }

    private Attribute getAttribute(Clazz clazz, String string) {
        for (int i = 0; i < this.u2attributesCount; ++i) {
            Attribute attribute = this.attributes[i];
            if (!attribute.getAttributeName(clazz).equals(string)) continue;
            return attribute;
        }
        return null;
    }

    public abstract void accept(ProgramClass var1, MemberVisitor var2);

    public abstract void attributesAccept(ProgramClass var1, AttributeVisitor var2);

    public int getAccessFlags() {
        return this.u2accessFlags;
    }

    public String getName(Clazz clazz) {
        return clazz.getString(this.u2nameIndex);
    }

    public String getDescriptor(Clazz clazz) {
        return clazz.getString(this.u2descriptorIndex);
    }

    public void accept(Clazz clazz, MemberVisitor memberVisitor) {
        this.accept((ProgramClass)clazz, memberVisitor);
    }

    public Object getVisitorInfo() {
        return this.visitorInfo;
    }

    public void setVisitorInfo(Object object) {
        this.visitorInfo = object;
    }
}

