/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class ClassPresenceFilter
implements ClassVisitor {
    private final ClassPool classPool;
    private final ClassVisitor presentClassVisitor;
    private final ClassVisitor missingClassVisitor;

    public ClassPresenceFilter(ClassPool classPool, ClassVisitor classVisitor, ClassVisitor classVisitor2) {
        this.classPool = classPool;
        this.presentClassVisitor = classVisitor;
        this.missingClassVisitor = classVisitor2;
    }

    public void visitProgramClass(ProgramClass programClass) {
        ClassVisitor classVisitor = this.classFileVisitor(programClass);
        if (classVisitor != null) {
            classVisitor.visitProgramClass(programClass);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        ClassVisitor classVisitor = this.classFileVisitor(libraryClass);
        if (classVisitor != null) {
            classVisitor.visitLibraryClass(libraryClass);
        }
    }

    private ClassVisitor classFileVisitor(Clazz clazz) {
        return this.classPool.getClass(clazz.getName()) != null ? this.presentClassVisitor : this.missingClassVisitor;
    }
}

