/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  net.h
 * Purpose: Header file for the network interface
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * Ethernet hardware address length:
 */
#define ETH_ZLEN	 60	/* Minimum size minus FCS */
#define ETH_ALEN          6	/* Bytes in one ethernet addr */
#define ETH_FLEN	  4	/* Bytes in FCS */
#define ETH_HLEN	 14	/* Total bytes in header */
#define ETH_DATA_MIN	 46	/* Min. bytes in payload */
#define ETH_DATA_MAX   1500	/* Max. bytes in payload */
#define ETH_FRAME_LEN  1514	/* Max. octets in frame sans FCS */

/*
 **************************************************************************
 *
 * Internet address length, and type:
 */
typedef unsigned long	t_ipaddr;

#define IP_ALEN		4



/*
 **************************************************************************
 *
 * Special internet addresses:
 */

/* Address to accept any incoming messages */
#define	IP_ANY		((t_ipaddr) 0x00000000L)

/* Address for a default route */
#define IP_DEFAULT	((t_ipaddr) 0x00000000L)

/* Address to send to all hosts */
#define	IP_BROADCAST	((t_ipaddr) 0xffffffffL)

/* Address to loopback in software to local host  */
#define	IP_LOCALHOST	((t_ipaddr) 0x7f000001L)

/* Address used in point-to-point links */
#define	IP_POINTOPOINT	((t_ipaddr) 0xffffffffL)

/* Netmask for class A network */
#define IN_CLASS_A(a)	(((a) & 0x80000000L) == 0L)
#define IP_CLASS_A	((t_ipaddr) 0xff000000L)

/* Netmask for class B network */
#define IN_CLASS_B(a)	(((a) & 0xc0000000L) == 0x80000000L)
#define IP_CLASS_B	((t_ipaddr) 0xffff0000L)

/* Netmask for class C network */
#define IN_CLASS_C(a)	(((a) & 0xe0000000L) == 0xc0000000L)
#define IP_CLASS_C	((t_ipaddr) 0xffffff00L)



/*
 **************************************************************************
 *
 * Routines to convert the host byte order into network byte order:
 */
extern unsigned short _htons __P((unsigned short));
extern unsigned long _htonl __P((unsigned long));
#define _ntohs _htons
#define _ntohl _htonl

#define htons _htons				/* short to net order	*/
#define htonl _htonl				/* long to net order	*/
#define ntohs _ntohs				/* net order to short	*/
#define ntohl _ntohl				/* net order to long	*/


/*
 **************************************************************************
 *
 * Public routines of the network interface library:
 */

/* Initialization of network library */
extern void init_net __P((void));

/* Configure interface addresses */
extern void if_config __P((t_ipaddr myip, t_ipaddr netmask));

/* Get hardware address */
extern void get_hw_addr __P((unsigned char *hwaddr));

/* Set default gateway */
extern void set_gateway __P((t_ipaddr gw));

/* Open a UDP socket */
extern int udp_open __P((t_ipaddr daddr, int source, int dest));

/* Read from a UDP socket */
extern int udp_read __P((char *buf, int bufsize, int timeout, char abortch));

/* Write to a UDP socket */
extern int udp_write __P((char *buf, int writelen));

/* Load/store unaligned 4-byte word */
extern unsigned int ld4(void *ptr);
extern void st4(void *ptr, unsigned int val);

/* Perform RARP discovery */
extern int rarp(void);
