/**
 ** Physical properties of Roxy.
 ** Copyright 2000 Sun Microsystems, Inc.
 ** This code is licensed under the GNU General Public License.
 **/

/*
 * Consolidated address space
 *
 * PCI has only configuration space addresses fixed,
 * I/O and memory addresses are assigned during configuration.
 * We list here addresses which a bound by hadrware or
 * known to be mapped by OBP in a certain location.
 * PCIC on IIep has a fixed translation area at the begining of PCI space.
 */
#define PHYS_JK_FLASH	0x20400000	/* [00800000] AM29LV081 */
#define PHYS_JK_PCI_IO	0x30000000	/* [10000] PCI I/O Cycle */
#define PHYS_JK_PCI_CFA	0x30080000	/* [x] Configuration address */
#define PHYS_JK_PCI_CFD	0x300A0000	/* [x] Configuration data */
#define PHYS_JK_PCIC	0x300C0000	/* [100] PCI Controller registers */
#define PHYS_JK_PCI_SPC	0x300E0000	/* [x] PCI Special Cycle */
#define PHYS_JK_PCI_IAK 0x300F0000	/* [x] Interrupt acknowledge cycle */
/* 0x30100000-0x30FFFFFF - pass through into PCI memory cycles */
#define PHYS_RO_SU_A	0x300002F8	/* Ports inverted: ttya == COM2 */
#define PHYS_RO_SU_B	0x300003F8	/* Ports inverted: ttyb == COM1 */
#define PHYS_RO_ACFGX	0x300003F0	/* Ali1543 Config Index */
#define PHYS_RO_ACFGD	0x300003F1	/* Ali1543 Config Data */
#define PHYS_RO_IGA	0x39000000	/* Customary base for IGA */

#define BANKS_RO	2		/* May have a hole even with 1 DIMM */

#define PHYS_RO_PIN_CSE  0
#define PHYS_RO_IRQ_CSE  2
