/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.StartSetHandler;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;

public class BestFirst
extends ASSearch
implements OptionHandler,
StartSetHandler {
    static final long serialVersionUID = 7841338689536821867L;
    protected int m_maxStale;
    protected int m_searchDirection;
    protected static final int SELECTION_BACKWARD = 0;
    protected static final int SELECTION_FORWARD = 1;
    protected static final int SELECTION_BIDIRECTIONAL = 2;
    public static final Tag[] TAGS_SELECTION = new Tag[]{new Tag(0, "Backward"), new Tag(1, "Forward"), new Tag(2, "Bi-directional")};
    protected int[] m_starting;
    protected Range m_startRange;
    protected boolean m_hasClass;
    protected int m_classIndex;
    protected int m_numAttribs;
    protected int m_totalEvals;
    protected boolean m_debug;
    protected double m_bestMerit;
    protected int m_cacheSize;

    public String globalInfo() {
        return "BestFirst:\n\nSearches the space of attribute subsets by greedy hillclimbing augmented with a backtracking facility. Setting the number of consecutive non-improving nodes allowed controls the level of backtracking done. Best first may start with the empty set of attributes and search forward, or start with the full set of attributes and search backward, or start at any point and search in both directions (by considering all possible single attribute additions and deletions at a given point).\n";
    }

    public BestFirst() {
        this.resetOptions();
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tSpecify a starting set of attributes.\n\tEg. 1,3,5-7.", "P", 1, "-P <start set>"));
        newVector.addElement(new Option("\tDirection of search. (default = 1).", "D", 1, "-D <0 = backward | 1 = forward | 2 = bi-directional>"));
        newVector.addElement(new Option("\tNumber of non-improving nodes to\n\tconsider before terminating search.", "N", 1, "-N <num>"));
        newVector.addElement(new Option("\tSize of lookup cache for evaluated subsets.\n\tExpressed as a multiple of the number of\n\tattributes in the data set. (default = 1)", "S", 1, "-S <num>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String optionString = Utils.getOption('P', options);
        if (optionString.length() != 0) {
            this.setStartSet(optionString);
        }
        if ((optionString = Utils.getOption('D', options)).length() != 0) {
            this.setDirection(new SelectedTag(Integer.parseInt(optionString), TAGS_SELECTION));
        } else {
            this.setDirection(new SelectedTag(1, TAGS_SELECTION));
        }
        optionString = Utils.getOption('N', options);
        if (optionString.length() != 0) {
            this.setSearchTermination(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('S', options)).length() != 0) {
            this.setLookupCacheSize(Integer.parseInt(optionString));
        }
        this.m_debug = Utils.getFlag('Z', options);
    }

    public void setLookupCacheSize(int size) {
        if (size >= 0) {
            this.m_cacheSize = size;
        }
    }

    public int getLookupCacheSize() {
        return this.m_cacheSize;
    }

    public String lookupCacheSizeTipText() {
        return "Set the maximum size of the lookup cache of evaluated subsets. This is expressed as a multiplier of the number of attributes in the data set. (default = 1).";
    }

    public String startSetTipText() {
        return "Set the start point for the search. This is specified as a comma seperated list off attribute indexes starting at 1. It can include ranges. Eg. 1,2,5-9,17.";
    }

    public void setStartSet(String startSet) throws Exception {
        this.m_startRange.setRanges(startSet);
    }

    public String getStartSet() {
        return this.m_startRange.getRanges();
    }

    public String searchTerminationTipText() {
        return "Set the amount of backtracking. Specify the number of ";
    }

    public void setSearchTermination(int t) throws Exception {
        if (t < 1) {
            throw new Exception("Value of -N must be > 0.");
        }
        this.m_maxStale = t;
    }

    public int getSearchTermination() {
        return this.m_maxStale;
    }

    public String directionTipText() {
        return "Set the direction of the search.";
    }

    public void setDirection(SelectedTag d) {
        if (d.getTags() == TAGS_SELECTION) {
            this.m_searchDirection = d.getSelectedTag().getID();
        }
    }

    public SelectedTag getDirection() {
        return new SelectedTag(this.m_searchDirection, TAGS_SELECTION);
    }

    public String[] getOptions() {
        String[] options = new String[6];
        int current = 0;
        if (!this.getStartSet().equals("")) {
            options[current++] = "-P";
            options[current++] = "" + this.startSetToString();
        }
        options[current++] = "-D";
        options[current++] = "" + this.m_searchDirection;
        options[current++] = "-N";
        options[current++] = "" + this.m_maxStale;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    private String startSetToString() {
        StringBuffer FString = new StringBuffer();
        if (this.m_starting == null) {
            return this.getStartSet();
        }
        for (int i = 0; i < this.m_starting.length; ++i) {
            boolean didPrint = false;
            if (!this.m_hasClass || this.m_hasClass && i != this.m_classIndex) {
                FString.append(this.m_starting[i] + 1);
                didPrint = true;
            }
            if (i == this.m_starting.length - 1) {
                FString.append("");
                continue;
            }
            if (!didPrint) continue;
            FString.append(",");
        }
        return FString.toString();
    }

    public String toString() {
        StringBuffer BfString = new StringBuffer();
        BfString.append("\tBest first.\n\tStart set: ");
        if (this.m_starting == null) {
            BfString.append("no attributes\n");
        } else {
            BfString.append(this.startSetToString() + "\n");
        }
        BfString.append("\tSearch direction: ");
        if (this.m_searchDirection == 0) {
            BfString.append("backward\n");
        } else if (this.m_searchDirection == 1) {
            BfString.append("forward\n");
        } else {
            BfString.append("bi-directional\n");
        }
        BfString.append("\tStale search after " + this.m_maxStale + " node expansions\n");
        BfString.append("\tTotal number of subsets evaluated: " + this.m_totalEvals + "\n");
        BfString.append("\tMerit of best subset found: " + Utils.doubleToString(Math.abs(this.m_bestMerit), 8, 3) + "\n");
        return BfString.toString();
    }

    protected void printGroup(BitSet tt, int numAttribs) {
        for (int i = 0; i < numAttribs; ++i) {
            if (!tt.get(i)) continue;
            System.out.print(i + 1 + " ");
        }
        System.out.println();
    }

    public int[] search(ASEvaluation ASEval, Instances data) throws Exception {
        int i;
        this.m_totalEvals = 0;
        if (!(ASEval instanceof SubsetEvaluator)) {
            throw new Exception(ASEval.getClass().getName() + " is not a " + "Subset evaluator!");
        }
        if (ASEval instanceof UnsupervisedSubsetEvaluator) {
            this.m_hasClass = false;
        } else {
            this.m_hasClass = true;
            this.m_classIndex = data.classIndex();
        }
        SubsetEvaluator ASEvaluator = (SubsetEvaluator)((Object)ASEval);
        this.m_numAttribs = data.numAttributes();
        int best_size = 0;
        int size = 0;
        int sd = this.m_searchDirection;
        Hashtable<String, Double> lookup = new Hashtable<String, Double>(this.m_cacheSize * this.m_numAttribs);
        int insertCount = 0;
        int cacheHits = 0;
        LinkedList2 bfList = new LinkedList2(this.m_maxStale);
        double best_merit = -1.7976931348623157E308;
        int stale = 0;
        BitSet best_group = new BitSet(this.m_numAttribs);
        this.m_startRange.setUpper(this.m_numAttribs - 1);
        if (!this.getStartSet().equals("")) {
            this.m_starting = this.m_startRange.getSelection();
        }
        if (this.m_starting != null) {
            for (i = 0; i < this.m_starting.length; ++i) {
                if (this.m_starting[i] == this.m_classIndex) continue;
                best_group.set(this.m_starting[i]);
            }
            best_size = this.m_starting.length;
            ++this.m_totalEvals;
        } else if (this.m_searchDirection == 0) {
            this.setStartSet("1-last");
            this.m_starting = new int[this.m_numAttribs];
            int j = 0;
            for (i = 0; i < this.m_numAttribs; ++i) {
                if (i == this.m_classIndex) continue;
                best_group.set(i);
                this.m_starting[j++] = i;
            }
            best_size = this.m_numAttribs - 1;
            ++this.m_totalEvals;
        }
        best_merit = ASEvaluator.evaluateSubset(best_group);
        Object[] best = new Object[]{best_group.clone()};
        bfList.addToList(best, best_merit);
        BitSet tt = (BitSet)best_group.clone();
        String hashC = tt.toString();
        lookup.put(hashC, new Double(best_merit));
        while (stale < this.m_maxStale) {
            int done;
            boolean added = false;
            if (this.m_searchDirection == 2) {
                done = 2;
                sd = 1;
            } else {
                done = 1;
            }
            if (bfList.size() == 0) {
                stale = this.m_maxStale;
                break;
            }
            Link2 tl = bfList.getLinkAt(0);
            BitSet temp_group = (BitSet)tl.getData()[0];
            temp_group = (BitSet)temp_group.clone();
            bfList.removeLinkAt(0);
            size = 0;
            for (int kk = 0; kk < this.m_numAttribs; ++kk) {
                if (!temp_group.get(kk)) continue;
                ++size;
            }
            do {
                for (i = 0; i < this.m_numAttribs; ++i) {
                    double merit;
                    boolean z;
                    if (sd == 1) {
                        z = i != this.m_classIndex && !temp_group.get(i);
                    } else {
                        boolean bl = z = i != this.m_classIndex && temp_group.get(i);
                    }
                    if (!z) continue;
                    if (sd == 1) {
                        temp_group.set(i);
                        ++size;
                    } else {
                        temp_group.clear(i);
                        --size;
                    }
                    tt = (BitSet)temp_group.clone();
                    hashC = tt.toString();
                    if (!lookup.containsKey(hashC)) {
                        merit = ASEvaluator.evaluateSubset(temp_group);
                        ++this.m_totalEvals;
                        if (insertCount > this.m_cacheSize * this.m_numAttribs) {
                            lookup = new Hashtable(this.m_cacheSize * this.m_numAttribs);
                            insertCount = 0;
                        }
                        hashC = tt.toString();
                        lookup.put(hashC, new Double(merit));
                        ++insertCount;
                    } else {
                        merit = (Double)lookup.get(hashC);
                        ++cacheHits;
                    }
                    Object[] add = new Object[]{tt.clone()};
                    bfList.addToList(add, merit);
                    if (this.m_debug) {
                        System.out.print("Group: ");
                        this.printGroup(tt, this.m_numAttribs);
                        System.out.println("Merit: " + merit);
                    }
                    if (sd == 1) {
                        z = merit - best_merit > 1.0E-5;
                    } else if (merit == best_merit) {
                        z = size < best_size;
                    } else {
                        boolean bl = z = merit > best_merit;
                    }
                    if (z) {
                        added = true;
                        stale = 0;
                        best_merit = merit;
                        best_size = size;
                        best_group = (BitSet)temp_group.clone();
                    }
                    if (sd == 1) {
                        temp_group.clear(i);
                        --size;
                        continue;
                    }
                    temp_group.set(i);
                    ++size;
                }
                if (done != 2) continue;
                sd = 0;
            } while (--done > 0);
            if (added) continue;
            ++stale;
        }
        this.m_bestMerit = best_merit;
        return this.attributeList(best_group);
    }

    protected void resetOptions() {
        this.m_maxStale = 5;
        this.m_searchDirection = 1;
        this.m_starting = null;
        this.m_startRange = new Range();
        this.m_classIndex = -1;
        this.m_totalEvals = 0;
        this.m_cacheSize = 1;
        this.m_debug = false;
    }

    protected int[] attributeList(BitSet group) {
        int count = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!group.get(i)) continue;
            ++count;
        }
        int[] list = new int[count];
        count = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!group.get(i)) continue;
            list[count++] = i;
        }
        return list;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.29 $");
    }

    public class LinkedList2
    extends FastVector {
        static final long serialVersionUID = 3250538292330398929L;
        int m_MaxSize;

        public LinkedList2(int sz) {
            this.m_MaxSize = sz;
        }

        public void removeLinkAt(int index) throws Exception {
            if (index < 0 || index >= this.size()) {
                throw new Exception("index out of range (removeLinkAt)");
            }
            this.removeElementAt(index);
        }

        public Link2 getLinkAt(int index) throws Exception {
            if (this.size() == 0) {
                throw new Exception("List is empty (getLinkAt)");
            }
            if (index >= 0 && index < this.size()) {
                return (Link2)this.elementAt(index);
            }
            throw new Exception("index out of range (getLinkAt)");
        }

        public void addToList(Object[] data, double mer) throws Exception {
            Link2 newL = new Link2(data, mer);
            if (this.size() == 0) {
                this.addElement(newL);
            } else if (mer > ((Link2)this.firstElement()).m_merit) {
                if (this.size() == this.m_MaxSize) {
                    this.removeLinkAt(this.m_MaxSize - 1);
                }
                this.insertElementAt(newL, 0);
            } else {
                int i = 0;
                int size = this.size();
                boolean done = false;
                if (size != this.m_MaxSize || !(mer <= ((Link2)this.lastElement()).m_merit)) {
                    while (!done && i < size) {
                        if (mer > ((Link2)this.elementAt((int)i)).m_merit) {
                            if (size == this.m_MaxSize) {
                                this.removeLinkAt(this.m_MaxSize - 1);
                            }
                            this.insertElementAt(newL, i);
                            done = true;
                            continue;
                        }
                        if (i == size - 1) {
                            this.addElement(newL);
                            done = true;
                            continue;
                        }
                        ++i;
                    }
                }
            }
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.29 $");
        }
    }

    public class Link2
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -8236598311516351420L;
        Object[] m_data;
        double m_merit;

        public Link2(Object[] data, double mer) {
            this.m_data = data;
            this.m_merit = mer;
        }

        public Object[] getData() {
            return this.m_data;
        }

        public String toString() {
            return "Node: " + this.m_data.toString() + "  " + this.m_merit;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.29 $");
        }
    }
}

