/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Range;
import weka.core.converters.CSVLoader;
import weka.experiment.CSVResultListener;
import weka.experiment.DatabaseResultListener;
import weka.experiment.Experiment;
import weka.experiment.InstanceQuery;
import weka.experiment.PairedCorrectedTTester;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;
import weka.experiment.Tester;
import weka.gui.DatabaseConnectionDialog;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.ListSelectorDialog;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.experiment.ExperimenterDefaults;
import weka.gui.experiment.Messages;
import weka.gui.experiment.OutputFormatDialog;

public class ResultsPanel
extends JPanel {
    private static final long serialVersionUID = -4913007978534178569L;
    protected static final String NO_SOURCE;
    protected JButton m_FromFileBut;
    protected JButton m_FromDBaseBut;
    protected JButton m_FromExpBut;
    protected JLabel m_FromLab;
    private static String[] FOR_JFC_1_1_DCBM_BUG;
    protected DefaultComboBoxModel m_DatasetModel;
    protected DefaultComboBoxModel m_CompareModel;
    protected DefaultComboBoxModel m_SortModel;
    protected DefaultListModel m_TestsModel;
    protected DefaultListModel m_DisplayedModel;
    protected JLabel m_TesterClassesLabel;
    protected static DefaultComboBoxModel m_TesterClassesModel;
    protected static Vector m_Testers;
    protected JComboBox m_TesterClasses;
    protected JLabel m_DatasetKeyLabel;
    protected JButton m_DatasetKeyBut;
    protected DefaultListModel m_DatasetKeyModel;
    protected JList m_DatasetKeyList;
    protected JLabel m_ResultKeyLabel;
    protected JButton m_ResultKeyBut;
    protected DefaultListModel m_ResultKeyModel;
    protected JList m_ResultKeyList;
    protected JButton m_TestsButton;
    protected JButton m_DisplayedButton;
    protected JList m_TestsList;
    protected JList m_DisplayedList;
    protected JComboBox m_CompareCombo;
    protected JComboBox m_SortCombo;
    protected JTextField m_SigTex;
    protected JCheckBox m_ShowStdDevs;
    protected JButton m_OutputFormatButton;
    protected JButton m_PerformBut;
    protected JButton m_SaveOutBut;
    SaveBuffer m_SaveOut;
    protected JTextArea m_OutText;
    protected ResultHistoryPanel m_History;
    protected JFileChooser m_FileChooser;
    protected ExtensionFileFilter m_csvFileFilter;
    protected ExtensionFileFilter m_arffFileFilter;
    protected Tester m_TTester;
    protected Instances m_Instances;
    protected InstanceQuery m_InstanceQuery;
    protected Thread m_LoadThread;
    protected Experiment m_Exp;
    private Dimension COMBO_SIZE;
    protected ResultMatrix m_ResultMatrix;

    public ResultsPanel() {
        Messages.getInstance();
        this.m_FromFileBut = new JButton(Messages.getString("ResultsPanel_FromFileBut_JButton_Text"));
        Messages.getInstance();
        this.m_FromDBaseBut = new JButton(Messages.getString("ResultsPanel_FromDBaseBut_JButton_Text"));
        Messages.getInstance();
        this.m_FromExpBut = new JButton(Messages.getString("ResultsPanel_FromExpBut_JButton_Text"));
        this.m_FromLab = new JLabel(NO_SOURCE);
        this.m_DatasetModel = new DefaultComboBoxModel<String>(FOR_JFC_1_1_DCBM_BUG);
        this.m_CompareModel = new DefaultComboBoxModel<String>(FOR_JFC_1_1_DCBM_BUG);
        this.m_SortModel = new DefaultComboBoxModel<String>(FOR_JFC_1_1_DCBM_BUG);
        this.m_TestsModel = new DefaultListModel();
        this.m_DisplayedModel = new DefaultListModel();
        Messages.getInstance();
        this.m_TesterClassesLabel = new JLabel(Messages.getString("ResultsPanel_TesterClassesLabel_JButton_Text"), 4);
        this.m_TesterClasses = new JComboBox(m_TesterClassesModel);
        Messages.getInstance();
        this.m_DatasetKeyLabel = new JLabel(Messages.getString("ResultsPanel_DatasetKeyLabel_JButton_Text"), 4);
        Messages.getInstance();
        this.m_DatasetKeyBut = new JButton(Messages.getString("ResultsPanel_DatasetKeyBut_JButton_Text"));
        this.m_DatasetKeyModel = new DefaultListModel();
        this.m_DatasetKeyList = new JList(this.m_DatasetKeyModel);
        Messages.getInstance();
        this.m_ResultKeyLabel = new JLabel(Messages.getString("ResultsPanel_ResultKeyLabel_JButton_Text"), 4);
        Messages.getInstance();
        this.m_ResultKeyBut = new JButton(Messages.getString("ResultsPanel_ResultKeyBut_JButton_Text"));
        this.m_ResultKeyModel = new DefaultListModel();
        this.m_ResultKeyList = new JList(this.m_ResultKeyModel);
        Messages.getInstance();
        this.m_TestsButton = new JButton(Messages.getString("ResultsPanel_TestsButton_JButton_Text"));
        Messages.getInstance();
        this.m_DisplayedButton = new JButton(Messages.getString("ResultsPanel_DisplayedButton_JButton_Text"));
        this.m_TestsList = new JList(this.m_TestsModel);
        this.m_DisplayedList = new JList(this.m_DisplayedModel);
        this.m_CompareCombo = new JComboBox(this.m_CompareModel);
        this.m_SortCombo = new JComboBox(this.m_SortModel);
        this.m_SigTex = new JTextField("" + ExperimenterDefaults.getSignificance());
        this.m_ShowStdDevs = new JCheckBox("");
        Messages.getInstance();
        this.m_OutputFormatButton = new JButton(Messages.getString("ResultsPanel_OutputFormatButton_JButton_Text"));
        Messages.getInstance();
        this.m_PerformBut = new JButton(Messages.getString("ResultsPanel_PerformBut_JButton_Text"));
        Messages.getInstance();
        this.m_SaveOutBut = new JButton(Messages.getString("ResultsPanel_SaveOutBut_JButton_Text"));
        this.m_SaveOut = new SaveBuffer(null, this);
        this.m_OutText = new JTextArea();
        this.m_History = new ResultHistoryPanel(this.m_OutText);
        this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        Messages.getInstance();
        this.m_csvFileFilter = new ExtensionFileFilter(CSVLoader.FILE_EXTENSION, Messages.getString("ResultsPanel_CsvFileFilter_ExtensionFileFilter_Text"));
        Messages.getInstance();
        this.m_arffFileFilter = new ExtensionFileFilter(".arff", Messages.getString("ResultsPanel_ArffFileFilter_ExtensionFileFilter_Text"));
        this.m_TTester = new PairedCorrectedTTester();
        this.COMBO_SIZE = new Dimension(150, this.m_ResultKeyBut.getPreferredSize().height);
        this.m_ResultMatrix = new ResultMatrixPlainText();
        this.m_TTester.setSignificanceLevel(ExperimenterDefaults.getSignificance());
        this.m_TTester.setShowStdDevs(ExperimenterDefaults.getShowStdDevs());
        try {
            this.m_ResultMatrix = (ResultMatrix)Class.forName(ExperimenterDefaults.getOutputFormat()).newInstance();
        }
        catch (Exception e) {
            this.m_ResultMatrix = new ResultMatrixPlainText();
        }
        this.m_ResultMatrix.setShowStdDev(ExperimenterDefaults.getShowStdDevs());
        this.m_ResultMatrix.setMeanPrec(ExperimenterDefaults.getMeanPrecision());
        this.m_ResultMatrix.setStdDevPrec(ExperimenterDefaults.getStdDevPrecision());
        this.m_ResultMatrix.setRemoveFilterName(ExperimenterDefaults.getRemoveFilterClassnames());
        this.m_ResultMatrix.setShowAverage(ExperimenterDefaults.getShowAverage());
        this.m_FileChooser.addChoosableFileFilter(this.m_csvFileFilter);
        this.m_FileChooser.addChoosableFileFilter(this.m_arffFileFilter);
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_FromExpBut.setEnabled(false);
        this.m_FromExpBut.setMnemonic('E');
        this.m_FromExpBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ResultsPanel.this.m_LoadThread == null) {
                    ResultsPanel.this.m_LoadThread = new Thread(){

                        public void run() {
                            ResultsPanel.this.setInstancesFromExp(ResultsPanel.this.m_Exp);
                            ResultsPanel.this.m_LoadThread = null;
                        }
                    };
                    ResultsPanel.this.m_LoadThread.start();
                }
            }
        });
        this.m_FromDBaseBut.setMnemonic('D');
        this.m_FromDBaseBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ResultsPanel.this.m_LoadThread == null) {
                    ResultsPanel.this.m_LoadThread = new Thread(){

                        public void run() {
                            ResultsPanel.this.setInstancesFromDBaseQuery();
                            ResultsPanel.this.m_LoadThread = null;
                        }
                    };
                    ResultsPanel.this.m_LoadThread.start();
                }
            }
        });
        this.m_FromFileBut.setMnemonic('F');
        this.m_FromFileBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = ResultsPanel.this.m_FileChooser.showOpenDialog(ResultsPanel.this);
                if (returnVal == 0) {
                    final File selected = ResultsPanel.this.m_FileChooser.getSelectedFile();
                    if (ResultsPanel.this.m_LoadThread == null) {
                        ResultsPanel.this.m_LoadThread = new Thread(){

                            public void run() {
                                ResultsPanel.this.setInstancesFromFile(selected);
                                ResultsPanel.this.m_LoadThread = null;
                            }
                        };
                        ResultsPanel.this.m_LoadThread.start();
                    }
                }
            }
        });
        this.setComboSizes();
        this.m_TesterClasses.setEnabled(false);
        this.m_DatasetKeyBut.setEnabled(false);
        this.m_DatasetKeyBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.setDatasetKeyFromDialog();
            }
        });
        this.m_DatasetKeyList.setSelectionMode(2);
        this.m_ResultKeyBut.setEnabled(false);
        this.m_ResultKeyBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.setResultKeyFromDialog();
            }
        });
        this.m_ResultKeyList.setSelectionMode(2);
        this.m_CompareCombo.setEnabled(false);
        this.m_SortCombo.setEnabled(false);
        this.m_SigTex.setEnabled(false);
        this.m_TestsButton.setEnabled(false);
        this.m_TestsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.setTestBaseFromDialog();
            }
        });
        this.m_DisplayedButton.setEnabled(false);
        this.m_DisplayedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.setDisplayedFromDialog();
            }
        });
        this.m_ShowStdDevs.setEnabled(false);
        this.m_ShowStdDevs.setSelected(ExperimenterDefaults.getShowStdDevs());
        this.m_OutputFormatButton.setEnabled(false);
        this.m_OutputFormatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.setOutputFormatFromDialog();
            }
        });
        this.m_PerformBut.setEnabled(false);
        this.m_PerformBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.performTest();
                ResultsPanel.this.m_SaveOutBut.setEnabled(true);
            }
        });
        this.m_PerformBut.setToolTipText(this.m_TTester.getToolTipText());
        this.m_SaveOutBut.setEnabled(false);
        this.m_SaveOutBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.saveBuffer();
            }
        });
        this.m_OutText.setFont(new Font("Monospaced", 0, 12));
        this.m_OutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_OutText.setEditable(false);
        Messages.getInstance();
        this.m_History.setBorder(BorderFactory.createTitledBorder(Messages.getString("ResultsPanel_OutText_SetBorder_BorderFactoryCreateTitledBorder_Text")));
        JPanel p1 = new JPanel();
        Messages.getInstance();
        p1.setBorder(BorderFactory.createTitledBorder(Messages.getString("ResultsPanel_OutText_SetBorder_BorderFactoryCreateTitledBorder_Text_First")));
        JPanel p2 = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        p2.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
        p2.setLayout(gb);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        p2.add((Component)this.m_FromFileBut, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        p2.add((Component)this.m_FromDBaseBut, constraints);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        p2.add((Component)this.m_FromExpBut, constraints);
        p1.setLayout(new BorderLayout());
        p1.add((Component)this.m_FromLab, "Center");
        p1.add((Component)p2, "East");
        JPanel p3 = new JPanel();
        Messages.getInstance();
        p3.setBorder(BorderFactory.createTitledBorder(Messages.getString("ResultsPanel_P3_SetBorder_BorderFactoryCreateTitledBorder_Text")));
        GridBagLayout gbL = new GridBagLayout();
        p3.setLayout(gbL);
        int y = 0;
        GridBagConstraints gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(this.m_TesterClassesLabel, gbC);
        this.m_TesterClassesLabel.setDisplayedMnemonic('w');
        this.m_TesterClassesLabel.setLabelFor(this.m_TesterClasses);
        p3.add(this.m_TesterClassesLabel);
        gbC = new GridBagConstraints();
        gbC.gridy = y++;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.insets = new Insets(5, 0, 5, 0);
        gbC.fill = 2;
        gbL.setConstraints(this.m_TesterClasses, gbC);
        p3.add(this.m_TesterClasses);
        this.m_TesterClasses.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.setTester();
            }
        });
        this.setSelectedItem(this.m_TesterClasses, ExperimenterDefaults.getTester());
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(this.m_DatasetKeyLabel, gbC);
        this.m_DatasetKeyLabel.setDisplayedMnemonic('R');
        this.m_DatasetKeyLabel.setLabelFor(this.m_DatasetKeyBut);
        p3.add(this.m_DatasetKeyLabel);
        gbC = new GridBagConstraints();
        gbC.fill = 2;
        gbC.gridy = y++;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.insets = new Insets(5, 0, 5, 0);
        gbL.setConstraints(this.m_DatasetKeyBut, gbC);
        p3.add(this.m_DatasetKeyBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(this.m_ResultKeyLabel, gbC);
        this.m_ResultKeyLabel.setDisplayedMnemonic('C');
        this.m_ResultKeyLabel.setLabelFor(this.m_ResultKeyBut);
        p3.add(this.m_ResultKeyLabel);
        gbC = new GridBagConstraints();
        gbC.fill = 2;
        gbC.gridy = y++;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.insets = new Insets(5, 0, 5, 0);
        gbL.setConstraints(this.m_ResultKeyBut, gbC);
        p3.add(this.m_ResultKeyBut);
        Messages.getInstance();
        JLabel lab = new JLabel(Messages.getString("ResultsPanel_Lab_JLabel_Text_First"), 4);
        lab.setDisplayedMnemonic('m');
        lab.setLabelFor(this.m_CompareCombo);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(lab, gbC);
        p3.add(lab);
        gbC = new GridBagConstraints();
        gbC.gridy = y++;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.insets = new Insets(5, 0, 5, 0);
        gbC.fill = 2;
        gbL.setConstraints(this.m_CompareCombo, gbC);
        p3.add(this.m_CompareCombo);
        Messages.getInstance();
        lab = new JLabel(Messages.getString("ResultsPanel_Lab_JLabel_Text_Second"), 4);
        lab.setDisplayedMnemonic('g');
        lab.setLabelFor(this.m_SigTex);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(lab, gbC);
        p3.add(lab);
        gbC = new GridBagConstraints();
        gbC.fill = 2;
        gbC.gridy = y++;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbL.setConstraints(this.m_SigTex, gbC);
        p3.add(this.m_SigTex);
        Messages.getInstance();
        lab = new JLabel(Messages.getString("ResultsPanel_Lab_JLabel_Text_Third"), 4);
        lab.setDisplayedMnemonic('S');
        lab.setLabelFor(this.m_SortCombo);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(lab, gbC);
        p3.add(lab);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = y++;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.insets = new Insets(5, 0, 5, 0);
        gbL.setConstraints(this.m_SortCombo, gbC);
        p3.add(this.m_SortCombo);
        Messages.getInstance();
        lab = new JLabel(Messages.getString("ResultsPanel_Lab_JLabel_Text_Fourth"), 4);
        lab.setDisplayedMnemonic('b');
        lab.setLabelFor(this.m_TestsButton);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(lab, gbC);
        p3.add(lab);
        gbC = new GridBagConstraints();
        gbC.fill = 2;
        gbC.gridy = y++;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.insets = new Insets(5, 0, 5, 0);
        gbL.setConstraints(this.m_TestsButton, gbC);
        p3.add(this.m_TestsButton);
        Messages.getInstance();
        lab = new JLabel(Messages.getString("ResultsPanel_Lab_JLabel_Text_Fifth"), 4);
        lab.setDisplayedMnemonic('i');
        lab.setLabelFor(this.m_DisplayedButton);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(lab, gbC);
        p3.add(lab);
        gbC = new GridBagConstraints();
        gbC.fill = 2;
        gbC.gridy = y++;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.insets = new Insets(5, 0, 5, 0);
        gbL.setConstraints(this.m_DisplayedButton, gbC);
        p3.add(this.m_DisplayedButton);
        Messages.getInstance();
        lab = new JLabel(Messages.getString("ResultsPanel_Lab_JLabel_Text_Sixth"), 4);
        lab.setDisplayedMnemonic('a');
        lab.setLabelFor(this.m_ShowStdDevs);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(lab, gbC);
        p3.add(lab);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = y++;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.insets = new Insets(5, 0, 5, 0);
        gbL.setConstraints(this.m_ShowStdDevs, gbC);
        p3.add(this.m_ShowStdDevs);
        Messages.getInstance();
        lab = new JLabel(Messages.getString("ResultsPanel_Lab_JLabel_Text_Seventh"), 4);
        lab.setDisplayedMnemonic('O');
        lab.setLabelFor(this.m_OutputFormatButton);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(lab, gbC);
        p3.add(lab);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = y;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.insets = new Insets(5, 0, 5, 0);
        gbL.setConstraints(this.m_OutputFormatButton, gbC);
        p3.add(this.m_OutputFormatButton);
        JPanel output = new JPanel();
        output.setLayout(new BorderLayout());
        Messages.getInstance();
        output.setBorder(BorderFactory.createTitledBorder(Messages.getString("ResultsPanel_Output_SetBorder_BorderFactoryCreateTitledBorder_Text")));
        output.add((Component)new JScrollPane(this.m_OutText), "Center");
        JPanel mondo = new JPanel();
        gbL = new GridBagLayout();
        mondo.setLayout(gbL);
        gbC = new GridBagConstraints();
        gbC.gridy = 0;
        gbC.gridx = 0;
        gbL.setConstraints(p3, gbC);
        mondo.add(p3);
        JPanel bts = new JPanel();
        this.m_PerformBut.setMnemonic('t');
        this.m_SaveOutBut.setMnemonic('S');
        bts.setLayout(new GridLayout(1, 2, 5, 5));
        bts.add(this.m_PerformBut);
        bts.add(this.m_SaveOutBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 11;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 0;
        gbC.insets = new Insets(5, 5, 5, 5);
        gbL.setConstraints(bts, gbC);
        mondo.add(bts);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 2;
        gbC.gridx = 0;
        gbC.weightx = 0.0;
        gbC.weighty = 100.0;
        gbL.setConstraints(this.m_History, gbC);
        mondo.add(this.m_History);
        JSplitPane splitPane = new JSplitPane(1, mondo, output);
        splitPane.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)p1, "North");
        this.add((Component)splitPane, "Center");
    }

    protected void setComboSizes() {
        this.m_TesterClasses.setPreferredSize(this.COMBO_SIZE);
        this.m_DatasetKeyBut.setPreferredSize(this.COMBO_SIZE);
        this.m_ResultKeyBut.setPreferredSize(this.COMBO_SIZE);
        this.m_CompareCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_SigTex.setPreferredSize(this.COMBO_SIZE);
        this.m_SortCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_TesterClasses.setMaximumSize(this.COMBO_SIZE);
        this.m_DatasetKeyBut.setMaximumSize(this.COMBO_SIZE);
        this.m_ResultKeyBut.setMaximumSize(this.COMBO_SIZE);
        this.m_CompareCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_SigTex.setMaximumSize(this.COMBO_SIZE);
        this.m_SortCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_TesterClasses.setMinimumSize(this.COMBO_SIZE);
        this.m_DatasetKeyBut.setMinimumSize(this.COMBO_SIZE);
        this.m_ResultKeyBut.setMinimumSize(this.COMBO_SIZE);
        this.m_CompareCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_SigTex.setMinimumSize(this.COMBO_SIZE);
        this.m_SortCombo.setMinimumSize(this.COMBO_SIZE);
    }

    public void setExperiment(Experiment exp) {
        this.m_Exp = exp;
        this.m_FromExpBut.setEnabled(exp != null);
    }

    protected void setInstancesFromDBaseQuery() {
        try {
            int result;
            if (this.m_InstanceQuery == null) {
                this.m_InstanceQuery = new InstanceQuery();
            }
            String dbaseURL = this.m_InstanceQuery.getDatabaseURL();
            String username = this.m_InstanceQuery.getUsername();
            String passwd = this.m_InstanceQuery.getPassword();
            DatabaseConnectionDialog dbd = new DatabaseConnectionDialog(null, dbaseURL, username);
            dbd.setVisible(true);
            if (dbd.getReturnValue() == -1) {
                Messages.getInstance();
                this.m_FromLab.setText(Messages.getString("ResultsPanel_SetInstancesFromDBaseQuery_FromLab_Text_First"));
                return;
            }
            dbaseURL = dbd.getURL();
            username = dbd.getUsername();
            passwd = dbd.getPassword();
            this.m_InstanceQuery.setDatabaseURL(dbaseURL);
            this.m_InstanceQuery.setUsername(username);
            this.m_InstanceQuery.setPassword(passwd);
            this.m_InstanceQuery.setDebug(dbd.getDebug());
            this.m_InstanceQuery.connectToDatabase();
            if (!this.m_InstanceQuery.experimentIndexExists()) {
                Messages.getInstance();
                System.err.println(Messages.getString("ResultsPanel_SetInstancesFromDBaseQuery_Error_Text_First"));
                Messages.getInstance();
                this.m_FromLab.setText(Messages.getString("ResultsPanel_SetInstancesFromDBaseQuery_FromLab_Text_Second"));
                this.m_InstanceQuery.disconnectFromDatabase();
                return;
            }
            Messages.getInstance();
            System.err.println(Messages.getString("ResultsPanel_SetInstancesFromDBaseQuery_Error_Text_Second"));
            Messages.getInstance();
            this.m_FromLab.setText(Messages.getString("ResultsPanel_SetInstancesFromDBaseQuery_FromLab_Text_Fourth"));
            Instances index = this.m_InstanceQuery.retrieveInstances("SELECT * FROM Experiment_index");
            if (index.numInstances() == 0) {
                Messages.getInstance();
                this.m_FromLab.setText(Messages.getString("ResultsPanel_SetInstancesFromDBaseQuery_FromLab_Text_Fifth"));
                this.m_InstanceQuery.disconnectFromDatabase();
                return;
            }
            Messages.getInstance();
            this.m_FromLab.setText(Messages.getString("ResultsPanel_SetInstancesFromDBaseQuery_FromLab_Text_Sixth"));
            DefaultListModel<String> lm = new DefaultListModel<String>();
            for (int i = 0; i < index.numInstances(); ++i) {
                lm.addElement(index.instance(i).toString());
            }
            JList jl = new JList(lm);
            jl.setSelectedIndex(0);
            if (jl.getModel().getSize() != 1) {
                ListSelectorDialog jd = new ListSelectorDialog(null, jl);
                result = jd.showDialog();
            } else {
                result = 0;
            }
            if (result != 0) {
                Messages.getInstance();
                this.m_FromLab.setText(Messages.getString("ResultsPanel_SetInstancesFromDBaseQuery_FromLab_Text_Sixth"));
                this.m_InstanceQuery.disconnectFromDatabase();
                return;
            }
            Instance selInst = index.instance(jl.getSelectedIndex());
            Attribute tableAttr = index.attribute("Result_table");
            String table = "Results" + selInst.toString(tableAttr);
            this.setInstancesFromDatabaseTable(table);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("ResultsPanel_SetInstancesFromDBaseQuery_FromLab_Text_Seventh_First")).append(ex.getMessage());
            Messages.getInstance();
            this.m_FromLab.setText(stringBuilder2.append(Messages.getString("ResultsPanel_SetInstancesFromDBaseQuery_FromLab_Text_Seventh_Second")).toString());
        }
    }

    protected void setInstancesFromExp(Experiment exp) {
        if (exp.getResultListener() instanceof CSVResultListener) {
            File resultFile = ((CSVResultListener)exp.getResultListener()).getOutputFile();
            if (resultFile == null) {
                Messages.getInstance();
                this.m_FromLab.setText(Messages.getString("ResultsPanel_SetInstancesFromExp_FromLab_Text_First"));
            } else {
                this.setInstancesFromFile(resultFile);
            }
        } else if (exp.getResultListener() instanceof DatabaseResultListener) {
            String dbaseURL = ((DatabaseResultListener)exp.getResultListener()).getDatabaseURL();
            try {
                if (this.m_InstanceQuery == null) {
                    this.m_InstanceQuery = new InstanceQuery();
                }
                this.m_InstanceQuery.setDatabaseURL(dbaseURL);
                this.m_InstanceQuery.connectToDatabase();
                String tableName = this.m_InstanceQuery.getResultsTableName(exp.getResultProducer());
                this.setInstancesFromDatabaseTable(tableName);
            }
            catch (Exception ex) {
                Messages.getInstance();
                this.m_FromLab.setText(Messages.getString("ResultsPanel_SetInstancesFromExp_FromLab_Text_Second"));
            }
        } else {
            Messages.getInstance();
            this.m_FromLab.setText(Messages.getString("ResultsPanel_SetInstancesFromExp_FromLab_Text_Third"));
        }
    }

    protected void setInstancesFromDatabaseTable(String tableName) {
        try {
            Messages.getInstance();
            this.m_FromLab.setText(Messages.getString("ResultsPanel_SetInstancesFromDatabaseTable_FromLab_Text"));
            final Instances i = this.m_InstanceQuery.retrieveInstances("SELECT * FROM " + tableName);
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ResultsPanel.this.setInstances(i);
                }
            });
            this.m_InstanceQuery.disconnectFromDatabase();
        }
        catch (Exception ex) {
            this.m_FromLab.setText(ex.getMessage());
        }
    }

    protected void setInstancesFromFile(File f) {
        block5: {
            String fileType = f.getName();
            try {
                Messages.getInstance();
                this.m_FromLab.setText(Messages.getString("ResultsPanel_SetInstancesFromFile_FromLab_Text"));
                if (f.getName().toLowerCase().endsWith(".arff")) {
                    fileType = "arff";
                    BufferedReader r = new BufferedReader(new FileReader(f));
                    this.setInstances(new Instances(r));
                    ((Reader)r).close();
                    break block5;
                }
                if (f.getName().toLowerCase().endsWith(CSVLoader.FILE_EXTENSION)) {
                    fileType = "csv";
                    CSVLoader cnv = new CSVLoader();
                    cnv.setSource(f);
                    Instances inst = cnv.getDataSet();
                    this.setInstances(inst);
                    break block5;
                }
                Messages.getInstance();
                throw new Exception(Messages.getString("ResultsPanel_SetInstancesFromFile_Error_Text"));
            }
            catch (Exception ex) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("ResultsPanel_SetInstancesFromFile_Error_FromLab_Text_First")).append(f.getName());
                Messages.getInstance();
                StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("ResultsPanel_SetInstancesFromFile_Error_FromLab_Text_Second")).append(fileType);
                Messages.getInstance();
                this.m_FromLab.setText(stringBuilder3.append(Messages.getString("ResultsPanel_SetInstancesFromFile_Error_FromLab_Text_Third")).toString());
                StringBuilder stringBuilder4 = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder5 = stringBuilder4.append(Messages.getString("ResultsPanel_SetInstancesFromFile_Error_JOptionPaneShowOptionDialog_Text_First")).append(f.getName());
                Messages.getInstance();
                StringBuilder stringBuilder6 = stringBuilder5.append(Messages.getString("ResultsPanel_SetInstancesFromFile_Error_JOptionPaneShowOptionDialog_Text_Second")).append(fileType);
                Messages.getInstance();
                StringBuilder stringBuilder7 = stringBuilder6.append(Messages.getString("ResultsPanel_SetInstancesFromFile_Error_JOptionPaneShowOptionDialog_Text_Third"));
                Messages.getInstance();
                String string = stringBuilder7.append(Messages.getString("ResultsPanel_SetInstancesFromFile_Error_JOptionPaneShowOptionDialog_Text_Fourth")).append(ex.getMessage()).toString();
                Messages.getInstance();
                String string2 = Messages.getString("ResultsPanel_SetInstancesFromFile_Error_JOptionPaneShowOptionDialog_Text_Fifth");
                Object[] objectArray = new String[1];
                Messages.getInstance();
                objectArray[0] = Messages.getString("ResultsPanel_SetInstancesFromFile_Error_JOptionPaneShowOptionDialog_Text_Sixth");
                if (JOptionPane.showOptionDialog(this, string, string2, 0, 0, null, objectArray, null) == 1) {
                    // empty if block
                }
            }
        }
    }

    protected Vector determineColumnNames(String list, String defaultList, Instances inst) {
        Vector<String> atts = new Vector<String>();
        for (int i = 0; i < inst.numAttributes(); ++i) {
            atts.add(inst.attribute(i).name().toLowerCase());
        }
        Vector<String> result = new Vector<String>();
        StringTokenizer tok = new StringTokenizer(list, ",");
        while (tok.hasMoreTokens()) {
            String item = tok.nextToken().toLowerCase();
            if (atts.contains(item)) {
                result.add(item);
                continue;
            }
            result.clear();
            break;
        }
        if (result.size() == 0) {
            tok = new StringTokenizer(defaultList, ",");
            while (tok.hasMoreTokens()) {
                result.add(tok.nextToken().toLowerCase());
            }
        }
        return result;
    }

    public void setInstances(Instances newInstances) {
        this.m_Instances = newInstances;
        this.m_TTester.setInstances(this.m_Instances);
        StringBuilder stringBuilder = new StringBuilder();
        Messages.getInstance();
        StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("ResultsPanel_SetInstances_FromLab_Text_First")).append(this.m_Instances.numInstances());
        Messages.getInstance();
        this.m_FromLab.setText(stringBuilder2.append(Messages.getString("ResultsPanel_SetInstances_FromLab_Text_Second")).toString());
        Vector rows = this.determineColumnNames(ExperimenterDefaults.getRow(), "Key_Dataset", this.m_Instances);
        Vector cols = this.determineColumnNames(ExperimenterDefaults.getColumn(), "Key_Scheme,Key_Scheme_options,Key_Scheme_version_ID", this.m_Instances);
        this.m_DatasetKeyModel.removeAllElements();
        this.m_ResultKeyModel.removeAllElements();
        this.m_CompareModel.removeAllElements();
        this.m_SortModel.removeAllElements();
        this.m_SortModel.addElement("<default>");
        this.m_TTester.setSortColumn(-1);
        String selectedList = "";
        String selectedListDataset = "";
        boolean comparisonFieldSet = false;
        for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
            String name = this.m_Instances.attribute(i).name();
            if (name.toLowerCase().startsWith("key_", 0)) {
                this.m_DatasetKeyModel.addElement(name.substring(4));
                this.m_ResultKeyModel.addElement(name.substring(4));
                this.m_CompareModel.addElement(name.substring(4));
            } else {
                this.m_DatasetKeyModel.addElement(name);
                this.m_ResultKeyModel.addElement(name);
                this.m_CompareModel.addElement(name);
                if (this.m_Instances.attribute(i).isNumeric()) {
                    this.m_SortModel.addElement(name);
                }
            }
            if (rows.contains(name.toLowerCase())) {
                this.m_DatasetKeyList.addSelectionInterval(i, i);
                selectedListDataset = selectedListDataset + "," + (i + 1);
                continue;
            }
            if (name.toLowerCase().equals("key_run")) {
                this.m_TTester.setRunColumn(i);
                continue;
            }
            if (name.toLowerCase().equals("key_fold")) {
                this.m_TTester.setFoldColumn(i);
                continue;
            }
            if (cols.contains(name.toLowerCase())) {
                this.m_ResultKeyList.addSelectionInterval(i, i);
                selectedList = selectedList + "," + (i + 1);
                continue;
            }
            if (name.toLowerCase().indexOf(ExperimenterDefaults.getComparisonField()) != -1) {
                this.m_CompareCombo.setSelectedIndex(i);
                comparisonFieldSet = true;
                continue;
            }
            if (name.toLowerCase().indexOf("root_relative_squared_error") == -1 || comparisonFieldSet) continue;
            this.m_CompareCombo.setSelectedIndex(i);
            comparisonFieldSet = true;
        }
        this.m_TesterClasses.setEnabled(true);
        this.m_DatasetKeyBut.setEnabled(true);
        this.m_ResultKeyBut.setEnabled(true);
        this.m_CompareCombo.setEnabled(true);
        this.m_SortCombo.setEnabled(true);
        if (ExperimenterDefaults.getSorting().length() != 0) {
            this.setSelectedItem(this.m_SortCombo, ExperimenterDefaults.getSorting());
        }
        Range generatorRange = new Range();
        if (selectedList.length() != 0) {
            try {
                generatorRange.setRanges(selectedList);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println(ex.getMessage());
            }
        }
        this.m_TTester.setResultsetKeyColumns(generatorRange);
        generatorRange = new Range();
        if (selectedListDataset.length() != 0) {
            try {
                generatorRange.setRanges(selectedListDataset);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println(ex.getMessage());
            }
        }
        this.m_TTester.setDatasetKeyColumns(generatorRange);
        this.m_SigTex.setEnabled(true);
        this.setTTester();
    }

    protected void setSelectedItem(JComboBox cb, String item) {
        for (int i = 0; i < cb.getItemCount(); ++i) {
            if (!cb.getItemAt(i).toString().equals(item)) continue;
            cb.setSelectedIndex(i);
            break;
        }
    }

    protected void setTTester() {
        int i;
        this.m_TTester.setDisplayedResultsets(null);
        StringBuilder stringBuilder = new StringBuilder().append(new SimpleDateFormat("HH:mm:ss - ").format(new Date()));
        Messages.getInstance();
        String name = stringBuilder.append(Messages.getString("ResultsPanel_SetTTester_Name_Text")).toString();
        StringBuffer outBuff = new StringBuffer();
        StringBuilder stringBuilder2 = new StringBuilder();
        Messages.getInstance();
        outBuff.append(stringBuilder2.append(Messages.getString("ResultsPanel_SetTTester_OutBuff_Text_First")).append(this.m_TTester.resultsetKey()).append("\n\n").toString());
        this.m_History.addResult(name, outBuff);
        this.m_History.setSingle(name);
        this.m_TestsModel.removeAllElements();
        for (i = 0; i < this.m_TTester.getNumResultsets(); ++i) {
            String tname = this.m_TTester.getResultsetName(i);
            this.m_TestsModel.addElement(tname);
        }
        this.m_DisplayedModel.removeAllElements();
        for (i = 0; i < this.m_TestsModel.size(); ++i) {
            this.m_DisplayedModel.addElement(this.m_TestsModel.elementAt(i));
        }
        Messages.getInstance();
        this.m_TestsModel.addElement(Messages.getString("ResultsPanel_SetTTester_TestsModel_Element_Text_First"));
        Messages.getInstance();
        this.m_TestsModel.addElement(Messages.getString("ResultsPanel_SetTTester_TestsModel_Element_Text_Second"));
        this.m_TestsList.setSelectedIndex(0);
        this.m_DisplayedList.setSelectionInterval(0, this.m_DisplayedModel.size() - 1);
        this.m_TestsButton.setEnabled(true);
        this.m_DisplayedButton.setEnabled(true);
        this.m_ShowStdDevs.setEnabled(true);
        this.m_OutputFormatButton.setEnabled(true);
        this.m_PerformBut.setEnabled(true);
    }

    protected void performTest() {
        String sigStr = this.m_SigTex.getText();
        if (sigStr.length() != 0) {
            this.m_TTester.setSignificanceLevel(new Double(sigStr));
        } else {
            this.m_TTester.setSignificanceLevel(ExperimenterDefaults.getSignificance());
        }
        this.m_TTester.setShowStdDevs(this.m_ShowStdDevs.isSelected());
        if (this.m_Instances.attribute(this.m_SortCombo.getSelectedItem().toString()) != null) {
            this.m_TTester.setSortColumn(this.m_Instances.attribute(this.m_SortCombo.getSelectedItem().toString()).index());
        } else {
            this.m_TTester.setSortColumn(-1);
        }
        int compareCol = this.m_CompareCombo.getSelectedIndex();
        int tType = this.m_TestsList.getSelectedIndex();
        String name = new SimpleDateFormat("HH:mm:ss - ").format(new Date()) + (String)this.m_CompareCombo.getSelectedItem() + " - " + (String)this.m_TestsList.getSelectedValue();
        StringBuffer outBuff = new StringBuffer();
        outBuff.append(this.m_TTester.header(compareCol));
        outBuff.append("\n");
        this.m_History.addResult(name, outBuff);
        this.m_History.setSingle(name);
        this.m_TTester.setDisplayedResultsets(this.m_DisplayedList.getSelectedIndices());
        this.m_TTester.setResultMatrix(this.m_ResultMatrix);
        try {
            if (tType < this.m_TTester.getNumResultsets()) {
                outBuff.append(this.m_TTester.multiResultsetFull(tType, compareCol));
            } else if (tType == this.m_TTester.getNumResultsets()) {
                outBuff.append(this.m_TTester.multiResultsetSummary(compareCol));
            } else {
                outBuff.append(this.m_TTester.multiResultsetRanking(compareCol));
            }
            outBuff.append("\n");
        }
        catch (Exception ex) {
            outBuff.append(ex.getMessage() + "\n");
        }
        this.m_History.updateResult(name);
    }

    public void setResultKeyFromDialog() {
        ListSelectorDialog jd = new ListSelectorDialog(null, this.m_ResultKeyList);
        int result = jd.showDialog();
        if (result == 0) {
            int[] selected = this.m_ResultKeyList.getSelectedIndices();
            String selectedList = "";
            for (int i = 0; i < selected.length; ++i) {
                selectedList = selectedList + "," + (selected[i] + 1);
            }
            Range generatorRange = new Range();
            if (selectedList.length() != 0) {
                try {
                    generatorRange.setRanges(selectedList);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.err.println(ex.getMessage());
                }
            }
            this.m_TTester.setResultsetKeyColumns(generatorRange);
            this.setTTester();
        }
    }

    public void setDatasetKeyFromDialog() {
        ListSelectorDialog jd = new ListSelectorDialog(null, this.m_DatasetKeyList);
        int result = jd.showDialog();
        if (result == 0) {
            int[] selected = this.m_DatasetKeyList.getSelectedIndices();
            String selectedList = "";
            for (int i = 0; i < selected.length; ++i) {
                selectedList = selectedList + "," + (selected[i] + 1);
            }
            Range generatorRange = new Range();
            if (selectedList.length() != 0) {
                try {
                    generatorRange.setRanges(selectedList);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.err.println(ex.getMessage());
                }
            }
            this.m_TTester.setDatasetKeyColumns(generatorRange);
            this.setTTester();
        }
    }

    public void setTestBaseFromDialog() {
        ListSelectorDialog jd = new ListSelectorDialog(null, this.m_TestsList);
        jd.showDialog();
    }

    public void setDisplayedFromDialog() {
        ListSelectorDialog jd = new ListSelectorDialog(null, this.m_DisplayedList);
        jd.showDialog();
    }

    public void setOutputFormatFromDialog() {
        OutputFormatDialog dialog = new OutputFormatDialog(null);
        dialog.setResultMatrix(this.m_ResultMatrix.getClass());
        dialog.setMeanPrec(this.m_ResultMatrix.getMeanPrec());
        dialog.setStdDevPrec(this.m_ResultMatrix.getStdDevPrec());
        dialog.setRemoveFilterName(this.m_ResultMatrix.getRemoveFilterName());
        dialog.setShowAverage(this.m_ResultMatrix.getShowAverage());
        if (dialog.showDialog() == 0) {
            try {
                this.m_ResultMatrix = (ResultMatrix)dialog.getResultMatrix().newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_ResultMatrix = new ResultMatrixPlainText();
            }
            this.m_ResultMatrix.setMeanPrec(dialog.getMeanPrec());
            this.m_ResultMatrix.setStdDevPrec(dialog.getStdDevPrec());
            this.m_ResultMatrix.setRemoveFilterName(dialog.getRemoveFilterName());
            this.m_ResultMatrix.setShowAverage(dialog.getShowAverage());
        }
    }

    protected void saveBuffer() {
        StringBuffer sb = this.m_History.getSelectedBuffer();
        if (sb != null) {
            if (this.m_SaveOut.save(sb)) {
                Messages.getInstance();
                String string = Messages.getString("ResultsPanel_SetTTester_SaveBuffer_JOptionPaneShowMessageDialog_Text_First");
                Messages.getInstance();
                JOptionPane.showMessageDialog(this, string, Messages.getString("ResultsPanel_SetTTester_SaveBuffer_JOptionPaneShowMessageDialog_Text_Second"), 1);
            }
        } else {
            this.m_SaveOutBut.setEnabled(false);
        }
    }

    protected void setTester() {
        if (this.m_TesterClasses.getSelectedItem() == null) {
            return;
        }
        Tester tester = null;
        try {
            for (int i = 0; i < m_Testers.size(); ++i) {
                Tester t = (Tester)((Class)m_Testers.get(i)).newInstance();
                if (!t.getDisplayName().equals(this.m_TesterClasses.getSelectedItem())) continue;
                tester = t;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (tester == null) {
            tester = new PairedCorrectedTTester();
            this.m_TesterClasses.setSelectedItem(tester.getDisplayName());
        }
        tester.assign(this.m_TTester);
        this.m_TTester = tester;
        this.m_PerformBut.setToolTipText(this.m_TTester.getToolTipText());
        StringBuilder stringBuilder = new StringBuilder();
        Messages.getInstance();
        System.out.println(stringBuilder.append(Messages.getString("ResultsPanel_SetTTester_SetTester_Text")).append(this.m_TTester.getClass().getName()).toString());
    }

    public static void main(String[] args) {
        try {
            Messages.getInstance();
            final JFrame jf = new JFrame(Messages.getString("ResultsPanel_SetTTester_Main_JFrame_Text"));
            jf.getContentPane().setLayout(new BorderLayout());
            ResultsPanel sp = new ResultsPanel();
            jf.getContentPane().add((Component)sp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setSize(700, 550);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        Messages.getInstance();
        NO_SOURCE = Messages.getString("ResultsPanel_FromFileBut_JButton_Text");
        FOR_JFC_1_1_DCBM_BUG = new String[]{""};
        m_TesterClassesModel = new DefaultComboBoxModel<String>(FOR_JFC_1_1_DCBM_BUG);
        m_Testers = null;
        Vector<String> classes = GenericObjectEditor.getClassnames(Tester.class.getName());
        m_Testers = new Vector();
        m_TesterClassesModel = new DefaultComboBoxModel();
        for (int i = 0; i < classes.size(); ++i) {
            try {
                Class<?> cls = Class.forName(classes.get(i).toString());
                Tester tester = (Tester)cls.newInstance();
                m_Testers.add(cls);
                m_TesterClassesModel.addElement(tester.getDisplayName());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

