<?xml version='1.0'?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns="http://www.w3.org/1999/xhtml"
    xmlns:d="http://docbook.org/ns/docbook"
    xmlns:exsl="http://exslt.org/common"
    version="1.0"
    exclude-result-prefixes="exsl d"
    extension-element-prefixes="d"
>

<xsl:import href="http://docbook.sourceforge.net/release/xsl-ns/current/xhtml5/docbook.xsl"/>
<xsl:import href="html-common.xsl"/>

<xsl:param name="html.append"/>
<xsl:param name="generate.toc">nop</xsl:param>
<xsl:param name="poper.as.dl"  select="1"/>
<xsl:param name="html.stylesheet">pdfmain.css</xsl:param>

<xsl:template name="article.titlepage.recto">
</xsl:template>
<xsl:template name="book.titlepage.recto">
</xsl:template>

<!--
From: html/component.xsl
Reason: Override Chapter H2 to H1 for PDF titles
-->
<xsl:template name="component.title">
  <xsl:param name="node" select="."/>

  <xsl:variable name="level">
    <xsl:choose>
      <xsl:when test="ancestor::section">
        <xsl:value-of select="count(ancestor::section)+1"/>
      </xsl:when>
      <xsl:when test="ancestor::sect5">6</xsl:when>
      <xsl:when test="ancestor::sect4">5</xsl:when>
      <xsl:when test="ancestor::sect3">4</xsl:when>
      <xsl:when test="ancestor::sect2">3</xsl:when>
      <xsl:when test="ancestor::sect1">2</xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <!-- Let's handle the case where a component (bibliography, for example)
       occurs inside a section; will we need parameters for this? -->

  <xsl:element name="h{$level+1}">
    <xsl:attribute name="class">title</xsl:attribute>
    <xsl:if test="$generate.id.attributes = 0">
      <xsl:call-template name="anchor">
	<xsl:with-param name="node" select="$node"/>
	<xsl:with-param name="conditional" select="0"/>
      </xsl:call-template>
    </xsl:if>
      <xsl:apply-templates select="$node" mode="object.title.markup">
      <xsl:with-param name="allow-anchors" select="1"/>
    </xsl:apply-templates>
  </xsl:element>
</xsl:template>

<!--
From: xhtml/docbook.xsl
Reason: Add css class for draft mode
Version: 1.72.0
-->
<xsl:template name="body.attributes">
	<xsl:if test="starts-with($writing.mode, 'rl')">
		<xsl:attribute name="dir">rtl</xsl:attribute>
	</xsl:if>
	<xsl:variable name="class">
		<xsl:if test="($draft.mode = 'yes' or ($draft.mode = 'maybe' and (ancestor-or-self::set | ancestor-or-self::book | ancestor-or-self::article)[1]/@status = 'draft'))">
			<xsl:value-of select="ancestor-or-self::*[@status][1]/@status"/><xsl:text> </xsl:text>
		</xsl:if>
		<xsl:text> pdf</xsl:text>
	</xsl:variable>
        <xsl:if test="$class != ''">
	  <xsl:attribute name="class">
		<xsl:value-of select="$class"/>
	  </xsl:attribute>
	</xsl:if>
</xsl:template>

<!--
From: xhtml/docbook.xsl
Reason: add TOC div for web site
Version:
-->

<xsl:template match="*" mode="process.root">
  <xsl:variable name="doc" select="self::*"/>

  <xsl:call-template name="user.preroot"/>
  <xsl:call-template name="root.messages"/>

  <html>
    <head>
      <xsl:call-template name="system.head.content">
        <xsl:with-param name="node" select="$doc"/>
      </xsl:call-template>
      <xsl:call-template name="head.content">
        <xsl:with-param name="node" select="$doc"/>
      </xsl:call-template>
      <xsl:call-template name="user.head.content">
        <xsl:with-param name="node" select="$doc"/>
      </xsl:call-template>
    </head>
    <body>
      <xsl:call-template name="body.attributes"/>
     <xsl:call-template name="user.header.content">
        <xsl:with-param name="node" select="$doc"/>
      </xsl:call-template>
      <xsl:apply-templates select="."/>
      <xsl:call-template name="user.footer.content">
        <xsl:with-param name="node" select="$doc"/>
      </xsl:call-template>
    </body>
  </html>
  <xsl:value-of select="$html.append"/>
</xsl:template>

<xsl:template name="head.content">
  <xsl:param name="node" select="."/>
  <xsl:param name="title">
    <xsl:apply-templates select="$node" mode="object.title.markup.textonly"/>
  </xsl:param>

  <title>
    <xsl:copy-of select="$product"/> <xsl:copy-of select="$title"/>
  </title>

  <xsl:if test="$html.base != ''">
    <base href="{$html.base}"/>
  </xsl:if>

  <!-- Insert links to CSS files or insert literal style elements -->
  <xsl:call-template name="generate.css"/>

  <xsl:if test="$html.stylesheet != ''">
    <xsl:call-template name="output.html.stylesheets">
      <xsl:with-param name="stylesheets" select="normalize-space($html.stylesheet)"/>
    </xsl:call-template>
  </xsl:if>

  <xsl:if test="$link.mailto.url != ''">
    <link rev="made" href="{$link.mailto.url}"/>
  </xsl:if>

  <meta name="generator" content="DocBook {$DistroTitle} V{$VERSION}"/>
  <meta xmlns="http://www.w3.org/1999/xhtml" name="generator">
    <xsl:attribute name="content">
      <xsl:text>publican </xsl:text><xsl:value-of select="$publican.version"/>
    </xsl:attribute>
  </meta>
  <xsl:if test="$generate.meta.abstract != 0">
    <xsl:variable name="info" select="(articleinfo                                       |bookinfo                                       |prefaceinfo                                       |chapterinfo                                       |appendixinfo                                       |sectioninfo                                       |sect1info                                       |sect2info                                       |sect3info                                       |sect4info                                       |sect5info                                       |referenceinfo                                       |refentryinfo                                       |partinfo                                       |info                                       |docinfo)[1]"/>
    <xsl:if test="$info and $info/abstract">
      <meta name="description">
        <xsl:attribute name="content">
          <xsl:for-each select="$info/abstract[1]/*">
            <xsl:value-of select="normalize-space(.)"/>
            <xsl:if test="position() &lt; last()">
              <xsl:text> </xsl:text>
            </xsl:if>
          </xsl:for-each>
        </xsl:attribute>
      </meta>
    </xsl:if>
  </xsl:if>

  <xsl:apply-templates select="." mode="head.keywords.content"/>
</xsl:template>

<xsl:template match="book|set|article" mode="class.value">
  <xsl:choose>
    <xsl:when test="($draft.mode = 'yes' or ($draft.mode = 'maybe' and (self::set | self::book | self::article)[1]/@status = 'draft'))">
      <xsl:value-of select="local-name(.)"/><xsl:text> draft</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="local-name(.)"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="d:videodata">
  <a>
    <xsl:call-template name="common.html.attributes"/>

    <xsl:attribute name="href">
      <xsl:value-of select="@fileref"/>
    </xsl:attribute>

    <xsl:call-template name="video.poster"/>

    <xsl:value-of select="@fileref"/>
    <!--xsl:apply-templates select="@*[local-name() != 'fileref']"/-->
    <xsl:apply-templates select="../d:multimediaparam"/>
    
    <!-- add any fallback content -->
    <xsl:call-template name="video.fallback"/>
      
  </a>
</xsl:template>


</xsl:stylesheet>
