describe 'apache::mod::pagespeed', :type => :class do
  let :pre_condition do
    'include apache'
  end
  context "on a Debian OS" do
    let :facts do
      {
        :osfamily               => 'Debian',
        :operatingsystemrelease => '6',
        :concat_basedir         => '/dne',
      }
    end
    it { should contain_class("apache::params") }
    it { should contain_apache__mod('pagespeed') }
    it { should contain_package("mod-pagespeed-stable") }
    it { should contain_file('pagespeed.conf') }
  end

  context "on a RedHat OS" do
    let :facts do
      {
        :osfamily               => 'RedHat',
        :operatingsystemrelease => '6',
        :concat_basedir         => '/dne',
      }
    end
    it { should contain_class("apache::params") }
    it { should contain_apache__mod('pagespeed') }
    it { should contain_package("mod-pagespeed-stable") }
    it { should contain_file('pagespeed.conf') }
  end
end
