#!/usr/bin/python
# -*- coding: utf-8 -*-

#  Copyright © 2009, 2011  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys, os

from ldtp import *
from ldtputils import *
from ooldtp import *

from nose.plugins.skip import SkipTest

sys.path.insert(0, os.path.dirname(__file__)+'/..')
from pybiklib.confstore import confstore

os.environ['GUI_TIMEOUT'] = '2'
os.environ['LANG'] = ''

BUTTON_ANIMSPEED_RESET = 'btnClearAnimspeed'
BUTTON_COLOR_RESET = 'btnClearFaceColor'
BUTTON_IMAGE_RESET = 'btnClearImageFile'
BUTTON_LIGHTING = 'btnLighting'
BUTTON_LIGHTING_RESET = 'btnClearLighting'
BUTTON_PATTERN_RESET = 'btnClearPattern'
BUTTON_SIZE = 'sbtnSpinButtonSize'
BUTTON_SIZE_RESET = 'btnClearSize'
DIALOG_EDIT_COLORS = 'dlgColorselector'
DIALOG_PREFERENCES = 'dlgPreferences'
ENTRY_FORMULA = 'txtEntryFormula'
HSCALE_ANIMSPEED = '???AnimSpeed'
MENU_COLORS = 'mnuEdit;mnuColor'
MENU_EDIT = 'mnuEdit'
MENU_GAME = 'mnuGame'
MENU_HELP = 'mnuHelp'
MENU_INFO = 'mnuHelp;mnuAbout'
MENU_NEW_RANDOM = 'mnuGame;mnuNewrandom'
MENU_NEW_SOLVED = 'mnuGame;mnuNewsolved'
MENU_PLAY_TOOLBAR = 'mnuView;mnuPlayToolbar'
MENU_PREFERENCES = 'mnuEdit;mnuPreferences'
MENU_QUIT = 'mnuGame;mnuQuit'
MENU_STATUSBAR = 'mnuView;mnuStatusBar'
MENU_VIEW = 'mnuView'
RADIOBUTTON_MOSAIC = 'btnMosaic'
RADIOBUTTON_TILE = 'btnTiled'
STATUSBAR_MAIN = 'statStatusbarMain'
TOOLBAR_PLAY = 'tbarToolbarPlay'
TOOLBUTTON_ADD_MARK = 'btnAddmark'
TOOLBUTTON_FORWARD = 'btnForward'
TOOLBUTTON_NEXT = 'btnNext'
TOOLBUTTON_PLAY = 'btnPlay'
TOOLBUTTON_PREVIOUS = 'btnPrevious'
TOOLBUTTON_REMOVE_MARK = 'btnRemovemark'
TOOLBUTTON_REWIND = 'btnRewind'
TOOLBUTTON_STOP = 'btnStop'
TREEVIEW_SCRIPTS = 'ttblTreeviewScripts'
WINDOW_MAIN = 'Pybik'

class AppPybik (component):
    def __init__(self):
        component.__init__(self, WINDOW_MAIN)
        
    @classmethod
    def launch(cls, *args):
        cmd = os.path.dirname(__file__) + '/../pybik'
        if args:
            launchapp(cmd, list(args))
        else:
            launchapp(cmd)
        pybik = cls()
        assert pybik.waittillguiexist ()
        return pybik
    
    def quit(self):
        self.selectmenuitem (MENU_QUIT)
        return self.waittillguinotexist ()
        
    def set_formula(self, formula, pos, status):
        '''Sets formula text with cursor position and checks statusbar text'''
        assert self.settextvalue (ENTRY_FORMULA, formula), formula
        assert self.setcursorposition (ENTRY_FORMULA, pos), pos
        assert self.activatetext (ENTRY_FORMULA)
        text = self.getstatusbartext (STATUSBAR_MAIN)
        assert text == status, (text, status)
        return True
        
    def set_formula_pos(self, pos, status):
        '''Sets cursor position in formula and checks statusbar text'''
        assert self.setcursorposition (ENTRY_FORMULA, pos), pos
        assert self.activatetext (ENTRY_FORMULA)
        text = self.getstatusbartext (STATUSBAR_MAIN)
        assert text == status, (text, status)
        return True

class DlgBase (component):
    def __init__(self):
        component.__init__(self, self.DIALOG)
    
    @classmethod
    def open(cls):
        dlg = cls()
        assert dlg.waittillguiexist ()
        return dlg
    
    def close(self):
        assert self.click ('btnClose')
        return self.waittillguinotexist ()
    
    def yes(self):
        assert self.click ('btnYes')
        return self.waittillguinotexist ()
    
    def no(self):
        assert self.click ('btnNo')
        return self.waittillguinotexist ()
        

class DlgQuestion (DlgBase):
    DIALOG = "dlgQuestion"
    

class DlgPreferences (DlgBase):
    DIALOG = DIALOG_PREFERENCES
    
    def close(self, confirm):
        assert self.click ('btnClose')
        if confirm:
            dlgQuestion = DlgQuestion.open()
            assert dlgQuestion.yes()
        return self.waittillguinotexist ()
        
    
class DlgEditColors (DlgBase):
    DIALOG = DIALOG_EDIT_COLORS
    

def test_start_quit():
    '''Verify, that the app starts and some widgets exist'''
    Pybik = AppPybik.launch()
    assert Pybik.verifystatusbar (STATUSBAR_MAIN)
    assert Pybik.quit()


def test_bars_hide_show():
    Pybik = AppPybik.launch()
    
    #TODO
    #assert Pybik.verifystatusbarvisible(TOOLBAR_PLAY)
    #assert Pybik.selectmenuitem(MENU_PLAY_TOOLBAR)
    #assert not Pybik.verifystatusbarvisible(TOOLBAR_PLAY)
    
    assert Pybik.verifystatusbarvisible(STATUSBAR_MAIN)
    assert Pybik.selectmenuitem(MENU_STATUSBAR)
    assert not Pybik.verifystatusbarvisible(STATUSBAR_MAIN)
    
    assert Pybik.quit()


def test_set_pos():
    Pybik = AppPybik.launch()
    
    assert Pybik.set_formula('', 0, '0 / 0 moves')
    assert Pybik.set_formula('ffb', 0, '0 / 3 moves')
    assert Pybik.set_formula_pos(1, '1 / 3 moves')
    assert Pybik.set_formula_pos(3, '3 / 3 moves')
    assert Pybik.set_formula("llr'u2' b2", 0, '0 / 5 moves')
    assert Pybik.set_formula_pos(1, '1 / 5 moves')
    assert Pybik.set_formula_pos(2, '2 / 5 moves')
    assert Pybik.set_formula_pos(3, '3 / 5 moves')
    assert Pybik.set_formula_pos(4, '3 / 5 moves')
    assert Pybik.set_formula_pos(5, '4 / 5 moves')
    assert Pybik.set_formula_pos(6, '4 / 5 moves')
    assert Pybik.set_formula_pos(7, '4 / 5 moves')
    assert Pybik.set_formula_pos(8, '4 / 5 moves')
    assert Pybik.set_formula_pos(9, '5 / 5 moves')
    assert Pybik.set_formula_pos(10,'5 / 5 moves')
    assert Pybik.set_formula_pos(5, '4 / 5 moves')
    
    assert Pybik.quit()
    
    assert confstore.saved_moves == "llr'u2' b2", repr(confstore.saved_moves)
    assert confstore.saved_pos == 8, confstore.saved_pos
    

def test_set_dimension_from_config():
    raise SkipTest
    confstore.dimension = 3
    confstore.saved_state = 'Cube 4 identity:'
    confstore.saved_moves = ''
    
    Pybik = AppPybik.launch()
    assert Pybik.selectmenuitem (MENU_NEW_SOLVED)
    assert Pybik.quit()
    
    assert confstore.dimension == 3, confstore.dimension
    assert confstore.saved_state == 'Cube 3 identity:', repr(confstore.saved_state)
    assert confstore.saved_moves == '', repr(confstore.saved_moves)

def test_set_dimension_cmd():
    '''Set dimension from commandline'''
    confstore.dimension = 3
    confstore.saved_state = 'Cube 3 identity:'
    confstore.saved_moves = ''
    
    Pybik = AppPybik.launch('--size=4')
    assert Pybik.selectmenuitem (MENU_NEW_SOLVED)
    assert Pybik.quit()
    
    assert confstore.dimension == 3, confstore.dimension
    assert confstore.saved_state == 'Cube 3 identity:', repr(confstore.saved_state)
    assert confstore.saved_moves == '', repr(confstore.saved_moves)
    
def test_set_dimension_dlg():
    '''Set dimension with dialog'''
    confstore.dimension = 3
    confstore.saved_state = 'Cube 3 identity:'
    confstore.saved_moves = ''
    
    Pybik = AppPybik.launch()
    assert Pybik.selectmenuitem (MENU_NEW_SOLVED)
    
    assert Pybik.selectmenuitem (MENU_PREFERENCES)
    preferences = DlgPreferences.open()
    assert preferences.verifysetvalue(BUTTON_SIZE, 3)
    assert preferences.close(confirm=False)
    
    confstore.clear_cache()
    assert confstore.dimension == 3, confstore.dimension
    assert confstore.saved_state == 'Cube 3 identity:', repr(confstore.saved_state)
    assert confstore.saved_moves == '', repr(confstore.saved_moves)
    
    assert Pybik.selectmenuitem (MENU_PREFERENCES)
    preferences = DlgPreferences.open()
    assert preferences.verifysetvalue(BUTTON_SIZE, 3)
    assert preferences.setvalue(BUTTON_SIZE, 4)
    assert preferences.verifysetvalue(BUTTON_SIZE, 4)
    assert preferences.close(confirm=True)
    
    assert Pybik.quit()
    
    confstore.clear_cache()
    assert confstore.dimension == 4, confstore.dimension
    assert confstore.saved_state == 'Cube 4 identity:', repr(confstore.saved_state)
    assert confstore.saved_moves == '', repr(confstore.saved_moves)
    
def test_new_random():
    confstore.dimension = 3
    confstore.saved_state = 'Cube 3 identity:'
    confstore.saved_moves = ''
    
    Pybik = AppPybik.launch('--debug=0')
    assert Pybik.selectmenuitem (MENU_NEW_RANDOM)
    assert Pybik.quit()
    
    confstore.clear_cache()
    assert confstore.dimension == 3, confstore.dimension
    assert (confstore.saved_state == "Cube 3 blocks_compact: "
            "0,0,2,l 2,0,1,lu 0,2,0,uu 2,2,1,fll 1,1,0,u 2,1,2,ff 0,2,2,l 1,0,0,uu 2,0,0,f' "
            "2,1,0,fuu 1,0,1,ll 0,0,1,ll 0,1,1,f' 1,1,1, 2,1,1,f 1,2,0,l' 1,2,1,ll 1,0,2,ffl' "
            "2,0,2,l 0,1,2,f'u 2,2,2,u 1,2,2,u' 1,1,2,u 0,2,1,f'u 2,2,0,f'u' 0,1,0,ffu' 0,0,0,ffu'"
            ), repr(confstore.saved_state)
    assert confstore.saved_moves == '', repr(confstore.saved_moves)
    
def test_solver_mellor():
    raise SkipTest
    confstore.dimension = 3
    confstore.saved_state = 'Cube 3 identity:'
    confstore.saved_moves = ''
    
    Pybik = AppPybik.launch('--debug=0')
    assert Pybik.selectmenuitem (MENU_NEW_RANDOM)
    #assert Pybik.expandtablecell(TREEVIEW_SCRIPTS, 'Solvers')
    #assert Pybik.expandtablecell(TREEVIEW_SCRIPTS, 0)
    #assert Pybik.doubleclickrow(TREEVIEW_SCRIPTS, 'Mellor (3x3)')
    #assert Pybik.doesrowexist(TREEVIEW_SCRIPTS, 'Solvers', True)
    print Pybik.getrowcount(TREEVIEW_SCRIPTS)
    print Pybik.getcellvalue(TREEVIEW_SCRIPTS, 0,0)
    print Pybik.expandtablecell(TREEVIEW_SCRIPTS, 0)
    assert Pybik.doubleclickrow(TREEVIEW_SCRIPTS, 0)
    wait(1)
    assert Pybik.click(TOOLBUTTON_STOP)
    wait(3)
    assert Pybik.click(TOOLBUTTON_FORWARD)
    wait(1)
    assert Pybik.quit()
    
    confstore.clear_cache()
    assert confstore.dimension == 3, confstore.dimension
    assert confstore.saved_state == "Cube 3 identity:", repr(confstore.saved_state)
    assert confstore.saved_moves == '', repr(confstore.saved_moves)
    
if __name__ == '__main__':
    import nose
    nose.runmodule()

