/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.io.InputStream;
import loci.formats.in.BZip2Constants;
import loci.formats.in.CRC;

public class CBZip2InputStream
extends InputStream
implements BZip2Constants {
    private int last;
    private int origPtr;
    private int blockSize100k;
    private boolean blockRandomised;
    private int bsBuff;
    private int bsLive;
    private CRC mCrc = new CRC();
    private boolean[] inUse = new boolean[256];
    private int nInUse;
    private char[] seqToUnseq = new char[256];
    private char[] unseqToSeq = new char[256];
    private char[] selector = new char[18002];
    private char[] selectorMtf = new char[18002];
    private int[] tt = null;
    private char[] ll8 = null;
    private int[] unzftab = new int[256];
    private int[][] limit = new int[6][258];
    private int[][] base = new int[6][258];
    private int[][] perm = new int[6][258];
    private int[] minLens = new int[6];
    private InputStream bsStream;
    private boolean streamEnd = false;
    private int currentChar = -1;
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    private int currentState = 1;
    private int storedBlockCRC;
    private int storedCombinedCRC;
    private int computedBlockCRC;
    private int computedCombinedCRC;
    protected int i2;
    protected int count;
    protected int chPrev;
    protected int ch2;
    protected int i;
    protected int tPos;
    protected int rNToGo = 0;
    protected int rTPos = 0;
    protected int j2;
    protected char z;

    private static void cadvise() {
        System.out.println("CRC Error");
    }

    private static void compressedStreamEOF() {
        CBZip2InputStream.cadvise();
    }

    private void makeMaps() {
        this.nInUse = 0;
        for (int q = 0; q < 256; ++q) {
            if (!this.inUse[q]) continue;
            this.seqToUnseq[this.nInUse] = (char)q;
            this.unseqToSeq[q] = (char)this.nInUse;
            ++this.nInUse;
        }
    }

    public CBZip2InputStream(InputStream zStream) {
        this.bsSetStream(zStream);
        this.initialize();
        this.initBlock();
        this.setupBlock();
    }

    public int read() {
        if (this.streamEnd) {
            return -1;
        }
        int retChar = this.currentChar;
        switch (this.currentState) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setupRandPartB();
                break;
            }
            case 4: {
                this.setupRandPartC();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.setupNoRandPartB();
                break;
            }
            case 7: {
                this.setupNoRandPartC();
                break;
            }
        }
        return retChar;
    }

    private void initialize() {
        char magic3 = this.bsGetUChar();
        char magic4 = this.bsGetUChar();
        if (magic3 != 'h' || magic4 < '1' || magic4 > '9') {
            this.bsFinishedWithStream();
            this.streamEnd = true;
            return;
        }
        this.setDecompressStructureSizes(magic4 - 48);
        this.computedCombinedCRC = 0;
    }

    private void initBlock() {
        char magic1 = this.bsGetUChar();
        char magic2 = this.bsGetUChar();
        char magic3 = this.bsGetUChar();
        char magic4 = this.bsGetUChar();
        char magic5 = this.bsGetUChar();
        char magic6 = this.bsGetUChar();
        if (magic1 == '\u0017' && magic2 == 'r' && magic3 == 'E' && magic4 == '8' && magic5 == 'P' && magic6 == '\u0090') {
            this.complete();
            return;
        }
        if (magic1 != '1' || magic2 != 'A' || magic3 != 'Y' || magic4 != '&' || magic5 != 'S' || magic6 != 'Y') {
            CBZip2InputStream.badBlockHeader();
            this.streamEnd = true;
            return;
        }
        this.storedBlockCRC = this.bsGetInt32();
        this.blockRandomised = this.bsR(1) == 1;
        this.getAndMoveToFrontDecode();
        this.mCrc.initialiseCRC();
        this.currentState = 1;
    }

    private void endBlock() {
        this.computedBlockCRC = this.mCrc.getFinalCRC();
        if (this.storedBlockCRC != this.computedBlockCRC) {
            CBZip2InputStream.crcError();
        }
        this.computedCombinedCRC = this.computedCombinedCRC << 1 | this.computedCombinedCRC >>> 31;
        this.computedCombinedCRC ^= this.computedBlockCRC;
    }

    private void complete() {
        this.storedCombinedCRC = this.bsGetInt32();
        if (this.storedCombinedCRC != this.computedCombinedCRC) {
            CBZip2InputStream.crcError();
        }
        this.bsFinishedWithStream();
        this.streamEnd = true;
    }

    private static void blockOverrun() {
        CBZip2InputStream.cadvise();
    }

    private static void badBlockHeader() {
        CBZip2InputStream.cadvise();
    }

    private static void crcError() {
        CBZip2InputStream.cadvise();
    }

    private void bsFinishedWithStream() {
        try {
            if (this.bsStream != null && this.bsStream != System.in) {
                this.bsStream.close();
                this.bsStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void bsSetStream(InputStream f) {
        this.bsStream = f;
        this.bsLive = 0;
        this.bsBuff = 0;
    }

    private int bsR(int n) {
        while (this.bsLive < n) {
            char thech = '\u0000';
            try {
                thech = (char)this.bsStream.read();
            }
            catch (IOException e) {
                CBZip2InputStream.compressedStreamEOF();
            }
            if (thech == '\uffffffff') {
                CBZip2InputStream.compressedStreamEOF();
            }
            char zzi = thech;
            this.bsBuff = this.bsBuff << 8 | zzi & 0xFF;
            this.bsLive += 8;
        }
        int v = this.bsBuff >> this.bsLive - n & (1 << n) - 1;
        this.bsLive -= n;
        return v;
    }

    private char bsGetUChar() {
        return (char)this.bsR(8);
    }

    private int bsGetint() {
        int u = 0;
        u = u << 8 | this.bsR(8);
        u = u << 8 | this.bsR(8);
        u = u << 8 | this.bsR(8);
        u = u << 8 | this.bsR(8);
        return u;
    }

    private int bsGetIntVS(int numBits) {
        return this.bsR(numBits);
    }

    private int bsGetInt32() {
        return this.bsGetint();
    }

    private void hbCreateDecodeTables(int[] tLimit, int[] tBase, int[] tPerm, char[] length, int minLen, int maxLen, int alphaSize) {
        int q;
        int pp = 0;
        for (q = minLen; q <= maxLen; ++q) {
            for (int j = 0; j < alphaSize; ++j) {
                if (length[j] != q) continue;
                tPerm[pp] = j;
                ++pp;
            }
        }
        for (q = 0; q < 23; ++q) {
            tBase[q] = 0;
        }
        for (q = 0; q < alphaSize; ++q) {
            int n = length[q] + '\u0001';
            tBase[n] = tBase[n] + 1;
        }
        for (q = 1; q < 23; ++q) {
            int n = q;
            tBase[n] = tBase[n] + tBase[q - 1];
        }
        for (q = 0; q < 23; ++q) {
            tLimit[q] = 0;
        }
        int vec = 0;
        for (q = minLen; q <= maxLen; ++q) {
            tLimit[q] = (vec += tBase[q + 1] - tBase[q]) - 1;
            vec <<= 1;
        }
        for (q = minLen + 1; q <= maxLen; ++q) {
            tBase[q] = (tLimit[q - 1] + 1 << 1) - tBase[q];
        }
    }

    private void recvDecodingTables() {
        int t;
        int v;
        int j;
        int q;
        char[][] len = new char[6][258];
        boolean[] inUse16 = new boolean[16];
        for (q = 0; q < 16; ++q) {
            inUse16[q] = this.bsR(1) == 1;
        }
        for (q = 0; q < 256; ++q) {
            this.inUse[q] = false;
        }
        for (q = 0; q < 16; ++q) {
            if (!inUse16[q]) continue;
            for (j = 0; j < 16; ++j) {
                if (this.bsR(1) != 1) continue;
                this.inUse[q * 16 + j] = true;
            }
        }
        this.makeMaps();
        int alphaSize = this.nInUse + 2;
        int nGroups = this.bsR(3);
        int nSelectors = this.bsR(15);
        for (q = 0; q < nSelectors; ++q) {
            j = 0;
            while (this.bsR(1) == 1) {
                ++j;
            }
            this.selectorMtf[q] = (char)j;
        }
        char[] pos = new char[6];
        for (v = 0; v < nGroups; v = (int)((char)(v + 1))) {
            pos[v] = v;
        }
        for (q = 0; q < nSelectors; ++q) {
            char tmp = pos[v];
            for (v = this.selectorMtf[q]; v > 0; v = (int)((char)(v - 1))) {
                pos[v] = pos[v - 1];
            }
            pos[0] = tmp;
            this.selector[q] = tmp;
        }
        for (t = 0; t < nGroups; ++t) {
            int curr = this.bsR(5);
            for (q = 0; q < alphaSize; ++q) {
                while (this.bsR(1) == 1) {
                    if (this.bsR(1) == 0) {
                        ++curr;
                        continue;
                    }
                    --curr;
                }
                len[t][q] = (char)curr;
            }
        }
        for (t = 0; t < nGroups; ++t) {
            int minLen = 32;
            char maxLen = '\u0000';
            for (q = 0; q < alphaSize; ++q) {
                if (len[t][q] > maxLen) {
                    maxLen = len[t][q];
                }
                if (len[t][q] >= minLen) continue;
                minLen = len[t][q];
            }
            this.hbCreateDecodeTables(this.limit[t], this.base[t], this.perm[t], len[t], minLen, maxLen, alphaSize);
            this.minLens[t] = minLen;
        }
    }

    private void getAndMoveToFrontDecode() {
        int zj;
        int q;
        char[] yy = new char[256];
        int limitLast = 100000 * this.blockSize100k;
        this.origPtr = this.bsGetIntVS(24);
        this.recvDecodingTables();
        int eob = this.nInUse + 1;
        int groupNo = -1;
        int groupPos = 0;
        for (q = 0; q <= 255; ++q) {
            this.unzftab[this.i] = 0;
        }
        for (q = 0; q <= 255; ++q) {
            yy[q] = (char)q;
        }
        this.last = -1;
        if (groupPos == 0) {
            ++groupNo;
            groupPos = 50;
        }
        --groupPos;
        char zt = this.selector[groupNo];
        int zn = this.minLens[zt];
        int zvec = this.bsR(zn);
        while (zvec > this.limit[zt][zn]) {
            ++zn;
            while (this.bsLive < 1) {
                char thech = '\u0000';
                try {
                    thech = (char)this.bsStream.read();
                }
                catch (IOException e) {
                    CBZip2InputStream.compressedStreamEOF();
                }
                if (thech == '\uffffffff') {
                    CBZip2InputStream.compressedStreamEOF();
                }
                char zzi = thech;
                this.bsBuff = this.bsBuff << 8 | zzi & 0xFF;
                this.bsLive += 8;
            }
            zj = this.bsBuff >> this.bsLive - 1 & 1;
            --this.bsLive;
            zvec = zvec << 1 | zj;
        }
        int nextSym = this.perm[zt][zvec - this.base[zt][zn]];
        while (nextSym != eob) {
            int j;
            if (nextSym == 0 || nextSym == 1) {
                char ch;
                int s = -1;
                int n = 1;
                do {
                    if (nextSym == 0) {
                        s += 1 * n;
                    } else if (nextSym == 1) {
                        s += 2 * n;
                    }
                    n *= 2;
                    if (groupPos == 0) {
                        ++groupNo;
                        groupPos = 50;
                    }
                    --groupPos;
                    zt = this.selector[groupNo];
                    zn = this.minLens[zt];
                    zvec = this.bsR(zn);
                    while (zvec > this.limit[zt][zn]) {
                        ++zn;
                        while (this.bsLive < 1) {
                            char thech = '\u0000';
                            try {
                                thech = (char)this.bsStream.read();
                            }
                            catch (IOException e) {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            if (thech == '\uffffffff') {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            char zzi = thech;
                            this.bsBuff = this.bsBuff << 8 | zzi & 0xFF;
                            this.bsLive += 8;
                        }
                        zj = this.bsBuff >> this.bsLive - 1 & 1;
                        --this.bsLive;
                        zvec = zvec << 1 | zj;
                    }
                } while ((nextSym = this.perm[zt][zvec - this.base[zt][zn]]) == 0 || nextSym == 1);
                char c = ch = this.seqToUnseq[yy[0]];
                this.unzftab[c] = this.unzftab[c] + ++s;
                while (s > 0) {
                    ++this.last;
                    this.ll8[this.last] = ch;
                    --s;
                }
                if (this.last < limitLast) continue;
                CBZip2InputStream.blockOverrun();
                continue;
            }
            ++this.last;
            if (this.last >= limitLast) {
                CBZip2InputStream.blockOverrun();
            }
            char tmp = yy[nextSym - 1];
            char c = this.seqToUnseq[tmp];
            this.unzftab[c] = this.unzftab[c] + 1;
            this.ll8[this.last] = this.seqToUnseq[tmp];
            for (j = nextSym - 1; j > 3; j -= 4) {
                yy[j] = yy[j - 1];
                yy[j - 1] = yy[j - 2];
                yy[j - 2] = yy[j - 3];
                yy[j - 3] = yy[j - 4];
            }
            while (j > 0) {
                yy[j] = yy[j - 1];
                --j;
            }
            yy[0] = tmp;
            if (groupPos == 0) {
                ++groupNo;
                groupPos = 50;
            }
            --groupPos;
            zt = this.selector[groupNo];
            zn = this.minLens[zt];
            zvec = this.bsR(zn);
            while (zvec > this.limit[zt][zn]) {
                ++zn;
                while (this.bsLive < 1) {
                    char thech = '\u0000';
                    try {
                        thech = (char)this.bsStream.read();
                    }
                    catch (IOException e) {
                        CBZip2InputStream.compressedStreamEOF();
                    }
                    char zzi = thech;
                    this.bsBuff = this.bsBuff << 8 | zzi & 0xFF;
                    this.bsLive += 8;
                }
                zj = this.bsBuff >> this.bsLive - 1 & 1;
                --this.bsLive;
                zvec = zvec << 1 | zj;
            }
            nextSym = this.perm[zt][zvec - this.base[zt][zn]];
        }
    }

    private void setupBlock() {
        int[] cftab = new int[257];
        cftab[0] = 0;
        this.i = 1;
        while (this.i <= 256) {
            cftab[this.i] = this.unzftab[this.i - 1];
            ++this.i;
        }
        this.i = 1;
        while (this.i <= 256) {
            int n = this.i;
            cftab[n] = cftab[n] + cftab[this.i - 1];
            ++this.i;
        }
        this.i = 0;
        while (this.i <= this.last) {
            char ch = this.ll8[this.i];
            this.tt[cftab[ch]] = this.i++;
            char c = ch;
            cftab[c] = cftab[c] + 1;
        }
        cftab = null;
        this.tPos = this.tt[this.origPtr];
        this.count = 0;
        this.i2 = 0;
        this.ch2 = 256;
        if (this.blockRandomised) {
            this.rNToGo = 0;
            this.rTPos = 0;
            this.setupRandPartA();
        } else {
            this.setupNoRandPartA();
        }
    }

    private void setupRandPartA() {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.ll8[this.tPos];
            this.tPos = this.tt[this.tPos];
            if (this.rNToGo == 0) {
                this.rNToGo = R_NUMS[this.rTPos];
                ++this.rTPos;
                if (this.rTPos == 512) {
                    this.rTPos = 0;
                }
            }
            --this.rNToGo;
            this.ch2 ^= this.rNToGo == 1 ? 1 : 0;
            ++this.i2;
            this.currentChar = this.ch2;
            this.currentState = 3;
            this.mCrc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupNoRandPartA() {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.ll8[this.tPos];
            this.tPos = this.tt[this.tPos];
            ++this.i2;
            this.currentChar = this.ch2;
            this.currentState = 6;
            this.mCrc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.currentState = 2;
            this.count = 1;
            this.setupRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.ll8[this.tPos];
                this.tPos = this.tt[this.tPos];
                if (this.rNToGo == 0) {
                    this.rNToGo = R_NUMS[this.rTPos];
                    ++this.rTPos;
                    if (this.rTPos == 512) {
                        this.rTPos = 0;
                    }
                }
                --this.rNToGo;
                this.z = (char)(this.z ^ (this.rNToGo == 1 ? (char)'\u0001' : '\u0000'));
                this.j2 = 0;
                this.currentState = 4;
                this.setupRandPartC();
            } else {
                this.currentState = 2;
                this.setupRandPartA();
            }
        }
    }

    private void setupRandPartC() {
        if (this.j2 < this.z) {
            this.currentChar = this.ch2;
            this.mCrc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.currentState = 2;
            ++this.i2;
            this.count = 0;
            this.setupRandPartA();
        }
    }

    private void setupNoRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.currentState = 5;
            this.count = 1;
            this.setupNoRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.ll8[this.tPos];
                this.tPos = this.tt[this.tPos];
                this.currentState = 7;
                this.j2 = 0;
                this.setupNoRandPartC();
            } else {
                this.currentState = 5;
                this.setupNoRandPartA();
            }
        }
    }

    private void setupNoRandPartC() {
        if (this.j2 < this.z) {
            this.currentChar = this.ch2;
            this.mCrc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.currentState = 5;
            ++this.i2;
            this.count = 0;
            this.setupNoRandPartA();
        }
    }

    private void setDecompressStructureSizes(int newSize100k) {
        if (0 > newSize100k || newSize100k > 9 || 0 > this.blockSize100k || this.blockSize100k > 9) {
            // empty if block
        }
        this.blockSize100k = newSize100k;
        if (newSize100k == 0) {
            return;
        }
        int n = 100000 * newSize100k;
        this.ll8 = new char[n];
        this.tt = new int[n];
    }
}

