/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen;

import java.text.ParseException;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;

public class DatasetEnhancer1 {
    private static Logger logger = LoggerFactory.getLogger(DatasetEnhancer1.class);
    private DatasetMetadataAdder mdataAdder;
    private boolean applyToLeafNodesOnly;

    private DatasetEnhancer1(DatasetMetadataAdder metadataAdder, boolean applyToLeafNodesOnly) {
        if (metadataAdder == null) {
            throw new IllegalArgumentException("MetadataAdder must not be null.");
        }
        this.mdataAdder = metadataAdder;
        this.applyToLeafNodesOnly = applyToLeafNodesOnly;
    }

    public static DatasetEnhancer1 createDatasetEnhancer(DatasetMetadataAdder metadataAdder, boolean applyToLeafNodesOnly) {
        return new DatasetEnhancer1(metadataAdder, applyToLeafNodesOnly);
    }

    public static DatasetEnhancer1 createAddTimeCoverageEnhancer(String dsNameMatchPattern, String startTimeSubstitutionPattern, String duration) {
        return new DatasetEnhancer1(new AddTimeCoverageModels(dsNameMatchPattern, startTimeSubstitutionPattern, duration), true);
    }

    public static DatasetEnhancer1 createAddIdEnhancer(String baseID) {
        return new DatasetEnhancer1(new AddId(baseID), false);
    }

    public void addMetadata(InvDataset dataset) {
        boolean doEnhance;
        boolean doEnhanceChildren;
        if (dataset.getClass().equals(InvCatalogRef.class) || dataset.getClass().equals(InvDatasetScan.class)) {
            doEnhanceChildren = false;
            doEnhance = !this.applyToLeafNodesOnly;
        } else if (dataset.hasNestedDatasets()) {
            doEnhanceChildren = true;
            doEnhance = !this.applyToLeafNodesOnly;
        } else {
            doEnhanceChildren = false;
            doEnhance = true;
        }
        if (doEnhance && !this.mdataAdder.addMetadata(dataset)) {
            logger.debug("addMetadata(): failed to enhance dataset <{}>.", (Object)dataset.getName());
        }
        if (doEnhanceChildren) {
            Iterator<InvDataset> dsIter = dataset.getDatasets().iterator();
            while (dsIter.hasNext()) {
                this.addMetadata(dsIter.next());
            }
        }
    }

    protected static class AddId
    implements DatasetMetadataAdder {
        private String baseId;

        public AddId(String baseId) {
            if (baseId == null) {
                throw new IllegalArgumentException("Base Id must not be null.");
            }
            this.baseId = baseId;
        }

        public boolean addMetadata(InvDataset dataset) {
            String curId;
            InvDataset parentDs = dataset.getParent();
            String string = curId = parentDs == null ? this.baseId : parentDs.getID();
            if (curId == null) {
                curId = this.baseId;
            }
            if (dataset.getName() != null && !dataset.getName().equals("")) {
                curId = curId + "/" + dataset.getName();
            }
            ((InvDatasetImpl)dataset).setID(curId);
            return true;
        }
    }

    protected static class AddTimeCoverageModels
    implements DatasetMetadataAdder {
        private String substitutionPattern;
        private String duration;
        private Pattern pattern;

        public AddTimeCoverageModels(String matchPattern, String substitutionPattern, String duration) {
            this.substitutionPattern = substitutionPattern;
            this.duration = duration;
            this.pattern = Pattern.compile(matchPattern);
        }

        public boolean addMetadata(InvDataset dataset) {
            Matcher matcher = this.pattern.matcher(dataset.getName());
            if (!matcher.find()) {
                return false;
            }
            StringBuffer startTime = new StringBuffer();
            matcher.appendReplacement(startTime, this.substitutionPattern);
            startTime.delete(0, matcher.start());
            try {
                ((InvDatasetImpl)dataset).setTimeCoverage(new DateRange(new DateType(startTime.toString(), null, null), null, new TimeDuration(this.duration), null));
            }
            catch (ParseException e) {
                logger.debug("Start time <" + startTime.toString() + "> or duration <" + this.duration + "> not parsable: " + e.getMessage());
                return false;
            }
            ((InvDatasetImpl)dataset).finish();
            return true;
        }
    }

    public static interface DatasetMetadataAdder {
        public boolean addMetadata(InvDataset var1);
    }
}

