/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.filesystem.ControllerOS;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.DateExtractorFromName;
import thredds.inventory.MCollection;
import thredds.inventory.MController;
import thredds.inventory.MFile;
import thredds.inventory.MFileFilter;
import thredds.inventory.filter.Composite;
import thredds.inventory.filter.LastModifiedLimit;
import thredds.inventory.filter.RegExpMatchOnName;
import thredds.inventory.filter.WildcardMatchOnName;
import thredds.inventory.filter.WildcardMatchOnPath;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.CancelTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetCollectionManager {
    private static Logger logger = LoggerFactory.getLogger(DatasetCollectionManager.class);
    private static boolean debugSyncDetail = false;
    private static MController controller;
    private List<MCollection> scanList = new ArrayList<MCollection>();
    private Map<String, MFile> map;
    private TimeUnit recheck;
    private long lastScanned;

    public static void setController(MController _controller) {
        controller = _controller;
    }

    public DatasetCollectionManager(String collectionSpec, Formatter errlog) {
        CollectionSpecParser sp = new CollectionSpecParser(collectionSpec, errlog);
        WildcardMatchOnName mfilter = null == sp.getFilter() ? null : new WildcardMatchOnName(sp.getFilter());
        DateExtractorFromName dateExtractor = sp.getDateFormatMark() == null ? null : new DateExtractorFromName(sp.getDateFormatMark());
        this.scanList.add(new MCollection(sp.getTopDir(), sp.getTopDir(), sp.wantSubdirs(), mfilter, dateExtractor, null));
    }

    public DatasetCollectionManager(CollectionSpecParser sp, Formatter errlog) {
        WildcardMatchOnName mfilter = null == sp.getFilter() ? null : new WildcardMatchOnName(sp.getFilter());
        DateExtractorFromName dateExtractor = sp.getDateFormatMark() == null ? null : new DateExtractorFromName(sp.getDateFormatMark());
        this.scanList.add(new MCollection(sp.getTopDir(), sp.getTopDir(), sp.wantSubdirs(), mfilter, dateExtractor, null));
    }

    public DatasetCollectionManager(String recheckS) {
        if (recheckS != null) {
            try {
                this.recheck = new TimeUnit(recheckS);
            }
            catch (Exception e) {
                logger.error("Invalid time unit for recheckEvery = {}", (Object)recheckS);
            }
        }
    }

    public void addDirectoryScan(String dirName, String suffix, String regexpPatternString, String subdirsS, String olderS, String dateFormatString, Object auxInfo) {
        ArrayList<MFileFilter> filters = new ArrayList<MFileFilter>(3);
        if (null != regexpPatternString) {
            filters.add(new RegExpMatchOnName(regexpPatternString));
        } else if (suffix != null) {
            filters.add(new WildcardMatchOnPath("*" + suffix));
        }
        if (olderS != null) {
            try {
                TimeUnit tu = new TimeUnit(olderS);
                filters.add(new LastModifiedLimit((long)(1000.0 * tu.getValueInSeconds())));
            }
            catch (Exception e) {
                logger.error("Invalid time unit for olderThan = {}", (Object)olderS);
            }
        }
        DateExtractorFromName dateExtractor = dateFormatString == null ? null : new DateExtractorFromName(dateFormatString);
        boolean wantSubdirs = true;
        if (subdirsS != null && subdirsS.equalsIgnoreCase("false")) {
            wantSubdirs = false;
        }
        Composite filter = filters.size() == 0 ? null : (filters.size() == 1 ? (MFileFilter)filters.get(0) : new Composite(filters));
        MCollection mc = new MCollection(dirName, dirName, wantSubdirs, filter, dateExtractor, auxInfo);
        this.scanList.add(mc);
    }

    public void scan(CancelTask cancelTask) throws IOException {
        HashMap<String, MFile> newMap = new HashMap<String, MFile>();
        this.scan(newMap, cancelTask);
        this.map = newMap;
        this.lastScanned = System.currentTimeMillis();
    }

    public boolean timeToRescan() {
        if (this.scanList.isEmpty()) {
            if (debugSyncDetail) {
                System.out.println(" *Sync not needed, no scanners");
            }
            return false;
        }
        if (this.recheck == null) {
            if (debugSyncDetail) {
                System.out.println(" *Sync not needed, recheck is null");
            }
            return false;
        }
        Date now = new Date();
        Date lastCheckedDate = new Date(this.lastScanned);
        Date need = this.recheck.add(lastCheckedDate);
        if (now.before(need)) {
            if (logger.isDebugEnabled()) {
                logger.debug(" *Sync not needed, last= " + lastCheckedDate + " now = " + now);
            }
            return false;
        }
        return true;
    }

    public boolean rescan() throws IOException {
        String path;
        if (logger.isDebugEnabled()) {
            logger.debug(" *Sync at " + new Date());
        }
        this.lastScanned = System.currentTimeMillis();
        HashMap<String, MFile> newMap = new HashMap<String, MFile>();
        this.scan(newMap, null);
        boolean changed = false;
        for (MFile newDataset : newMap.values()) {
            path = newDataset.getPath();
            MFile oldDataset = this.map.get(path);
            if (oldDataset != null) {
                newMap.put(path, oldDataset);
                if (!debugSyncDetail) continue;
                System.out.println("  sync using old Dataset= " + path);
                continue;
            }
            changed = true;
            if (!debugSyncDetail) continue;
            System.out.println("  sync found new Dataset= " + path);
        }
        if (!changed) {
            for (MFile oldDataset : this.map.values()) {
                path = oldDataset.getPath();
                MFile newDataset = (MFile)newMap.get(path);
                if (newDataset != null) continue;
                changed = true;
                if (!debugSyncDetail) break;
                System.out.println("  sync found deleted Dataset= " + path);
                break;
            }
        }
        if (changed) {
            this.map = newMap;
        }
        return changed;
    }

    public TimeUnit getRecheck() {
        return this.recheck;
    }

    public long getLastScanned() {
        return this.lastScanned;
    }

    public List<MFile> getFiles() {
        ArrayList<MFile> result = new ArrayList<MFile>(this.map.values());
        Collections.sort(result);
        return result;
    }

    private void scan(Map<String, MFile> map, CancelTask cancelTask) throws IOException {
        if (null == controller) {
            controller = new ControllerOS();
        }
        for (MCollection mc : this.scanList) {
            Iterator<MFile> iter;
            Iterator<MFile> iterator = iter = mc.wantSubdirs() ? controller.getInventory(mc) : controller.getInventoryNoSubdirs(mc);
            if (iter == null) {
                logger.error("DatasetCollectionManager Invalid collection= " + mc);
                continue;
            }
            while (iter.hasNext()) {
                MFile mfile = iter.next();
                mfile.setAuxInfo(mc.getAuxInfo());
                map.put(mfile.getPath(), mfile);
            }
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
    }
}

