/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.stream.NcStream;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public abstract class AbstractIOServiceProvider
implements IOServiceProvider {
    protected RandomAccessFile raf;

    public static String createValidNetcdfObjectName(String name) {
        return name;
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        this.raf = raf;
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        this.raf = null;
    }

    public long readToByteChannel(Variable v2, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        Array data = this.readData(v2, section);
        return AbstractIOServiceProvider.copyToByteChannel(data, channel);
    }

    public static long copyToByteChannel(Array data, WritableByteChannel channel) throws IOException, InvalidRangeException {
        if (data instanceof ArrayStructureBB) {
            ArrayStructureBB dataBB = (ArrayStructureBB)data;
            ByteBuffer bb = dataBB.getByteBuffer();
            bb.rewind();
            channel.write(bb);
            return bb.limit();
        }
        DataOutputStream outStream = new DataOutputStream(Channels.newOutputStream(channel));
        IndexIterator iterA = data.getIndexIterator();
        Class classType = data.getElementType();
        if (classType == Double.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeDouble(iterA.getDoubleNext());
            }
        } else if (classType == Float.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeFloat(iterA.getFloatNext());
            }
        } else if (classType == Long.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeLong(iterA.getLongNext());
            }
        } else if (classType == Integer.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeInt(iterA.getIntNext());
            }
        } else if (classType == Short.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeShort(iterA.getShortNext());
            }
        } else if (classType == Character.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeChar(iterA.getCharNext());
            }
        } else if (classType == Byte.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeByte(iterA.getByteNext());
            }
        } else if (classType == Boolean.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeBoolean(iterA.getBooleanNext());
            }
        } else {
            if (classType == String.class) {
                long size = 0L;
                while (iterA.hasNext()) {
                    String s = (String)iterA.getObjectNext();
                    size += (long)NcStream.writeVInt(outStream, s.length());
                    byte[] b = s.getBytes("UTF-8");
                    outStream.write(b);
                    size += (long)b.length;
                }
                return size;
            }
            if (classType == ByteBuffer.class) {
                long size = 0L;
                while (iterA.hasNext()) {
                    ByteBuffer bb = (ByteBuffer)iterA.getObjectNext();
                    size += (long)NcStream.writeVInt(outStream, bb.limit());
                    bb.rewind();
                    channel.write(bb);
                    size += (long)bb.limit();
                }
                return size;
            }
            throw new UnsupportedOperationException("Class type = " + classType.getName());
        }
        return data.getSizeBytes();
    }

    public Array readSection(ParsedSectionSpec cer) throws IOException, InvalidRangeException {
        return IospHelper.readSection(cer);
    }

    public StructureDataIterator getStructureIterator(Structure s, int bufferSize) throws IOException {
        return null;
    }

    public Object sendIospMessage(Object message) {
        return null;
    }

    public boolean syncExtend() throws IOException {
        return false;
    }

    public boolean sync() throws IOException {
        return false;
    }

    public String toStringDebug(Object o) {
        return "";
    }

    public String getDetailInfo() {
        return "";
    }

    public String getFileTypeVersion() {
        return "N/A";
    }
}

