/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.SampledSet;
import visad.Scalar;
import visad.Set;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.data.netcdf.in.Context;
import visad.data.netcdf.in.InvalidContextException;
import visad.data.netcdf.in.VirtualData;
import visad.data.netcdf.in.VirtualField;
import visad.data.netcdf.in.VirtualFlatField;
import visad.data.netcdf.in.VirtualScalar;
import visad.data.netcdf.in.VirtualTuple;

public class DataFactory {
    private static DataFactory instance = new DataFactory();

    protected DataFactory() {
    }

    public static DataFactory instance() {
        return instance;
    }

    public DataImpl newData(Context context, VirtualData virtualData) throws RemoteException, VisADException, InvalidContextException, IOException {
        return virtualData instanceof VirtualScalar ? this.newData(context, (VirtualScalar)virtualData) : (virtualData instanceof VirtualFlatField ? this.newData(context, (VirtualFlatField)virtualData) : (virtualData instanceof VirtualField ? this.newData(context, (VirtualField)virtualData) : this.newData(context, (VirtualTuple)virtualData)));
    }

    public Scalar newData(Context context, VirtualScalar virtualScalar) throws VisADException, InvalidContextException, IOException {
        return virtualScalar.getScalar(context);
    }

    public FlatField newData(Context context, VirtualFlatField virtualField) throws VisADException, RemoteException, IOException {
        FunctionType funcType = virtualField.getFunctionType();
        SampledSet domainSet = virtualField.getDomainSet();
        VirtualTuple rangeTuple = virtualField.getRangeTuple();
        int componentCount = rangeTuple.size();
        Set[] rangeSets = new Set[componentCount];
        Unit[] rangeUnits = new Unit[componentCount];
        for (int i = 0; i < componentCount; ++i) {
            VirtualScalar component = (VirtualScalar)rangeTuple.get(i);
            rangeSets[i] = component.getRangeSet();
            rangeUnits[i] = component.getUnit();
        }
        FlatField field = new FlatField(funcType, (Set)domainSet, (CoordinateSystem)null, rangeSets, rangeUnits);
        double[][] values = new double[componentCount][];
        for (int i = 0; i < componentCount; ++i) {
            values[i] = ((VirtualScalar)rangeTuple.get(i)).getDoubles(context);
        }
        field.setSamples(values, false);
        return field;
    }

    public FieldImpl newData(Context context, VirtualField virtualField) throws VisADException, RemoteException, IOException {
        FieldImpl field;
        if (virtualField instanceof VirtualFlatField) {
            field = this.newData(context, (VirtualFlatField)virtualField);
        } else {
            FunctionType funcType = virtualField.getFunctionType();
            SampledSet domainSet = virtualField.getDomainSet();
            VirtualTuple rangeTuple = virtualField.getRangeTuple();
            int sampleCount = domainSet.getLength();
            field = new FieldImpl(funcType, domainSet);
            context = context.newSubContext();
            for (int i = 0; i < sampleCount; ++i) {
                context.setSubContext(i);
                field.setSample(i, (Data)this.newData(context, rangeTuple), false);
            }
        }
        return field;
    }

    public DataImpl newData(Context context, VirtualTuple virtualTuple) throws RemoteException, VisADException, IOException {
        DataImpl data = null;
        int size = virtualTuple.size();
        if (size == 1) {
            data = this.newData(context, virtualTuple.get(0));
        } else if (size > 1) {
            MathType type = virtualTuple.getType();
            if (type instanceof RealTupleType) {
                Real[] reals = new Real[size];
                for (int i = 0; i < size; ++i) {
                    reals[i] = (Real)this.newData(context, (VirtualScalar)virtualTuple.get(i));
                }
                data = new RealTuple((RealTupleType)type, reals, null);
            } else if (type instanceof TupleType) {
                Data[] datas = new DataImpl[size];
                for (int i = 0; i < datas.length; ++i) {
                    datas[i] = this.newData(context, virtualTuple.get(i));
                }
                data = new Tuple((TupleType)type, datas, false);
            }
        }
        return data;
    }
}

