/*
 * Decompiled with CFR 0.152.
 */
package visad.data.vis5d;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visad.AnimationControl;
import visad.BadMappingException;
import visad.CachingCoordinateSystem;
import visad.CartesianProductCoordinateSystem;
import visad.CellImpl;
import visad.ContourControl;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DDoubleSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Linear1DSet;
import visad.Linear3DSet;
import visad.MathType;
import visad.OffsetUnit;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Set;
import visad.Tuple;
import visad.TupleType;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.units.ParseException;
import visad.data.units.Parser;
import visad.data.units.UnitParser;
import visad.data.vis5d.V5DStruct;
import visad.data.vis5d.Vis5DAdaptedForm;
import visad.data.vis5d.Vis5DCoordinateSystem;
import visad.data.vis5d.Vis5DFile;
import visad.data.vis5d.Vis5DVerticalSystem;
import visad.java3d.DisplayImplJ3D;
import visad.jmet.DumpType;
import visad.util.VisADSlider;

public class Vis5DForm
extends Form
implements FormFileInformer {
    private final int MAXVARS = 200;
    private final int MAXTIMES = 400;
    private final int MAXROWS = 400;
    private final int MAXCOLUMNS = 400;
    private final int MAXLEVELS = 400;
    private final int MAXPROJARGS = 801;
    private final int MAXVERTARGS = 401;
    private static int num = 0;
    private static boolean loaded = false;
    public static int WIDTH = 800;
    public static int HEIGHT = 600;

    public Vis5DForm() {
        super("Vis5DForm" + num++);
    }

    public boolean isThisType(String name) {
        return name.endsWith(".v5d");
    }

    public boolean isThisType(byte[] block) {
        String v5d = new String(block, 0, 3);
        return v5d.equals("V5D");
    }

    public String[] getDefaultSuffixes() {
        String[] suff = new String[]{"v5d"};
        return suff;
    }

    public synchronized void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        throw new UnimplementedException("Vis5DForm.save");
    }

    public synchronized void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("Vis5DForm.add");
    }

    public synchronized DataImpl open(String id) throws BadFormException, IOException, VisADException {
        if (id == null) {
            throw new BadFormException("Vis5DForm.open: null name String");
        }
        byte[] name = id.getBytes();
        int[] sizes = new int[5];
        int[] map_proj = new int[1];
        String[] varnames = new String[200];
        String[] varunits = new String[200];
        int[] n_levels = new int[200];
        int[] vert_sys = new int[1];
        float[] vertargs = new float[401];
        double[] times = new double[400];
        float[] projargs = new float[801];
        V5DStruct vv = V5DStruct.v5d_open(name, name.length, sizes, n_levels, varnames, varunits, map_proj, projargs, vert_sys, vertargs, times);
        if (sizes[0] < 1) {
            throw new BadFormException("Vis5DForm.open: bad file");
        }
        int nr = sizes[0];
        int nc = sizes[1];
        int nl = sizes[2];
        int ntimes = sizes[3];
        int nvars = sizes[4];
        RealType time = RealType.Time;
        RealType row = RealType.getRealType("row");
        RealType col = RealType.getRealType("col");
        RealType[] vars = new RealType[nvars];
        for (int i = 0; i < nvars; ++i) {
            String unit_spec = varunits[i];
            Unit unit = null;
            if (unit_spec != null) {
                try {
                    unit = Parser.parse(unit_spec);
                }
                catch (ParseException e) {
                    System.out.println(e.getMessage());
                }
            }
            vars[i] = RealType.getRealType(varnames[i], unit);
            if (vars[i] != null) continue;
            vars[i] = RealType.getRealType("var" + i);
        }
        double[][] proj_args = Set.floatToDouble(new float[][]{projargs});
        double[][] vert_args = Set.floatToDouble(new float[][]{vertargs});
        Vis5DCoordinateSystem coord_sys = new Vis5DCoordinateSystem(map_proj[0], proj_args[0], nr, nc);
        Vis5DVerticalSystem vert_coord_sys = null;
        Hashtable<Integer, Object> var_table = new Hashtable<Integer, Object>();
        for (int i = 0; i < nvars; ++i) {
            var_table.put(new Integer(n_levels[i]), new Object());
        }
        int n_var_groups = var_table.size();
        if (n_var_groups > 2) {
            throw new BadFormException("more than two variable groups by n_levels");
        }
        if (n_var_groups == 0) {
            throw new BadFormException("n_var_groups == 0");
        }
        RealType[][] var_grps = new RealType[n_var_groups][];
        RealType[] tmp_r = new RealType[nvars];
        int[][] var_grps_indexes = new int[n_var_groups][];
        int[] tmp_i = new int[nvars];
        int[] var_grps_nlevels = new int[n_var_groups];
        Enumeration en = var_table.keys();
        for (int grp = 0; grp < n_var_groups; ++grp) {
            Integer key = (Integer)en.nextElement();
            int cnt = 0;
            for (int i = 0; i < nvars; ++i) {
                if (n_levels[i] != key) continue;
                tmp_r[cnt] = vars[i];
                tmp_i[cnt] = i;
                ++cnt;
            }
            var_grps[grp] = new RealType[cnt];
            System.arraycopy(tmp_r, 0, var_grps[grp], 0, cnt);
            var_grps_indexes[grp] = new int[cnt];
            System.arraycopy(tmp_i, 0, var_grps_indexes[grp], 0, cnt);
            var_grps_nlevels[grp] = key;
        }
        FunctionType[][] grid_type = new FunctionType[n_var_groups][];
        Vis5DFile[][] v5dfile_s = new Vis5DFile[n_var_groups][];
        int n_comps = 0;
        for (int grp = 0; grp < n_var_groups; ++grp) {
            int grid_size;
            GriddedSet space_set;
            RealTupleType domain;
            RealType[] sub_vars = var_grps[grp];
            int[] sub_vars_indexes = var_grps_indexes[grp];
            nl = var_grps_nlevels[grp];
            if (nl > 1) {
                vert_coord_sys = new Vis5DVerticalSystem(vert_sys[0], nl, vert_args[0]);
                RealType height = vert_coord_sys.vert_type;
                CachingCoordinateSystem pcs = new CachingCoordinateSystem(new CartesianProductCoordinateSystem(new CoordinateSystem[]{coord_sys, vert_coord_sys.vert_cs}));
                domain = new RealTupleType(new RealType[]{row, col, height}, (CoordinateSystem)pcs, null);
                SampledSet vert_set = vert_coord_sys.vertSet;
                if (vert_set instanceof Linear1DSet) {
                    space_set = new Linear3DSet((MathType)domain, new Linear1DSet[]{new Integer1DSet((MathType)row, nr), new Integer1DSet((MathType)col, nc), (Linear1DSet)vert_set}, (CoordinateSystem)null, new Unit[]{null, null, vert_coord_sys.vert_unit}, (ErrorEstimate[])null);
                } else {
                    float[][] vert_samples = vert_set.getSamples();
                    float[][] domain_samples = new float[3][nr * nc * nl];
                    int idx = 0;
                    for (int kk = 0; kk < nl; ++kk) {
                        for (int jj = 0; jj < nc; ++jj) {
                            for (int ii = 0; ii < nr; ++ii) {
                                domain_samples[0][idx] = ii;
                                domain_samples[1][idx] = jj;
                                domain_samples[2][idx] = vert_samples[0][kk];
                                ++idx;
                            }
                        }
                    }
                    space_set = new Gridded3DSet((MathType)domain, domain_samples, nr, nc, nl, (CoordinateSystem)null, new Unit[]{null, null, vert_coord_sys.vert_unit}, null);
                }
                grid_type[grp] = new FunctionType[sub_vars.length];
                v5dfile_s[grp] = new Vis5DFile[sub_vars.length];
                grid_size = nr * nc * nl;
                for (int k = 0; k < sub_vars.length; ++k) {
                    grid_type[grp][k] = new FunctionType(domain, sub_vars[k]);
                    v5dfile_s[grp][k] = new Vis5DFile(id, vv, space_set, grid_type[grp][k], new RealType[]{sub_vars[k]}, new int[]{sub_vars_indexes[k]}, grid_size);
                }
                n_comps += grid_type[grp].length;
                continue;
            }
            domain = new RealTupleType(new RealType[]{row, col}, (CoordinateSystem)new CachingCoordinateSystem(coord_sys), null);
            space_set = new Integer2DSet((MathType)domain, nr, nc);
            grid_type[grp] = new FunctionType[1];
            v5dfile_s[grp] = new Vis5DFile[1];
            RealTupleType range = new RealTupleType(sub_vars);
            grid_type[grp][0] = new FunctionType(domain, range);
            grid_size = nr * nc * nl;
            v5dfile_s[grp][0] = new Vis5DFile(id, vv, space_set, grid_type[grp][0], sub_vars, sub_vars_indexes, grid_size);
            n_comps += grid_type[grp].length;
        }
        RealTupleType time_domain = new RealTupleType(time);
        MathType[] range_comps = new MathType[n_comps];
        int cnt = 0;
        for (int grp = 0; grp < grid_type.length; ++grp) {
            for (int i = 0; i < grid_type[grp].length; ++i) {
                range_comps[cnt++] = grid_type[grp][i];
            }
        }
        MathType v5d_range = range_comps.length == 1 ? range_comps[0] : new TupleType(range_comps);
        FunctionType v5d_type = new FunctionType(time_domain, v5d_range);
        double[][] timeses = new double[1][ntimes];
        for (int i = 0; i < ntimes; ++i) {
            timeses[0][i] = times[i];
        }
        OffsetUnit v5d_time_unit = new OffsetUnit(UnitParser.encodeTimestamp(1900, 1, 1, 0, 0, 0.0f, 0), SI.second);
        Gridded1DDoubleSet time_set = new Gridded1DDoubleSet((MathType)time, timeses, ntimes, null, new Unit[]{v5d_time_unit}, null);
        FieldImpl v5d = new FieldImpl(v5d_type, time_set);
        for (int i = 0; i < ntimes; ++i) {
            DataImpl range_data;
            if (range_comps.length == 1) {
                range_data = this.getFlatField(v5dfile_s[0][0], i);
            } else {
                Data[] datas = new DataImpl[range_comps.length];
                cnt = 0;
                for (int j = 0; j < v5dfile_s.length; ++j) {
                    for (int k = 0; k < v5dfile_s[j].length; ++k) {
                        datas[cnt++] = this.getFlatField(v5dfile_s[j][k], i);
                    }
                }
                range_data = new Tuple(datas, false);
            }
            v5d.setSample(i, (Data)range_data, false);
        }
        return v5d;
    }

    public FlatField getFlatField(Vis5DFile v5dfile, int time_idx) throws VisADException, IOException, BadFormException {
        return Vis5DForm.makeFlatField(v5dfile, time_idx);
    }

    public static FlatField makeFlatField(Vis5DFile v5dfile, int time_idx) throws VisADException, IOException, BadFormException {
        int nvars = v5dfile.nvars;
        int grid_size = v5dfile.grid_size;
        FunctionType grid_type = v5dfile.grid_type;
        Set space_set = v5dfile.space_set;
        V5DStruct vv = v5dfile.vv;
        RealType[] vars = v5dfile.vars;
        int[] vars_indexes = v5dfile.vars_indexes;
        float[][] data = new float[nvars][grid_size];
        Linear1DSet[] range_sets = new Linear1DSet[nvars];
        for (int j = 0; j < nvars; ++j) {
            int cnt;
            float[] ranges = new float[2];
            vv.v5d_read(time_idx, vars_indexes[j], ranges, data[j]);
            if ((double)ranges[0] >= 9.9E29 && (double)ranges[1] <= -9.9E29) {
                range_sets[j] = new Linear1DSet(0.0, 1.0, 255);
            } else {
                if (ranges[0] > ranges[1]) {
                    throw new BadFormException("Vis5DForm.open: bad read " + vars[j].getName());
                }
                range_sets[j] = new Linear1DSet(ranges[0], ranges[1], 255);
            }
            float[] tmp_data = new float[grid_size];
            int[] lens = ((GriddedSet)space_set).getLengths();
            if (lens.length == 2) {
                cnt = 0;
                for (int mm = 0; mm < lens[1]; ++mm) {
                    int start = (mm + 1) * lens[0] - 1;
                    for (int nn = 0; nn < lens[0]; ++nn) {
                        tmp_data[cnt++] = data[j][start--];
                    }
                }
            } else if (lens.length == 3) {
                cnt = 0;
                for (int ll = 0; ll < lens[2]; ++ll) {
                    for (int mm = 0; mm < lens[1]; ++mm) {
                        int start = (mm + 1) * lens[0] - 1 + lens[0] * lens[1] * ll;
                        for (int nn = 0; nn < lens[0]; ++nn) {
                            tmp_data[cnt++] = data[j][start--];
                        }
                    }
                }
            }
            System.arraycopy(tmp_data, 0, data[j], 0, grid_size);
            tmp_data = null;
            for (int k = 0; k < grid_size; ++k) {
                if (!((double)data[j][k] > 5.0E34)) continue;
                data[j][k] = Float.NaN;
            }
        }
        FlatField grid = new FlatField(grid_type, space_set);
        grid.setSamples(data, false);
        return grid;
    }

    public synchronized DataImpl open(URL url) throws BadFormException, VisADException, IOException {
        return this.open(url.toString());
    }

    public synchronized FormNode getForms(Data data) {
        return null;
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        int i;
        if (args == null || args.length < 1) {
            System.out.println("run 'java visad.data.vis5d.Vis5DForm file.v5d'");
        }
        Vis5DAdaptedForm form = new Vis5DAdaptedForm();
        FieldImpl vis5d = null;
        try {
            vis5d = (FieldImpl)form.open(args[0]);
            DumpType.dumpMathType(vis5d.getType());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return;
        }
        if (vis5d == null) {
            System.out.println("bad Vis5D file read");
            return;
        }
        FunctionType type = (FunctionType)vis5d.getType();
        FieldImpl new_vis5d = type.getRange() instanceof TupleType ? vis5d : vis5d;
        FunctionType vis5d_type = (FunctionType)new_vis5d.getType();
        System.out.println(vis5d_type);
        DataReferenceImpl vis5d_ref = new DataReferenceImpl("vis5d_ref");
        vis5d_ref.setData(new_vis5d);
        JFrame frame = new JFrame("Vis5D");
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        frame.addWindowListener(l);
        frame.setSize(WIDTH, HEIGHT);
        frame.setCursor(Cursor.getPredefinedCursor(0));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - WIDTH / 2, screenSize.height / 2 - HEIGHT / 2);
        JPanel big_panel = new JPanel();
        big_panel.setLayout(new BoxLayout(big_panel, 0));
        big_panel.setAlignmentY(0.0f);
        big_panel.setAlignmentX(0.0f);
        frame.getContentPane().add(big_panel);
        JPanel left = new JPanel();
        left.setLayout(new BoxLayout(left, 1));
        left.setAlignmentY(0.0f);
        left.setAlignmentX(0.0f);
        big_panel.add(left);
        left.add(new JLabel("Simple Vis5D File Viewer using VisAD - See:"));
        left.add(new JLabel("  "));
        left.add(new JLabel("  http://www.ssec.wisc.edu/~billh/visad.html"));
        left.add(new JLabel("  "));
        left.add(new JLabel("for more information about VisAD."));
        left.add(new JLabel("  "));
        left.add(new JLabel("Space Science and Engineering Center"));
        left.add(new JLabel("University of Wisconsin - Madison"));
        left.add(new JLabel("  "));
        left.add(new JLabel("  "));
        left.add(new JLabel("Move sliders to adjust iso-surface levels"));
        left.add(new JLabel("  "));
        left.add(new JLabel("Click Animate button to toggle animation"));
        left.add(new JLabel("  "));
        left.add(new JLabel("Rotate scenes with left mouse button."));
        left.add(new JLabel("  "));
        left.add(new JLabel("  "));
        left.add(new JLabel("  "));
        JPanel sliders = new JPanel();
        sliders.setName("GoesRetrieval Sliders");
        sliders.setFont(new Font("Dialog", 0, 12));
        sliders.setLayout(new BoxLayout(sliders, 1));
        sliders.setAlignmentY(0.0f);
        sliders.setAlignmentX(0.0f);
        left.add(sliders);
        JPanel display_panel = new JPanel();
        display_panel.setLayout(new BoxLayout(display_panel, 0));
        display_panel.setAlignmentY(0.0f);
        display_panel.setAlignmentX(0.0f);
        big_panel.add(display_panel);
        DisplayImplJ3D display = new DisplayImplJ3D("image display");
        GraphicsModeControl mode = ((DisplayImpl)display).getGraphicsModeControl();
        mode.setScaleEnable(true);
        display_panel.add(display.getComponent());
        RealType time = (RealType)vis5d_type.getDomain().getComponent(0);
        ScalarMap animation_map = new ScalarMap(time, Display.Animation);
        display.addMap(animation_map);
        final AnimationControl animation_control = (AnimationControl)((Object)animation_map.getControl());
        display.addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
        display.addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        display.addMap(new ScalarMap(RealType.Altitude, Display.ZAxis));
        int n_range_real_types = 0;
        MathType v5d_range = vis5d_type.getRange();
        RealType[] tmp = new RealType[200];
        if (v5d_range instanceof TupleType) {
            for (int ii = 0; ii < ((TupleType)v5d_range).getDimension(); ++ii) {
                FunctionType f_type = (FunctionType)((TupleType)v5d_range).getComponent(ii);
                MathType mtype = f_type.getRange();
                if (mtype instanceof TupleType) {
                    int nn = ((TupleType)mtype).getDimension();
                    for (int kk = 0; kk < nn; ++kk) {
                        tmp[n_range_real_types++] = (RealType)((TupleType)mtype).getComponent(kk);
                    }
                    continue;
                }
                tmp[n_range_real_types++] = (RealType)mtype;
            }
        } else {
            MathType mtype = ((FunctionType)v5d_range).getRange();
            if (mtype instanceof TupleType) {
                int nn = ((TupleType)mtype).getDimension();
                for (int kk = 0; kk < nn; ++kk) {
                    tmp[n_range_real_types++] = (RealType)((TupleType)mtype).getComponent(kk);
                }
            } else {
                tmp[n_range_real_types++] = (RealType)mtype;
            }
        }
        int dim = n_range_real_types;
        RealType[] range_types = new RealType[dim];
        ScalarMap[] contour_maps = new ScalarMap[dim];
        ContourControl[] contour_controls = new ContourControl[dim];
        DataReferenceImpl[] range_refs = new DataReferenceImpl[dim];
        for (int i2 = 0; i2 < dim; ++i2) {
            range_types[i2] = tmp[i2];
            contour_maps[i2] = new ScalarMap(range_types[i2], Display.IsoContour);
            try {
                display.addMap(contour_maps[i2]);
                contour_controls[i2] = (ContourControl)contour_maps[i2].getControl();
                contour_controls[i2].enableContours(false);
            }
            catch (BadMappingException bme) {
                // empty catch block
            }
            range_refs[i2] = new DataReferenceImpl(range_types[i2].getName() + "_ref");
        }
        display.addReference(vis5d_ref);
        boolean scaled = false;
        double[][] ranges = new double[dim][];
        block10: while (!scaled) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            scaled = true;
            for (i = 0; i < dim; ++i) {
                ranges[i] = contour_maps[i].getRange();
                if (ranges[i][0] == ranges[i][0] && ranges[i][1] == ranges[i][1]) continue;
                scaled = false;
                continue block10;
            }
        }
        for (i = 0; i < dim; ++i) {
            double scale = (ranges[i][1] - ranges[i][0]) / 255.0;
            int low = (int)(ranges[i][0] / scale);
            int hi = (int)(ranges[i][1] / scale);
            range_refs[i].setData(new Real(range_types[i], scale * (double)low));
            sliders.add(new VisADSlider(range_types[i].getName(), low, hi, low, scale, range_refs[i], range_types[i]));
            sliders.add(new JLabel("  "));
            Vis5DAdaptedForm vis5DAdaptedForm = form;
            vis5DAdaptedForm.getClass();
            ContourCell cell = vis5DAdaptedForm.new ContourCell(contour_controls[i], range_refs[i]);
            cell.addReference(range_refs[i]);
        }
        final JToggleButton button = new JToggleButton("Animate", false);
        button.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                try {
                    boolean state = button.getModel().isSelected();
                    animation_control.setOn(state);
                }
                catch (VisADException ee) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
        sliders.add(button);
        frame.setVisible(true);
    }

    class ContourCell
    extends CellImpl {
        ContourControl control;
        DataReference ref;
        double value;

        ContourCell(ContourControl c, DataReference r) throws VisADException, RemoteException {
            this.control = c;
            this.ref = r;
            this.value = ((Real)this.ref.getData()).getValue();
        }

        public void doAction() throws VisADException, RemoteException {
            double val = ((Real)this.ref.getData()).getValue();
            if (val == val && val != this.value) {
                this.control.setSurfaceValue((float)((Real)this.ref.getData()).getValue());
                this.control.enableContours(true);
                this.value = val;
            }
        }
    }
}

