/*
 * Decompiled with CFR 0.152.
 */
package visad.install;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import visad.install.Download;
import visad.install.Path;
import visad.util.CmdlineGenericConsumer;
import visad.util.CmdlineParser;

public class UpdateJar
extends CmdlineGenericConsumer {
    private static final String CLASSPATH_PROPERTY = "java.class.path";
    private static final String VISAD_JAR_URL = "http://www.ssec.wisc.edu/~dglo/visad.jar";
    private File installJar;
    private URL jarURL;
    private boolean verbose;

    public UpdateJar(String[] args) {
        CmdlineParser cmdline = new CmdlineParser(this);
        if (!cmdline.processArgs(args)) {
            System.exit(1);
            return;
        }
        Download.getFile(this.jarURL, this.installJar, this.verbose);
    }

    public int checkKeyword(String mainName, int thisArg, String[] args) {
        String suffix;
        URL tmpURL;
        try {
            tmpURL = new URL(args[thisArg]);
        }
        catch (MalformedURLException mfe) {
            tmpURL = null;
        }
        if (tmpURL != null) {
            if (this.jarURL != null) {
                System.err.println(mainName + ": Too many URLs specified!");
                return -1;
            }
            this.jarURL = tmpURL;
            return 1;
        }
        if (this.installJar != null) {
            System.err.println(mainName + ": Too many jar install directories specified!");
            return -1;
        }
        int thisLen = args[thisArg].length();
        int suffixLen = 4;
        File dir = this.installJar = new File(args[thisArg]);
        String baseName = null;
        if (thisLen > 4 && (suffix = args[thisArg].substring(thisLen - 4, thisLen)).toLowerCase().equals(".jar")) {
            baseName = this.installJar.getName();
            dir = new File(this.installJar.getParent());
        }
        if (!dir.exists()) {
            System.err.println(mainName + ": Directory \"" + dir + "\" does not exist!");
            this.installJar = null;
            return -1;
        }
        if (!dir.isDirectory()) {
            System.err.println(mainName + ": \"" + dir + "\" is not a directory!");
            this.installJar = null;
            return -1;
        }
        if (!dir.canWrite()) {
            System.err.println(mainName + ": Cannot write to directory \"" + dir + "\"!");
            this.installJar = null;
            return -1;
        }
        if (this.installJar != dir && this.installJar.exists() && !this.installJar.canWrite()) {
            System.err.println(mainName + ": Cannot write to jar file \"" + this.installJar + "\"!");
            this.installJar = null;
            return -1;
        }
        return 1;
    }

    public int checkOption(String mainName, char ch, String arg) {
        if (ch == 'v') {
            this.verbose = true;
            return 1;
        }
        return 0;
    }

    public boolean finalizeArgs(String mainName) {
        if (this.jarURL == null) {
            try {
                this.jarURL = new URL(VISAD_JAR_URL);
            }
            catch (MalformedURLException mue) {
                System.err.println(mainName + ": Couldn't build URL from \"" + VISAD_JAR_URL + "\"");
                return false;
            }
        }
        if (this.installJar == null) {
            File urlFile = new File(this.jarURL.getFile());
            this.installJar = this.findJar(urlFile.getName());
        }
        if (this.installJar == null) {
            System.err.println(mainName + ": Couldn't determine" + " where jar file should be installed");
            return false;
        }
        return true;
    }

    private File findJar(String jarName) {
        Path classpath;
        try {
            classpath = new Path(System.getProperty(CLASSPATH_PROPERTY));
        }
        catch (IllegalArgumentException iae) {
            System.err.println(this.getClass().getName() + ": Couldn't get Java class path");
            return null;
        }
        ArrayList jarList = classpath.findMatch(jarName);
        if (jarList == null || jarList.size() == 0) {
            return null;
        }
        return (File)jarList.get(0);
    }

    public void initializeArgs() {
        this.installJar = null;
        this.jarURL = null;
    }

    public String keywordUsage() {
        return " [url] [jarLocation]";
    }

    public String optionUsage() {
        return " [-v(erbose)]";
    }

    public static final void main(String[] args) {
        new UpdateJar(args);
        System.exit(0);
    }
}

