#!/bin/bash
#
# Mini-gallery script for Pyntor PNG exports

f=index.html

for i in slide*.png; do
	convert -scale 200 $i thumb.$i
done

cat > $f << EOF
<html>
<title>
Presentation exported by Pyntor
</title>
<body>
<table>
EOF

z=0
echo "<tr>" >> $f
for i in slide*.png; do
	echo "<td>" >> $f
	echo "<a href=\"$i\"><img src=\"thumb.$i\"></a>" >> $f
	echo "</td>" >> $f
	if test $[$z % 3] == 2; then
		echo "</tr>" >> $f
		echo "<tr>" >> $f
	fi
	z=$[$z + 1]
done
while test $[$z % 3] -gt 0; do
	echo "<td><!-- empty --></td>" >> $f
	z=$[$z + 1]
done
echo "</tr>" >> $f

cat >> $f << EOF
</table>
</body>
</html>
EOF

