--
-- MySQL data file for Network Flow 1ef10
-- Generated Tue Jul 12 11:32:21 -0600 2011
--

drop table if exists Demand;
drop table if exists FCost;
drop table if exists b0Cost;
drop table if exists CapCost;
drop table if exists Arcs;
drop table if exists Nodes;

create table Nodes ( name varchar(16) not null default '', primary key (name) ) engine=innodb;
insert into Nodes values ('A'),('B'),('C'),('D'),('E'),('F'),('G'),('H'),('I'),('J');

create table Arcs ( 
        first varchar(16) not null, 
        second varchar(16) not null, 
        primary key (first, second),
        foreign key (first) references Nodes (name),
        foreign key (second) references Nodes (name)
        ) engine=innodb ;
insert into Arcs values ('A','B'),('B','A'),('A','C'),('C','A'),('B','C'),('C','B'),('B','D'),('D','B'),('B','E'),('E','B'),('C','D'),('D','C'),('D','E'),('E','D'),('F','G'),('G','F'),('F','H'),('H','F'),('G','H'),('H','G'),('G','I'),('I','G'),('G','J'),('J','G'),('H','I'),('I','H'),('I','J'),('J','I'),('E','F'),('F','E');

create table CapCost (
        first varchar(16) not null,
        second varchar(16) not null,
        cost int not null,
        primary key (first, second),
        foreign key (first, second) references Arcs (first, second)
        ) engine=innodb ;
insert into CapCost values ('A','B','112'),('A','C','123'),('B','C','116'),('B','D','128'),('B','E','130'),('C','D','112'),('D','E','110'),('B','A','112'),('C','A','123'),('C','B','116'),('D','B','128'),('E','B','130'),('D','C','112'),('E','D','110'),('E','F','110'),('F','E','110'),('F','G','112'),('F','H','128'),('G','H','116'),('G','I','123'),('G','J','130'),('H','I','112'),('I','J','110'),('G','F','112'),('H','F','128'),('H','G','116'),('I','G','123'),('J','G','130'),('I','H','112'),('J','I','110');

create table b0Cost (
        first varchar(16) not null,
        second varchar(16) not null,
        cost int not null,
        primary key (first, second),
        foreign key (first, second) references Arcs (first, second)
        ) engine=innodb ;
insert into b0Cost values ('A','B','1120'),('A','C','1230'),('B','C','1160'),('B','D','1280'),('B','E','1300'),('C','D','1120'),('D','E','1100'),('B','A','1120'),('C','A','1230'),('C','B','1160'),('D','B','1280'),('E','B','1300'),('D','C','1120'),('E','D','1100'),('E','F','1100'),('F','E','1100'),('F','G','1120'),('F','H','1280'),('G','H','1160'),('G','I','1230'),('G','J','1300'),('H','I','1120'),('I','J','1100'),('G','F','1120'),('H','F','1280'),('H','G','1160'),('I','G','1230'),('J','G','1300'),('I','H','1120'),('J','I','1100');

create table FCost (
        scenario int not null default 0,
        first varchar(16) not null,
        second varchar(16) not null,
        cost float not null,
        primary key (scenario, first, second),
        foreign key (first) references Nodes (name),
        foreign key (second) references Nodes (name)
        ) engine=innodb ;
insert into FCost values ('1','A','A','0.00'),('1','A','B','560.00'),('1','A','C','1845.00'),('1','A','D','2010.00'),('1','A','E','2175.00'),('1','A','F','1560.00'),('1','A','G','1670.00'),('1','A','H','1780.00'),('1','A','I','2835.00'),('1','A','J','950.00'),('1','B','A','560.00'),('1','B','B','0.00'),('1','B','C','1740.00'),('1','B','D','640.00'),('1','B','E','650.00'),('1','B','F','1420.00'),('1','B','G','2310.00'),('1','B','H','1660.00'),('1','B','I','890.00'),('1','B','J','900.00'),('1','C','A','1845.00'),('1','C','B','1740.00'),('1','C','C','0.00'),('1','C','D','1680.00'),('1','C','E','1250.00'),('1','C','F','2070.00'),('1','C','G','705.00'),('1','C','H','1540.00'),('1','C','I','835.00'),('1','C','J','1700.00'),('1','D','A','2010.00'),('1','D','B','640.00'),('1','D','C','1680.00'),('1','D','D','0.00'),('1','D','E','1100.00'),('1','D','F','1860.00'),('1','D','G','690.00'),('1','D','H','710.00'),('1','D','I','2340.00'),('1','D','J','1600.00'),('1','E','A','2175.00'),('1','E','B','650.00'),('1','E','C','1250.00'),('1','E','D','1100.00'),('1','E','E','0.00'),('1','E','F','1100.00'),('1','E','G','1875.00'),('1','E','H','1300.00'),('1','E','I','2175.00'),('1','E','J','1500.00'),('1','F','A','1560.00'),('1','F','B','1420.00'),('1','F','C','2070.00'),('1','F','D','1860.00'),('1','F','E','1100.00'),('1','F','F','0.00'),('1','F','G','560.00'),('1','F','H','640.00'),('1','F','I','2010.00'),('1','F','J','700.00'),('1','G','A','1670.00'),('1','G','B','2310.00'),('1','G','C','705.00'),('1','G','D','690.00'),('1','G','E','1875.00'),('1','G','F','560.00'),('1','G','G','0.00'),('1','G','H','1740.00'),('1','G','I','615.00'),('1','G','J','1950.00'),('1','H','A','1780.00'),('1','H','B','1660.00'),('1','H','C','1540.00'),('1','H','D','710.00'),('1','H','E','1300.00'),('1','H','F','640.00'),('1','H','G','1740.00'),('1','H','H','0.00'),('1','H','I','560.00'),('1','H','J','600.00'),('1','I','A','2835.00'),('1','I','B','890.00'),('1','I','C','835.00'),('1','I','D','2340.00'),('1','I','E','2175.00'),('1','I','F','2010.00'),('1','I','G','615.00'),('1','I','H','560.00'),('1','I','I','0.00'),('1','I','J','550.00'),('1','J','A','950.00'),('1','J','B','900.00'),('1','J','C','1700.00'),('1','J','D','1600.00'),('1','J','E','1500.00'),('1','J','F','700.00'),('1','J','G','1950.00'),('1','J','H','600.00'),('1','J','I','550.00'),('1','J','J','0.00');
insert into FCost values ('2','A','A','0.00'),('2','A','B','560.00'),('2','A','C','1230.00'),('2','A','D','1340.00'),('2','A','E','2175.00'),('2','A','F','2340.00'),('2','A','G','2505.00'),('2','A','H','890.00'),('2','A','I','2835.00'),('2','A','J','1900.00'),('2','B','A','560.00'),('2','B','B','0.00'),('2','B','C','1160.00'),('2','B','D','640.00'),('2','B','E','1950.00'),('2','B','F','710.00'),('2','B','G','1540.00'),('2','B','H','830.00'),('2','B','I','890.00'),('2','B','J','1800.00'),('2','C','A','1230.00'),('2','C','B','1160.00'),('2','C','C','0.00'),('2','C','D','1120.00'),('2','C','E','1250.00'),('2','C','F','690.00'),('2','C','G','705.00'),('2','C','H','1540.00'),('2','C','I','835.00'),('2','C','J','1700.00'),('2','D','A','1340.00'),('2','D','B','640.00'),('2','D','C','1120.00'),('2','D','D','0.00'),('2','D','E','550.00'),('2','D','F','1860.00'),('2','D','G','1380.00'),('2','D','H','710.00'),('2','D','I','1560.00'),('2','D','J','800.00'),('2','E','A','2175.00'),('2','E','B','1950.00'),('2','E','C','1250.00'),('2','E','D','550.00'),('2','E','E','0.00'),('2','E','F','1650.00'),('2','E','G','1875.00'),('2','E','H','650.00'),('2','E','I','1450.00'),('2','E','J','750.00'),('2','F','A','2340.00'),('2','F','B','710.00'),('2','F','C','690.00'),('2','F','D','1860.00'),('2','F','E','1650.00'),('2','F','F','0.00'),('2','F','G','1680.00'),('2','F','H','640.00'),('2','F','I','1340.00'),('2','F','J','2100.00'),('2','G','A','2505.00'),('2','G','B','1540.00'),('2','G','C','705.00'),('2','G','D','1380.00'),('2','G','E','1875.00'),('2','G','F','1680.00'),('2','G','G','0.00'),('2','G','H','1160.00'),('2','G','I','1230.00'),('2','G','J','650.00'),('2','H','A','890.00'),('2','H','B','830.00'),('2','H','C','1540.00'),('2','H','D','710.00'),('2','H','E','650.00'),('2','H','F','640.00'),('2','H','G','1160.00'),('2','H','H','0.00'),('2','H','I','1120.00'),('2','H','J','1800.00'),('2','I','A','2835.00'),('2','I','B','890.00'),('2','I','C','835.00'),('2','I','D','1560.00'),('2','I','E','1450.00'),('2','I','F','1340.00'),('2','I','G','1230.00'),('2','I','H','1120.00'),('2','I','I','0.00'),('2','I','J','550.00'),('2','J','A','1900.00'),('2','J','B','1800.00'),('2','J','C','1700.00'),('2','J','D','800.00'),('2','J','E','750.00'),('2','J','F','2100.00'),('2','J','G','650.00'),('2','J','H','1800.00'),('2','J','I','550.00'),('2','J','J','0.00');
insert into FCost values ('3','A','A','0.00'),('3','A','B','1120.00'),('3','A','C','1230.00'),('3','A','D','670.00'),('3','A','E','1450.00'),('3','A','F','1560.00'),('3','A','G','835.00'),('3','A','H','1780.00'),('3','A','I','1890.00'),('3','A','J','1900.00'),('3','B','A','1120.00'),('3','B','B','0.00'),('3','B','C','1160.00'),('3','B','D','1920.00'),('3','B','E','650.00'),('3','B','F','710.00'),('3','B','G','770.00'),('3','B','H','2490.00'),('3','B','I','2670.00'),('3','B','J','1800.00'),('3','C','A','1230.00'),('3','C','B','1160.00'),('3','C','C','0.00'),('3','C','D','560.00'),('3','C','E','1875.00'),('3','C','F','690.00'),('3','C','G','2115.00'),('3','C','H','2310.00'),('3','C','I','835.00'),('3','C','J','2550.00'),('3','D','A','670.00'),('3','D','B','1920.00'),('3','D','C','560.00'),('3','D','D','0.00'),('3','D','E','1100.00'),('3','D','F','1240.00'),('3','D','G','1380.00'),('3','D','H','710.00'),('3','D','I','1560.00'),('3','D','J','1600.00'),('3','E','A','1450.00'),('3','E','B','650.00'),('3','E','C','1875.00'),('3','E','D','1100.00'),('3','E','E','0.00'),('3','E','F','1650.00'),('3','E','G','625.00'),('3','E','H','1300.00'),('3','E','I','725.00'),('3','E','J','750.00'),('3','F','A','1560.00'),('3','F','B','710.00'),('3','F','C','690.00'),('3','F','D','1240.00'),('3','F','E','1650.00'),('3','F','F','0.00'),('3','F','G','1120.00'),('3','F','H','1280.00'),('3','F','I','670.00'),('3','F','J','700.00'),('3','G','A','835.00'),('3','G','B','770.00'),('3','G','C','2115.00'),('3','G','D','1380.00'),('3','G','E','625.00'),('3','G','F','1120.00'),('3','G','G','0.00'),('3','G','H','1740.00'),('3','G','I','615.00'),('3','G','J','1950.00'),('3','H','A','1780.00'),('3','H','B','2490.00'),('3','H','C','2310.00'),('3','H','D','710.00'),('3','H','E','1300.00'),('3','H','F','1280.00'),('3','H','G','1740.00'),('3','H','H','0.00'),('3','H','I','1680.00'),('3','H','J','1800.00'),('3','I','A','1890.00'),('3','I','B','2670.00'),('3','I','C','835.00'),('3','I','D','1560.00'),('3','I','E','725.00'),('3','I','F','670.00'),('3','I','G','615.00'),('3','I','H','1680.00'),('3','I','I','0.00'),('3','I','J','1650.00'),('3','J','A','1900.00'),('3','J','B','1800.00'),('3','J','C','2550.00'),('3','J','D','1600.00'),('3','J','E','750.00'),('3','J','F','700.00'),('3','J','G','1950.00'),('3','J','H','1800.00'),('3','J','I','1650.00'),('3','J','J','0.00');
insert into FCost values ('4','A','A','0.00'),('4','A','B','1120.00'),('4','A','C','1230.00'),('4','A','D','670.00'),('4','A','E','1450.00'),('4','A','F','2340.00'),('4','A','G','2505.00'),('4','A','H','890.00'),('4','A','I','1890.00'),('4','A','J','950.00'),('4','B','A','1120.00'),('4','B','B','0.00'),('4','B','C','1160.00'),('4','B','D','1920.00'),('4','B','E','1950.00'),('4','B','F','1420.00'),('4','B','G','770.00'),('4','B','H','1660.00'),('4','B','I','890.00'),('4','B','J','1800.00'),('4','C','A','1230.00'),('4','C','B','1160.00'),('4','C','C','0.00'),('4','C','D','1120.00'),('4','C','E','1875.00'),('4','C','F','690.00'),('4','C','G','1410.00'),('4','C','H','770.00'),('4','C','I','1670.00'),('4','C','J','2550.00'),('4','D','A','670.00'),('4','D','B','1920.00'),('4','D','C','1120.00'),('4','D','D','0.00'),('4','D','E','550.00'),('4','D','F','620.00'),('4','D','G','690.00'),('4','D','H','2130.00'),('4','D','I','780.00'),('4','D','J','800.00'),('4','E','A','1450.00'),('4','E','B','1950.00'),('4','E','C','1875.00'),('4','E','D','550.00'),('4','E','E','0.00'),('4','E','F','1100.00'),('4','E','G','1875.00'),('4','E','H','1950.00'),('4','E','I','725.00'),('4','E','J','1500.00'),('4','F','A','2340.00'),('4','F','B','1420.00'),('4','F','C','690.00'),('4','F','D','620.00'),('4','F','E','1100.00'),('4','F','F','0.00'),('4','F','G','560.00'),('4','F','H','1920.00'),('4','F','I','2010.00'),('4','F','J','700.00'),('4','G','A','2505.00'),('4','G','B','770.00'),('4','G','C','1410.00'),('4','G','D','690.00'),('4','G','E','1875.00'),('4','G','F','560.00'),('4','G','G','0.00'),('4','G','H','1160.00'),('4','G','I','1230.00'),('4','G','J','1950.00'),('4','H','A','890.00'),('4','H','B','1660.00'),('4','H','C','770.00'),('4','H','D','2130.00'),('4','H','E','1950.00'),('4','H','F','1920.00'),('4','H','G','1160.00'),('4','H','H','0.00'),('4','H','I','560.00'),('4','H','J','1800.00'),('4','I','A','1890.00'),('4','I','B','890.00'),('4','I','C','1670.00'),('4','I','D','780.00'),('4','I','E','725.00'),('4','I','F','2010.00'),('4','I','G','1230.00'),('4','I','H','560.00'),('4','I','I','0.00'),('4','I','J','1650.00'),('4','J','A','950.00'),('4','J','B','1800.00'),('4','J','C','2550.00'),('4','J','D','800.00'),('4','J','E','1500.00'),('4','J','F','700.00'),('4','J','G','1950.00'),('4','J','H','1800.00'),('4','J','I','1650.00'),('4','J','J','0.00');
insert into FCost values ('5','A','A','0.00'),('5','A','B','1680.00'),('5','A','C','1230.00'),('5','A','D','670.00'),('5','A','E','1450.00'),('5','A','F','2340.00'),('5','A','G','2505.00'),('5','A','H','2670.00'),('5','A','I','2835.00'),('5','A','J','2850.00'),('5','B','A','1680.00'),('5','B','B','0.00'),('5','B','C','1740.00'),('5','B','D','640.00'),('5','B','E','1950.00'),('5','B','F','2130.00'),('5','B','G','770.00'),('5','B','H','1660.00'),('5','B','I','890.00'),('5','B','J','2700.00'),('5','C','A','1230.00'),('5','C','B','1740.00'),('5','C','C','0.00'),('5','C','D','560.00'),('5','C','E','1875.00'),('5','C','F','2070.00'),('5','C','G','2115.00'),('5','C','H','770.00'),('5','C','I','2505.00'),('5','C','J','1700.00'),('5','D','A','670.00'),('5','D','B','640.00'),('5','D','C','560.00'),('5','D','D','0.00'),('5','D','E','550.00'),('5','D','F','620.00'),('5','D','G','1380.00'),('5','D','H','1420.00'),('5','D','I','1560.00'),('5','D','J','1600.00'),('5','E','A','1450.00'),('5','E','B','1950.00'),('5','E','C','1875.00'),('5','E','D','550.00'),('5','E','E','0.00'),('5','E','F','550.00'),('5','E','G','625.00'),('5','E','H','1950.00'),('5','E','I','2175.00'),('5','E','J','1500.00'),('5','F','A','2340.00'),('5','F','B','2130.00'),('5','F','C','2070.00'),('5','F','D','620.00'),('5','F','E','550.00'),('5','F','F','0.00'),('5','F','G','1120.00'),('5','F','H','1280.00'),('5','F','I','1340.00'),('5','F','J','1400.00'),('5','G','A','2505.00'),('5','G','B','770.00'),('5','G','C','2115.00'),('5','G','D','1380.00'),('5','G','E','625.00'),('5','G','F','1120.00'),('5','G','G','0.00'),('5','G','H','1740.00'),('5','G','I','615.00'),('5','G','J','1950.00'),('5','H','A','2670.00'),('5','H','B','1660.00'),('5','H','C','770.00'),('5','H','D','1420.00'),('5','H','E','1950.00'),('5','H','F','1280.00'),('5','H','G','1740.00'),('5','H','H','0.00'),('5','H','I','560.00'),('5','H','J','600.00'),('5','I','A','2835.00'),('5','I','B','890.00'),('5','I','C','2505.00'),('5','I','D','1560.00'),('5','I','E','2175.00'),('5','I','F','1340.00'),('5','I','G','615.00'),('5','I','H','560.00'),('5','I','I','0.00'),('5','I','J','1650.00'),('5','J','A','2850.00'),('5','J','B','2700.00'),('5','J','C','1700.00'),('5','J','D','1600.00'),('5','J','E','1500.00'),('5','J','F','1400.00'),('5','J','G','1950.00'),('5','J','H','600.00'),('5','J','I','1650.00'),('5','J','J','0.00');
insert into FCost values ('6','A','A','0.00'),('6','A','B','1120.00'),('6','A','C','1230.00'),('6','A','D','1340.00'),('6','A','E','1450.00'),('6','A','F','1560.00'),('6','A','G','1670.00'),('6','A','H','890.00'),('6','A','I','1890.00'),('6','A','J','950.00'),('6','B','A','1120.00'),('6','B','B','0.00'),('6','B','C','1740.00'),('6','B','D','1920.00'),('6','B','E','650.00'),('6','B','F','2130.00'),('6','B','G','770.00'),('6','B','H','830.00'),('6','B','I','2670.00'),('6','B','J','2700.00'),('6','C','A','1230.00'),('6','C','B','1740.00'),('6','C','C','0.00'),('6','C','D','1680.00'),('6','C','E','1875.00'),('6','C','F','2070.00'),('6','C','G','2115.00'),('6','C','H','2310.00'),('6','C','I','835.00'),('6','C','J','850.00'),('6','D','A','1340.00'),('6','D','B','1920.00'),('6','D','C','1680.00'),('6','D','D','0.00'),('6','D','E','550.00'),('6','D','F','1240.00'),('6','D','G','1380.00'),('6','D','H','2130.00'),('6','D','I','2340.00'),('6','D','J','2400.00'),('6','E','A','1450.00'),('6','E','B','650.00'),('6','E','C','1875.00'),('6','E','D','550.00'),('6','E','E','0.00'),('6','E','F','1650.00'),('6','E','G','1875.00'),('6','E','H','1950.00'),('6','E','I','725.00'),('6','E','J','2250.00'),('6','F','A','1560.00'),('6','F','B','2130.00'),('6','F','C','2070.00'),('6','F','D','1240.00'),('6','F','E','1650.00'),('6','F','F','0.00'),('6','F','G','1680.00'),('6','F','H','1280.00'),('6','F','I','670.00'),('6','F','J','700.00'),('6','G','A','1670.00'),('6','G','B','770.00'),('6','G','C','2115.00'),('6','G','D','1380.00'),('6','G','E','1875.00'),('6','G','F','1680.00'),('6','G','G','0.00'),('6','G','H','580.00'),('6','G','I','615.00'),('6','G','J','1950.00'),('6','H','A','890.00'),('6','H','B','830.00'),('6','H','C','2310.00'),('6','H','D','2130.00'),('6','H','E','1950.00'),('6','H','F','1280.00'),('6','H','G','580.00'),('6','H','H','0.00'),('6','H','I','1120.00'),('6','H','J','1200.00'),('6','I','A','1890.00'),('6','I','B','2670.00'),('6','I','C','835.00'),('6','I','D','2340.00'),('6','I','E','725.00'),('6','I','F','670.00'),('6','I','G','615.00'),('6','I','H','1120.00'),('6','I','I','0.00'),('6','I','J','1100.00'),('6','J','A','950.00'),('6','J','B','2700.00'),('6','J','C','850.00'),('6','J','D','2400.00'),('6','J','E','2250.00'),('6','J','F','700.00'),('6','J','G','1950.00'),('6','J','H','1200.00'),('6','J','I','1100.00'),('6','J','J','0.00');
insert into FCost values ('7','A','A','0.00'),('7','A','B','560.00'),('7','A','C','615.00'),('7','A','D','2010.00'),('7','A','E','2175.00'),('7','A','F','2340.00'),('7','A','G','835.00'),('7','A','H','2670.00'),('7','A','I','1890.00'),('7','A','J','2850.00'),('7','B','A','560.00'),('7','B','B','0.00'),('7','B','C','1740.00'),('7','B','D','640.00'),('7','B','E','650.00'),('7','B','F','1420.00'),('7','B','G','2310.00'),('7','B','H','830.00'),('7','B','I','890.00'),('7','B','J','900.00'),('7','C','A','615.00'),('7','C','B','1740.00'),('7','C','C','0.00'),('7','C','D','560.00'),('7','C','E','1875.00'),('7','C','F','1380.00'),('7','C','G','2115.00'),('7','C','H','770.00'),('7','C','I','835.00'),('7','C','J','2550.00'),('7','D','A','2010.00'),('7','D','B','640.00'),('7','D','C','560.00'),('7','D','D','0.00'),('7','D','E','1100.00'),('7','D','F','620.00'),('7','D','G','690.00'),('7','D','H','2130.00'),('7','D','I','780.00'),('7','D','J','2400.00'),('7','E','A','2175.00'),('7','E','B','650.00'),('7','E','C','1875.00'),('7','E','D','1100.00'),('7','E','E','0.00'),('7','E','F','1100.00'),('7','E','G','625.00'),('7','E','H','650.00'),('7','E','I','1450.00'),('7','E','J','1500.00'),('7','F','A','2340.00'),('7','F','B','1420.00'),('7','F','C','1380.00'),('7','F','D','620.00'),('7','F','E','1100.00'),('7','F','F','0.00'),('7','F','G','1680.00'),('7','F','H','1920.00'),('7','F','I','1340.00'),('7','F','J','700.00'),('7','G','A','835.00'),('7','G','B','2310.00'),('7','G','C','2115.00'),('7','G','D','690.00'),('7','G','E','625.00'),('7','G','F','1680.00'),('7','G','G','0.00'),('7','G','H','1160.00'),('7','G','I','615.00'),('7','G','J','1300.00'),('7','H','A','2670.00'),('7','H','B','830.00'),('7','H','C','770.00'),('7','H','D','2130.00'),('7','H','E','650.00'),('7','H','F','1920.00'),('7','H','G','1160.00'),('7','H','H','0.00'),('7','H','I','1120.00'),('7','H','J','600.00'),('7','I','A','1890.00'),('7','I','B','890.00'),('7','I','C','835.00'),('7','I','D','780.00'),('7','I','E','1450.00'),('7','I','F','1340.00'),('7','I','G','615.00'),('7','I','H','1120.00'),('7','I','I','0.00'),('7','I','J','1650.00'),('7','J','A','2850.00'),('7','J','B','900.00'),('7','J','C','2550.00'),('7','J','D','2400.00'),('7','J','E','1500.00'),('7','J','F','700.00'),('7','J','G','1300.00'),('7','J','H','600.00'),('7','J','I','1650.00'),('7','J','J','0.00');
insert into FCost values ('8','A','A','0.00'),('8','A','B','1120.00'),('8','A','C','1230.00'),('8','A','D','670.00'),('8','A','E','1450.00'),('8','A','F','2340.00'),('8','A','G','835.00'),('8','A','H','1780.00'),('8','A','I','1890.00'),('8','A','J','1900.00'),('8','B','A','1120.00'),('8','B','B','0.00'),('8','B','C','580.00'),('8','B','D','1920.00'),('8','B','E','1950.00'),('8','B','F','710.00'),('8','B','G','770.00'),('8','B','H','2490.00'),('8','B','I','1780.00'),('8','B','J','2700.00'),('8','C','A','1230.00'),('8','C','B','580.00'),('8','C','C','0.00'),('8','C','D','560.00'),('8','C','E','1250.00'),('8','C','F','690.00'),('8','C','G','2115.00'),('8','C','H','1540.00'),('8','C','I','1670.00'),('8','C','J','2550.00'),('8','D','A','670.00'),('8','D','B','1920.00'),('8','D','C','560.00'),('8','D','D','0.00'),('8','D','E','1650.00'),('8','D','F','1860.00'),('8','D','G','690.00'),('8','D','H','1420.00'),('8','D','I','780.00'),('8','D','J','800.00'),('8','E','A','1450.00'),('8','E','B','1950.00'),('8','E','C','1250.00'),('8','E','D','1650.00'),('8','E','E','0.00'),('8','E','F','1100.00'),('8','E','G','1875.00'),('8','E','H','1950.00'),('8','E','I','725.00'),('8','E','J','2250.00'),('8','F','A','2340.00'),('8','F','B','710.00'),('8','F','C','690.00'),('8','F','D','1860.00'),('8','F','E','1100.00'),('8','F','F','0.00'),('8','F','G','1120.00'),('8','F','H','1280.00'),('8','F','I','2010.00'),('8','F','J','1400.00'),('8','G','A','835.00'),('8','G','B','770.00'),('8','G','C','2115.00'),('8','G','D','690.00'),('8','G','E','1875.00'),('8','G','F','1120.00'),('8','G','G','0.00'),('8','G','H','580.00'),('8','G','I','615.00'),('8','G','J','1950.00'),('8','H','A','1780.00'),('8','H','B','2490.00'),('8','H','C','1540.00'),('8','H','D','1420.00'),('8','H','E','1950.00'),('8','H','F','1280.00'),('8','H','G','580.00'),('8','H','H','0.00'),('8','H','I','1120.00'),('8','H','J','1200.00'),('8','I','A','1890.00'),('8','I','B','1780.00'),('8','I','C','1670.00'),('8','I','D','780.00'),('8','I','E','725.00'),('8','I','F','2010.00'),('8','I','G','615.00'),('8','I','H','1120.00'),('8','I','I','0.00'),('8','I','J','550.00'),('8','J','A','1900.00'),('8','J','B','2700.00'),('8','J','C','2550.00'),('8','J','D','800.00'),('8','J','E','2250.00'),('8','J','F','1400.00'),('8','J','G','1950.00'),('8','J','H','1200.00'),('8','J','I','550.00'),('8','J','J','0.00');
insert into FCost values ('9','A','A','0.00'),('9','A','B','560.00'),('9','A','C','615.00'),('9','A','D','1340.00'),('9','A','E','2175.00'),('9','A','F','780.00'),('9','A','G','1670.00'),('9','A','H','1780.00'),('9','A','I','1890.00'),('9','A','J','950.00'),('9','B','A','560.00'),('9','B','B','0.00'),('9','B','C','1740.00'),('9','B','D','640.00'),('9','B','E','650.00'),('9','B','F','2130.00'),('9','B','G','1540.00'),('9','B','H','830.00'),('9','B','I','1780.00'),('9','B','J','2700.00'),('9','C','A','615.00'),('9','C','B','1740.00'),('9','C','C','0.00'),('9','C','D','1680.00'),('9','C','E','625.00'),('9','C','F','690.00'),('9','C','G','1410.00'),('9','C','H','1540.00'),('9','C','I','835.00'),('9','C','J','1700.00'),('9','D','A','1340.00'),('9','D','B','640.00'),('9','D','C','1680.00'),('9','D','D','0.00'),('9','D','E','1100.00'),('9','D','F','620.00'),('9','D','G','690.00'),('9','D','H','1420.00'),('9','D','I','1560.00'),('9','D','J','1600.00'),('9','E','A','2175.00'),('9','E','B','650.00'),('9','E','C','625.00'),('9','E','D','1100.00'),('9','E','E','0.00'),('9','E','F','1650.00'),('9','E','G','1875.00'),('9','E','H','1950.00'),('9','E','I','2175.00'),('9','E','J','1500.00'),('9','F','A','780.00'),('9','F','B','2130.00'),('9','F','C','690.00'),('9','F','D','620.00'),('9','F','E','1650.00'),('9','F','F','0.00'),('9','F','G','560.00'),('9','F','H','1280.00'),('9','F','I','1340.00'),('9','F','J','1400.00'),('9','G','A','1670.00'),('9','G','B','1540.00'),('9','G','C','1410.00'),('9','G','D','690.00'),('9','G','E','1875.00'),('9','G','F','560.00'),('9','G','G','0.00'),('9','G','H','1160.00'),('9','G','I','1230.00'),('9','G','J','650.00'),('9','H','A','1780.00'),('9','H','B','830.00'),('9','H','C','1540.00'),('9','H','D','1420.00'),('9','H','E','1950.00'),('9','H','F','1280.00'),('9','H','G','1160.00'),('9','H','H','0.00'),('9','H','I','1120.00'),('9','H','J','1800.00'),('9','I','A','1890.00'),('9','I','B','1780.00'),('9','I','C','835.00'),('9','I','D','1560.00'),('9','I','E','2175.00'),('9','I','F','1340.00'),('9','I','G','1230.00'),('9','I','H','1120.00'),('9','I','I','0.00'),('9','I','J','550.00'),('9','J','A','950.00'),('9','J','B','2700.00'),('9','J','C','1700.00'),('9','J','D','1600.00'),('9','J','E','1500.00'),('9','J','F','1400.00'),('9','J','G','650.00'),('9','J','H','1800.00'),('9','J','I','550.00'),('9','J','J','0.00');
insert into FCost values ('10','A','A','0.00'),('10','A','B','560.00'),('10','A','C','1845.00'),('10','A','D','670.00'),('10','A','E','2175.00'),('10','A','F','1560.00'),('10','A','G','1670.00'),('10','A','H','2670.00'),('10','A','I','1890.00'),('10','A','J','2850.00'),('10','B','A','560.00'),('10','B','B','0.00'),('10','B','C','1160.00'),('10','B','D','1920.00'),('10','B','E','1950.00'),('10','B','F','710.00'),('10','B','G','1540.00'),('10','B','H','2490.00'),('10','B','I','2670.00'),('10','B','J','900.00'),('10','C','A','1845.00'),('10','C','B','1160.00'),('10','C','C','0.00'),('10','C','D','1680.00'),('10','C','E','1875.00'),('10','C','F','1380.00'),('10','C','G','705.00'),('10','C','H','2310.00'),('10','C','I','1670.00'),('10','C','J','1700.00'),('10','D','A','670.00'),('10','D','B','1920.00'),('10','D','C','1680.00'),('10','D','D','0.00'),('10','D','E','1100.00'),('10','D','F','1860.00'),('10','D','G','2070.00'),('10','D','H','2130.00'),('10','D','I','2340.00'),('10','D','J','1600.00'),('10','E','A','2175.00'),('10','E','B','1950.00'),('10','E','C','1875.00'),('10','E','D','1100.00'),('10','E','E','0.00'),('10','E','F','550.00'),('10','E','G','1875.00'),('10','E','H','650.00'),('10','E','I','1450.00'),('10','E','J','750.00'),('10','F','A','1560.00'),('10','F','B','710.00'),('10','F','C','1380.00'),('10','F','D','1860.00'),('10','F','E','550.00'),('10','F','F','0.00'),('10','F','G','1680.00'),('10','F','H','640.00'),('10','F','I','670.00'),('10','F','J','2100.00'),('10','G','A','1670.00'),('10','G','B','1540.00'),('10','G','C','705.00'),('10','G','D','2070.00'),('10','G','E','1875.00'),('10','G','F','1680.00'),('10','G','G','0.00'),('10','G','H','1160.00'),('10','G','I','1845.00'),('10','G','J','650.00'),('10','H','A','2670.00'),('10','H','B','2490.00'),('10','H','C','2310.00'),('10','H','D','2130.00'),('10','H','E','650.00'),('10','H','F','640.00'),('10','H','G','1160.00'),('10','H','H','0.00'),('10','H','I','1680.00'),('10','H','J','1800.00'),('10','I','A','1890.00'),('10','I','B','2670.00'),('10','I','C','1670.00'),('10','I','D','2340.00'),('10','I','E','1450.00'),('10','I','F','670.00'),('10','I','G','1845.00'),('10','I','H','1680.00'),('10','I','I','0.00'),('10','I','J','1650.00'),('10','J','A','2850.00'),('10','J','B','900.00'),('10','J','C','1700.00'),('10','J','D','1600.00'),('10','J','E','750.00'),('10','J','F','2100.00'),('10','J','G','650.00'),('10','J','H','1800.00'),('10','J','I','1650.00'),('10','J','J','0.00');
insert into FCost values ('0','A','A','0.00'),('0','A','B','560.00'),('0','A','C','1845.00'),('0','A','D','2010.00'),('0','A','E','2175.00'),('0','A','F','1560.00'),('0','A','G','1670.00'),('0','A','H','1780.00'),('0','A','I','2835.00'),('0','A','J','950.00'),('0','B','A','560.00'),('0','B','B','0.00'),('0','B','C','1740.00'),('0','B','D','640.00'),('0','B','E','650.00'),('0','B','F','1420.00'),('0','B','G','2310.00'),('0','B','H','1660.00'),('0','B','I','890.00'),('0','B','J','900.00'),('0','C','A','1845.00'),('0','C','B','1740.00'),('0','C','C','0.00'),('0','C','D','1680.00'),('0','C','E','1250.00'),('0','C','F','2070.00'),('0','C','G','705.00'),('0','C','H','1540.00'),('0','C','I','835.00'),('0','C','J','1700.00'),('0','D','A','2010.00'),('0','D','B','640.00'),('0','D','C','1680.00'),('0','D','D','0.00'),('0','D','E','1100.00'),('0','D','F','1860.00'),('0','D','G','690.00'),('0','D','H','710.00'),('0','D','I','2340.00'),('0','D','J','1600.00'),('0','E','A','2175.00'),('0','E','B','650.00'),('0','E','C','1250.00'),('0','E','D','1100.00'),('0','E','E','0.00'),('0','E','F','1100.00'),('0','E','G','1875.00'),('0','E','H','1300.00'),('0','E','I','2175.00'),('0','E','J','1500.00'),('0','F','A','1560.00'),('0','F','B','1420.00'),('0','F','C','2070.00'),('0','F','D','1860.00'),('0','F','E','1100.00'),('0','F','F','0.00'),('0','F','G','560.00'),('0','F','H','640.00'),('0','F','I','2010.00'),('0','F','J','700.00'),('0','G','A','1670.00'),('0','G','B','2310.00'),('0','G','C','705.00'),('0','G','D','690.00'),('0','G','E','1875.00'),('0','G','F','560.00'),('0','G','G','0.00'),('0','G','H','1740.00'),('0','G','I','615.00'),('0','G','J','1950.00'),('0','H','A','1780.00'),('0','H','B','1660.00'),('0','H','C','1540.00'),('0','H','D','710.00'),('0','H','E','1300.00'),('0','H','F','640.00'),('0','H','G','1740.00'),('0','H','H','0.00'),('0','H','I','560.00'),('0','H','J','600.00'),('0','I','A','2835.00'),('0','I','B','890.00'),('0','I','C','835.00'),('0','I','D','2340.00'),('0','I','E','2175.00'),('0','I','F','2010.00'),('0','I','G','615.00'),('0','I','H','560.00'),('0','I','I','0.00'),('0','I','J','550.00'),('0','J','A','950.00'),('0','J','B','900.00'),('0','J','C','1700.00'),('0','J','D','1600.00'),('0','J','E','1500.00'),('0','J','F','700.00'),('0','J','G','1950.00'),('0','J','H','600.00'),('0','J','I','550.00'),('0','J','J','0.00');

create table Demand (
        scenario int not null default 0,
        first varchar(16) not null,
        second varchar(16) not null,
        demand float not null,
        primary key (scenario, first, second),
        foreign key (first) references Nodes (name),
        foreign key (second) references Nodes (name)
        ) engine=innodb ;
insert into Demand values ('1','A','A','0'),('1','A','B','3.47'),('1','A','C','4.16'),('1','A','D','3.81'),('1','A','E','4.02'),('1','A','F','3.77'),('1','A','G','3.84'),('1','A','H','4.02'),('1','A','I','3.80'),('1','A','J','3.84'),('1','B','A','3.47'),('1','B','B','0'),('1','B','C','4.21'),('1','B','D','4.18'),('1','B','E','3.94'),('1','B','F','4.14'),('1','B','G','4.07'),('1','B','H','3.69'),('1','B','I','3.50'),('1','B','J','3.96'),('1','C','A','4.16'),('1','C','B','4.21'),('1','C','C','0'),('1','C','D','4.29'),('1','C','E','4.27'),('1','C','F','4.26'),('1','C','G','4.09'),('1','C','H','3.73'),('1','C','I','3.64'),('1','C','J','3.88'),('1','D','A','3.81'),('1','D','B','4.18'),('1','D','C','4.29'),('1','D','D','0'),('1','D','E','3.66'),('1','D','F','3.95'),('1','D','G','3.54'),('1','D','H','4.07'),('1','D','I','3.64'),('1','D','J','4.21'),('1','E','A','4.02'),('1','E','B','3.94'),('1','E','C','4.27'),('1','E','D','3.66'),('1','E','E','0'),('1','E','F','4.04'),('1','E','G','4.14'),('1','E','H','3.92'),('1','E','I','3.57'),('1','E','J','3.77'),('1','F','A','3.77'),('1','F','B','4.14'),('1','F','C','4.26'),('1','F','D','3.95'),('1','F','E','4.04'),('1','F','F','0'),('1','F','G','3.69'),('1','F','H','3.62'),('1','F','I','3.76'),('1','F','J','3.73'),('1','G','A','3.84'),('1','G','B','4.07'),('1','G','C','4.09'),('1','G','D','3.54'),('1','G','E','4.14'),('1','G','F','3.69'),('1','G','G','0'),('1','G','H','4.10'),('1','G','I','3.25'),('1','G','J','4.08'),('1','H','A','4.02'),('1','H','B','3.69'),('1','H','C','3.73'),('1','H','D','4.07'),('1','H','E','3.92'),('1','H','F','3.62'),('1','H','G','4.10'),('1','H','H','0'),('1','H','I','3.55'),('1','H','J','3.82'),('1','I','A','3.80'),('1','I','B','3.50'),('1','I','C','3.64'),('1','I','D','3.64'),('1','I','E','3.57'),('1','I','F','3.76'),('1','I','G','3.25'),('1','I','H','3.55'),('1','I','I','0'),('1','I','J','4.19'),('1','J','A','3.84'),('1','J','B','3.96'),('1','J','C','3.88'),('1','J','D','4.21'),('1','J','E','3.77'),('1','J','F','3.73'),('1','J','G','4.08'),('1','J','H','3.82'),('1','J','I','4.19'),('1','J','J','0');
insert into Demand values ('2','A','A','0'),('2','A','B','3.41'),('2','A','C','3.24'),('2','A','D','3.22'),('2','A','E','2.80'),('2','A','F','3.06'),('2','A','G','3.32'),('2','A','H','3.00'),('2','A','I','3.53'),('2','A','J','3.35'),('2','B','A','3.41'),('2','B','B','0'),('2','B','C','3.15'),('2','B','D','3.50'),('2','B','E','2.98'),('2','B','F','3.19'),('2','B','G','3.14'),('2','B','H','3.12'),('2','B','I','3.49'),('2','B','J','3.20'),('2','C','A','3.24'),('2','C','B','3.15'),('2','C','C','0'),('2','C','D','3.01'),('2','C','E','3.13'),('2','C','F','3.24'),('2','C','G','3.08'),('2','C','H','3.59'),('2','C','I','3.05'),('2','C','J','3.19'),('2','D','A','3.22'),('2','D','B','3.50'),('2','D','C','3.01'),('2','D','D','0'),('2','D','E','3.35'),('2','D','F','2.97'),('2','D','G','3.18'),('2','D','H','3.17'),('2','D','I','2.90'),('2','D','J','3.12'),('2','E','A','2.80'),('2','E','B','2.98'),('2','E','C','3.13'),('2','E','D','3.35'),('2','E','E','0'),('2','E','F','3.17'),('2','E','G','3.12'),('2','E','H','3.27'),('2','E','I','3.14'),('2','E','J','3.16'),('2','F','A','3.06'),('2','F','B','3.19'),('2','F','C','3.24'),('2','F','D','2.97'),('2','F','E','3.17'),('2','F','F','0'),('2','F','G','3.01'),('2','F','H','3.21'),('2','F','I','2.87'),('2','F','J','3.25'),('2','G','A','3.32'),('2','G','B','3.14'),('2','G','C','3.08'),('2','G','D','3.18'),('2','G','E','3.12'),('2','G','F','3.01'),('2','G','G','0'),('2','G','H','3.02'),('2','G','I','2.95'),('2','G','J','3.18'),('2','H','A','3.00'),('2','H','B','3.12'),('2','H','C','3.59'),('2','H','D','3.17'),('2','H','E','3.27'),('2','H','F','3.21'),('2','H','G','3.02'),('2','H','H','0'),('2','H','I','3.37'),('2','H','J','3.02'),('2','I','A','3.53'),('2','I','B','3.49'),('2','I','C','3.05'),('2','I','D','2.90'),('2','I','E','3.14'),('2','I','F','2.87'),('2','I','G','2.95'),('2','I','H','3.37'),('2','I','I','0'),('2','I','J','3.10'),('2','J','A','3.35'),('2','J','B','3.20'),('2','J','C','3.19'),('2','J','D','3.12'),('2','J','E','3.16'),('2','J','F','3.25'),('2','J','G','3.18'),('2','J','H','3.02'),('2','J','I','3.10'),('2','J','J','0');
insert into Demand values ('3','A','A','0'),('3','A','B','2.66'),('3','A','C','3.06'),('3','A','D','2.77'),('3','A','E','3.06'),('3','A','F','3.17'),('3','A','G','3.61'),('3','A','H','3.69'),('3','A','I','3.41'),('3','A','J','3.12'),('3','B','A','2.66'),('3','B','B','0'),('3','B','C','2.86'),('3','B','D','3.34'),('3','B','E','3.23'),('3','B','F','3.34'),('3','B','G','2.85'),('3','B','H','3.06'),('3','B','I','3.16'),('3','B','J','3.06'),('3','C','A','3.06'),('3','C','B','2.86'),('3','C','C','0'),('3','C','D','3.18'),('3','C','E','3.46'),('3','C','F','3.28'),('3','C','G','2.95'),('3','C','H','3.18'),('3','C','I','3.40'),('3','C','J','3.04'),('3','D','A','2.77'),('3','D','B','3.34'),('3','D','C','3.18'),('3','D','D','0'),('3','D','E','2.86'),('3','D','F','3.15'),('3','D','G','3.61'),('3','D','H','2.88'),('3','D','I','3.44'),('3','D','J','2.86'),('3','E','A','3.06'),('3','E','B','3.23'),('3','E','C','3.46'),('3','E','D','2.86'),('3','E','E','0'),('3','E','F','3.11'),('3','E','G','3.02'),('3','E','H','3.50'),('3','E','I','3.67'),('3','E','J','3.30'),('3','F','A','3.17'),('3','F','B','3.34'),('3','F','C','3.28'),('3','F','D','3.15'),('3','F','E','3.11'),('3','F','F','0'),('3','F','G','3.25'),('3','F','H','3.13'),('3','F','I','2.73'),('3','F','J','3.38'),('3','G','A','3.61'),('3','G','B','2.85'),('3','G','C','2.95'),('3','G','D','3.61'),('3','G','E','3.02'),('3','G','F','3.25'),('3','G','G','0'),('3','G','H','3.11'),('3','G','I','3.32'),('3','G','J','3.67'),('3','H','A','3.69'),('3','H','B','3.06'),('3','H','C','3.18'),('3','H','D','2.88'),('3','H','E','3.50'),('3','H','F','3.13'),('3','H','G','3.11'),('3','H','H','0'),('3','H','I','2.68'),('3','H','J','3.25'),('3','I','A','3.41'),('3','I','B','3.16'),('3','I','C','3.40'),('3','I','D','3.44'),('3','I','E','3.67'),('3','I','F','2.73'),('3','I','G','3.32'),('3','I','H','2.68'),('3','I','I','0'),('3','I','J','2.94'),('3','J','A','3.12'),('3','J','B','3.06'),('3','J','C','3.04'),('3','J','D','2.86'),('3','J','E','3.30'),('3','J','F','3.38'),('3','J','G','3.67'),('3','J','H','3.25'),('3','J','I','2.94'),('3','J','J','0');
insert into Demand values ('4','A','A','0'),('4','A','B','2.81'),('4','A','C','2.39'),('4','A','D','2.60'),('4','A','E','2.88'),('4','A','F','2.85'),('4','A','G','2.95'),('4','A','H','2.76'),('4','A','I','2.77'),('4','A','J','2.66'),('4','B','A','2.81'),('4','B','B','0'),('4','B','C','2.52'),('4','B','D','2.77'),('4','B','E','2.76'),('4','B','F','2.34'),('4','B','G','2.83'),('4','B','H','2.85'),('4','B','I','2.43'),('4','B','J','2.44'),('4','C','A','2.39'),('4','C','B','2.52'),('4','C','C','0'),('4','C','D','2.69'),('4','C','E','2.62'),('4','C','F','3.00'),('4','C','G','2.59'),('4','C','H','2.81'),('4','C','I','2.39'),('4','C','J','2.91'),('4','D','A','2.60'),('4','D','B','2.77'),('4','D','C','2.69'),('4','D','D','0'),('4','D','E','2.30'),('4','D','F','2.93'),('4','D','G','2.34'),('4','D','H','2.81'),('4','D','I','2.34'),('4','D','J','2.83'),('4','E','A','2.88'),('4','E','B','2.76'),('4','E','C','2.62'),('4','E','D','2.30'),('4','E','E','0'),('4','E','F','2.73'),('4','E','G','2.71'),('4','E','H','2.84'),('4','E','I','2.52'),('4','E','J','2.34'),('4','F','A','2.85'),('4','F','B','2.34'),('4','F','C','3.00'),('4','F','D','2.93'),('4','F','E','2.73'),('4','F','F','0'),('4','F','G','2.93'),('4','F','H','2.37'),('4','F','I','2.62'),('4','F','J','2.84'),('4','G','A','2.95'),('4','G','B','2.83'),('4','G','C','2.59'),('4','G','D','2.34'),('4','G','E','2.71'),('4','G','F','2.93'),('4','G','G','0'),('4','G','H','2.97'),('4','G','I','2.82'),('4','G','J','2.64'),('4','H','A','2.76'),('4','H','B','2.85'),('4','H','C','2.81'),('4','H','D','2.81'),('4','H','E','2.84'),('4','H','F','2.37'),('4','H','G','2.97'),('4','H','H','0'),('4','H','I','2.79'),('4','H','J','2.29'),('4','I','A','2.77'),('4','I','B','2.43'),('4','I','C','2.39'),('4','I','D','2.34'),('4','I','E','2.52'),('4','I','F','2.62'),('4','I','G','2.82'),('4','I','H','2.79'),('4','I','I','0'),('4','I','J','3.12'),('4','J','A','2.66'),('4','J','B','2.44'),('4','J','C','2.91'),('4','J','D','2.83'),('4','J','E','2.34'),('4','J','F','2.84'),('4','J','G','2.64'),('4','J','H','2.29'),('4','J','I','3.12'),('4','J','J','0');
insert into Demand values ('5','A','A','0'),('5','A','B','3.67'),('5','A','C','3.22'),('5','A','D','3.63'),('5','A','E','3.46'),('5','A','F','3.65'),('5','A','G','3.80'),('5','A','H','3.73'),('5','A','I','3.59'),('5','A','J','3.26'),('5','B','A','3.67'),('5','B','B','0'),('5','B','C','3.50'),('5','B','D','3.61'),('5','B','E','3.93'),('5','B','F','3.71'),('5','B','G','3.70'),('5','B','H','3.56'),('5','B','I','3.86'),('5','B','J','3.58'),('5','C','A','3.22'),('5','C','B','3.50'),('5','C','C','0'),('5','C','D','3.65'),('5','C','E','3.49'),('5','C','F','3.50'),('5','C','G','3.55'),('5','C','H','3.22'),('5','C','I','3.49'),('5','C','J','3.70'),('5','D','A','3.63'),('5','D','B','3.61'),('5','D','C','3.65'),('5','D','D','0'),('5','D','E','3.57'),('5','D','F','4.12'),('5','D','G','3.39'),('5','D','H','3.83'),('5','D','I','3.32'),('5','D','J','3.57'),('5','E','A','3.46'),('5','E','B','3.93'),('5','E','C','3.49'),('5','E','D','3.57'),('5','E','E','0'),('5','E','F','3.51'),('5','E','G','3.85'),('5','E','H','3.43'),('5','E','I','3.90'),('5','E','J','3.53'),('5','F','A','3.65'),('5','F','B','3.71'),('5','F','C','3.50'),('5','F','D','4.12'),('5','F','E','3.51'),('5','F','F','0'),('5','F','G','3.76'),('5','F','H','3.46'),('5','F','I','3.74'),('5','F','J','3.95'),('5','G','A','3.80'),('5','G','B','3.70'),('5','G','C','3.55'),('5','G','D','3.39'),('5','G','E','3.85'),('5','G','F','3.76'),('5','G','G','0'),('5','G','H','3.98'),('5','G','I','3.60'),('5','G','J','3.91'),('5','H','A','3.73'),('5','H','B','3.56'),('5','H','C','3.22'),('5','H','D','3.83'),('5','H','E','3.43'),('5','H','F','3.46'),('5','H','G','3.98'),('5','H','H','0'),('5','H','I','3.53'),('5','H','J','3.20'),('5','I','A','3.59'),('5','I','B','3.86'),('5','I','C','3.49'),('5','I','D','3.32'),('5','I','E','3.90'),('5','I','F','3.74'),('5','I','G','3.60'),('5','I','H','3.53'),('5','I','I','0'),('5','I','J','3.99'),('5','J','A','3.26'),('5','J','B','3.58'),('5','J','C','3.70'),('5','J','D','3.57'),('5','J','E','3.53'),('5','J','F','3.95'),('5','J','G','3.91'),('5','J','H','3.20'),('5','J','I','3.99'),('5','J','J','0');
insert into Demand values ('6','A','A','0'),('6','A','B','3.05'),('6','A','C','3.08'),('6','A','D','3.22'),('6','A','E','3.11'),('6','A','F','3.42'),('6','A','G','2.75'),('6','A','H','3.02'),('6','A','I','3.12'),('6','A','J','2.83'),('6','B','A','3.05'),('6','B','B','0'),('6','B','C','3.35'),('6','B','D','3.12'),('6','B','E','3.07'),('6','B','F','3.29'),('6','B','G','3.28'),('6','B','H','3.03'),('6','B','I','3.09'),('6','B','J','2.83'),('6','C','A','3.08'),('6','C','B','3.35'),('6','C','C','0'),('6','C','D','2.69'),('6','C','E','2.94'),('6','C','F','3.07'),('6','C','G','3.56'),('6','C','H','3.30'),('6','C','I','2.91'),('6','C','J','2.78'),('6','D','A','3.22'),('6','D','B','3.12'),('6','D','C','2.69'),('6','D','D','0'),('6','D','E','3.26'),('6','D','F','3.20'),('6','D','G','3.26'),('6','D','H','3.28'),('6','D','I','3.08'),('6','D','J','3.06'),('6','E','A','3.11'),('6','E','B','3.07'),('6','E','C','2.94'),('6','E','D','3.26'),('6','E','E','0'),('6','E','F','3.15'),('6','E','G','3.13'),('6','E','H','2.77'),('6','E','I','2.85'),('6','E','J','2.52'),('6','F','A','3.42'),('6','F','B','3.29'),('6','F','C','3.07'),('6','F','D','3.20'),('6','F','E','3.15'),('6','F','F','0'),('6','F','G','3.26'),('6','F','H','2.56'),('6','F','I','2.98'),('6','F','J','3.12'),('6','G','A','2.75'),('6','G','B','3.28'),('6','G','C','3.56'),('6','G','D','3.26'),('6','G','E','3.13'),('6','G','F','3.26'),('6','G','G','0'),('6','G','H','2.98'),('6','G','I','2.94'),('6','G','J','3.00'),('6','H','A','3.02'),('6','H','B','3.03'),('6','H','C','3.30'),('6','H','D','3.28'),('6','H','E','2.77'),('6','H','F','2.56'),('6','H','G','2.98'),('6','H','H','0'),('6','H','I','3.42'),('6','H','J','3.27'),('6','I','A','3.12'),('6','I','B','3.09'),('6','I','C','2.91'),('6','I','D','3.08'),('6','I','E','2.85'),('6','I','F','2.98'),('6','I','G','2.94'),('6','I','H','3.42'),('6','I','I','0'),('6','I','J','2.89'),('6','J','A','2.83'),('6','J','B','2.83'),('6','J','C','2.78'),('6','J','D','3.06'),('6','J','E','2.52'),('6','J','F','3.12'),('6','J','G','3.00'),('6','J','H','3.27'),('6','J','I','2.89'),('6','J','J','0');
insert into Demand values ('7','A','A','0'),('7','A','B','3.61'),('7','A','C','3.36'),('7','A','D','3.68'),('7','A','E','3.32'),('7','A','F','2.85'),('7','A','G','3.30'),('7','A','H','3.51'),('7','A','I','3.25'),('7','A','J','3.36'),('7','B','A','3.61'),('7','B','B','0'),('7','B','C','3.79'),('7','B','D','3.43'),('7','B','E','3.39'),('7','B','F','3.42'),('7','B','G','2.94'),('7','B','H','3.40'),('7','B','I','2.74'),('7','B','J','3.28'),('7','C','A','3.36'),('7','C','B','3.79'),('7','C','C','0'),('7','C','D','3.26'),('7','C','E','2.72'),('7','C','F','2.91'),('7','C','G','3.11'),('7','C','H','2.98'),('7','C','I','3.10'),('7','C','J','3.38'),('7','D','A','3.68'),('7','D','B','3.43'),('7','D','C','3.26'),('7','D','D','0'),('7','D','E','2.81'),('7','D','F','2.99'),('7','D','G','2.83'),('7','D','H','3.33'),('7','D','I','3.55'),('7','D','J','3.14'),('7','E','A','3.32'),('7','E','B','3.39'),('7','E','C','2.72'),('7','E','D','2.81'),('7','E','E','0'),('7','E','F','3.28'),('7','E','G','2.96'),('7','E','H','2.88'),('7','E','I','3.55'),('7','E','J','3.02'),('7','F','A','2.85'),('7','F','B','3.42'),('7','F','C','2.91'),('7','F','D','2.99'),('7','F','E','3.28'),('7','F','F','0'),('7','F','G','3.48'),('7','F','H','2.98'),('7','F','I','3.56'),('7','F','J','3.02'),('7','G','A','3.30'),('7','G','B','2.94'),('7','G','C','3.11'),('7','G','D','2.83'),('7','G','E','2.96'),('7','G','F','3.48'),('7','G','G','0'),('7','G','H','3.33'),('7','G','I','3.38'),('7','G','J','3.24'),('7','H','A','3.51'),('7','H','B','3.40'),('7','H','C','2.98'),('7','H','D','3.33'),('7','H','E','2.88'),('7','H','F','2.98'),('7','H','G','3.33'),('7','H','H','0'),('7','H','I','3.27'),('7','H','J','3.24'),('7','I','A','3.25'),('7','I','B','2.74'),('7','I','C','3.10'),('7','I','D','3.55'),('7','I','E','3.55'),('7','I','F','3.56'),('7','I','G','3.38'),('7','I','H','3.27'),('7','I','I','0'),('7','I','J','2.78'),('7','J','A','3.36'),('7','J','B','3.28'),('7','J','C','3.38'),('7','J','D','3.14'),('7','J','E','3.02'),('7','J','F','3.02'),('7','J','G','3.24'),('7','J','H','3.24'),('7','J','I','2.78'),('7','J','J','0');
insert into Demand values ('8','A','A','0'),('8','A','B','3.08'),('8','A','C','3.52'),('8','A','D','3.34'),('8','A','E','2.96'),('8','A','F','3.24'),('8','A','G','2.91'),('8','A','H','3.29'),('8','A','I','3.32'),('8','A','J','2.92'),('8','B','A','3.08'),('8','B','B','0'),('8','B','C','2.89'),('8','B','D','3.04'),('8','B','E','3.03'),('8','B','F','2.91'),('8','B','G','2.87'),('8','B','H','3.30'),('8','B','I','3.20'),('8','B','J','2.90'),('8','C','A','3.52'),('8','C','B','2.89'),('8','C','C','0'),('8','C','D','3.28'),('8','C','E','2.81'),('8','C','F','3.26'),('8','C','G','3.17'),('8','C','H','3.42'),('8','C','I','2.78'),('8','C','J','3.21'),('8','D','A','3.34'),('8','D','B','3.04'),('8','D','C','3.28'),('8','D','D','0'),('8','D','E','3.00'),('8','D','F','3.00'),('8','D','G','2.85'),('8','D','H','2.59'),('8','D','I','3.36'),('8','D','J','3.19'),('8','E','A','2.96'),('8','E','B','3.03'),('8','E','C','2.81'),('8','E','D','3.00'),('8','E','E','0'),('8','E','F','2.95'),('8','E','G','3.09'),('8','E','H','2.99'),('8','E','I','2.74'),('8','E','J','2.89'),('8','F','A','3.24'),('8','F','B','2.91'),('8','F','C','3.26'),('8','F','D','3.00'),('8','F','E','2.95'),('8','F','F','0'),('8','F','G','2.91'),('8','F','H','2.95'),('8','F','I','2.87'),('8','F','J','3.21'),('8','G','A','2.91'),('8','G','B','2.87'),('8','G','C','3.17'),('8','G','D','2.85'),('8','G','E','3.09'),('8','G','F','2.91'),('8','G','G','0'),('8','G','H','2.90'),('8','G','I','3.16'),('8','G','J','3.11'),('8','H','A','3.29'),('8','H','B','3.30'),('8','H','C','3.42'),('8','H','D','2.59'),('8','H','E','2.99'),('8','H','F','2.95'),('8','H','G','2.90'),('8','H','H','0'),('8','H','I','3.19'),('8','H','J','2.81'),('8','I','A','3.32'),('8','I','B','3.20'),('8','I','C','2.78'),('8','I','D','3.36'),('8','I','E','2.74'),('8','I','F','2.87'),('8','I','G','3.16'),('8','I','H','3.19'),('8','I','I','0'),('8','I','J','2.43'),('8','J','A','2.92'),('8','J','B','2.90'),('8','J','C','3.21'),('8','J','D','3.19'),('8','J','E','2.89'),('8','J','F','3.21'),('8','J','G','3.11'),('8','J','H','2.81'),('8','J','I','2.43'),('8','J','J','0');
insert into Demand values ('9','A','A','0'),('9','A','B','3.44'),('9','A','C','3.42'),('9','A','D','3.55'),('9','A','E','3.18'),('9','A','F','3.71'),('9','A','G','3.79'),('9','A','H','3.88'),('9','A','I','3.76'),('9','A','J','3.38'),('9','B','A','3.44'),('9','B','B','0'),('9','B','C','3.57'),('9','B','D','3.60'),('9','B','E','3.34'),('9','B','F','3.40'),('9','B','G','3.61'),('9','B','H','3.06'),('9','B','I','3.28'),('9','B','J','3.29'),('9','C','A','3.42'),('9','C','B','3.57'),('9','C','C','0'),('9','C','D','3.22'),('9','C','E','3.36'),('9','C','F','3.63'),('9','C','G','3.47'),('9','C','H','3.73'),('9','C','I','3.06'),('9','C','J','3.33'),('9','D','A','3.55'),('9','D','B','3.60'),('9','D','C','3.22'),('9','D','D','0'),('9','D','E','3.34'),('9','D','F','3.15'),('9','D','G','3.81'),('9','D','H','3.67'),('9','D','I','3.29'),('9','D','J','3.34'),('9','E','A','3.18'),('9','E','B','3.34'),('9','E','C','3.36'),('9','E','D','3.34'),('9','E','E','0'),('9','E','F','3.59'),('9','E','G','3.35'),('9','E','H','3.30'),('9','E','I','3.19'),('9','E','J','3.28'),('9','F','A','3.71'),('9','F','B','3.40'),('9','F','C','3.63'),('9','F','D','3.15'),('9','F','E','3.59'),('9','F','F','0'),('9','F','G','3.53'),('9','F','H','3.33'),('9','F','I','3.91'),('9','F','J','3.66'),('9','G','A','3.79'),('9','G','B','3.61'),('9','G','C','3.47'),('9','G','D','3.81'),('9','G','E','3.35'),('9','G','F','3.53'),('9','G','G','0'),('9','G','H','3.73'),('9','G','I','3.35'),('9','G','J','3.66'),('9','H','A','3.88'),('9','H','B','3.06'),('9','H','C','3.73'),('9','H','D','3.67'),('9','H','E','3.30'),('9','H','F','3.33'),('9','H','G','3.73'),('9','H','H','0'),('9','H','I','3.48'),('9','H','J','3.31'),('9','I','A','3.76'),('9','I','B','3.28'),('9','I','C','3.06'),('9','I','D','3.29'),('9','I','E','3.19'),('9','I','F','3.91'),('9','I','G','3.35'),('9','I','H','3.48'),('9','I','I','0'),('9','I','J','3.52'),('9','J','A','3.38'),('9','J','B','3.29'),('9','J','C','3.33'),('9','J','D','3.34'),('9','J','E','3.28'),('9','J','F','3.66'),('9','J','G','3.66'),('9','J','H','3.31'),('9','J','I','3.52'),('9','J','J','0');
insert into Demand values ('10','A','A','0'),('10','A','B','3.12'),('10','A','C','3.34'),('10','A','D','3.12'),('10','A','E','3.15'),('10','A','F','3.47'),('10','A','G','3.03'),('10','A','H','3.33'),('10','A','I','3.15'),('10','A','J','3.20'),('10','B','A','3.12'),('10','B','B','0'),('10','B','C','3.42'),('10','B','D','3.59'),('10','B','E','3.21'),('10','B','F','3.16'),('10','B','G','3.43'),('10','B','H','3.40'),('10','B','I','3.57'),('10','B','J','3.71'),('10','C','A','3.34'),('10','C','B','3.42'),('10','C','C','0'),('10','C','D','3.35'),('10','C','E','3.50'),('10','C','F','3.06'),('10','C','G','3.27'),('10','C','H','3.38'),('10','C','I','3.17'),('10','C','J','3.45'),('10','D','A','3.12'),('10','D','B','3.59'),('10','D','C','3.35'),('10','D','D','0'),('10','D','E','2.94'),('10','D','F','2.80'),('10','D','G','3.12'),('10','D','H','3.08'),('10','D','I','3.67'),('10','D','J','3.05'),('10','E','A','3.15'),('10','E','B','3.21'),('10','E','C','3.50'),('10','E','D','2.94'),('10','E','E','0'),('10','E','F','3.24'),('10','E','G','3.32'),('10','E','H','3.14'),('10','E','I','3.08'),('10','E','J','3.52'),('10','F','A','3.47'),('10','F','B','3.16'),('10','F','C','3.06'),('10','F','D','2.80'),('10','F','E','3.24'),('10','F','F','0'),('10','F','G','3.03'),('10','F','H','3.24'),('10','F','I','3.36'),('10','F','J','3.23'),('10','G','A','3.03'),('10','G','B','3.43'),('10','G','C','3.27'),('10','G','D','3.12'),('10','G','E','3.32'),('10','G','F','3.03'),('10','G','G','0'),('10','G','H','3.17'),('10','G','I','3.38'),('10','G','J','3.52'),('10','H','A','3.33'),('10','H','B','3.40'),('10','H','C','3.38'),('10','H','D','3.08'),('10','H','E','3.14'),('10','H','F','3.24'),('10','H','G','3.17'),('10','H','H','0'),('10','H','I','3.07'),('10','H','J','3.15'),('10','I','A','3.15'),('10','I','B','3.57'),('10','I','C','3.17'),('10','I','D','3.67'),('10','I','E','3.08'),('10','I','F','3.36'),('10','I','G','3.38'),('10','I','H','3.07'),('10','I','I','0'),('10','I','J','2.75'),('10','J','A','3.20'),('10','J','B','3.71'),('10','J','C','3.45'),('10','J','D','3.05'),('10','J','E','3.52'),('10','J','F','3.23'),('10','J','G','3.52'),('10','J','H','3.15'),('10','J','I','2.75'),('10','J','J','0');
insert into Demand values ('0','A','A','0'),('0','A','B','3.47'),('0','A','C','4.16'),('0','A','D','3.81'),('0','A','E','4.02'),('0','A','F','3.77'),('0','A','G','3.84'),('0','A','H','4.02'),('0','A','I','3.80'),('0','A','J','3.84'),('0','B','A','3.47'),('0','B','B','0'),('0','B','C','4.21'),('0','B','D','4.18'),('0','B','E','3.94'),('0','B','F','4.14'),('0','B','G','4.07'),('0','B','H','3.69'),('0','B','I','3.50'),('0','B','J','3.96'),('0','C','A','4.16'),('0','C','B','4.21'),('0','C','C','0'),('0','C','D','4.29'),('0','C','E','4.27'),('0','C','F','4.26'),('0','C','G','4.09'),('0','C','H','3.73'),('0','C','I','3.64'),('0','C','J','3.88'),('0','D','A','3.81'),('0','D','B','4.18'),('0','D','C','4.29'),('0','D','D','0'),('0','D','E','3.66'),('0','D','F','3.95'),('0','D','G','3.54'),('0','D','H','4.07'),('0','D','I','3.64'),('0','D','J','4.21'),('0','E','A','4.02'),('0','E','B','3.94'),('0','E','C','4.27'),('0','E','D','3.66'),('0','E','E','0'),('0','E','F','4.04'),('0','E','G','4.14'),('0','E','H','3.92'),('0','E','I','3.57'),('0','E','J','3.77'),('0','F','A','3.77'),('0','F','B','4.14'),('0','F','C','4.26'),('0','F','D','3.95'),('0','F','E','4.04'),('0','F','F','0'),('0','F','G','3.69'),('0','F','H','3.62'),('0','F','I','3.76'),('0','F','J','3.73'),('0','G','A','3.84'),('0','G','B','4.07'),('0','G','C','4.09'),('0','G','D','3.54'),('0','G','E','4.14'),('0','G','F','3.69'),('0','G','G','0'),('0','G','H','4.10'),('0','G','I','3.25'),('0','G','J','4.08'),('0','H','A','4.02'),('0','H','B','3.69'),('0','H','C','3.73'),('0','H','D','4.07'),('0','H','E','3.92'),('0','H','F','3.62'),('0','H','G','4.10'),('0','H','H','0'),('0','H','I','3.55'),('0','H','J','3.82'),('0','I','A','3.80'),('0','I','B','3.50'),('0','I','C','3.64'),('0','I','D','3.64'),('0','I','E','3.57'),('0','I','F','3.76'),('0','I','G','3.25'),('0','I','H','3.55'),('0','I','I','0'),('0','I','J','4.19'),('0','J','A','3.84'),('0','J','B','3.96'),('0','J','C','3.88'),('0','J','D','4.21'),('0','J','E','3.77'),('0','J','F','3.73'),('0','J','G','4.08'),('0','J','H','3.82'),('0','J','I','4.19'),('0','J','J','0');

