token_names = {
    0x20: "TDS5_PARAMFMT2",
    0x22: "ORDERBY2",
    0x61: "ROWFMT2",
    0x71: "LOGOUT",
    0x79: "RETURNSTATUS",
    0x7C: "PROCID",
    0x81: "TDS7_RESULT",
    0x83: "TDS_CURINFO",
    0x88: "TDS7_COMPUTE_RESULT",
    0xA0: "COLNAME",
    0xA1: "COLFMT",
    0xA3: "DYNAMIC2",
    0xA4: "TABNAME",
    0xA5: "COLINFO",
    0xA7: "COMPUTE_NAMES",
    0xA8: "COMPUTE_RESULT",
    0xA9: "ORDERBY",
    0xAA: "ERROR",
    0xAB: "INFO",
    0xAC: "PARAM",
    0xAD: "LOGINACK",
    0xAE: "CONTROL",
    0xD1: "ROW",
    0xD3: "CMP_ROW",
    0xD7: "TDS5_PARAMS",
    0xE2: "CAPABILITY",
    0xE3: "ENVCHANGE",
    0xE5: "EED",
    0xE6: "DBRPC",
    0xE7: "TDS5_DYNAMIC",
    0xEC: "TDS5_PARAMFMT",
    0xED: "AUTH",
    0xEE: "RESULT",
    0xFD: "DONE",
    0xFE: "DONEPROC",
    0xFF: "DONEINPROC",
    }


def tds_token_name(marker):
    return token_names.get(marker, '')


_prtype_map = dict((
    (SYBAOPAVG, "avg"),
    (SYBAOPCNT, "count"),
    (SYBAOPMAX, "max"),
    (SYBAOPMIN, "min"),
    (SYBAOPSUM, "sum"),
    (SYBBINARY, "binary"),
    (SYBLONGBINARY, "longbinary"),
    (SYBBIT, "bit"),
    (SYBBITN, "bit-null"),
    (SYBCHAR, "char"),
    (SYBDATETIME4, "smalldatetime"),
    (SYBDATETIME, "datetime"),
    (SYBDATETIMN, "datetime-null"),
    (SYBDECIMAL, "decimal"),
    (SYBFLT8, "float"),
    (SYBFLTN, "float-null"),
    (SYBIMAGE, "image"),
    (SYBINT1, "tinyint"),
    (SYBINT2, "smallint"),
    (SYBINT4, "int"),
    (SYBINT8, "bigint"),
    (SYBINTN, "integer-null"),
    (SYBMONEY4, "smallmoney"),
    (SYBMONEY, "money"),
    (SYBMONEYN, "money-null"),
    (SYBNTEXT, "UCS-2 text"),
    (SYBNVARCHAR, "UCS-2 varchar"),
    (SYBNUMERIC, "numeric"),
    (SYBREAL, "real"),
    (SYBTEXT, "text"),
    (SYBUNIQUE, "uniqueidentifier"),
    (SYBVARBINARY, "varbinary"),
    (SYBVARCHAR, "varchar"),
    (SYBVARIANT, "variant"),
    (SYBVOID, "void"),
    (XSYBBINARY, "xbinary"),
    (XSYBCHAR, "xchar"),
    (XSYBNCHAR, "x UCS-2 char"),
    (XSYBNVARCHAR, "x UCS-2 varchar"),
    (XSYBVARBINARY, "xvarbinary"),
    (XSYBVARCHAR, "xvarchar"),
    (SYBMSDATE, "date"),
    (SYBMSTIME, "time"),
    ))


def tds_prtype(token):
    return _prtype_map.get(token, '')
