#*****************************************************************************
#   Copyright 2004-2008 Steve Menard
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#	   http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#   
#*****************************************************************************
import _jclass, _jpype

def _initialize() :
	_jclass.registerClassCustomizer(PropertiesCustomizer())
	
class PropertiesCustomizer(object) :
	def canCustomize(self, name, jc) :
		return True
		
	def customize(self, name, jc, bases, members) :
		gets = {}
		sets = {}
		
		for i in members :
			if not isinstance(members[i], _jpype._JavaMethod) :
				continue
				
			if i[:3] == 'get' :
				if len(i) > 3 and members[i].isBeanAccessor() :
					gets[i[3:]] = members[i]
			elif i[:3] == 'set' :
				if len(i) > 3 and members[i].isBeanMutator() :
					sets[i[3:]] = members[i]
				
		for i in gets :
			members[i[0].lower()+i[1:]] = property(gets[i], sets.get(i, None))
			
			
