#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
trace/generated-tracers.h
"""

__author__     = "Lluís Vilanova <vilanova@ac.upc.edu>"
__copyright__  = "Copyright 2012-2016, Lluís Vilanova <vilanova@ac.upc.edu>"
__license__    = "GPL version 2 or (at your option) any later version"

__maintainer__ = "Stefan Hajnoczi"
__email__      = "stefanha@linux.vnet.ibm.com"


from tracetool import out


def generate(events, backend):
    out('/* This file is autogenerated by tracetool, do not edit. */',
        '',
        '#ifndef TRACE__GENERATED_TRACERS_H',
        '#define TRACE__GENERATED_TRACERS_H',
        '',
        '#include "qemu-common.h"',
        '#include "trace/control.h"',
        '')

    backend.generate_begin(events)

    for e in events:
        if "vcpu" in e.properties:
            trace_cpu = next(iter(e.args))[1]
            cond = "trace_event_get_vcpu_state(%(cpu)s,"\
                   " TRACE_%(id)s,"\
                   " TRACE_VCPU_%(id)s)"\
                   % dict(
                       cpu=trace_cpu,
                       id=e.name.upper())
        else:
            cond = "true"

        out('',
            'static inline void %(api)s(%(args)s)',
            '{',
            '    if (%(cond)s) {',
            api=e.api(),
            args=e.args,
            cond=cond)

        if "disable" not in e.properties:
            backend.generate(e)

        out('    }',
            '}')

    backend.generate_end(events)

    out('#endif /* TRACE__GENERATED_TRACERS_H */')
