% File src/library/parallel/man/parallel-package.Rd
% Part of the R package, https://www.R-project.org
% Copyright 2011-2016 R Core Team
% Distributed under GPL 2 or later

\name{parallel-package}
\alias{parallel-package}
\alias{parallel}
\docType{package}
\title{
  Support for Parallel Computation
}
\description{
  Support for parallel computation, including random-number generation.
}
\details{
  This package was first included with \R 2.14.0 in 2011.

  There is support for multiple RNG streams with the
  \samp{"L'Ecuyer-CMRG"} \link{RNG}: see \code{\link{nextRNGStream}}.

  It contains functionality derived from and pretty much equivalent to
  that contained in packages \pkg{multicore} (formerly on
  \acronym{CRAN}, with some low-level functions renamed and not
  exported) and \CRANpkg{snow} (for socket clusters only, but MPI and
  NWS clusters generated by \CRANpkg{snow} are also supported). There
  have been many enhancements and bug fixes since 2011.

  This package also provides \code{\link{makeForkCluster}}.

  For a complete list of exported functions, use
  \code{library(help = "parallel")}.
}
\author{
  Brian Ripley, Luke Tierney and Simon Urbanek

  Maintainer: R Core Team \email{R-core@r-project.org}
}
\seealso{
  Parallel computation involves launching worker processes: functions
  \code{\link{psnice}} and \code{\link{pskill}} in package \pkg{tools}
  provide means to manage such processes.
}
\keyword{ package }
