% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handling.R
\docType{methods}
\name{tab}
\alias{tab}
\alias{tab,genind-method}
\alias{tab,genind-methods}
\alias{tab,genpop-method}
\alias{tab,genpop-methods}
\title{Access allele counts or frequencies}
\usage{
tab(x, ...)

\S4method{tab}{genind}(x, freq = FALSE, NA.method = c("asis", "mean",
  "zero"), ...)

\S4method{tab}{genpop}(x, freq = FALSE, NA.method = c("asis", "mean",
  "zero"), ...)
}
\arguments{
\item{x}{a \linkS4class{genind} or \linkS4class{genpop} object.}

\item{...}{further arguments passed to other methods.}

\item{freq}{a logical indicating if data should be transformed into relative frequencies (TRUE); defaults to FALSE.}

\item{NA.method}{a method to replace NA; asis: leave NAs as is; mean: replace by the mean allele frequencies; zero: replace by zero}
}
\value{
a matrix of integers or numeric
}
\description{
This accessor is used to retrieve a matrix of allele data.
By default, a matrix of integers representing allele counts is returned.
If \code{freq} is TRUE, then data are standardised as frequencies, so that for any individual and any locus the data sum to 1.
The argument \code{NA.method} allows to replace missing data (NAs).
This accessor replaces the previous function \code{truenames} as well as the function \code{makefreq}.
}
\examples{

data(microbov)
head(tab(microbov))
head(tab(microbov,freq=TRUE))


}
