% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ems.R
\name{ems}
\alias{ems}
\title{Expected values of mean squares for factorial designs
 
 Implements the Cornfield-Tukey algorithm for deriving the expected values of the mean squares for factorial designs.}
\usage{
ems(design, nested = NULL, random = NULL)
}
\arguments{
\item{design}{A \code{formula} object specifying the factors in the design (except residual error, which is always implicitly included). The left hand side of the \code{~} is the symbol that will be used to denote the number of replications per lowest-level factor combination (I usually use "r" or "n"). The right hand side should include all fixed and random factors separated by \code{*}. Factor names should be single letters.}

\item{nested}{A \code{character} vector, where each element is of the form \code{"A/B"}, indicating that the levels of factor B are nested under the levels of factor A.}

\item{random}{A \code{character} string indicating, without spaces or any separating characters, which of the factors specified in the design are random.}
}
\value{
The returned value is a formatted table where the rows represent the mean squares, the columns represent the variance components that comprise the various mean squares, and the entries in each cell represent the terms that are multiplied and summed to form the expectation of the mean square for that row. Each term is either the lower-case version of one of the experimental factors, which indicates the number of levels for that factor, or a "1", which means the variance component for that column is contributes to the mean square but is not multiplied by anything else.
}
\description{
Expected values of mean squares for factorial designs
 
 Implements the Cornfield-Tukey algorithm for deriving the expected values of the mean squares for factorial designs.
}
\note{
Names for factors or parameters should only be of length 1 as they are simply concatenated in the returned table.
}
\examples{
# 2x2 mixed anova
# A varies between-subjects, B varies within-subjects
ems(r ~ A*B*S, nested="A/S", random="S")

# Clark (1973) example
# random Subjects, random Words, fixed Treatments
ems(r ~ S*W*T, nested="T/W", random="SW")

# EMSs for Clark design if Words are fixed
ems(r ~ S*W*T, nested="T/W", random="S")

}
\author{
Jake Westfall
}
\seealso{
A detailed description with explanation of the example can be found \href{http://www.talkstats.com/showthread.php/18603-Share-your-functions-amp-code?p=82050&viewfull=1\#post82050}{elsewhere} (note that the \code{design} argument of the function described at the link behaves slightly different).

Example applications of this function can be found here: \url{http://stats.stackexchange.com/a/122662/442}.
}

