% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.frame_tidiers.R
\name{data.frame_tidiers}
\alias{data.frame_tidiers}
\alias{tidy.data.frame}
\alias{augment.data.frame}
\alias{glance.data.frame}
\title{Tidiers for data.frame objects}
\usage{
\method{tidy}{data.frame}(x, ...)

\method{augment}{data.frame}(x, data, ...)

\method{glance}{data.frame}(x, ...)
}
\arguments{
\item{x}{A data.frame}

\item{...}{extra arguments: for \code{tidy}, these are passed on to
\code{\link{describe}} from \code{psych} package}

\item{data}{data, not used}
}
\value{
\code{tidy.data.frame} produces a data frame with one
row per original column, containing summary statistics of each:
  \item{column}{name of original column}
  \item{n}{Number of valid (non-NA) values}
  \item{mean}{mean}
  \item{sd}{standard deviation}
  \item{median}{median}
  \item{trimmed}{trimmed mean, with trim defaulting to .1}
  \item{mad}{median absolute deviation (from the median)}
  \item{min}{minimum value}
  \item{max}{maximum value}
  \item{range}{range}
  \item{skew}{skew}
  \item{kurtosis}{kurtosis}
  \item{se}{standard error}

\code{glance} returns a one-row data.frame with
  \item{nrow}{number of rows}
  \item{ncol}{number of columns}
  \item{complete.obs}{number of rows that have no missing values}
  \item{na.fraction}{fraction of values across all rows and columns that
  are missing}
}
\description{
These perform tidy summaries of data.frame objects. \code{tidy} produces
summary statistics about each column, while \code{glance} simply reports
the number of rows and columns. Note that \code{augment.data.frame} will
throw an error.
}
\details{
The \code{tidy} method calls the psych method
\code{\link{describe}} directly to produce its per-columns summary
statistics.
}
\examples{

td <- tidy(mtcars)
td

glance(mtcars)

library(ggplot2)
# compare mean and standard deviation
ggplot(td, aes(mean, sd)) + geom_point() +
     geom_text(aes(label = column), hjust = 1, vjust = 1) +
     scale_x_log10() + scale_y_log10() + geom_abline()

}
\seealso{
\code{\link{describe}}
}
